/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import java.util.concurrent.Callable;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.parser.JSONParser;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;
import jdk.nashorn.internal.runtime.linker.Bootstrap;

public final class JSONFunctions {
    private static final Object REVIVER_INVOKER = new Object();

    private JSONFunctions() {
    }

    private static MethodHandle getREVIVER_INVOKER() {
        return Context.getGlobal().getDynamicInvoker(REVIVER_INVOKER, new Callable<MethodHandle>(){

            @Override
            public MethodHandle call() {
                return Bootstrap.createDynamicInvoker("dyn:call", Object.class, ScriptFunction.class, ScriptObject.class, String.class, Object.class);
            }
        });
    }

    public static String quote(String str) {
        return JSONParser.quote(str);
    }

    public static Object parse(Object text, Object reviver) {
        Node node;
        String str = JSType.toString(text);
        JSONParser parser = new JSONParser(Source.sourceFor("<json>", str), new Context.ThrowErrorManager());
        try {
            node = parser.parse();
        }
        catch (ParserException e) {
            throw ECMAErrors.syntaxError(e, "invalid.json", e.getMessage());
        }
        Global global = Context.getGlobal();
        Object unfiltered = JSONFunctions.convertNode(global, node);
        return JSONFunctions.applyReviver(global, unfiltered, reviver);
    }

    private static Object applyReviver(Global global, Object unfiltered, Object reviver) {
        if (reviver instanceof ScriptFunction) {
            ScriptObject root = global.newObject();
            root.addOwnProperty("", 0, unfiltered);
            return JSONFunctions.walk(root, "", (ScriptFunction)reviver);
        }
        return unfiltered;
    }

    private static Object walk(ScriptObject holder, Object name, ScriptFunction reviver) {
        Object val = holder.get(name);
        if (val instanceof ScriptObject) {
            ScriptObject valueObj = (ScriptObject)val;
            Iterator<String> iter = valueObj.propertyIterator();
            while (iter.hasNext()) {
                String key = iter.next();
                Object newElement = JSONFunctions.walk(valueObj, key, reviver);
                if (newElement == ScriptRuntime.UNDEFINED) {
                    valueObj.delete(key, false);
                    continue;
                }
                JSONFunctions.setPropertyValue(valueObj, key, newElement, false);
            }
        }
        try {
            return JSONFunctions.getREVIVER_INVOKER().invokeExact(reviver, holder, JSType.toString(name), val);
        }
        catch (Error | RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static Object convertNode(Global global, Node node) {
        assert (global instanceof Global);
        if (node instanceof LiteralNode) {
            if (node.tokenType() == TokenType.ARRAY) {
                assert (node instanceof LiteralNode.ArrayLiteralNode);
                Node[] elements = (Node[])((LiteralNode.ArrayLiteralNode)node).getValue();
                if (JSONFunctions.isNumericArray(elements)) {
                    double[] values = new double[elements.length];
                    int index = 0;
                    for (Node elem : elements) {
                        values[index++] = JSType.toNumber(JSONFunctions.convertNode(global, elem));
                    }
                    return global.wrapAsObject(values);
                }
                Object[] values = new Object[elements.length];
                int index = 0;
                for (Node elem : elements) {
                    values[index++] = JSONFunctions.convertNode(global, elem);
                }
                return global.wrapAsObject(values);
            }
            return ((LiteralNode)node).getValue();
        }
        if (node instanceof ObjectNode) {
            ObjectNode objNode = (ObjectNode)node;
            ScriptObject object = global.newObject();
            for (PropertyNode pNode : objNode.getElements()) {
                Expression valueNode = pNode.getValue();
                String name = pNode.getKeyName();
                Object value = JSONFunctions.convertNode(global, valueNode);
                JSONFunctions.setPropertyValue(object, name, value, false);
            }
            return object;
        }
        if (node instanceof UnaryNode) {
            UnaryNode unaryNode = (UnaryNode)node;
            return -((LiteralNode)unaryNode.rhs()).getNumber();
        }
        return null;
    }

    private static void setPropertyValue(ScriptObject sobj, String name, Object value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(name);
        if (ArrayIndex.isValidArrayIndex(index)) {
            sobj.defineOwnProperty(index, value);
        } else if (sobj.getMap().findProperty(name) != null) {
            sobj.set((Object)name, value, strict);
        } else {
            sobj.addOwnProperty(name, 0, value);
        }
    }

    private static boolean isNumericArray(Node[] values) {
        for (Node node : values) {
            if (node instanceof LiteralNode && ((LiteralNode)node).getValue() instanceof Number) continue;
            return false;
        }
        return true;
    }
}

