/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.ArrayList;
import java.util.List;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LexicalContextNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;

public abstract class Node
implements Cloneable {
    protected final int start;
    protected int finish;
    private final long token;

    public Node(long token, int finish) {
        this.token = token;
        this.start = Token.descPosition(token);
        this.finish = finish;
    }

    protected Node(long token, int start, int finish) {
        this.start = start;
        this.finish = finish;
        this.token = token;
    }

    protected Node(Node node) {
        this.token = node.token;
        this.start = node.start;
        this.finish = node.finish;
    }

    public boolean isAtom() {
        return false;
    }

    public boolean isLoop() {
        return false;
    }

    public boolean isAssignment() {
        return false;
    }

    public boolean isSelfModifying() {
        return false;
    }

    public Type getWidestOperationType() {
        return Type.OBJECT;
    }

    public boolean isComparison() {
        return false;
    }

    public Node ensureUniqueLabels(LexicalContext lc) {
        return this;
    }

    public abstract Node accept(NodeVisitor<? extends LexicalContext> var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public abstract void toString(StringBuilder var1);

    public boolean hasTerminalFlags() {
        return this.isTerminal() || this.hasGoto();
    }

    public int getFinish() {
        return this.finish;
    }

    public void setFinish(int finish) {
        this.finish = finish;
    }

    public boolean hasGoto() {
        return false;
    }

    public int getStart() {
        return this.start;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final boolean equals(Object other) {
        return super.equals(other);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public int position() {
        return Token.descPosition(this.token);
    }

    public int length() {
        return Token.descLength(this.token);
    }

    public TokenType tokenType() {
        return Token.descType(this.token);
    }

    public boolean isTokenType(TokenType type) {
        return Token.descType(this.token) == type;
    }

    public long getToken() {
        return this.token;
    }

    public boolean isTerminal() {
        return false;
    }

    static <T extends Node> List<T> accept(NodeVisitor<? extends LexicalContext> visitor, Class<T> clazz, List<T> list) {
        boolean changed = false;
        ArrayList<Node> newList = new ArrayList<Node>();
        for (Node node : list) {
            Node newNode;
            Node node2 = newNode = node == null ? null : (Node)clazz.cast(node.accept(visitor));
            if (newNode != node) {
                changed = true;
            }
            newList.add(newNode);
        }
        return changed ? newList : list;
    }

    static <T extends LexicalContextNode> T replaceInLexicalContext(LexicalContext lc, T oldNode, T newNode) {
        if (lc != null) {
            lc.replace(oldNode, newNode);
        }
        return newNode;
    }
}

