/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import sun.misc.HexDumpEncoder;
import sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialSpec;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;
import sun.security.ssl.Authenticator;
import sun.security.ssl.CipherBox;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.Debug;
import sun.security.ssl.EngineOutputRecord;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.InputRecord;
import sun.security.ssl.JsseJce;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.SignatureAndHashAlgorithm;

abstract class Handshaker {
    ProtocolVersion protocolVersion;
    ProtocolVersion activeProtocolVersion;
    boolean secureRenegotiation;
    byte[] clientVerifyData;
    byte[] serverVerifyData;
    boolean isInitialHandshake;
    private ProtocolList enabledProtocols;
    private CipherSuiteList enabledCipherSuites;
    String identificationProtocol;
    private AlgorithmConstraints algorithmConstraints = null;
    Collection<SignatureAndHashAlgorithm> localSupportedSignAlgs;
    Collection<SignatureAndHashAlgorithm> peerSupportedSignAlgs;
    private ProtocolList activeProtocols;
    private CipherSuiteList activeCipherSuites;
    List<SNIServerName> serverNames = Collections.emptyList();
    Collection<SNIMatcher> sniMatchers = Collections.emptyList();
    private boolean isClient;
    private boolean needCertVerify;
    SSLSocketImpl conn = null;
    SSLEngineImpl engine = null;
    HandshakeHash handshakeHash;
    HandshakeInStream input;
    HandshakeOutStream output;
    int state;
    SSLContextImpl sslContext;
    RandomCookie clnt_random;
    RandomCookie svr_random;
    SSLSessionImpl session;
    CipherSuite cipherSuite;
    CipherSuite.KeyExchange keyExchange;
    boolean resumingSession;
    boolean enableNewSession;
    private boolean sessKeysCalculated;
    boolean preferLocalCipherSuites = false;
    private SecretKey clntWriteKey;
    private SecretKey svrWriteKey;
    private IvParameterSpec clntWriteIV;
    private IvParameterSpec svrWriteIV;
    private SecretKey clntMacSecret;
    private SecretKey svrMacSecret;
    private volatile boolean taskDelegated = false;
    private volatile DelegatedTask<?> delegatedTask = null;
    private volatile Exception thrown = null;
    private Object thrownLock = new Object();
    static final Debug debug = Debug.getInstance("ssl");
    static final boolean allowUnsafeRenegotiation = Debug.getBooleanProperty("sun.security.ssl.allowUnsafeRenegotiation", false);
    static final boolean allowLegacyHelloMessages = Debug.getBooleanProperty("sun.security.ssl.allowLegacyHelloMessages", true);
    static final boolean rejectClientInitiatedRenego = Debug.getBooleanProperty("jdk.tls.rejectClientInitiatedRenegotiation", false);
    boolean invalidated;

    Handshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, boolean bl, boolean bl2, ProtocolVersion protocolVersion, boolean bl3, boolean bl4, byte[] byArray, byte[] byArray2) {
        this.conn = sSLSocketImpl;
        this.init(sSLContextImpl, protocolList, bl, bl2, protocolVersion, bl3, bl4, byArray, byArray2);
    }

    Handshaker(SSLEngineImpl sSLEngineImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, boolean bl, boolean bl2, ProtocolVersion protocolVersion, boolean bl3, boolean bl4, byte[] byArray, byte[] byArray2) {
        this.engine = sSLEngineImpl;
        this.init(sSLContextImpl, protocolList, bl, bl2, protocolVersion, bl3, bl4, byArray, byArray2);
    }

    private void init(SSLContextImpl sSLContextImpl, ProtocolList protocolList, boolean bl, boolean bl2, ProtocolVersion protocolVersion, boolean bl3, boolean bl4, byte[] byArray, byte[] byArray2) {
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("Allow unsafe renegotiation: " + allowUnsafeRenegotiation + "\nAllow legacy hello messages: " + allowLegacyHelloMessages + "\nIs initial handshake: " + bl3 + "\nIs secure renegotiation: " + bl4);
        }
        this.sslContext = sSLContextImpl;
        this.isClient = bl2;
        this.needCertVerify = bl;
        this.activeProtocolVersion = protocolVersion;
        this.isInitialHandshake = bl3;
        this.secureRenegotiation = bl4;
        this.clientVerifyData = byArray;
        this.serverVerifyData = byArray2;
        this.enableNewSession = true;
        this.invalidated = false;
        this.sessKeysCalculated = false;
        this.setCipherSuite(CipherSuite.C_NULL);
        this.setEnabledProtocols(protocolList);
        this.algorithmConstraints = this.conn != null ? new SSLAlgorithmConstraints(this.conn, true) : new SSLAlgorithmConstraints(this.engine, true);
        this.state = -2;
    }

    void fatalSE(byte by, String string) throws IOException {
        this.fatalSE(by, string, null);
    }

    void fatalSE(byte by, Throwable throwable) throws IOException {
        this.fatalSE(by, null, throwable);
    }

    void fatalSE(byte by, String string, Throwable throwable) throws IOException {
        if (this.conn != null) {
            this.conn.fatal(by, string, throwable);
        } else {
            this.engine.fatal(by, string, throwable);
        }
    }

    void warningSE(byte by) {
        if (this.conn != null) {
            this.conn.warning(by);
        } else {
            this.engine.warning(by);
        }
    }

    String getHostSE() {
        if (this.conn != null) {
            return this.conn.getHost();
        }
        return this.engine.getPeerHost();
    }

    String getHostAddressSE() {
        if (this.conn != null) {
            return this.conn.getInetAddress().getHostAddress();
        }
        return this.engine.getPeerHost();
    }

    int getPortSE() {
        if (this.conn != null) {
            return this.conn.getPort();
        }
        return this.engine.getPeerPort();
    }

    int getLocalPortSE() {
        if (this.conn != null) {
            return this.conn.getLocalPort();
        }
        return -1;
    }

    AccessControlContext getAccSE() {
        if (this.conn != null) {
            return this.conn.getAcc();
        }
        return this.engine.getAcc();
    }

    final boolean receivedChangeCipherSpec() {
        if (this.conn != null) {
            return this.conn.receivedChangeCipherSpec();
        }
        return this.engine.receivedChangeCipherSpec();
    }

    String getEndpointIdentificationAlgorithmSE() {
        SSLParameters sSLParameters = this.conn != null ? this.conn.getSSLParameters() : this.engine.getSSLParameters();
        return sSLParameters.getEndpointIdentificationAlgorithm();
    }

    private void setVersionSE(ProtocolVersion protocolVersion) {
        if (this.conn != null) {
            this.conn.setVersion(protocolVersion);
        } else {
            this.engine.setVersion(protocolVersion);
        }
    }

    void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.setVersionSE(protocolVersion);
        this.output.r.setVersion(protocolVersion);
    }

    void setEnabledProtocols(ProtocolList protocolList) {
        this.activeCipherSuites = null;
        this.activeProtocols = null;
        this.enabledProtocols = protocolList;
    }

    void setEnabledCipherSuites(CipherSuiteList cipherSuiteList) {
        this.activeCipherSuites = null;
        this.activeProtocols = null;
        this.enabledCipherSuites = cipherSuiteList;
    }

    void setAlgorithmConstraints(AlgorithmConstraints algorithmConstraints) {
        this.activeCipherSuites = null;
        this.activeProtocols = null;
        this.algorithmConstraints = new SSLAlgorithmConstraints(algorithmConstraints);
        this.localSupportedSignAlgs = null;
    }

    Collection<SignatureAndHashAlgorithm> getLocalSupportedSignAlgs() {
        if (this.localSupportedSignAlgs == null) {
            this.localSupportedSignAlgs = SignatureAndHashAlgorithm.getSupportedAlgorithms(this.algorithmConstraints);
        }
        return this.localSupportedSignAlgs;
    }

    void setPeerSupportedSignAlgs(Collection<SignatureAndHashAlgorithm> collection) {
        this.peerSupportedSignAlgs = new ArrayList<SignatureAndHashAlgorithm>(collection);
    }

    Collection<SignatureAndHashAlgorithm> getPeerSupportedSignAlgs() {
        return this.peerSupportedSignAlgs;
    }

    void setIdentificationProtocol(String string) {
        this.identificationProtocol = string;
    }

    void setSNIServerNames(List<SNIServerName> list) {
        this.serverNames = list;
    }

    void setSNIMatchers(Collection<SNIMatcher> collection) {
        this.sniMatchers = collection;
    }

    void setUseCipherSuitesOrder(boolean bl) {
        this.preferLocalCipherSuites = bl;
    }

    void activate(ProtocolVersion protocolVersion) throws IOException {
        if (this.activeProtocols == null) {
            this.activeProtocols = this.getActiveProtocols();
        }
        if (this.activeProtocols.collection().isEmpty() || this.activeProtocols.max.v == ProtocolVersion.NONE.v) {
            throw new SSLHandshakeException("No appropriate protocol (protocol is disabled or cipher suites are inappropriate)");
        }
        if (this.activeCipherSuites == null) {
            this.activeCipherSuites = this.getActiveCipherSuites();
        }
        if (this.activeCipherSuites.collection().isEmpty()) {
            throw new SSLHandshakeException("No appropriate cipher suite");
        }
        this.protocolVersion = !this.isInitialHandshake ? this.activeProtocolVersion : this.activeProtocols.max;
        if (protocolVersion == null || protocolVersion.v == ProtocolVersion.NONE.v) {
            protocolVersion = this.activeProtocols.helloVersion;
        }
        this.handshakeHash = new HandshakeHash(this.needCertVerify);
        this.input = new HandshakeInStream(this.handshakeHash);
        if (this.conn != null) {
            this.output = new HandshakeOutStream(this.protocolVersion, protocolVersion, this.handshakeHash, this.conn);
            this.conn.getAppInputStream().r.setHandshakeHash(this.handshakeHash);
            this.conn.getAppInputStream().r.setHelloVersion(protocolVersion);
            this.conn.getAppOutputStream().r.setHelloVersion(protocolVersion);
        } else {
            this.output = new HandshakeOutStream(this.protocolVersion, protocolVersion, this.handshakeHash, this.engine);
            this.engine.inputRecord.setHandshakeHash(this.handshakeHash);
            this.engine.inputRecord.setHelloVersion(protocolVersion);
            this.engine.outputRecord.setHelloVersion(protocolVersion);
        }
        this.state = -1;
    }

    void setCipherSuite(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
        this.keyExchange = cipherSuite.keyExchange;
    }

    boolean isNegotiable(CipherSuite cipherSuite) {
        if (this.activeCipherSuites == null) {
            this.activeCipherSuites = this.getActiveCipherSuites();
        }
        return Handshaker.isNegotiable(this.activeCipherSuites, cipherSuite);
    }

    static final boolean isNegotiable(CipherSuiteList cipherSuiteList, CipherSuite cipherSuite) {
        return cipherSuiteList.contains(cipherSuite) && cipherSuite.isNegotiable();
    }

    boolean isNegotiable(ProtocolVersion protocolVersion) {
        if (this.activeProtocols == null) {
            this.activeProtocols = this.getActiveProtocols();
        }
        return this.activeProtocols.contains(protocolVersion);
    }

    ProtocolVersion selectProtocolVersion(ProtocolVersion protocolVersion) {
        if (this.activeProtocols == null) {
            this.activeProtocols = this.getActiveProtocols();
        }
        return this.activeProtocols.selectProtocolVersion(protocolVersion);
    }

    CipherSuiteList getActiveCipherSuites() {
        if (this.activeCipherSuites == null) {
            if (this.activeProtocols == null) {
                this.activeProtocols = this.getActiveProtocols();
            }
            ArrayList<CipherSuite> arrayList = new ArrayList<CipherSuite>();
            if (!this.activeProtocols.collection().isEmpty() && this.activeProtocols.min.v != ProtocolVersion.NONE.v) {
                for (CipherSuite cipherSuite : this.enabledCipherSuites.collection()) {
                    if (cipherSuite.obsoleted > this.activeProtocols.min.v && cipherSuite.supported <= this.activeProtocols.max.v) {
                        if (!this.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), cipherSuite.name, null)) continue;
                        arrayList.add(cipherSuite);
                        continue;
                    }
                    if (debug == null || !Debug.isOn("verbose")) continue;
                    if (cipherSuite.obsoleted <= this.activeProtocols.min.v) {
                        System.out.println("Ignoring obsoleted cipher suite: " + cipherSuite);
                        continue;
                    }
                    System.out.println("Ignoring unsupported cipher suite: " + cipherSuite);
                }
            }
            this.activeCipherSuites = new CipherSuiteList(arrayList);
        }
        return this.activeCipherSuites;
    }

    ProtocolList getActiveProtocols() {
        if (this.activeProtocols == null) {
            ArrayList<ProtocolVersion> arrayList = new ArrayList<ProtocolVersion>(4);
            for (ProtocolVersion protocolVersion : this.enabledProtocols.collection()) {
                if (!this.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), protocolVersion.name, null)) {
                    if (debug == null || !Debug.isOn("verbose")) continue;
                    System.out.println("Ignoring disabled protocol: " + protocolVersion);
                    continue;
                }
                boolean bl = false;
                for (CipherSuite cipherSuite : this.enabledCipherSuites.collection()) {
                    if (cipherSuite.isAvailable() && cipherSuite.obsoleted > protocolVersion.v && cipherSuite.supported <= protocolVersion.v) {
                        if (this.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), cipherSuite.name, null)) {
                            arrayList.add(protocolVersion);
                            bl = true;
                            break;
                        }
                        if (debug == null || !Debug.isOn("verbose")) continue;
                        System.out.println("Ignoring disabled cipher suite: " + cipherSuite + " for " + protocolVersion);
                        continue;
                    }
                    if (debug == null || !Debug.isOn("verbose")) continue;
                    System.out.println("Ignoring unsupported cipher suite: " + cipherSuite + " for " + protocolVersion);
                }
                if (bl || debug == null || !Debug.isOn("handshake")) continue;
                System.out.println("No available cipher suite for " + protocolVersion);
            }
            this.activeProtocols = new ProtocolList(arrayList);
        }
        return this.activeProtocols;
    }

    void setEnableSessionCreation(boolean bl) {
        this.enableNewSession = bl;
    }

    CipherBox newReadCipher() throws NoSuchAlgorithmException {
        CipherBox cipherBox;
        CipherSuite.BulkCipher bulkCipher = this.cipherSuite.cipher;
        if (this.isClient) {
            cipherBox = bulkCipher.newCipher(this.protocolVersion, this.svrWriteKey, this.svrWriteIV, this.sslContext.getSecureRandom(), false);
            this.svrWriteKey = null;
            this.svrWriteIV = null;
        } else {
            cipherBox = bulkCipher.newCipher(this.protocolVersion, this.clntWriteKey, this.clntWriteIV, this.sslContext.getSecureRandom(), false);
            this.clntWriteKey = null;
            this.clntWriteIV = null;
        }
        return cipherBox;
    }

    CipherBox newWriteCipher() throws NoSuchAlgorithmException {
        CipherBox cipherBox;
        CipherSuite.BulkCipher bulkCipher = this.cipherSuite.cipher;
        if (this.isClient) {
            cipherBox = bulkCipher.newCipher(this.protocolVersion, this.clntWriteKey, this.clntWriteIV, this.sslContext.getSecureRandom(), true);
            this.clntWriteKey = null;
            this.clntWriteIV = null;
        } else {
            cipherBox = bulkCipher.newCipher(this.protocolVersion, this.svrWriteKey, this.svrWriteIV, this.sslContext.getSecureRandom(), true);
            this.svrWriteKey = null;
            this.svrWriteIV = null;
        }
        return cipherBox;
    }

    Authenticator newReadAuthenticator() throws NoSuchAlgorithmException, InvalidKeyException {
        Authenticator authenticator = null;
        if (this.cipherSuite.cipher.cipherType == CipherSuite.CipherType.AEAD_CIPHER) {
            authenticator = new Authenticator(this.protocolVersion);
        } else {
            CipherSuite.MacAlg macAlg = this.cipherSuite.macAlg;
            if (this.isClient) {
                authenticator = macAlg.newMac(this.protocolVersion, this.svrMacSecret);
                this.svrMacSecret = null;
            } else {
                authenticator = macAlg.newMac(this.protocolVersion, this.clntMacSecret);
                this.clntMacSecret = null;
            }
        }
        return authenticator;
    }

    Authenticator newWriteAuthenticator() throws NoSuchAlgorithmException, InvalidKeyException {
        Authenticator authenticator = null;
        if (this.cipherSuite.cipher.cipherType == CipherSuite.CipherType.AEAD_CIPHER) {
            authenticator = new Authenticator(this.protocolVersion);
        } else {
            CipherSuite.MacAlg macAlg = this.cipherSuite.macAlg;
            if (this.isClient) {
                authenticator = macAlg.newMac(this.protocolVersion, this.clntMacSecret);
                this.clntMacSecret = null;
            } else {
                authenticator = macAlg.newMac(this.protocolVersion, this.svrMacSecret);
                this.svrMacSecret = null;
            }
        }
        return authenticator;
    }

    boolean isDone() {
        return this.state == 20;
    }

    SSLSessionImpl getSession() {
        return this.session;
    }

    void setHandshakeSessionSE(SSLSessionImpl sSLSessionImpl) {
        if (this.conn != null) {
            this.conn.setHandshakeSession(sSLSessionImpl);
        } else {
            this.engine.setHandshakeSession(sSLSessionImpl);
        }
    }

    boolean isSecureRenegotiation() {
        return this.secureRenegotiation;
    }

    byte[] getClientVerifyData() {
        return this.clientVerifyData;
    }

    byte[] getServerVerifyData() {
        return this.serverVerifyData;
    }

    void process_record(InputRecord inputRecord, boolean bl) throws IOException {
        this.checkThrown();
        this.input.incomingRecord(inputRecord);
        if (this.conn != null || bl) {
            this.processLoop();
        } else {
            this.delegateTask(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Handshaker.this.processLoop();
                    return null;
                }
            });
        }
    }

    void processLoop() throws IOException {
        while (this.input.available() >= 4) {
            this.input.mark(4);
            byte by = (byte)this.input.getInt8();
            int n = this.input.getInt24();
            if (this.input.available() < n) {
                this.input.reset();
                return;
            }
            if (by == 0) {
                this.input.reset();
                this.processMessage(by, n);
                this.input.ignore(4 + n);
                continue;
            }
            this.input.mark(n);
            this.processMessage(by, n);
            this.input.digestNow();
        }
    }

    boolean activated() {
        return this.state >= -1;
    }

    boolean started() {
        return this.state >= 0;
    }

    void kickstart() throws IOException {
        if (this.state >= 0) {
            return;
        }
        HandshakeMessage handshakeMessage = this.getKickstartMessage();
        if (debug != null && Debug.isOn("handshake")) {
            handshakeMessage.print(System.out);
        }
        handshakeMessage.write(this.output);
        this.output.flush();
        this.state = handshakeMessage.messageType();
    }

    abstract HandshakeMessage getKickstartMessage() throws SSLException;

    abstract void processMessage(byte var1, int var2) throws IOException;

    abstract void handshakeAlert(byte var1) throws SSLProtocolException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendChangeCipherSpec(HandshakeMessage.Finished finished, boolean bl) throws IOException {
        this.output.flush();
        OutputRecord outputRecord = this.conn != null ? new OutputRecord(20) : new EngineOutputRecord(20, this.engine);
        outputRecord.setVersion(this.protocolVersion);
        outputRecord.write(1);
        if (this.conn != null) {
            this.conn.writeLock.lock();
            try {
                this.conn.writeRecord(outputRecord);
                this.conn.changeWriteCiphers();
                if (debug != null && Debug.isOn("handshake")) {
                    finished.print(System.out);
                }
                finished.write(this.output);
                this.output.flush();
            }
            finally {
                this.conn.writeLock.unlock();
            }
        }
        Object object = this.engine.writeLock;
        synchronized (object) {
            this.engine.writeRecord((EngineOutputRecord)outputRecord);
            this.engine.changeWriteCiphers();
            if (debug != null && Debug.isOn("handshake")) {
                finished.print(System.out);
            }
            finished.write(this.output);
            if (bl) {
                this.output.setFinishedMsg();
            }
            this.output.flush();
        }
    }

    void calculateKeys(SecretKey secretKey, ProtocolVersion protocolVersion) {
        SecretKey secretKey2 = this.calculateMasterSecret(secretKey, protocolVersion);
        this.session.setMasterSecret(secretKey2);
        this.calculateConnectionKeys(secretKey2);
    }

    private SecretKey calculateMasterSecret(SecretKey secretKey, ProtocolVersion protocolVersion) {
        CipherSuite.PRF pRF;
        Object object;
        if (debug != null && Debug.isOn("keygen")) {
            object = new HexDumpEncoder();
            System.out.println("SESSION KEYGEN:");
            System.out.println("PreMaster Secret:");
            Handshaker.printHex(object, secretKey.getEncoded());
        }
        if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            object = "SunTls12MasterSecret";
            pRF = this.cipherSuite.prfAlg;
        } else {
            object = "SunTlsMasterSecret";
            pRF = CipherSuite.PRF.P_NONE;
        }
        String string = pRF.getPRFHashAlg();
        int n = pRF.getPRFHashLength();
        int n2 = pRF.getPRFBlockSize();
        TlsMasterSecretParameterSpec tlsMasterSecretParameterSpec = new TlsMasterSecretParameterSpec(secretKey, this.protocolVersion.major, this.protocolVersion.minor, this.clnt_random.random_bytes, this.svr_random.random_bytes, string, n, n2);
        try {
            KeyGenerator keyGenerator = JsseJce.getKeyGenerator((String)object);
            keyGenerator.init(tlsMasterSecretParameterSpec);
            return keyGenerator.generateKey();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("RSA master secret generation error:");
                generalSecurityException.printStackTrace(System.out);
            }
            throw new ProviderException(generalSecurityException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void calculateConnectionKeys(SecretKey secretKey) {
        TlsKeyMaterialSpec tlsKeyMaterialSpec;
        Object object;
        CipherSuite.PRF pRF;
        String string;
        int n;
        int n2 = this.cipherSuite.macAlg.size;
        boolean bl = this.cipherSuite.exportable;
        CipherSuite.BulkCipher bulkCipher = this.cipherSuite.cipher;
        int n3 = n = bl ? bulkCipher.expandedKeySize : 0;
        if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            string = "SunTls12KeyMaterial";
            pRF = this.cipherSuite.prfAlg;
        } else {
            string = "SunTlsKeyMaterial";
            pRF = CipherSuite.PRF.P_NONE;
        }
        String string2 = pRF.getPRFHashAlg();
        int n4 = pRF.getPRFHashLength();
        int n5 = pRF.getPRFBlockSize();
        int n6 = bulkCipher.ivSize;
        if (bulkCipher.cipherType == CipherSuite.CipherType.AEAD_CIPHER) {
            n6 = bulkCipher.fixedIvSize;
        } else if (this.protocolVersion.v >= ProtocolVersion.TLS11.v && bulkCipher.cipherType == CipherSuite.CipherType.BLOCK_CIPHER) {
            n6 = 0;
        }
        TlsKeyMaterialParameterSpec tlsKeyMaterialParameterSpec = new TlsKeyMaterialParameterSpec(secretKey, this.protocolVersion.major, this.protocolVersion.minor, this.clnt_random.random_bytes, this.svr_random.random_bytes, bulkCipher.algorithm, bulkCipher.keySize, n, n6, n2, string2, n4, n5);
        try {
            object = JsseJce.getKeyGenerator(string);
            ((KeyGenerator)object).init(tlsKeyMaterialParameterSpec);
            tlsKeyMaterialSpec = (TlsKeyMaterialSpec)((KeyGenerator)object).generateKey();
            this.clntWriteKey = tlsKeyMaterialSpec.getClientCipherKey();
            this.svrWriteKey = tlsKeyMaterialSpec.getServerCipherKey();
            this.clntWriteIV = tlsKeyMaterialSpec.getClientIv();
            this.svrWriteIV = tlsKeyMaterialSpec.getServerIv();
            this.clntMacSecret = tlsKeyMaterialSpec.getClientMacKey();
            this.svrMacSecret = tlsKeyMaterialSpec.getServerMacKey();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
        this.sessKeysCalculated = true;
        if (debug != null && Debug.isOn("keygen")) {
            object = System.out;
            synchronized (object) {
                tlsKeyMaterialSpec = new HexDumpEncoder();
                System.out.println("CONNECTION KEYGEN:");
                System.out.println("Client Nonce:");
                Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.clnt_random.random_bytes);
                System.out.println("Server Nonce:");
                Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.svr_random.random_bytes);
                System.out.println("Master Secret:");
                Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, secretKey.getEncoded());
                if (this.clntMacSecret != null) {
                    System.out.println("Client MAC write Secret:");
                    Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.clntMacSecret.getEncoded());
                    System.out.println("Server MAC write Secret:");
                    Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.svrMacSecret.getEncoded());
                } else {
                    System.out.println("... no MAC keys used for this cipher");
                }
                if (this.clntWriteKey != null) {
                    System.out.println("Client write key:");
                    Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.clntWriteKey.getEncoded());
                    System.out.println("Server write key:");
                    Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.svrWriteKey.getEncoded());
                } else {
                    System.out.println("... no encryption keys used");
                }
                if (this.clntWriteIV != null) {
                    System.out.println("Client write IV:");
                    Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.clntWriteIV.getIV());
                    System.out.println("Server write IV:");
                    Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.svrWriteIV.getIV());
                } else if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                    System.out.println("... no IV derived for this protocol");
                } else {
                    System.out.println("... no IV used for this cipher");
                }
                System.out.flush();
            }
        }
    }

    boolean sessionKeysCalculated() {
        return this.sessKeysCalculated;
    }

    private static void printHex(HexDumpEncoder hexDumpEncoder, byte[] byArray) {
        if (byArray == null) {
            System.out.println("(key bytes not available)");
        } else {
            try {
                hexDumpEncoder.encodeBuffer(byArray, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void throwSSLException(String string, Throwable throwable) throws SSLException {
        SSLException sSLException = new SSLException(string);
        sSLException.initCause(throwable);
        throw sSLException;
    }

    private <T> void delegateTask(PrivilegedExceptionAction<T> privilegedExceptionAction) {
        this.delegatedTask = new DelegatedTask<T>(privilegedExceptionAction);
        this.taskDelegated = false;
        this.thrown = null;
    }

    DelegatedTask<?> getTask() {
        if (!this.taskDelegated) {
            this.taskDelegated = true;
            return this.delegatedTask;
        }
        return null;
    }

    boolean taskOutstanding() {
        return this.delegatedTask != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkThrown() throws SSLException {
        Object object = this.thrownLock;
        synchronized (object) {
            if (this.thrown != null) {
                String string = this.thrown.getMessage();
                if (string == null) {
                    string = "Delegated task threw Exception/Error";
                }
                Exception exception = this.thrown;
                this.thrown = null;
                if (exception instanceof RuntimeException) {
                    throw new RuntimeException(string, exception);
                }
                if (exception instanceof SSLHandshakeException) {
                    throw (SSLHandshakeException)new SSLHandshakeException(string).initCause(exception);
                }
                if (exception instanceof SSLKeyException) {
                    throw (SSLKeyException)new SSLKeyException(string).initCause(exception);
                }
                if (exception instanceof SSLPeerUnverifiedException) {
                    throw (SSLPeerUnverifiedException)new SSLPeerUnverifiedException(string).initCause(exception);
                }
                if (exception instanceof SSLProtocolException) {
                    throw (SSLProtocolException)new SSLProtocolException(string).initCause(exception);
                }
                throw new SSLException(string, exception);
            }
        }
    }

    class DelegatedTask<E>
    implements Runnable {
        private PrivilegedExceptionAction<E> pea;

        DelegatedTask(PrivilegedExceptionAction<E> privilegedExceptionAction) {
            this.pea = privilegedExceptionAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SSLEngineImpl sSLEngineImpl = Handshaker.this.engine;
            synchronized (sSLEngineImpl) {
                try {
                    AccessController.doPrivileged(this.pea, Handshaker.this.engine.getAcc());
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Handshaker.this.thrown = privilegedActionException.getException();
                }
                catch (RuntimeException runtimeException) {
                    Handshaker.this.thrown = runtimeException;
                }
                Handshaker.this.delegatedTask = null;
                Handshaker.this.taskDelegated = false;
            }
        }
    }
}

