/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import sun.nio.ch.FileChannelImpl;

public class FileOutputStream
extends OutputStream {
    private final FileDescriptor fd;
    private final boolean append;
    private FileChannel channel;
    private final String path;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;

    public FileOutputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null, false);
    }

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        this(string != null ? new File(string) : null, bl);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean bl) throws FileNotFoundException {
        String string = file != null ? file.getPath() : null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.fd.attach(this);
        this.append = bl;
        this.path = string;
        this.open(string, bl);
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.append = false;
        this.path = null;
        this.fd.attach(this);
    }

    private native void open(String var1, boolean var2) throws FileNotFoundException;

    private native void write(int var1, boolean var2) throws IOException;

    @Override
    public void write(int n) throws IOException {
        this.write(n, this.append);
    }

    private native void writeBytes(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    @Override
    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length, this.append);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2, this.append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        this.fd.closeAll(new Closeable(){

            @Override
            public void close() throws IOException {
                FileOutputStream.this.close0();
            }
        });
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, this.path, false, true, this.append, this);
            }
            return this.channel;
        }
    }

    protected void finalize() throws IOException {
        if (this.fd != null) {
            if (this.fd == FileDescriptor.out || this.fd == FileDescriptor.err) {
                this.flush();
            } else {
                this.close();
            }
        }
    }

    private native void close0() throws IOException;

    private static native void initIDs();

    static {
        FileOutputStream.initIDs();
    }
}

