/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.g1;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_implementation.g1.G1HeapRegionTable;
import sun.jvm.hotspot.gc_implementation.g1.HeapRegion;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class HeapRegionSeq
extends VMObject {
    private static long regionsFieldOffset;
    private static CIntegerField committedLengthField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("HeapRegionSeq");
        regionsFieldOffset = type.getField("_regions").getOffset();
        committedLengthField = type.getCIntegerField("_committed_length");
    }

    private G1HeapRegionTable regions() {
        Address regionsAddr = this.addr.addOffsetTo(regionsFieldOffset);
        return (G1HeapRegionTable)VMObjectFactory.newObject(G1HeapRegionTable.class, regionsAddr);
    }

    public long length() {
        return this.regions().length();
    }

    public long committedLength() {
        return committedLengthField.getValue(this.addr);
    }

    public Iterator<HeapRegion> heapRegionIterator() {
        return this.regions().heapRegionIterator(this.committedLength());
    }

    public HeapRegionSeq(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                HeapRegionSeq.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

