/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.Splitter;

public class CompileUnit
implements Comparable<CompileUnit> {
    private final String className;
    private ClassEmitter classEmitter;
    private long weight;
    private Class<?> clazz;

    CompileUnit(String className, ClassEmitter classEmitter) {
        this(className, classEmitter, 0L);
    }

    CompileUnit(String className, ClassEmitter classEmitter, long initialWeight) {
        this.className = className;
        this.classEmitter = classEmitter;
        this.weight = initialWeight;
    }

    public Class<?> getCode() {
        return this.clazz;
    }

    void setCode(Class<?> clazz) {
        clazz.getClass();
        this.clazz = clazz;
        this.classEmitter = null;
    }

    void addWeight(long w) {
        this.weight += w;
    }

    long getWeight() {
        return this.weight;
    }

    public boolean canHold(long w) {
        return this.weight + w < Splitter.SPLIT_THRESHOLD;
    }

    public ClassEmitter getClassEmitter() {
        return this.classEmitter;
    }

    public String getUnitClassName() {
        return this.className;
    }

    public String toString() {
        return "[classname=" + this.className + " weight=" + this.weight + '/' + Splitter.SPLIT_THRESHOLD + ']';
    }

    @Override
    public int compareTo(CompileUnit o) {
        return this.className.compareTo(o.className);
    }
}

