/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.DontInline;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.Invokers;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.invoke.Stable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.invoke.util.Wrapper;

class LambdaForm {
    final int arity;
    final int result;
    @Stable
    final Name[] names;
    final String debugName;
    MemberName vmentry;
    private boolean isCompiled;
    LambdaForm[] bindCache;
    public static final int VOID_RESULT = -1;
    public static final int LAST_RESULT = -2;
    private static final ConcurrentHashMap<String, LambdaForm> PREPARED_FORMS;
    private static final boolean USE_PREDEFINED_INTERPRET_METHODS = true;
    private static final int COMPILE_THRESHOLD;
    private int invocationCounter = 0;
    static final String ALL_TYPES = "LIJFD";
    static final int INTERNED_ARGUMENT_LIMIT = 10;
    private static final Name[][] INTERNED_ARGUMENTS;
    private static final MemberName.Factory IMPL_NAMES;
    private static final Name[] CONSTANT_ZERO;
    private static final boolean TRACE_INTERPRETER;

    LambdaForm(String string, int n, Name[] nameArray, int n2) {
        assert (LambdaForm.namesOK(n, nameArray));
        this.arity = n;
        this.result = LambdaForm.fixResult(n2, nameArray);
        this.names = (Name[])nameArray.clone();
        this.debugName = string;
        this.normalize();
    }

    LambdaForm(String string, int n, Name[] nameArray) {
        this(string, n, nameArray, -2);
    }

    LambdaForm(String string, Name[] nameArray, Name[] nameArray2, Name name) {
        this(string, nameArray.length, LambdaForm.buildNames(nameArray, nameArray2, name), -2);
    }

    private static Name[] buildNames(Name[] nameArray, Name[] nameArray2, Name name) {
        int n = nameArray.length;
        int n2 = n + nameArray2.length + (name == null ? 0 : 1);
        Name[] nameArray3 = Arrays.copyOf(nameArray, n2);
        System.arraycopy(nameArray2, 0, nameArray3, n, nameArray2.length);
        if (name != null) {
            nameArray3[n2 - 1] = name;
        }
        return nameArray3;
    }

    private LambdaForm(String string) {
        assert (LambdaForm.isValidSignature(string));
        this.arity = LambdaForm.signatureArity(string);
        this.result = LambdaForm.signatureReturn(string) == 'V' ? -1 : this.arity;
        this.names = LambdaForm.buildEmptyNames(this.arity, string);
        this.debugName = "LF.zero";
        assert (this.nameRefsAreLegal());
        assert (this.isEmpty());
        assert (string.equals(this.basicTypeSignature()));
    }

    private static Name[] buildEmptyNames(int n, String string) {
        assert (LambdaForm.isValidSignature(string));
        int n2 = n + 1;
        if (n < 0 || string.length() != n2 + 1) {
            throw new IllegalArgumentException("bad arity for " + string);
        }
        int n3 = string.charAt(n2) == 'V' ? 0 : 1;
        Name[] nameArray = LambdaForm.arguments(n3, string.substring(0, n));
        for (int i = 0; i < n3; ++i) {
            nameArray[n + i] = LambdaForm.constantZero(n + i, string.charAt(n2 + i));
        }
        return nameArray;
    }

    private static int fixResult(int n, Name[] nameArray) {
        if (n >= 0) {
            if (nameArray[n].type == 'V') {
                return -1;
            }
        } else if (n == -2) {
            return nameArray.length - 1;
        }
        return n;
    }

    private static boolean namesOK(int n, Name[] nameArray) {
        for (int i = 0; i < nameArray.length; ++i) {
            Name name = nameArray[i];
            assert (name != null) : "n is null";
            if (i < n) {
                assert (name.isParam()) : name + " is not param at " + i;
                continue;
            }
            assert (!name.isParam()) : name + " is param at " + i;
        }
        return true;
    }

    private void normalize() {
        int n;
        int n2;
        Name[] nameArray = null;
        int n3 = 0;
        for (n2 = 0; n2 < this.names.length; ++n2) {
            Name name = this.names[n2];
            if (name.initIndex(n2)) continue;
            if (nameArray == null) {
                nameArray = (Name[])this.names.clone();
                n3 = n2;
            }
            this.names[n2] = name.cloneWithIndex(n2);
        }
        if (nameArray != null) {
            n2 = this.arity;
            if (n2 <= n3) {
                n2 = n3 + 1;
            }
            for (int i = n2; i < this.names.length; ++i) {
                Name name = this.names[i].replaceNames(nameArray, this.names, n3, i);
                this.names[i] = name.newIndex(i);
            }
        }
        assert (this.nameRefsAreLegal());
        n2 = Math.min(this.arity, 10);
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            Name name = this.names[n];
            Name name2 = LambdaForm.internArgument(name);
            if (name == name2) continue;
            this.names[n] = name2;
            bl = true;
        }
        if (bl) {
            for (n = this.arity; n < this.names.length; ++n) {
                this.names[n].internArguments();
            }
            assert (this.nameRefsAreLegal());
        }
    }

    private boolean nameRefsAreLegal() {
        Name name;
        int n;
        assert (this.arity >= 0 && this.arity <= this.names.length);
        assert (this.result >= -1 && this.result < this.names.length);
        for (n = 0; n < this.arity; ++n) {
            name = this.names[n];
            assert (name.index() == n) : Arrays.asList(name.index(), n);
            assert (name.isParam());
        }
        for (n = this.arity; n < this.names.length; ++n) {
            name = this.names[n];
            assert (name.index() == n);
            for (Object object : name.arguments) {
                if (!(object instanceof Name)) continue;
                Name name2 = (Name)object;
                short s = name2.index;
                assert (0 <= s && s < this.names.length) : name.debugString() + ": 0 <= i2 && i2 < names.length: 0 <= " + s + " < " + this.names.length;
                assert (this.names[s] == name2) : Arrays.asList("-1-", n, "-2-", name.debugString(), "-3-", s, "-4-", name2.debugString(), "-5-", this.names[s].debugString(), "-6-", this);
                assert (s < n);
            }
        }
        return true;
    }

    char returnType() {
        if (this.result < 0) {
            return 'V';
        }
        Name name = this.names[this.result];
        return name.type;
    }

    char parameterType(int n) {
        assert (n < this.arity);
        return this.names[n].type;
    }

    int arity() {
        return this.arity;
    }

    MethodType methodType() {
        return LambdaForm.signatureType(this.basicTypeSignature());
    }

    final String basicTypeSignature() {
        StringBuilder stringBuilder = new StringBuilder(this.arity() + 3);
        int n = this.arity();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.parameterType(i));
        }
        return stringBuilder.append('_').append(this.returnType()).toString();
    }

    static int signatureArity(String string) {
        assert (LambdaForm.isValidSignature(string));
        return string.indexOf(95);
    }

    static char signatureReturn(String string) {
        return string.charAt(LambdaForm.signatureArity(string) + 1);
    }

    static boolean isValidSignature(String string) {
        int n = string.indexOf(95);
        if (n < 0) {
            return false;
        }
        int n2 = string.length();
        if (n2 != n + 2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (i == n) continue;
            char c = string.charAt(i);
            if (c == 'V') {
                return i == n2 - 1 && n == n2 - 2;
            }
            if (ALL_TYPES.indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    static Class<?> typeClass(char c) {
        switch (c) {
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                return Object.class;
            }
            case 'V': {
                return Void.TYPE;
            }
        }
        assert (false);
        return null;
    }

    static MethodType signatureType(String string) {
        Class[] classArray = new Class[LambdaForm.signatureArity(string)];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = LambdaForm.typeClass(string.charAt(i));
        }
        Class<?> clazz = LambdaForm.typeClass(LambdaForm.signatureReturn(string));
        return MethodType.methodType(clazz, classArray);
    }

    public void prepare() {
        if (COMPILE_THRESHOLD == 0) {
            this.compileToBytecode();
        }
        if (this.vmentry != null) {
            return;
        }
        LambdaForm lambdaForm = LambdaForm.getPreparedForm(this.basicTypeSignature());
        this.vmentry = lambdaForm.vmentry;
    }

    MemberName compileToBytecode() {
        MethodType methodType = this.methodType();
        assert (this.vmentry == null || this.vmentry.getMethodType().basicType().equals((Object)methodType));
        if (this.vmentry != null && this.isCompiled) {
            return this.vmentry;
        }
        try {
            this.vmentry = InvokerBytecodeGenerator.generateCustomizedCode(this, methodType);
            if (TRACE_INTERPRETER) {
                LambdaForm.traceInterpreter("compileToBytecode", this);
            }
            this.isCompiled = true;
            return this.vmentry;
        }
        catch (Error | Exception throwable) {
            throw MethodHandleStatics.newInternalError("compileToBytecode", throwable);
        }
    }

    private static Map<String, LambdaForm> computeInitialPreparedForms() {
        HashMap<String, LambdaForm> hashMap = new HashMap<String, LambdaForm>();
        for (MemberName memberName : MemberName.getFactory().getMethods(LambdaForm.class, false, null, null, null)) {
            MethodType methodType;
            if (!memberName.isStatic() || !memberName.isPackage() || (methodType = memberName.getMethodType()).parameterCount() <= 0 || methodType.parameterType(0) != MethodHandle.class || !memberName.getName().startsWith("interpret_")) continue;
            String string = LambdaForm.basicTypeSignature(methodType);
            assert (memberName.getName().equals("interpret" + string.substring(string.indexOf(95))));
            LambdaForm lambdaForm = new LambdaForm(string);
            lambdaForm.vmentry = memberName;
            lambdaForm = methodType.form().setCachedLambdaForm(7, lambdaForm);
            hashMap.put(string, lambdaForm);
        }
        return hashMap;
    }

    static Object interpret_L(MethodHandle methodHandle) throws Throwable {
        Object[] objectArray = new Object[]{methodHandle};
        String string = null;
        if (!$assertionsDisabled) {
            string = "L_L";
            if (!LambdaForm.argumentTypesMatch("L_L", objectArray)) {
                throw new AssertionError();
            }
        }
        Object object = methodHandle.form.interpretWithArguments(objectArray);
        assert (LambdaForm.returnTypesMatch(string, objectArray, object));
        return object;
    }

    static Object interpret_L(MethodHandle methodHandle, Object object) throws Throwable {
        Object[] objectArray = new Object[]{methodHandle, object};
        String string = null;
        if (!$assertionsDisabled) {
            string = "LL_L";
            if (!LambdaForm.argumentTypesMatch("LL_L", objectArray)) {
                throw new AssertionError();
            }
        }
        Object object2 = methodHandle.form.interpretWithArguments(objectArray);
        assert (LambdaForm.returnTypesMatch(string, objectArray, object2));
        return object2;
    }

    static Object interpret_L(MethodHandle methodHandle, Object object, Object object2) throws Throwable {
        Object[] objectArray = new Object[]{methodHandle, object, object2};
        String string = null;
        if (!$assertionsDisabled) {
            string = "LLL_L";
            if (!LambdaForm.argumentTypesMatch("LLL_L", objectArray)) {
                throw new AssertionError();
            }
        }
        Object object3 = methodHandle.form.interpretWithArguments(objectArray);
        assert (LambdaForm.returnTypesMatch(string, objectArray, object3));
        return object3;
    }

    private static LambdaForm getPreparedForm(String string) {
        MethodType methodType = LambdaForm.signatureType(string);
        LambdaForm lambdaForm = methodType.form().cachedLambdaForm(6);
        if (lambdaForm != null) {
            return lambdaForm;
        }
        assert (LambdaForm.isValidSignature(string));
        lambdaForm = new LambdaForm(string);
        lambdaForm.vmentry = InvokerBytecodeGenerator.generateLambdaFormInterpreterEntryPoint(string);
        return methodType.form().setCachedLambdaForm(6, lambdaForm);
    }

    private static boolean argumentTypesMatch(String string, Object[] objectArray) {
        int n = LambdaForm.signatureArity(string);
        assert (objectArray.length == n) : "av.length == arity: av.length=" + objectArray.length + ", arity=" + n;
        assert (objectArray[0] instanceof MethodHandle) : "av[0] not instace of MethodHandle: " + objectArray[0];
        MethodHandle methodHandle = (MethodHandle)objectArray[0];
        MethodType methodType = methodHandle.type();
        assert (methodType.parameterCount() == n - 1);
        for (int i = 0; i < objectArray.length; ++i) {
            Class<MethodHandle> clazz;
            Class clazz2 = clazz = i == 0 ? MethodHandle.class : methodType.parameterType(i - 1);
            assert (LambdaForm.valueMatches(string.charAt(i), clazz, objectArray[i]));
        }
        return true;
    }

    private static boolean valueMatches(char c, Class<?> clazz, Object object) {
        if (clazz == Void.TYPE) {
            c = (char)86;
        }
        assert (c == LambdaForm.basicType(clazz)) : c + " == basicType(" + clazz + ")=" + LambdaForm.basicType(clazz);
        switch (c) {
            case 'I': {
                assert (LambdaForm.checkInt(clazz, object)) : "checkInt(" + clazz + "," + object + ")";
                break;
            }
            case 'J': {
                assert (object instanceof Long) : "instanceof Long: " + object;
                break;
            }
            case 'F': {
                assert (object instanceof Float) : "instanceof Float: " + object;
                break;
            }
            case 'D': {
                assert (object instanceof Double) : "instanceof Double: " + object;
                break;
            }
            case 'L': {
                assert (LambdaForm.checkRef(clazz, object)) : "checkRef(" + clazz + "," + object + ")";
                break;
            }
            case 'V': {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    private static boolean returnTypesMatch(String string, Object[] objectArray, Object object) {
        MethodHandle methodHandle = (MethodHandle)objectArray[0];
        return LambdaForm.valueMatches(LambdaForm.signatureReturn(string), methodHandle.type().returnType(), object);
    }

    private static boolean checkInt(Class<?> clazz, Object object) {
        assert (object instanceof Integer);
        if (clazz == Integer.TYPE) {
            return true;
        }
        Wrapper wrapper = Wrapper.forBasicType(clazz);
        assert (wrapper.isSubwordOrInt());
        Object object2 = Wrapper.INT.wrap(wrapper.wrap(object));
        return object.equals(object2);
    }

    private static boolean checkRef(Class<?> clazz, Object object) {
        assert (!clazz.isPrimitive());
        if (object == null) {
            return true;
        }
        if (clazz.isInterface()) {
            return true;
        }
        return clazz.isInstance(object);
    }

    @Hidden
    @DontInline
    Object interpretWithArguments(Object ... objectArray) throws Throwable {
        if (TRACE_INTERPRETER) {
            return this.interpretWithArgumentsTracing(objectArray);
        }
        this.checkInvocationCounter();
        assert (this.arityCheck(objectArray));
        Object[] objectArray2 = Arrays.copyOf(objectArray, this.names.length);
        for (int i = objectArray.length; i < objectArray2.length; ++i) {
            objectArray2[i] = this.interpretName(this.names[i], objectArray2);
        }
        return this.result < 0 ? null : objectArray2[this.result];
    }

    @Hidden
    @DontInline
    Object interpretName(Name name, Object[] objectArray) throws Throwable {
        if (TRACE_INTERPRETER) {
            LambdaForm.traceInterpreter("| interpretName", name.debugString(), null);
        }
        Object[] objectArray2 = Arrays.copyOf(name.arguments, name.arguments.length, Object[].class);
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = objectArray2[i];
            if (!(object instanceof Name)) continue;
            int n = ((Name)object).index();
            assert (this.names[n] == object);
            object = objectArray[n];
            objectArray2[i] = object;
        }
        return name.function.invokeWithArguments(objectArray2);
    }

    private void checkInvocationCounter() {
        if (COMPILE_THRESHOLD != 0 && this.invocationCounter < COMPILE_THRESHOLD) {
            ++this.invocationCounter;
            if (this.invocationCounter >= COMPILE_THRESHOLD) {
                this.compileToBytecode();
            }
        }
    }

    Object interpretWithArgumentsTracing(Object ... objectArray) throws Throwable {
        Object object;
        LambdaForm.traceInterpreter("[ interpretWithArguments", this, objectArray);
        if (this.invocationCounter < COMPILE_THRESHOLD) {
            int n = this.invocationCounter++;
            LambdaForm.traceInterpreter("| invocationCounter", n);
            if (this.invocationCounter >= COMPILE_THRESHOLD) {
                this.compileToBytecode();
            }
        }
        try {
            assert (this.arityCheck(objectArray));
            Object[] objectArray2 = Arrays.copyOf(objectArray, this.names.length);
            for (int i = objectArray.length; i < objectArray2.length; ++i) {
                objectArray2[i] = this.interpretName(this.names[i], objectArray2);
            }
            object = this.result < 0 ? null : objectArray2[this.result];
        }
        catch (Throwable throwable) {
            LambdaForm.traceInterpreter("] throw =>", throwable);
            throw throwable;
        }
        LambdaForm.traceInterpreter("] return =>", object);
        return object;
    }

    static void traceInterpreter(String string, Object object, Object ... objectArray) {
        if (TRACE_INTERPRETER) {
            System.out.println("LFI: " + string + " " + (object != null ? object : "") + (objectArray != null && objectArray.length != 0 ? Arrays.asList(objectArray) : ""));
        }
    }

    static void traceInterpreter(String string, Object object) {
        LambdaForm.traceInterpreter(string, object, null);
    }

    private boolean arityCheck(Object[] objectArray) {
        assert (objectArray.length == this.arity) : this.arity + "!=" + Arrays.asList(objectArray) + ".length";
        assert (objectArray[0] instanceof MethodHandle) : "not MH: " + objectArray[0];
        assert (((MethodHandle)objectArray[0]).internalForm() == this);
        return true;
    }

    private boolean isEmpty() {
        if (this.result < 0) {
            return this.names.length == this.arity;
        }
        if (this.result == this.arity && this.names.length == this.arity + 1) {
            return this.names[this.arity].isConstantZero();
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.debugName + "=Lambda(");
        for (int i = 0; i < this.names.length; ++i) {
            if (i == this.arity) {
                stringBuilder.append(")=>{");
            }
            Name name = this.names[i];
            if (i >= this.arity) {
                stringBuilder.append("\n    ");
            }
            stringBuilder.append(name);
            if (i < this.arity) {
                if (i + 1 >= this.arity) continue;
                stringBuilder.append(",");
                continue;
            }
            stringBuilder.append("=").append(name.exprString());
            stringBuilder.append(";");
        }
        stringBuilder.append(this.result < 0 ? "void" : this.names[this.result]).append("}");
        if (TRACE_INTERPRETER) {
            stringBuilder.append(":").append(this.basicTypeSignature());
            stringBuilder.append("/").append(this.vmentry);
        }
        return stringBuilder.toString();
    }

    LambdaForm bindImmediate(int n, char c, Object object) {
        assert (n > 0 && n < this.arity && this.names[n].type == c && Name.typesMatch(c, object));
        int n2 = this.arity - 1;
        Name[] nameArray = new Name[this.names.length - 1];
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.names.length) {
            Name name = this.names[n3];
            if (name.isParam()) {
                if (name.index == n) {
                    --n4;
                } else {
                    nameArray[n4] = new Name(n4, name.type);
                }
            } else {
                Object[] objectArray = new Object[name.arguments.length];
                for (int i = 0; i < name.arguments.length; ++i) {
                    Object object2 = name.arguments[i];
                    if (object2 instanceof Name) {
                        short s = ((Name)object2).index;
                        if (s == n) {
                            objectArray[i] = object;
                            continue;
                        }
                        if (s < n) {
                            objectArray[i] = nameArray[s];
                            continue;
                        }
                        objectArray[i] = nameArray[s - 1];
                        continue;
                    }
                    objectArray[i] = object2;
                }
                nameArray[n4] = new Name(name.function, objectArray);
                nameArray[n4].initIndex(n4);
            }
            ++n3;
            ++n4;
        }
        n3 = this.result == -1 ? -1 : this.result - 1;
        return new LambdaForm(this.debugName, n2, nameArray, n3);
    }

    LambdaForm bind(int n, BoundMethodHandle.SpeciesData speciesData) {
        Name name = this.names[n];
        BoundMethodHandle.SpeciesData speciesData2 = speciesData.extendWithType(name.type);
        return this.bind(name, speciesData2.getterName(this.names[0], speciesData.fieldCount()), speciesData, speciesData2);
    }

    LambdaForm bind(Name name, Name name2, BoundMethodHandle.SpeciesData speciesData, BoundMethodHandle.SpeciesData speciesData2) {
        Name name3;
        int n;
        int n2 = name.index;
        assert (name.isParam());
        assert (!name2.isParam());
        assert (name.type == name2.type);
        assert (0 <= n2 && n2 < this.arity && this.names[n2] == name);
        assert (name2.function.memberDeclaringClassOrNull() == speciesData2.clazz);
        assert (speciesData.getters.length == speciesData2.getters.length - 1);
        if (this.bindCache != null) {
            LambdaForm lambdaForm = this.bindCache[n2];
            if (lambdaForm != null) {
                assert (lambdaForm.contains(name2)) : "form << " + lambdaForm + " >> does not contain binding << " + name2 + " >>";
                return lambdaForm;
            }
        } else {
            this.bindCache = new LambdaForm[this.arity];
        }
        assert (this.nameRefsAreLegal());
        int n3 = this.arity - 1;
        Name[] nameArray = (Name[])this.names.clone();
        nameArray[n2] = name2;
        int n4 = -1;
        for (n = 0; n < nameArray.length; ++n) {
            Name name4;
            name3 = this.names[n];
            if (name3.function == null || name3.function.memberDeclaringClassOrNull() != speciesData.clazz) continue;
            MethodHandle methodHandle = name3.function.resolvedHandle;
            MethodHandle methodHandle2 = null;
            for (int i = 0; i < speciesData.getters.length; ++i) {
                if (methodHandle != speciesData.getters[i]) continue;
                methodHandle2 = speciesData2.getters[i];
            }
            if (methodHandle2 == null) continue;
            if (n4 < 0) {
                n4 = n;
            }
            nameArray[n] = name4 = new Name(methodHandle2, name3.arguments);
        }
        assert (n4 < 0 || n4 > n2);
        for (n = n2 + 1; n < nameArray.length; ++n) {
            if (n <= n3) continue;
            nameArray[n] = nameArray[n].replaceNames(this.names, nameArray, n2, n);
        }
        n = n2;
        while (n + 1 < nameArray.length && (name3 = nameArray[n + 1]).isSiblingBindingBefore(name2)) {
            nameArray[n] = name3;
            ++n;
        }
        nameArray[n] = name2;
        int n5 = this.result;
        if (n5 == n2) {
            n5 = n;
        } else if (n5 > n2 && n5 <= n) {
            --n5;
        }
        this.bindCache[n2] = new LambdaForm(this.debugName, n3, nameArray, n5);
        return this.bindCache[n2];
    }

    boolean contains(Name name) {
        int n = name.index();
        if (n >= 0) {
            return n < this.names.length && name.equals(this.names[n]);
        }
        for (int i = this.arity; i < this.names.length; ++i) {
            if (!name.equals(this.names[i])) continue;
            return true;
        }
        return false;
    }

    LambdaForm addArguments(int n, char ... cArray) {
        assert (n <= this.arity);
        int n2 = this.names.length;
        int n3 = cArray.length;
        Name[] nameArray = Arrays.copyOf(this.names, n2 + n3);
        int n4 = this.arity + n3;
        int n5 = this.result;
        if (n5 >= this.arity) {
            n5 += n3;
        }
        int n6 = n + 1;
        System.arraycopy(this.names, n6, nameArray, n6 + n3, n2 - n6);
        for (int i = 0; i < n3; ++i) {
            nameArray[n6 + i] = new Name(cArray[i]);
        }
        return new LambdaForm(this.debugName, n4, nameArray, n5);
    }

    LambdaForm addArguments(int n, List<Class<?>> list) {
        char[] cArray = new char[list.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = LambdaForm.basicType(list.get(i));
        }
        return this.addArguments(n, cArray);
    }

    LambdaForm permuteArguments(int n, int[] nArray, char[] cArray) {
        int n2;
        Name name;
        int n3;
        int n4;
        int n5 = this.names.length;
        int n6 = cArray.length;
        int n7 = nArray.length;
        assert (n + n7 == this.arity);
        assert (LambdaForm.permutedTypesMatch(nArray, cArray, this.names, n));
        for (n4 = 0; n4 < n7 && nArray[n4] == n4; ++n4) {
        }
        Name[] nameArray = new Name[n5 - n7 + n6];
        System.arraycopy(this.names, 0, nameArray, 0, n + n4);
        int n8 = n5 - this.arity;
        System.arraycopy(this.names, n + n7, nameArray, n + n6, n8);
        int n9 = nameArray.length - n8;
        int n10 = this.result;
        if (n10 >= 0) {
            n10 = n10 < n + n7 ? nArray[n10 - n] : n10 - n7 + n6;
        }
        for (n3 = n4; n3 < n7; ++n3) {
            Name name2 = this.names[n + n3];
            int n11 = nArray[n3];
            name = nameArray[n + n11];
            if (name == null) {
                nameArray[n + n11] = name = new Name(cArray[n11]);
            } else assert (name.type == cArray[n11]);
            for (n2 = n9; n2 < nameArray.length; ++n2) {
                nameArray[n2] = nameArray[n2].replaceName(name2, name);
            }
        }
        for (n3 = n + n4; n3 < n9; ++n3) {
            if (nameArray[n3] != null) continue;
            nameArray[n3] = LambdaForm.argument(n3, cArray[n3 - n]);
        }
        for (n3 = this.arity; n3 < this.names.length; ++n3) {
            Name name3 = this.names[n3];
            int n12 = n3 - this.arity + n9;
            name = nameArray[n12];
            if (name3 == name) continue;
            for (n2 = n12 + 1; n2 < nameArray.length; ++n2) {
                nameArray[n2] = nameArray[n2].replaceName(name3, name);
            }
        }
        return new LambdaForm(this.debugName, n9, nameArray, n10);
    }

    static boolean permutedTypesMatch(int[] nArray, char[] cArray, Name[] nameArray, int n) {
        int n2 = cArray.length;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            assert (nameArray[n + i].isParam());
            assert (nameArray[n + i].type == cArray[nArray[i]]);
        }
        return true;
    }

    void resolve() {
        for (Name name : this.names) {
            name.resolve();
        }
    }

    public static char basicType(Class<?> clazz) {
        char c = Wrapper.basicTypeChar(clazz);
        if ("ZBSC".indexOf(c) >= 0) {
            c = 'I';
        }
        assert ("LIJFDV".indexOf(c) >= 0);
        return c;
    }

    public static char[] basicTypes(List<Class<?>> list) {
        char[] cArray = new char[list.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = LambdaForm.basicType(list.get(i));
        }
        return cArray;
    }

    public static String basicTypeSignature(MethodType methodType) {
        char[] cArray = new char[methodType.parameterCount() + 2];
        int n = 0;
        for (Class<?> clazz : methodType.parameterList()) {
            cArray[n++] = LambdaForm.basicType(clazz);
        }
        cArray[n++] = 95;
        cArray[n++] = LambdaForm.basicType(methodType.returnType());
        assert (n == cArray.length);
        return String.valueOf(cArray);
    }

    int lastUseIndex(Name name) {
        short s = name.index;
        int n = this.names.length;
        assert (this.names[s] == name);
        if (this.result == s) {
            return n;
        }
        int n2 = n;
        while (--n2 > s) {
            if (this.names[n2].lastUseIndex(name) < 0) continue;
            return n2;
        }
        return -1;
    }

    int useCount(Name name) {
        int n;
        short s = name.index;
        int n2 = this.names.length;
        int n3 = this.lastUseIndex(name);
        if (n3 < 0) {
            return 0;
        }
        int n4 = 0;
        if (n3 == n2) {
            ++n4;
            --n3;
        }
        if ((n = name.index() + 1) < this.arity) {
            n = this.arity;
        }
        for (int i = n; i <= n3; ++i) {
            n4 += this.names[i].useCount(name);
        }
        return n4;
    }

    static Name argument(int n, char c) {
        int n2 = ALL_TYPES.indexOf(c);
        if (n2 < 0 || n >= 10) {
            return new Name(n, c);
        }
        return INTERNED_ARGUMENTS[n2][n];
    }

    static Name internArgument(Name name) {
        assert (name.isParam()) : "not param: " + name;
        assert (name.index < 10);
        return LambdaForm.argument(name.index, name.type);
    }

    static Name[] arguments(int n, String string) {
        int n2 = string.length();
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, string.charAt(i));
        }
        return nameArray;
    }

    static Name[] arguments(int n, char ... cArray) {
        int n2 = cArray.length;
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, cArray[i]);
        }
        return nameArray;
    }

    static Name[] arguments(int n, List<Class<?>> list) {
        int n2 = list.size();
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, LambdaForm.basicType(list.get(i)));
        }
        return nameArray;
    }

    static Name[] arguments(int n, Class<?> ... classArray) {
        int n2 = classArray.length;
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, LambdaForm.basicType(classArray[i]));
        }
        return nameArray;
    }

    static Name[] arguments(int n, MethodType methodType) {
        int n2 = methodType.parameterCount();
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, LambdaForm.basicType(methodType.parameterType(i)));
        }
        return nameArray;
    }

    static Name constantZero(int n, char c) {
        return CONSTANT_ZERO[ALL_TYPES.indexOf(c)].newIndex(n);
    }

    private static int zeroI() {
        return 0;
    }

    private static long zeroJ() {
        return 0L;
    }

    private static float zeroF() {
        return 0.0f;
    }

    private static double zeroD() {
        return 0.0;
    }

    private static Object zeroL() {
        return null;
    }

    static {
        int n = 512;
        float f = 0.75f;
        char c = '\u0001';
        PREPARED_FORMS = new ConcurrentHashMap(n, f, c);
        COMPILE_THRESHOLD = MethodHandleStatics.COMPILE_THRESHOLD != null ? MethodHandleStatics.COMPILE_THRESHOLD : 30;
        INTERNED_ARGUMENTS = new Name[ALL_TYPES.length()][10];
        for (n = 0; n < ALL_TYPES.length(); ++n) {
            for (int i = 0; i < INTERNED_ARGUMENTS[n].length; ++i) {
                c = ALL_TYPES.charAt(n);
                LambdaForm.INTERNED_ARGUMENTS[n][i] = new Name(i, c);
            }
        }
        IMPL_NAMES = MemberName.getFactory();
        CONSTANT_ZERO = new Name[ALL_TYPES.length()];
        for (n = 0; n < ALL_TYPES.length(); ++n) {
            char c2 = ALL_TYPES.charAt(n);
            Wrapper wrapper = Wrapper.forBasicType(c2);
            MemberName memberName = new MemberName(LambdaForm.class, "zero" + c2, MethodType.methodType(wrapper.primitiveType()), 6);
            try {
                memberName = IMPL_NAMES.resolveOrFail((byte)6, memberName, null, NoSuchMethodException.class);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError(reflectiveOperationException);
            }
            NamedFunction namedFunction = new NamedFunction(memberName);
            Name name = new Name(namedFunction, new Object[0]).newIndex(0);
            assert (name.type == ALL_TYPES.charAt(n));
            LambdaForm.CONSTANT_ZERO[n] = name;
            assert (name.isConstantZero());
        }
        PREPARED_FORMS.putAll(LambdaForm.computeInitialPreparedForms());
        NamedFunction.initializeInvokers();
        TRACE_INTERPRETER = MethodHandleStatics.TRACE_INTERPRETER;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Hidden {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Compiled {
    }

    static final class Name {
        final char type;
        private short index;
        final NamedFunction function;
        @Stable
        final Object[] arguments;

        private Name(int n, char c, NamedFunction namedFunction, Object[] objectArray) {
            this.index = (short)n;
            this.type = c;
            this.function = namedFunction;
            this.arguments = objectArray;
            assert (this.index == n);
        }

        Name(MethodHandle methodHandle, Object ... objectArray) {
            this(new NamedFunction(methodHandle), objectArray);
        }

        Name(MethodType methodType, Object ... objectArray) {
            this(new NamedFunction(methodType), objectArray);
            assert (objectArray[0] instanceof Name && ((Name)objectArray[0]).type == 'L');
        }

        Name(MemberName memberName, Object ... objectArray) {
            this(new NamedFunction(memberName), objectArray);
        }

        Name(NamedFunction namedFunction, Object ... objectArray) {
            objectArray = (Object[])objectArray.clone();
            this(-1, namedFunction.returnType(), namedFunction, objectArray);
            assert (objectArray.length == namedFunction.arity()) : "arity mismatch: arguments.length=" + objectArray.length + " == function.arity()=" + namedFunction.arity() + " in " + this.debugString();
            for (int i = 0; i < objectArray.length; ++i) {
                assert (Name.typesMatch(namedFunction.parameterType(i), objectArray[i])) : "types don't match: function.parameterType(" + i + ")=" + namedFunction.parameterType(i) + ", arguments[" + i + "]=" + objectArray[i] + " in " + this.debugString();
            }
        }

        Name(int n, char c) {
            this(n, c, null, null);
        }

        Name(char c) {
            this(-1, c);
        }

        char type() {
            return this.type;
        }

        int index() {
            return this.index;
        }

        boolean initIndex(int n) {
            if (this.index != n) {
                if (this.index != -1) {
                    return false;
                }
                this.index = (short)n;
            }
            return true;
        }

        void resolve() {
            if (this.function != null) {
                this.function.resolve();
            }
        }

        Name newIndex(int n) {
            if (this.initIndex(n)) {
                return this;
            }
            return this.cloneWithIndex(n);
        }

        Name cloneWithIndex(int n) {
            Object[] objectArray = this.arguments == null ? null : (Object[])this.arguments.clone();
            return new Name(n, this.type, this.function, objectArray);
        }

        Name replaceName(Name name, Name name2) {
            if (name == name2) {
                return this;
            }
            Object[] objectArray = this.arguments;
            if (objectArray == null) {
                return this;
            }
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != name) continue;
                if (!bl) {
                    bl = true;
                    objectArray = (Object[])objectArray.clone();
                }
                objectArray[i] = name2;
            }
            if (!bl) {
                return this;
            }
            return new Name(this.function, objectArray);
        }

        Name replaceNames(Name[] nameArray, Name[] nameArray2, int n, int n2) {
            Object[] objectArray = this.arguments;
            boolean bl = false;
            block0: for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Name)) continue;
                Name name = (Name)objectArray[i];
                short s = name.index;
                if (s >= 0 && s < nameArray2.length && name == nameArray2[s]) continue;
                for (int j = n; j < n2; ++j) {
                    if (name != nameArray[j]) continue;
                    if (name == nameArray2[j]) continue block0;
                    if (!bl) {
                        bl = true;
                        objectArray = (Object[])objectArray.clone();
                    }
                    objectArray[i] = nameArray2[j];
                    continue block0;
                }
            }
            if (!bl) {
                return this;
            }
            return new Name(this.function, objectArray);
        }

        void internArguments() {
            Object[] objectArray = this.arguments;
            for (int i = 0; i < objectArray.length; ++i) {
                Name name;
                if (!(objectArray[i] instanceof Name) || !(name = (Name)objectArray[i]).isParam() || name.index >= 10) continue;
                objectArray[i] = LambdaForm.internArgument(name);
            }
        }

        boolean isParam() {
            return this.function == null;
        }

        boolean isConstantZero() {
            return !this.isParam() && this.arguments.length == 0 && this.function.equals(LambdaForm.constantZero((int)0, (char)this.type).function);
        }

        public String toString() {
            return (this.isParam() ? "a" : "t") + (this.index >= 0 ? this.index : System.identityHashCode(this)) + ":" + this.type;
        }

        public String debugString() {
            String string = this.toString();
            return this.function == null ? string : string + "=" + this.exprString();
        }

        public String exprString() {
            if (this.function == null) {
                return "null";
            }
            StringBuilder stringBuilder = new StringBuilder(this.function.toString());
            stringBuilder.append("(");
            String string = "";
            for (Object object : this.arguments) {
                stringBuilder.append(string);
                string = ",";
                if (object instanceof Name || object instanceof Integer) {
                    stringBuilder.append(object);
                    continue;
                }
                stringBuilder.append("(").append(object).append(")");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        private static boolean typesMatch(char c, Object object) {
            if (object instanceof Name) {
                return ((Name)object).type == c;
            }
            switch (c) {
                case 'I': {
                    return object instanceof Integer;
                }
                case 'J': {
                    return object instanceof Long;
                }
                case 'F': {
                    return object instanceof Float;
                }
                case 'D': {
                    return object instanceof Double;
                }
            }
            assert (c == 'L');
            return true;
        }

        boolean isSiblingBindingBefore(Name name) {
            assert (!name.isParam());
            if (this.isParam()) {
                return true;
            }
            if (this.function.equals(name.function) && this.arguments.length == name.arguments.length) {
                boolean bl = false;
                for (int i = 0; i < this.arguments.length; ++i) {
                    Object object = this.arguments[i];
                    Object object2 = name.arguments[i];
                    if (object.equals(object2)) continue;
                    if (object instanceof Integer && object2 instanceof Integer) {
                        if (bl) continue;
                        bl = true;
                        if ((Integer)object < (Integer)object2) continue;
                    }
                    return false;
                }
                return bl;
            }
            return false;
        }

        int lastUseIndex(Name name) {
            if (this.arguments == null) {
                return -1;
            }
            int n = this.arguments.length;
            while (--n >= 0) {
                if (this.arguments[n] != name) continue;
                return n;
            }
            return -1;
        }

        int useCount(Name name) {
            if (this.arguments == null) {
                return 0;
            }
            int n = 0;
            int n2 = this.arguments.length;
            while (--n2 >= 0) {
                if (this.arguments[n2] != name) continue;
                ++n;
            }
            return n;
        }

        boolean contains(Name name) {
            return this == name || this.lastUseIndex(name) >= 0;
        }

        public boolean equals(Name name) {
            if (this == name) {
                return true;
            }
            if (this.isParam()) {
                return false;
            }
            return this.type == name.type && this.function.equals(name.function) && Arrays.equals(this.arguments, name.arguments);
        }

        public boolean equals(Object object) {
            return object instanceof Name && this.equals((Name)object);
        }

        public int hashCode() {
            if (this.isParam()) {
                return this.index | this.type << 8;
            }
            return this.function.hashCode() ^ Arrays.hashCode(this.arguments);
        }
    }

    static class NamedFunction {
        final MemberName member;
        @Stable
        MethodHandle resolvedHandle;
        @Stable
        MethodHandle invoker;
        static final MethodType INVOKER_METHOD_TYPE = MethodType.methodType(Object.class, MethodHandle.class, Object[].class);

        NamedFunction(MethodHandle methodHandle) {
            this(methodHandle.internalMemberName(), methodHandle);
        }

        NamedFunction(MemberName memberName, MethodHandle methodHandle) {
            this.member = memberName;
            this.resolvedHandle = methodHandle;
        }

        NamedFunction(MethodType methodType) {
            assert (methodType == methodType.basicType()) : methodType;
            if (methodType.parameterSlotCount() < 253) {
                this.resolvedHandle = methodType.invokers().basicInvoker();
                this.member = this.resolvedHandle.internalMemberName();
            } else {
                this.member = Invokers.invokeBasicMethod(methodType);
            }
        }

        NamedFunction(Method method) {
            this(new MemberName(method));
        }

        NamedFunction(Field field) {
            this(new MemberName(field));
        }

        NamedFunction(MemberName memberName) {
            this.member = memberName;
            this.resolvedHandle = null;
        }

        MethodHandle resolvedHandle() {
            if (this.resolvedHandle == null) {
                this.resolve();
            }
            return this.resolvedHandle;
        }

        void resolve() {
            this.resolvedHandle = DirectMethodHandle.make(this.member);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof NamedFunction)) {
                return false;
            }
            NamedFunction namedFunction = (NamedFunction)object;
            return this.member != null && this.member.equals(namedFunction.member);
        }

        public int hashCode() {
            if (this.member != null) {
                return this.member.hashCode();
            }
            return super.hashCode();
        }

        static void initializeInvokers() {
            for (MemberName memberName : MemberName.getFactory().getMethods(NamedFunction.class, false, null, null, null)) {
                MethodType methodType;
                if (!memberName.isStatic() || !memberName.isPackage() || !(methodType = memberName.getMethodType()).equals((Object)INVOKER_METHOD_TYPE) || !memberName.getName().startsWith("invoke_")) continue;
                String string = memberName.getName().substring("invoke_".length());
                int n = LambdaForm.signatureArity(string);
                MethodType methodType2 = MethodType.genericMethodType(n);
                if (LambdaForm.signatureReturn(string) == 'V') {
                    methodType2 = methodType2.changeReturnType(Void.TYPE);
                }
                MethodTypeForm methodTypeForm = methodType2.form();
                methodTypeForm.namedFunctionInvoker = DirectMethodHandle.make(memberName);
            }
        }

        @Hidden
        static Object invoke__V(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (objectArray.length == 0);
            methodHandle.invokeBasic();
            return null;
        }

        @Hidden
        static Object invoke_L_V(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (objectArray.length == 1);
            methodHandle.invokeBasic(objectArray[0]);
            return null;
        }

        @Hidden
        static Object invoke_LL_V(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (objectArray.length == 2);
            methodHandle.invokeBasic(objectArray[0], objectArray[1]);
            return null;
        }

        @Hidden
        static Object invoke_LLL_V(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (objectArray.length == 3);
            methodHandle.invokeBasic(objectArray[0], objectArray[1], objectArray[2]);
            return null;
        }

        @Hidden
        static Object invoke_LLLL_V(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (objectArray.length == 4);
            methodHandle.invokeBasic(objectArray[0], objectArray[1], objectArray[2], objectArray[3]);
            return null;
        }

        @Hidden
        static Object invoke_LLLLL_V(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (objectArray.length == 5);
            methodHandle.invokeBasic(objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4]);
            return null;
        }

        @Hidden
        static Object invoke__L(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (objectArray.length == 0);
            return methodHandle.invokeBasic();
        }

        @Hidden
        static Object invoke_L_L(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (objectArray.length == 1);
            return methodHandle.invokeBasic(objectArray[0]);
        }

        @Hidden
        static Object invoke_LL_L(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (objectArray.length == 2);
            return methodHandle.invokeBasic(objectArray[0], objectArray[1]);
        }

        @Hidden
        static Object invoke_LLL_L(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (objectArray.length == 3);
            return methodHandle.invokeBasic(objectArray[0], objectArray[1], objectArray[2]);
        }

        @Hidden
        static Object invoke_LLLL_L(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (objectArray.length == 4);
            return methodHandle.invokeBasic(objectArray[0], objectArray[1], objectArray[2], objectArray[3]);
        }

        @Hidden
        static Object invoke_LLLLL_L(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (objectArray.length == 5);
            return methodHandle.invokeBasic(objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4]);
        }

        private static MethodHandle computeInvoker(MethodTypeForm methodTypeForm) {
            MethodHandle methodHandle = methodTypeForm.namedFunctionInvoker;
            if (methodHandle != null) {
                return methodHandle;
            }
            MemberName memberName = InvokerBytecodeGenerator.generateNamedFunctionInvoker(methodTypeForm);
            methodHandle = DirectMethodHandle.make(memberName);
            MethodHandle methodHandle2 = methodTypeForm.namedFunctionInvoker;
            if (methodHandle2 != null) {
                return methodHandle2;
            }
            if (!methodHandle.type().equals((Object)INVOKER_METHOD_TYPE)) {
                throw new InternalError(methodHandle.debugString());
            }
            methodTypeForm.namedFunctionInvoker = methodHandle;
            return methodTypeForm.namedFunctionInvoker;
        }

        @Hidden
        Object invokeWithArguments(Object ... objectArray) throws Throwable {
            if (TRACE_INTERPRETER) {
                return this.invokeWithArgumentsTracing(objectArray);
            }
            assert (NamedFunction.checkArgumentTypes(objectArray, this.methodType()));
            return this.invoker().invokeBasic(this.resolvedHandle(), objectArray);
        }

        @Hidden
        Object invokeWithArgumentsTracing(Object[] objectArray) throws Throwable {
            Object object;
            try {
                LambdaForm.traceInterpreter("[ call", this, objectArray);
                if (this.invoker == null) {
                    LambdaForm.traceInterpreter("| getInvoker", this);
                    this.invoker();
                }
                if (this.resolvedHandle == null) {
                    LambdaForm.traceInterpreter("| resolve", this);
                    this.resolvedHandle();
                }
                assert (NamedFunction.checkArgumentTypes(objectArray, this.methodType()));
                object = this.invoker().invokeBasic(this.resolvedHandle(), objectArray);
            }
            catch (Throwable throwable) {
                LambdaForm.traceInterpreter("] throw =>", throwable);
                throw throwable;
            }
            LambdaForm.traceInterpreter("] return =>", object);
            return object;
        }

        private MethodHandle invoker() {
            if (this.invoker != null) {
                return this.invoker;
            }
            this.invoker = NamedFunction.computeInvoker(this.methodType().form());
            return this.invoker;
        }

        private static boolean checkArgumentTypes(Object[] objectArray, MethodType methodType) {
            return true;
        }

        String basicTypeSignature() {
            return LambdaForm.basicTypeSignature(this.methodType());
        }

        MethodType methodType() {
            if (this.resolvedHandle != null) {
                return this.resolvedHandle.type();
            }
            return this.member.getInvocationType();
        }

        MemberName member() {
            assert (this.assertMemberIsConsistent());
            return this.member;
        }

        private boolean assertMemberIsConsistent() {
            if (this.resolvedHandle instanceof DirectMethodHandle) {
                MemberName memberName = this.resolvedHandle.internalMemberName();
                assert (memberName.equals(this.member));
            }
            return true;
        }

        Class<?> memberDeclaringClassOrNull() {
            return this.member == null ? null : this.member.getDeclaringClass();
        }

        char returnType() {
            return LambdaForm.basicType(this.methodType().returnType());
        }

        char parameterType(int n) {
            return LambdaForm.basicType(this.methodType().parameterType(n));
        }

        int arity() {
            return this.methodType().parameterCount();
        }

        public String toString() {
            if (this.member == null) {
                return String.valueOf(this.resolvedHandle);
            }
            return this.member.getDeclaringClass().getSimpleName() + "." + this.member.getName();
        }
    }
}

