/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.Wrapper;

abstract class BoundMethodHandle
extends MethodHandle {
    static final String EXTENSION_TYPES = "LIJFD";
    static final byte INDEX_L = 0;
    static final byte INDEX_I = 1;
    static final byte INDEX_J = 2;
    static final byte INDEX_F = 3;
    static final byte INDEX_D = 4;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.Lookup.IMPL_LOOKUP;
    static final SpeciesData SPECIES_DATA = SpeciesData.EMPTY;
    private static final SpeciesData[] SPECIES_DATA_CACHE = new SpeciesData[5];

    BoundMethodHandle(MethodType methodType, LambdaForm lambdaForm) {
        super(methodType, lambdaForm);
    }

    static MethodHandle bindSingle(MethodType methodType, LambdaForm lambdaForm, char c, Object object) {
        try {
            switch (c) {
                case 'L': {
                    return BoundMethodHandle.bindSingle(methodType, lambdaForm, object);
                }
                case 'I': {
                    return SpeciesData.EMPTY.extendWithType((char)'I').constructor[0].invokeBasic(methodType, lambdaForm, ValueConversions.widenSubword(object));
                }
                case 'J': {
                    return SpeciesData.EMPTY.extendWithType((char)'J').constructor[0].invokeBasic(methodType, lambdaForm, (Long)object);
                }
                case 'F': {
                    return SpeciesData.EMPTY.extendWithType((char)'F').constructor[0].invokeBasic(methodType, lambdaForm, ((Float)object).floatValue());
                }
                case 'D': {
                    return SpeciesData.EMPTY.extendWithType((char)'D').constructor[0].invokeBasic(methodType, lambdaForm, (Double)object);
                }
            }
            throw new InternalError("unexpected xtype: " + c);
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.newInternalError(throwable);
        }
    }

    static MethodHandle bindSingle(MethodType methodType, LambdaForm lambdaForm, Object object) {
        return new Species_L(methodType, lambdaForm, object);
    }

    MethodHandle cloneExtend(MethodType methodType, LambdaForm lambdaForm, char c, Object object) {
        try {
            switch (c) {
                case 'L': {
                    return this.cloneExtendL(methodType, lambdaForm, object);
                }
                case 'I': {
                    return this.cloneExtendI(methodType, lambdaForm, ValueConversions.widenSubword(object));
                }
                case 'J': {
                    return this.cloneExtendJ(methodType, lambdaForm, (Long)object);
                }
                case 'F': {
                    return this.cloneExtendF(methodType, lambdaForm, ((Float)object).floatValue());
                }
                case 'D': {
                    return this.cloneExtendD(methodType, lambdaForm, (Double)object);
                }
            }
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.newInternalError(throwable);
        }
        throw new InternalError("unexpected type: " + c);
    }

    @Override
    MethodHandle bindArgument(int n, char c, Object object) {
        MethodType methodType = this.type().dropParameterTypes(n, n + 1);
        LambdaForm lambdaForm = this.internalForm().bind(1 + n, this.speciesData());
        return this.cloneExtend(methodType, lambdaForm, c, object);
    }

    @Override
    MethodHandle dropArguments(MethodType methodType, int n, int n2) {
        LambdaForm lambdaForm = this.internalForm().addArguments(n, methodType.parameterList().subList(n, n + n2));
        try {
            return this.clone(methodType, lambdaForm);
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.newInternalError(throwable);
        }
    }

    @Override
    MethodHandle permuteArguments(MethodType methodType, int[] nArray) {
        try {
            return this.clone(methodType, this.form.permuteArguments(1, nArray, LambdaForm.basicTypes(methodType.parameterList())));
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.newInternalError(throwable);
        }
    }

    static byte extensionIndex(char c) {
        int n = EXTENSION_TYPES.indexOf(c);
        if (n < 0) {
            throw new InternalError();
        }
        return (byte)n;
    }

    abstract SpeciesData speciesData();

    @Override
    final Object internalProperties() {
        return "/BMH=" + this.internalValues();
    }

    @Override
    final Object internalValues() {
        Object[] objectArray = new Object[this.speciesData().fieldCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.arg(i);
        }
        return Arrays.asList(objectArray);
    }

    final Object arg(int n) {
        try {
            switch (this.speciesData().fieldType(n)) {
                case 'L': {
                    return this.argL(n);
                }
                case 'I': {
                    return this.argI(n);
                }
                case 'F': {
                    return Float.valueOf(this.argF(n));
                }
                case 'D': {
                    return this.argD(n);
                }
                case 'J': {
                    return this.argJ(n);
                }
            }
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.newInternalError(throwable);
        }
        throw new InternalError("unexpected type: " + this.speciesData().types + "." + n);
    }

    final Object argL(int n) throws Throwable {
        return this.speciesData().getters[n].invokeBasic(this);
    }

    final int argI(int n) throws Throwable {
        return this.speciesData().getters[n].invokeBasic(this);
    }

    final float argF(int n) throws Throwable {
        return this.speciesData().getters[n].invokeBasic(this);
    }

    final double argD(int n) throws Throwable {
        return this.speciesData().getters[n].invokeBasic(this);
    }

    final long argJ(int n) throws Throwable {
        return this.speciesData().getters[n].invokeBasic(this);
    }

    abstract BoundMethodHandle clone(MethodType var1, LambdaForm var2) throws Throwable;

    abstract BoundMethodHandle cloneExtendL(MethodType var1, LambdaForm var2, Object var3) throws Throwable;

    abstract BoundMethodHandle cloneExtendI(MethodType var1, LambdaForm var2, int var3) throws Throwable;

    abstract BoundMethodHandle cloneExtendJ(MethodType var1, LambdaForm var2, long var3) throws Throwable;

    abstract BoundMethodHandle cloneExtendF(MethodType var1, LambdaForm var2, float var3) throws Throwable;

    abstract BoundMethodHandle cloneExtendD(MethodType var1, LambdaForm var2, double var3) throws Throwable;

    @Override
    MethodHandle reinvokerTarget() {
        try {
            return (MethodHandle)this.argL(0);
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.newInternalError(throwable);
        }
    }

    static SpeciesData getSpeciesData(String string) {
        return SpeciesData.get(string);
    }

    private static SpeciesData checkCache(int n, String string) {
        int n2 = n - 1;
        SpeciesData speciesData = SPECIES_DATA_CACHE[n2];
        if (speciesData != null) {
            return speciesData;
        }
        BoundMethodHandle.SPECIES_DATA_CACHE[n2] = speciesData = BoundMethodHandle.getSpeciesData(string);
        return speciesData;
    }

    static SpeciesData speciesData_L() {
        return BoundMethodHandle.checkCache(1, "L");
    }

    static SpeciesData speciesData_LL() {
        return BoundMethodHandle.checkCache(2, "LL");
    }

    static SpeciesData speciesData_LLL() {
        return BoundMethodHandle.checkCache(3, "LLL");
    }

    static SpeciesData speciesData_LLLL() {
        return BoundMethodHandle.checkCache(4, "LLLL");
    }

    static SpeciesData speciesData_LLLLL() {
        return BoundMethodHandle.checkCache(5, "LLLLL");
    }

    static class Factory {
        static final String JLO_SIG = "Ljava/lang/Object;";
        static final String JLS_SIG = "Ljava/lang/String;";
        static final String JLC_SIG = "Ljava/lang/Class;";
        static final String MH = "java/lang/invoke/MethodHandle";
        static final String MH_SIG = "Ljava/lang/invoke/MethodHandle;";
        static final String BMH = "java/lang/invoke/BoundMethodHandle";
        static final String BMH_SIG = "Ljava/lang/invoke/BoundMethodHandle;";
        static final String SPECIES_DATA = "java/lang/invoke/BoundMethodHandle$SpeciesData";
        static final String SPECIES_DATA_SIG = "Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String SPECIES_PREFIX_NAME = "Species_";
        static final String SPECIES_PREFIX_PATH = "java/lang/invoke/BoundMethodHandle$Species_";
        static final String BMHSPECIES_DATA_EWI_SIG = "(B)Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String BMHSPECIES_DATA_GFC_SIG = "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String MYSPECIES_DATA_SIG = "()Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String VOID_SIG = "()V";
        static final String SIG_INCIPIT = "(Ljava/lang/invoke/MethodType;Ljava/lang/invoke/LambdaForm;";
        static final Class<?>[] TYPES = new Class[]{Object.class, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        static final String[] E_THROWABLE = new String[]{"java/lang/Throwable"};

        Factory() {
        }

        /*
         * WARNING - void declaration
         */
        static Class<? extends BoundMethodHandle> generateConcreteBMHClass(String string) {
            void var6_8;
            ClassWriter classWriter = new ClassWriter(3);
            String string2 = SPECIES_PREFIX_PATH + string;
            String string3 = SPECIES_PREFIX_NAME + string;
            classWriter.visit(50, 48, string2, null, BMH, null);
            classWriter.visitSource(string3, null);
            classWriter.visitField(8, "SPECIES_DATA", SPECIES_DATA_SIG, null, null).visitEnd();
            for (int i = 0; i < string.length(); ++i) {
                char n = string.charAt(i);
                String string4 = Factory.makeFieldName(string, i);
                String string5 = n == 'L' ? JLO_SIG : String.valueOf(n);
                classWriter.visitField(16, string4, string5, null, null).visitEnd();
            }
            MethodVisitor methodVisitor = classWriter.visitMethod(0, "<init>", Factory.makeSignature(string, true), null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(183, BMH, "<init>", Factory.makeSignature("", true));
            boolean objectArray = false;
            int n = 0;
            while (var6_8 < string.length()) {
                char c = string.charAt((int)var6_8);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(Factory.typeLoadOp(c), n + 3);
                methodVisitor.visitFieldInsn(181, string2, Factory.makeFieldName(string, (int)var6_8), Factory.typeSig(c));
                if (c == 'J' || c == 'D') {
                    ++n;
                }
                ++var6_8;
                ++n;
            }
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = classWriter.visitMethod(16, "reinvokerTarget", "()Ljava/lang/invoke/MethodHandle;", null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, string2, "argL0", JLO_SIG);
            methodVisitor.visitTypeInsn(192, MH);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = classWriter.visitMethod(16, "speciesData", MYSPECIES_DATA_SIG, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitFieldInsn(178, string2, "SPECIES_DATA", SPECIES_DATA_SIG);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = classWriter.visitMethod(16, "clone", Factory.makeSignature("", false), null, E_THROWABLE);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(178, string2, "SPECIES_DATA", SPECIES_DATA_SIG);
            methodVisitor.visitFieldInsn(180, SPECIES_DATA, "constructor", "[Ljava/lang/invoke/MethodHandle;");
            methodVisitor.visitInsn(3);
            methodVisitor.visitInsn(50);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            Factory.emitPushFields(string, string2, methodVisitor);
            methodVisitor.visitMethodInsn(182, MH, "invokeBasic", Factory.makeSignature(string, false));
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            for (Class<?> clazz : TYPES) {
                char c = Wrapper.basicTypeChar(clazz);
                methodVisitor = classWriter.visitMethod(16, "cloneExtend" + c, Factory.makeSignature(String.valueOf(c), false), null, E_THROWABLE);
                methodVisitor.visitCode();
                methodVisitor.visitFieldInsn(178, string2, "SPECIES_DATA", SPECIES_DATA_SIG);
                int n2 = 3 + BoundMethodHandle.extensionIndex(c);
                assert (n2 <= 8);
                methodVisitor.visitInsn(n2);
                methodVisitor.visitMethodInsn(182, SPECIES_DATA, "extendWithIndex", BMHSPECIES_DATA_EWI_SIG);
                methodVisitor.visitFieldInsn(180, SPECIES_DATA, "constructor", "[Ljava/lang/invoke/MethodHandle;");
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(50);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, 2);
                Factory.emitPushFields(string, string2, methodVisitor);
                methodVisitor.visitVarInsn(Factory.typeLoadOp(c), 3);
                methodVisitor.visitMethodInsn(182, MH, "invokeBasic", Factory.makeSignature(string + c, false));
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(0, 0);
                methodVisitor.visitEnd();
            }
            methodVisitor = classWriter.visitMethod(8, "<clinit>", VOID_SIG, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitLdcInsn(string);
            methodVisitor.visitLdcInsn(Type.getObjectType(string2));
            methodVisitor.visitMethodInsn(184, SPECIES_DATA, "getForClass", BMHSPECIES_DATA_GFC_SIG);
            methodVisitor.visitFieldInsn(179, string2, "SPECIES_DATA", SPECIES_DATA_SIG);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            classWriter.visitEnd();
            byte[] byArray = classWriter.toByteArray();
            InvokerBytecodeGenerator.maybeDump(string2, byArray);
            Class<BoundMethodHandle> clazz = MethodHandleStatics.UNSAFE.defineClass(string2, byArray, 0, byArray.length, BoundMethodHandle.class.getClassLoader(), null).asSubclass(BoundMethodHandle.class);
            MethodHandleStatics.UNSAFE.ensureClassInitialized(clazz);
            return clazz;
        }

        private static int typeLoadOp(char c) {
            switch (c) {
                case 'L': {
                    return 25;
                }
                case 'I': {
                    return 21;
                }
                case 'J': {
                    return 22;
                }
                case 'F': {
                    return 23;
                }
                case 'D': {
                    return 24;
                }
            }
            throw new InternalError("unrecognized type " + c);
        }

        private static void emitPushFields(String string, String string2, MethodVisitor methodVisitor) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, string2, Factory.makeFieldName(string, i), Factory.typeSig(c));
            }
        }

        static String typeSig(char c) {
            return c == 'L' ? JLO_SIG : String.valueOf(c);
        }

        private static MethodHandle makeGetter(Class<?> clazz, String string, int n) {
            String string2 = Factory.makeFieldName(string, n);
            Class<?> clazz2 = Wrapper.forBasicType(string.charAt(n)).primitiveType();
            try {
                return LOOKUP.findGetter(clazz, string2, clazz2);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError(reflectiveOperationException);
            }
        }

        static MethodHandle[] makeGetters(Class<?> clazz, String string, MethodHandle[] methodHandleArray) {
            if (methodHandleArray == null) {
                methodHandleArray = new MethodHandle[string.length()];
            }
            for (int i = 0; i < methodHandleArray.length; ++i) {
                methodHandleArray[i] = Factory.makeGetter(clazz, string, i);
                assert (methodHandleArray[i].internalMemberName().getDeclaringClass() == clazz);
            }
            return methodHandleArray;
        }

        static MethodHandle[] makeCtors(Class<? extends BoundMethodHandle> clazz, String string, MethodHandle[] methodHandleArray) {
            if (methodHandleArray == null) {
                methodHandleArray = new MethodHandle[]{Factory.makeCbmhCtor(clazz, string)};
            }
            return methodHandleArray;
        }

        static SpeciesData speciesDataFromConcreteBMHClass(Class<? extends BoundMethodHandle> clazz) {
            try {
                Field field = clazz.getDeclaredField("SPECIES_DATA");
                return (SpeciesData)field.get(null);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError(reflectiveOperationException);
            }
        }

        private static String makeFieldName(String string, int n) {
            assert (n >= 0 && n < string.length());
            return "arg" + string.charAt(n) + n;
        }

        private static String makeSignature(String string, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder(SIG_INCIPIT);
            for (char c : string.toCharArray()) {
                stringBuilder.append(Factory.typeSig(c));
            }
            return stringBuilder.append(')').append(bl ? "V" : BMH_SIG).toString();
        }

        static MethodHandle makeCbmhCtor(Class<? extends BoundMethodHandle> clazz, String string) {
            try {
                return Factory.linkConstructor(LOOKUP.findConstructor(clazz, MethodType.fromMethodDescriptorString(Factory.makeSignature(string, true), null)));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | TypeNotPresentException exception) {
                throw MethodHandleStatics.newInternalError(exception);
            }
        }

        private static MethodHandle linkConstructor(MethodHandle methodHandle) {
            LambdaForm lambdaForm = methodHandle.form;
            int n = lambdaForm.names.length - 1;
            LambdaForm.Name name = lambdaForm.names[n];
            MemberName memberName = name.function.member;
            MethodType methodType = memberName.getInvocationType();
            MethodType methodType2 = methodType.changeParameterType(0, BoundMethodHandle.class).appendParameterTypes(MemberName.class);
            MemberName memberName2 = new MemberName(MethodHandle.class, "linkToSpecial", methodType2, 6);
            try {
                memberName2 = MemberName.getFactory().resolveOrFail((byte)6, memberName2, null, NoSuchMethodException.class);
                assert (memberName2.isStatic());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError(reflectiveOperationException);
            }
            Object[] objectArray = Arrays.copyOf(name.arguments, name.arguments.length + 1);
            objectArray[objectArray.length - 1] = memberName;
            LambdaForm.NamedFunction namedFunction = new LambdaForm.NamedFunction(memberName2);
            LambdaForm.Name name2 = new LambdaForm.Name(namedFunction, objectArray);
            name2.initIndex(n);
            lambdaForm.names[n] = name2;
            return methodHandle;
        }
    }

    static class SpeciesData {
        final String types;
        final Class<? extends BoundMethodHandle> clazz;
        final MethodHandle[] constructor;
        final MethodHandle[] getters;
        final SpeciesData[] extensions;
        static final SpeciesData EMPTY = new SpeciesData("", BoundMethodHandle.class);
        private static final HashMap<String, SpeciesData> CACHE = new HashMap();
        private static final boolean INIT_DONE;

        int fieldCount() {
            return this.types.length();
        }

        char fieldType(int n) {
            return this.types.charAt(n);
        }

        public String toString() {
            return "SpeciesData[" + (this.isPlaceholder() ? "<placeholder>" : this.clazz.getSimpleName()) + ":" + this.types + "]";
        }

        LambdaForm.Name getterName(LambdaForm.Name name, int n) {
            MethodHandle methodHandle = this.getters[n];
            assert (methodHandle != null) : this + "." + n;
            return new LambdaForm.Name(methodHandle, name);
        }

        LambdaForm.NamedFunction getterFunction(int n) {
            return new LambdaForm.NamedFunction(this.getters[n]);
        }

        private SpeciesData(String string, Class<? extends BoundMethodHandle> clazz) {
            this.types = string;
            this.clazz = clazz;
            if (!INIT_DONE) {
                this.constructor = new MethodHandle[1];
                this.getters = new MethodHandle[string.length()];
            } else {
                this.constructor = Factory.makeCtors(clazz, string, null);
                this.getters = Factory.makeGetters(clazz, string, null);
            }
            this.extensions = new SpeciesData[BoundMethodHandle.EXTENSION_TYPES.length()];
        }

        private void initForBootstrap() {
            assert (!INIT_DONE);
            if (this.constructor[0] == null) {
                Factory.makeCtors(this.clazz, this.types, this.constructor);
                Factory.makeGetters(this.clazz, this.types, this.getters);
            }
        }

        private SpeciesData(String string) {
            this.types = string;
            this.clazz = null;
            this.constructor = null;
            this.getters = null;
            this.extensions = null;
        }

        private boolean isPlaceholder() {
            return this.clazz == null;
        }

        SpeciesData extendWithType(char c) {
            byte by = BoundMethodHandle.extensionIndex(c);
            SpeciesData speciesData = this.extensions[by];
            if (speciesData != null) {
                return speciesData;
            }
            this.extensions[by] = speciesData = SpeciesData.get(this.types + c);
            return speciesData;
        }

        SpeciesData extendWithIndex(byte by) {
            SpeciesData speciesData = this.extensions[by];
            if (speciesData != null) {
                return speciesData;
            }
            this.extensions[by] = speciesData = SpeciesData.get(this.types + BoundMethodHandle.EXTENSION_TYPES.charAt(by));
            return speciesData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static SpeciesData get(String string) {
            SpeciesData speciesData = SpeciesData.lookupCache(string);
            if (!speciesData.isPlaceholder()) {
                return speciesData;
            }
            SpeciesData speciesData2 = speciesData;
            synchronized (speciesData2) {
                if (SpeciesData.lookupCache(string).isPlaceholder()) {
                    Factory.generateConcreteBMHClass(string);
                }
            }
            speciesData = SpeciesData.lookupCache(string);
            assert (speciesData != null && !speciesData.isPlaceholder());
            return speciesData;
        }

        static SpeciesData getForClass(String string, Class<? extends BoundMethodHandle> clazz) {
            return SpeciesData.updateCache(string, new SpeciesData(string, clazz));
        }

        private static synchronized SpeciesData lookupCache(String string) {
            SpeciesData speciesData = CACHE.get(string);
            if (speciesData != null) {
                return speciesData;
            }
            speciesData = new SpeciesData(string);
            assert (speciesData.isPlaceholder());
            CACHE.put(string, speciesData);
            return speciesData;
        }

        private static synchronized SpeciesData updateCache(String string, SpeciesData speciesData) {
            SpeciesData speciesData2;
            assert ((speciesData2 = CACHE.get(string)) == null || speciesData2.isPlaceholder());
            assert (!speciesData.isPlaceholder());
            CACHE.put(string, speciesData);
            return speciesData;
        }

        static {
            CACHE.put("", EMPTY);
            Class<BoundMethodHandle> clazz = BoundMethodHandle.class;
            SpeciesData speciesData = SPECIES_DATA;
            assert (speciesData == null || speciesData == SpeciesData.lookupCache("")) : speciesData;
            try {
                for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
                    if (!clazz.isAssignableFrom(clazz2)) continue;
                    Class<BoundMethodHandle> clazz3 = clazz2.asSubclass(BoundMethodHandle.class);
                    SpeciesData speciesData2 = Factory.speciesDataFromConcreteBMHClass(clazz3);
                    assert (speciesData2 != null) : clazz3.getName();
                    assert (speciesData2.clazz == clazz3);
                    assert (speciesData2 == SpeciesData.lookupCache(speciesData2.types));
                }
            }
            catch (Throwable throwable) {
                throw MethodHandleStatics.newInternalError(throwable);
            }
            for (SpeciesData speciesData3 : CACHE.values()) {
                speciesData3.initForBootstrap();
            }
            INIT_DONE = Boolean.TRUE;
        }
    }

    private static final class Species_L
    extends BoundMethodHandle {
        final Object argL0;
        static final SpeciesData SPECIES_DATA = SpeciesData.getForClass("L", Species_L.class);

        Species_L(MethodType methodType, LambdaForm lambdaForm, Object object) {
            super(methodType, lambdaForm);
            this.argL0 = object;
        }

        @Override
        MethodHandle reinvokerTarget() {
            return (MethodHandle)this.argL0;
        }

        @Override
        SpeciesData speciesData() {
            return SPECIES_DATA;
        }

        @Override
        final BoundMethodHandle clone(MethodType methodType, LambdaForm lambdaForm) throws Throwable {
            return new Species_L(methodType, lambdaForm, this.argL0);
        }

        @Override
        final BoundMethodHandle cloneExtendL(MethodType methodType, LambdaForm lambdaForm, Object object) throws Throwable {
            return Species_L.SPECIES_DATA.extendWithIndex((byte)0).constructor[0].invokeBasic(methodType, lambdaForm, this.argL0, object);
        }

        @Override
        final BoundMethodHandle cloneExtendI(MethodType methodType, LambdaForm lambdaForm, int n) throws Throwable {
            return Species_L.SPECIES_DATA.extendWithIndex((byte)1).constructor[0].invokeBasic(methodType, lambdaForm, this.argL0, n);
        }

        @Override
        final BoundMethodHandle cloneExtendJ(MethodType methodType, LambdaForm lambdaForm, long l) throws Throwable {
            return Species_L.SPECIES_DATA.extendWithIndex((byte)2).constructor[0].invokeBasic(methodType, lambdaForm, this.argL0, l);
        }

        @Override
        final BoundMethodHandle cloneExtendF(MethodType methodType, LambdaForm lambdaForm, float f) throws Throwable {
            return Species_L.SPECIES_DATA.extendWithIndex((byte)3).constructor[0].invokeBasic(methodType, lambdaForm, this.argL0, f);
        }

        @Override
        final BoundMethodHandle cloneExtendD(MethodType methodType, LambdaForm lambdaForm, double d) throws Throwable {
            return Species_L.SPECIES_DATA.extendWithIndex((byte)4).constructor[0].invokeBasic(methodType, lambdaForm, this.argL0, d);
        }
    }
}

