/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xalan.internal.utils.SecuritySupport;
import com.sun.org.apache.xml.internal.serializer.EncodingInfo;
import com.sun.org.apache.xml.internal.serializer.utils.WrappedRuntimeException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Encodings {
    private static final int m_defaultLastPrintable = 127;
    private static final String ENCODINGS_FILE = "com/sun/org/apache/xml/internal/serializer/Encodings.properties";
    private static final String ENCODINGS_PROP = "com.sun.org.apache.xalan.internal.serialize.encodings";
    static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final EncodingInfos _encodingInfos = new EncodingInfos();

    static Writer getWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        EncodingInfo ei = _encodingInfos.findEncoding(Encodings.toUpperCaseFast(encoding));
        if (ei != null) {
            try {
                return new BufferedWriter(new OutputStreamWriter(output, ei.javaName));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new BufferedWriter(new OutputStreamWriter(output, encoding));
    }

    public static int getLastPrintable() {
        return 127;
    }

    static EncodingInfo getEncodingInfo(String encoding) {
        String normalizedEncoding = Encodings.toUpperCaseFast(encoding);
        EncodingInfo ei = _encodingInfos.findEncoding(normalizedEncoding);
        if (ei == null) {
            try {
                Charset c = Charset.forName(encoding);
                String name = c.name();
                ei = new EncodingInfo(name, name);
                _encodingInfos.putEncoding(normalizedEncoding, ei);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException x) {
                ei = new EncodingInfo(null, null);
            }
        }
        return ei;
    }

    private static String toUpperCaseFast(String s) {
        boolean different = false;
        int mx = s.length();
        char[] chars = new char[mx];
        for (int i = 0; i < mx; ++i) {
            char ch = s.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                ch = (char)(ch + -32);
                different = true;
            }
            chars[i] = ch;
        }
        String upper = different ? String.valueOf(chars) : s;
        return upper;
    }

    static String getMimeEncoding(String encoding) {
        block5: {
            if (null == encoding) {
                try {
                    encoding = SecuritySupport.getSystemProperty("file.encoding", "UTF8");
                    if (null != encoding) {
                        String jencoding = encoding.equalsIgnoreCase("Cp1252") || encoding.equalsIgnoreCase("ISO8859_1") || encoding.equalsIgnoreCase("8859_1") || encoding.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(encoding);
                        encoding = null != jencoding ? jencoding : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    encoding = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException se) {
                    encoding = DEFAULT_MIME_ENCODING;
                }
            } else {
                encoding = Encodings.convertJava2MimeEncoding(encoding);
            }
        }
        return encoding;
    }

    private static String convertJava2MimeEncoding(String encoding) {
        EncodingInfo enc = _encodingInfos.getEncodingFromJavaKey(Encodings.toUpperCaseFast(encoding));
        if (null != enc) {
            return enc.name;
        }
        return encoding;
    }

    public static String convertMime2JavaEncoding(String encoding) {
        EncodingInfo info = _encodingInfos.findEncoding(Encodings.toUpperCaseFast(encoding));
        return info != null ? info.javaName : encoding;
    }

    static boolean isHighUTF16Surrogate(char ch) {
        return '\ud800' <= ch && ch <= '\udbff';
    }

    static boolean isLowUTF16Surrogate(char ch) {
        return '\udc00' <= ch && ch <= '\udfff';
    }

    static int toCodePoint(char highSurrogate, char lowSurrogate) {
        int codePoint = (highSurrogate - 55296 << 10) + (lowSurrogate - 56320) + 65536;
        return codePoint;
    }

    static int toCodePoint(char ch) {
        char codePoint = ch;
        return codePoint;
    }

    private static final class EncodingInfos {
        private final Map<String, EncodingInfo> _encodingTableKeyJava = new HashMap<String, EncodingInfo>();
        private final Map<String, EncodingInfo> _encodingTableKeyMime = new HashMap<String, EncodingInfo>();
        private final Map<String, EncodingInfo> _encodingDynamicTable = Collections.synchronizedMap(new HashMap());

        private EncodingInfos() {
            this.loadEncodingInfo();
        }

        private InputStream openEncodingsFileStream() throws MalformedURLException, IOException {
            String urlString = null;
            InputStream is = null;
            try {
                urlString = SecuritySupport.getSystemProperty(Encodings.ENCODINGS_PROP, "");
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (urlString != null && urlString.length() > 0) {
                URL url = new URL(urlString);
                is = url.openStream();
            }
            if (is == null) {
                is = SecuritySupport.getResourceAsStream(Encodings.ENCODINGS_FILE);
            }
            return is;
        }

        private Properties loadProperties() throws MalformedURLException, IOException {
            Properties props = new Properties();
            try (InputStream is = this.openEncodingsFileStream();){
                if (is != null) {
                    props.load(is);
                }
            }
            return props;
        }

        private String[] parseMimeTypes(String val) {
            int pos = val.indexOf(32);
            if (pos < 0) {
                return new String[]{val};
            }
            StringTokenizer st = new StringTokenizer(val.substring(0, pos), ",");
            String[] values = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                values[i] = st.nextToken();
                ++i;
            }
            return values;
        }

        private String findCharsetNameFor(String name) {
            try {
                return Charset.forName(name).name();
            }
            catch (Exception x) {
                return null;
            }
        }

        private String findCharsetNameFor(String javaName, String[] mimes) {
            String m;
            String cs = this.findCharsetNameFor(javaName);
            if (cs != null) {
                return javaName;
            }
            String[] stringArray = mimes;
            int n = stringArray.length;
            for (int i = 0; i < n && (cs = this.findCharsetNameFor(m = stringArray[i])) == null; ++i) {
            }
            return cs;
        }

        private void loadEncodingInfo() {
            try {
                Properties props = this.loadProperties();
                Enumeration keys = props.keys();
                HashMap<String, EncodingInfo> canonicals = new HashMap<String, EncodingInfo>();
                while (keys.hasMoreElements()) {
                    String[] mimes;
                    String javaName = (String)keys.nextElement();
                    String charsetName = this.findCharsetNameFor(javaName, mimes = this.parseMimeTypes(props.getProperty(javaName)));
                    if (charsetName == null) continue;
                    String kj = Encodings.toUpperCaseFast(javaName);
                    String kc = Encodings.toUpperCaseFast(charsetName);
                    for (int i = 0; i < mimes.length; ++i) {
                        String mimeName = mimes[i];
                        String km = Encodings.toUpperCaseFast(mimeName);
                        EncodingInfo info = new EncodingInfo(mimeName, charsetName);
                        this._encodingTableKeyMime.put(km, info);
                        if (!canonicals.containsKey(kc)) {
                            canonicals.put(kc, info);
                            this._encodingTableKeyJava.put(kc, info);
                        }
                        this._encodingTableKeyJava.put(kj, info);
                    }
                }
                for (Map.Entry<String, EncodingInfo> e : this._encodingTableKeyJava.entrySet()) {
                    e.setValue((EncodingInfo)canonicals.get(Encodings.toUpperCaseFast(e.getValue().javaName)));
                }
            }
            catch (MalformedURLException mue) {
                throw new WrappedRuntimeException(mue);
            }
            catch (IOException ioe) {
                throw new WrappedRuntimeException(ioe);
            }
        }

        EncodingInfo findEncoding(String normalizedEncoding) {
            EncodingInfo info = this._encodingTableKeyJava.get(normalizedEncoding);
            if (info == null) {
                info = this._encodingTableKeyMime.get(normalizedEncoding);
            }
            if (info == null) {
                info = this._encodingDynamicTable.get(normalizedEncoding);
            }
            return info;
        }

        EncodingInfo getEncodingFromMimeKey(String normalizedMimeName) {
            return this._encodingTableKeyMime.get(normalizedMimeName);
        }

        EncodingInfo getEncodingFromJavaKey(String normalizedJavaName) {
            return this._encodingTableKeyJava.get(normalizedJavaName);
        }

        void putEncoding(String key, EncodingInfo info) {
            this._encodingDynamicTable.put(key, info);
        }
    }
}

