/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import jdk.nashorn.internal.runtime.Source;

final class CompiledScript
implements Serializable {
    private final String mainClassName;
    private final Map<String, byte[]> classBytes;
    private final Object[] constants;
    private transient Source source;
    private static final long serialVersionUID = 2958227232195298340L;

    CompiledScript(Source source, String mainClassName, Map<String, byte[]> classBytes, Object[] constants) {
        this.source = source;
        this.mainClassName = mainClassName;
        this.classBytes = classBytes;
        this.constants = constants;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public Map<String, byte[]> getClassBytes() {
        return this.classBytes;
    }

    public Object[] getConstants() {
        return this.constants;
    }

    public Source getSource() {
        return this.source;
    }

    void setSource(Source source) {
        this.source = source;
    }

    public int hashCode() {
        int hash = this.mainClassName.hashCode();
        hash = 31 * hash + this.classBytes.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.constants);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompiledScript)) {
            return false;
        }
        CompiledScript cs = (CompiledScript)obj;
        return this.mainClassName.equals(cs.mainClassName) && this.classBytes.equals(cs.classBytes) && Arrays.equals(this.constants, cs.constants);
    }
}

