/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.runtime.DebugLogger;

public abstract class Range {
    private static final Range GENERIC_RANGE = new Range(){

        @Override
        public Type getType() {
            return Type.OBJECT;
        }
    };
    private static final Range NUMBER_RANGE = new Range(){

        @Override
        public Type getType() {
            return Type.NUMBER;
        }
    };
    private static final Range UNKNOWN_RANGE = new Range(){

        @Override
        public Type getType() {
            return Type.UNKNOWN;
        }

        @Override
        public boolean isUnknown() {
            return true;
        }
    };

    public abstract Type getType();

    public boolean isUnknown() {
        return false;
    }

    public boolean isIntegerType() {
        return this instanceof IntegerRange;
    }

    public boolean isIntegerConst() {
        return false;
    }

    public static Range createUnknownRange() {
        return UNKNOWN_RANGE;
    }

    public static Range createRange(int value) {
        return Range.createIntegerRange(value, value);
    }

    public static Range createRange(long value) {
        return Range.createIntegerRange(value, value);
    }

    public static Range createRange(double value) {
        if (Range.isRepresentableAsLong(value)) {
            return Range.createIntegerRange((long)value, (long)value);
        }
        return Range.createNumberRange();
    }

    public static Range createRange(Object value) {
        if (value instanceof Integer) {
            return Range.createRange((Integer)value);
        }
        if (value instanceof Long) {
            return Range.createRange((Long)value);
        }
        if (value instanceof Double) {
            return Range.createRange((Double)value);
        }
        return Range.createGenericRange();
    }

    public static Range createGenericRange() {
        return GENERIC_RANGE;
    }

    public static Range createNumberRange() {
        return NUMBER_RANGE;
    }

    public static IntegerRange createIntegerRange(long min, long max) {
        return new IntegerRange(min, max);
    }

    public static IntegerRange createIntegerRange(Type type) {
        long max;
        long min;
        assert (type.isNumeric() && !type.isNumber());
        if (type.isInteger()) {
            min = Integer.MIN_VALUE;
            max = Integer.MAX_VALUE;
        } else if (type.isLong()) {
            min = Long.MIN_VALUE;
            max = Long.MAX_VALUE;
        } else {
            throw new AssertionError();
        }
        return new IntegerRange(min, max);
    }

    public static Range createTypeRange(Type type) {
        if (type.isNumber()) {
            return Range.createNumberRange();
        }
        if (type.isNumeric()) {
            return Range.createIntegerRange(type);
        }
        return Range.createGenericRange();
    }

    private static boolean checkAdd(long a, long b) {
        long result = a + b;
        return ((a ^ result) & (b ^ result)) >= 0L;
    }

    private static boolean checkSub(long a, long b) {
        long result = a - b;
        return ((a ^ result) & (b ^ result)) >= 0L;
    }

    private static boolean checkMul(long a, long b) {
        return a >= Integer.MIN_VALUE && a <= Integer.MAX_VALUE && b >= Integer.MIN_VALUE && b <= Integer.MAX_VALUE;
    }

    public String toString() {
        return String.valueOf(this.getType());
    }

    private static boolean isRepresentableAsInt(double number) {
        return (double)((int)number) == number && !Range.isNegativeZero(number);
    }

    private static boolean isRepresentableAsLong(double number) {
        return (double)((long)number) == number && !Range.isNegativeZero(number);
    }

    private static boolean isNegativeZero(double number) {
        return Double.doubleToLongBits(number) == Double.doubleToLongBits(-0.0);
    }

    public static class TraceFunctionality
    extends Functionality {
        TraceFunctionality(DebugLogger log) {
            super(log);
        }

        private Range trace(Range result, String operation, Range ... operands) {
            this.log.fine("range::" + operation + Arrays.toString(operands) + " => " + result);
            return result;
        }

        @Override
        public Range join(Range a, Range b) {
            Range result = super.join(a, b);
            if (!a.equals(b)) {
                this.trace(result, "join", a, b);
            }
            return result;
        }

        @Override
        public Range add(Range a, Range b) {
            return this.trace(super.add(a, b), "add", a, b);
        }

        @Override
        public Range sub(Range a, Range b) {
            return this.trace(super.sub(a, b), "sub", a, b);
        }

        @Override
        public Range mul(Range a, Range b) {
            return this.trace(super.mul(a, b), "mul", a, b);
        }

        @Override
        public Range neg(Range a) {
            return this.trace(super.neg(a), "neg", a);
        }

        @Override
        public Range and(Range a, Range b) {
            return this.trace(super.and(a, b), "and", a, b);
        }

        @Override
        public Range or(Range a, Range b) {
            return this.trace(super.or(a, b), "or", a, b);
        }

        @Override
        public Range xor(Range a, Range b) {
            return this.trace(super.xor(a, b), "xor", a, b);
        }

        @Override
        public Range shl(Range a, Range b) {
            return this.trace(super.shl(a, b), "shl", a, b);
        }

        @Override
        public Range shr(Range a, Range b) {
            return this.trace(super.shr(a, b), "shr", a, b);
        }

        @Override
        public Range sar(Range a, Range b) {
            return this.trace(super.sar(a, b), "sar", a, b);
        }

        @Override
        public Range mod(Range a, Range b) {
            return this.trace(super.mod(a, b), "mod", a, b);
        }

        @Override
        public Range div(Range a, Range b) {
            return this.trace(super.div(a, b), "div", a, b);
        }
    }

    public static class Functionality {
        protected final DebugLogger log;

        public Functionality(DebugLogger log) {
            this.log = log;
        }

        public Range join(Range a, Range b) {
            if (a.equals(b)) {
                return a;
            }
            Type joinedType = a.getType();
            if (a.getType() != b.getType()) {
                if (a.isUnknown()) {
                    return b;
                }
                if (b.isUnknown()) {
                    return a;
                }
                joinedType = Type.widest(a.getType(), b.getType());
            }
            if (joinedType.isInteger() || joinedType.isLong()) {
                return Range.createIntegerRange(Math.min(((IntegerRange)a).getMin(), ((IntegerRange)b).getMin()), Math.max(((IntegerRange)a).getMax(), ((IntegerRange)b).getMax()));
            }
            return Range.createTypeRange(joinedType);
        }

        public Range add(Range a, Range b) {
            if (a.isIntegerType() && b.isIntegerType()) {
                IntegerRange lhs = (IntegerRange)a;
                IntegerRange rhs = (IntegerRange)b;
                if (Range.checkAdd(lhs.getMin(), rhs.getMin()) && Range.checkAdd(lhs.getMax(), rhs.getMax())) {
                    return Range.createIntegerRange(lhs.getMin() + rhs.getMin(), lhs.getMax() + rhs.getMax());
                }
            }
            if (a.getType().isNumeric() && b.getType().isNumeric()) {
                return Range.createNumberRange();
            }
            return Range.createGenericRange();
        }

        public Range sub(Range a, Range b) {
            if (a.isIntegerType() && b.isIntegerType()) {
                IntegerRange lhs = (IntegerRange)a;
                IntegerRange rhs = (IntegerRange)b;
                if (Range.checkSub(lhs.getMin(), rhs.getMax()) && Range.checkSub(lhs.getMax(), rhs.getMin())) {
                    return Range.createIntegerRange(lhs.getMin() - rhs.getMax(), lhs.getMax() - rhs.getMin());
                }
            }
            if (a.getType().isNumeric() && b.getType().isNumeric()) {
                return Range.createNumberRange();
            }
            return Range.createGenericRange();
        }

        public Range mul(Range a, Range b) {
            if (a.isIntegerType() && b.isIntegerType()) {
                IntegerRange lhs = (IntegerRange)a;
                IntegerRange rhs = (IntegerRange)b;
                if (Range.checkMul(lhs.getMin(), rhs.getMin()) && Range.checkMul(lhs.getMax(), rhs.getMax()) && Range.checkMul(lhs.getMin(), rhs.getMax()) && Range.checkMul(lhs.getMax(), rhs.getMin())) {
                    List<Long> results = Arrays.asList(lhs.getMin() * rhs.getMin(), lhs.getMin() * rhs.getMax(), lhs.getMax() * rhs.getMin(), lhs.getMax() * rhs.getMax());
                    return Range.createIntegerRange(Collections.min(results), Collections.max(results));
                }
            }
            if (a.getType().isNumeric() && b.getType().isNumeric()) {
                return Range.createNumberRange();
            }
            return Range.createGenericRange();
        }

        public Range neg(Range a) {
            IntegerRange rhs;
            if (a.isIntegerType() && (rhs = (IntegerRange)a).getMin() != Long.MIN_VALUE && rhs.getMax() != Long.MIN_VALUE) {
                return Range.createIntegerRange(-rhs.getMax(), -rhs.getMin());
            }
            if (a.getType().isNumeric()) {
                return Range.createNumberRange();
            }
            return Range.createGenericRange();
        }

        public Range and(Range a, Range b) {
            long operandMask;
            if (a.isIntegerType() && b.isIntegerType()) {
                int resultMask = (int)(((IntegerRange)a).getBitMask() & ((IntegerRange)b).getBitMask());
                if (resultMask >= 0) {
                    return Range.createIntegerRange(0L, resultMask);
                }
            } else if (a.isUnknown() && b.isIntegerType()) {
                long operandMask2 = ((IntegerRange)b).getBitMask();
                if (operandMask2 >= 0L) {
                    return Range.createIntegerRange(0L, operandMask2);
                }
            } else if (a.isIntegerType() && b.isUnknown() && (operandMask = ((IntegerRange)a).getBitMask()) >= 0L) {
                return Range.createIntegerRange(0L, operandMask);
            }
            return Range.createTypeRange(Type.INT);
        }

        public Range or(Range a, Range b) {
            int resultMask;
            if (a.isIntegerType() && b.isIntegerType() && (resultMask = (int)(((IntegerRange)a).getBitMask() | ((IntegerRange)b).getBitMask())) >= 0) {
                return Range.createIntegerRange(0L, resultMask);
            }
            return Range.createTypeRange(Type.INT);
        }

        public Range xor(Range a, Range b) {
            int resultMask;
            if (a.isIntegerConst() && b.isIntegerConst()) {
                return Range.createRange(((IntegerRange)a).getMin() ^ ((IntegerRange)b).getMin());
            }
            if (a.isIntegerType() && b.isIntegerType() && (resultMask = (int)(((IntegerRange)a).getBitMask() | ((IntegerRange)b).getBitMask())) >= 0) {
                return Range.createIntegerRange(0L, Range.createIntegerRange(0L, resultMask).getBitMask());
            }
            return Range.createTypeRange(Type.INT);
        }

        public Range shl(Range a, Range b) {
            if (b.isIntegerType() && b.isIntegerConst()) {
                IntegerRange left = (IntegerRange)(a.isIntegerType() ? a : Range.createTypeRange(Type.INT));
                int shift = (int)((IntegerRange)b).getMin() & 0x1F;
                int min = (int)left.getMin() << shift;
                int max = (int)left.getMax() << shift;
                if ((long)(min >> shift) == left.getMin() && (long)(max >> shift) == left.getMax()) {
                    return Range.createIntegerRange(min, max);
                }
            }
            return Range.createTypeRange(Type.INT);
        }

        public Range shr(Range a, Range b) {
            if (b.isIntegerType() && b.isIntegerConst()) {
                long shift = ((IntegerRange)b).getMin() & 0x1FL;
                IntegerRange left = (IntegerRange)(a.isIntegerType() ? a : Range.createTypeRange(Type.INT));
                if (left.getMin() >= 0L) {
                    long min = left.getMin() >>> (int)shift;
                    long max = left.getMax() >>> (int)shift;
                    return Range.createIntegerRange(min, max);
                }
                if (shift >= 1L) {
                    return Range.createIntegerRange(0L, 0xFFFFFFFFL >>> (int)shift);
                }
            }
            return Range.createTypeRange(Type.INT);
        }

        public Range sar(Range a, Range b) {
            if (b.isIntegerType() && b.isIntegerConst()) {
                IntegerRange left = (IntegerRange)(a.isIntegerType() ? a : Range.createTypeRange(Type.INT));
                long shift = ((IntegerRange)b).getMin() & 0x1FL;
                long min = left.getMin() >> (int)shift;
                long max = left.getMax() >> (int)shift;
                return Range.createIntegerRange(min, max);
            }
            return Range.createTypeRange(Type.INT);
        }

        public Range mod(Range a, Range b) {
            IntegerRange rhs;
            if (a.isIntegerType() && b.isIntegerType() && ((rhs = (IntegerRange)b).getMin() > 0L || rhs.getMax() < 0L)) {
                long absmax = Math.max(Math.abs(rhs.getMin()), Math.abs(rhs.getMax())) - 1L;
                return Range.createIntegerRange(rhs.getMin() > 0L ? 0L : -absmax, rhs.getMax() < 0L ? 0L : absmax);
            }
            return Range.createTypeRange(Type.NUMBER);
        }

        public Range div(Range a, Range b) {
            return Range.createTypeRange(Type.NUMBER);
        }
    }

    private static class IntegerRange
    extends Range {
        private final long min;
        private final long max;
        private final Type type;

        private IntegerRange(long min, long max) {
            assert (min <= max);
            this.min = min;
            this.max = max;
            this.type = IntegerRange.typeFromRange(min, max);
        }

        private static Type typeFromRange(long from, long to) {
            if (from >= Integer.MIN_VALUE && to <= Integer.MAX_VALUE) {
                return Type.INT;
            }
            return Type.LONG;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        @Override
        public boolean isIntegerConst() {
            return this.getMin() == this.getMax();
        }

        private long getBitMask() {
            if (this.min == this.max) {
                return this.min;
            }
            if (this.min < 0L) {
                return -1L;
            }
            long mask = 1L;
            while (mask < this.max) {
                mask = mask << 1 | 1L;
            }
            return mask;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IntegerRange) {
                IntegerRange other = (IntegerRange)obj;
                return this.type == other.type && this.min == other.min && this.max == other.max;
            }
            return false;
        }

        public int hashCode() {
            return Long.hashCode(this.min) ^ Long.hashCode(this.max);
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.min + ", " + this.max + "]";
        }
    }
}

