/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayList;
import java.util.List;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;

public class MapCreator {
    private final Class<?> structure;
    final List<String> keys;
    final List<Symbol> symbols;

    MapCreator(Class<?> structure, List<String> keys, List<Symbol> symbols) {
        this.structure = structure;
        this.keys = keys;
        this.symbols = symbols;
    }

    PropertyMap makeFieldMap(boolean hasArguments, int fieldCount, int fieldMaximum) {
        ArrayList<Property> properties = new ArrayList<Property>();
        assert (this.keys != null);
        int length = this.keys.size();
        for (int i = 0; i < length; ++i) {
            String key = this.keys.get(i);
            Symbol symbol = this.symbols.get(i);
            if (symbol == null || ArrayIndex.isValidArrayIndex(ArrayIndex.getArrayIndex(key))) continue;
            properties.add(new AccessorProperty(key, this.getPropertyFlags(symbol, hasArguments), this.structure, symbol.getFieldIndex()));
        }
        return PropertyMap.newMap(properties, this.structure.getName(), fieldCount, fieldMaximum, 0);
    }

    PropertyMap makeSpillMap(boolean hasArguments) {
        ArrayList<Property> properties = new ArrayList<Property>();
        int spillIndex = 0;
        assert (this.keys != null);
        int length = this.keys.size();
        for (int i = 0; i < length; ++i) {
            String key = this.keys.get(i);
            Symbol symbol = this.symbols.get(i);
            if (symbol == null || ArrayIndex.isValidArrayIndex(ArrayIndex.getArrayIndex(key))) continue;
            properties.add(new AccessorProperty(key, this.getPropertyFlags(symbol, hasArguments), spillIndex++));
        }
        return PropertyMap.newMap(properties, this.structure.getName(), 0, 0, spillIndex);
    }

    protected int getPropertyFlags(Symbol symbol, boolean hasArguments) {
        int flags = 0;
        if (symbol.isParam()) {
            flags |= 0x50;
        }
        if (hasArguments) {
            flags |= 0x60;
        }
        if (symbol.isScope()) {
            flags |= 4;
        }
        if (symbol.canBePrimitive()) {
            flags |= 0x80;
        }
        if (symbol.canBeUndefined()) {
            flags |= 0x100;
        }
        if (symbol.isFunctionDeclaration()) {
            flags |= 0x200;
        }
        return flags;
    }
}

