/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.Bytecode;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeBipush
extends Bytecode {
    BytecodeBipush(Method method, int bci) {
        super(method, bci);
    }

    public byte getValue() {
        return this.javaByteAt(1);
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check bipush");
        }
    }

    public boolean isValid() {
        return this.javaCode() == 16;
    }

    public static BytecodeBipush at(Method method, int bci) {
        BytecodeBipush b = new BytecodeBipush(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeBipush atCheck(Method method, int bci) {
        BytecodeBipush b = new BytecodeBipush(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeBipush at(BytecodeStream bcs) {
        return new BytecodeBipush(bcs.method(), bcs.bci());
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("bipush");
        buf.append(" ");
        buf.append(Byte.toString(this.getValue()));
        return buf.toString();
    }
}

