/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XObject;
import sun.tools.jconsole.inspector.XOperations;

public class XTextField
extends JPanel
implements DocumentListener,
ActionListener {
    private static final Color selF = Color.red;
    private static final Color selB = Color.yellow;
    private Color fore = null;
    private Color back = null;
    private HashMap items = null;
    private XObject selectedObject;
    private XObject currentObject;
    private Class expectedClass;
    private Object value;
    protected JTextField textField;
    private JButton browseObjects;
    private static boolean allowNullSelection = false;
    protected static final int COMPATIBLE_VALUE = 1;
    protected static final int CURRENT_VALUE = 2;
    protected static final int NULL_VALUE = 3;
    private JButton button;
    private XOperations operation;

    public XTextField() {
        super(new BorderLayout());
        this.textField = new JTextField();
        this.add((Component)this.textField, "Center");
        this.textField.addActionListener(this);
    }

    public XTextField(Object value) {
        this(value, value.toString().length());
    }

    public XTextField(Object value, int colWidth) {
        this(value, value.getClass(), colWidth, true, null, null);
    }

    public XTextField(Object value, Class expectedClass, int colWidth, boolean isCallable, JButton button, XOperations operation) {
        super(new BorderLayout());
        boolean fieldEditable;
        this.expectedClass = expectedClass;
        this.button = button;
        this.operation = operation;
        this.textField = new JTextField(value.toString(), colWidth);
        this.add((Component)this.textField, "Center");
        if (isCallable) {
            this.textField.addActionListener(this);
        }
        if ((fieldEditable = Utils.isEditableType(expectedClass.getName())) && isCallable) {
            this.textField.setEditable(true);
        } else {
            this.textField.setEditable(false);
        }
    }

    public static void setNullSelectionAllowed(boolean allowNullSelection) {
        XTextField.allowNullSelection = allowNullSelection;
    }

    public static boolean getNullSelectionAllowed() {
        return allowNullSelection;
    }

    protected void init(Object value, Class expectedClass) {
        this.expectedClass = expectedClass;
        this.value = value;
        boolean fieldEditable = Utils.isEditableType(expectedClass.getName());
        this.clearObject();
        if (value != null) {
            this.currentObject = new XObject(value);
            this.textField.setText(value.toString());
        } else {
            this.currentObject = XObject.NULL_OBJECT;
            this.textField.setText("");
        }
        this.textField.setToolTipText(null);
        if (fieldEditable) {
            if (!this.textField.isEditable()) {
                this.textField.setEditable(true);
            }
        } else if (this.textField.isEditable()) {
            this.textField.setEditable(false);
        }
    }

    private synchronized void setObject(XObject object) {
        this.clearObject();
        this.selectedObject = object;
        this.currentObject = object;
        this.setSelectedColors();
        this.textField.setText(object.getText());
        this.textField.getDocument().addDocumentListener(this);
        this.paintImmediately(this.getVisibleRect());
    }

    private synchronized void clearObject() {
        this.textField.getDocument().removeDocumentListener(this);
        this.selectedObject = null;
        this.currentObject = null;
        this.setDefaultColors();
    }

    private synchronized void setSelectedColors() {
    }

    private synchronized void setDefaultColors() {
    }

    public void setHorizontalAlignment(int h) {
        this.textField.setHorizontalAlignment(h);
    }

    protected JMenuItem buildJMenuItem(XObject xobject, int valueType) {
        if (valueType == 1) {
            return new JMenuItem(xobject.getText());
        }
        if (valueType == 2) {
            return new JMenuItem("> " + xobject.getText());
        }
        if (valueType == 3) {
            return new JMenuItem("null");
        }
        return null;
    }

    private JPopupMenu buildEditPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JTextField && this.operation != null) {
            this.operation.performInvokeRequest(this.button);
        }
    }

    public Object getValue() {
        if (this.selectedObject != null) {
            if (this.selectedObject == XObject.NULL_OBJECT) {
                return null;
            }
            return this.selectedObject;
        }
        return this.textField.getText();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.clearObject();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.clearObject();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.clearObject();
    }
}

