/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.OperationEntry;
import sun.tools.jconsole.inspector.ThreadDialog;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XMBean;

public abstract class XOperations
extends JPanel
implements ActionListener {
    public static final String OPERATION_INVOCATION_EVENT = "jam.xoperations.invoke.result";
    private List<NotificationListener> notificationListenersList;
    private Hashtable<JButton, OperationEntry> operationEntryTable;
    private XMBean mbean;
    private MBeanInfo mbeanInfo;
    private MBeansTab mbeansTab;

    public XOperations(MBeansTab mbeansTab) {
        super(new GridLayout(1, 1));
        this.mbeansTab = mbeansTab;
        this.operationEntryTable = new Hashtable();
        ArrayList l = new ArrayList(1);
        this.notificationListenersList = Collections.synchronizedList(l);
    }

    public void removeOperations() {
        this.removeAll();
    }

    public void loadOperations(XMBean mbean, MBeanInfo mbeanInfo) {
        this.mbean = mbean;
        this.mbeanInfo = mbeanInfo;
        MBeanOperationInfo[] operations = mbeanInfo.getOperations();
        this.invalidate();
        Component[] listeners = this.getComponents();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof JButton)) continue;
            ((JButton)listeners[i]).removeActionListener(this);
        }
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel outerPanelLeft = new JPanel(new GridLayout(operations.length, 1));
        JPanel outerPanelRight = new JPanel(new GridLayout(operations.length, 1));
        for (int i = 0; i < operations.length; ++i) {
            JLabel methodLabel;
            JPanel innerPanelLeft = new JPanel(new FlowLayout(2));
            JPanel innerPanelRight = new JPanel(new FlowLayout(0));
            String returnType = operations[i].getReturnType();
            if (returnType == null) {
                methodLabel = new JLabel("null", 4);
                if (JConsole.isDebug()) {
                    System.err.println("WARNING: The operation's return type shouldn't be \"null\". Check how the MBeanOperationInfo for the \"" + operations[i].getName() + "\" operation has " + "been defined in the MBean's implementation code.");
                }
            } else {
                methodLabel = new JLabel(Utils.getReadableClassName(returnType), 4);
            }
            innerPanelLeft.add(methodLabel);
            if (methodLabel.getText().length() > 20) {
                methodLabel.setText(methodLabel.getText().substring(methodLabel.getText().lastIndexOf(".") + 1, methodLabel.getText().length()));
            }
            JButton methodButton = new JButton(operations[i].getName());
            methodButton.setToolTipText(operations[i].getDescription());
            boolean callable = this.isCallable(operations[i].getSignature());
            if (callable) {
                methodButton.addActionListener(this);
            } else {
                methodButton.setEnabled(false);
            }
            MBeanParameterInfo[] signature = operations[i].getSignature();
            OperationEntry paramEntry = new OperationEntry(operations[i], callable, methodButton, this);
            this.operationEntryTable.put(methodButton, paramEntry);
            innerPanelRight.add(methodButton);
            if (signature.length == 0) {
                innerPanelRight.add(new JLabel("( )", 0));
            } else {
                innerPanelRight.add(paramEntry);
            }
            outerPanelLeft.add((Component)innerPanelLeft, "West");
            outerPanelRight.add((Component)innerPanelRight, "Center");
        }
        this.add((Component)outerPanelLeft, "West");
        this.add((Component)outerPanelRight, "Center");
        this.validate();
    }

    private boolean isCallable(MBeanParameterInfo[] signature) {
        for (int i = 0; i < signature.length; ++i) {
            if (Utils.isEditableType(signature[i].getType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.performInvokeRequest((JButton)e.getSource());
    }

    void performInvokeRequest(final JButton button) {
        final OperationEntry entryIf = this.operationEntryTable.get(button);
        new SwingWorker<Object, Void>(){

            @Override
            public Object doInBackground() throws Exception {
                return XOperations.this.mbean.invoke(button.getText(), entryIf.getParameters(), entryIf.getSignature());
            }

            @Override
            protected void done() {
                try {
                    Object result = this.get();
                    if (entryIf.getReturnType() != null && !entryIf.getReturnType().equals(Void.TYPE.getName()) && !entryIf.getReturnType().equals(Void.class.getName())) {
                        XOperations.this.fireChangedNotification(XOperations.OPERATION_INVOCATION_EVENT, button, result);
                    } else {
                        new ThreadDialog(button, Resources.getText("Method successfully invoked", new Object[0]), Resources.getText("Info", new Object[0]), 1).run();
                    }
                }
                catch (Throwable t) {
                    t = Utils.getActualException(t);
                    if (JConsole.isDebug()) {
                        t.printStackTrace();
                    }
                    new ThreadDialog(button, Resources.getText("Problem invoking", new Object[0]) + " " + button.getText() + " : " + t.toString(), Resources.getText("Error", new Object[0]), 0).run();
                }
            }
        }.execute();
    }

    public void addOperationsListener(NotificationListener nl) {
        this.notificationListenersList.add(nl);
    }

    public void removeOperationsListener(NotificationListener nl) {
        this.notificationListenersList.remove(nl);
    }

    private void fireChangedNotification(String type, Object source, Object handback) {
        Notification n = new Notification(type, source, 0L);
        for (NotificationListener nl : this.notificationListenersList) {
            nl.handleNotification(n, handback);
        }
    }

    protected abstract MBeanOperationInfo[] updateOperations(MBeanOperationInfo[] var1);
}

