/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Utilities;

abstract class OverviewPanel
extends PlotterPanel {
    private static final Dimension PREFERRED_PLOTTER_SIZE = new Dimension(300, 200);
    private static final Dimension MINIMUM_PLOTTER_SIZE = new Dimension(200, 150);
    static final int VIEW_RANGE = -1;
    static Color PLOTTER_COLOR = JConsole.IS_GTK ? new Color(231, 111, 80) : null;
    private JLabel infoLabel;

    public OverviewPanel(String title) {
        this(title, null, null, null);
    }

    public OverviewPanel(String title, String plotterKey, String plotterName, Plotter.Unit plotterUnit) {
        super(title);
        this.setLayout(new BorderLayout(0, 0));
        if (plotterKey != null && plotterName != null) {
            Plotter plotter = new Plotter();
            plotter.setPreferredSize(PREFERRED_PLOTTER_SIZE);
            plotter.setMinimumSize(MINIMUM_PLOTTER_SIZE);
            plotter.setViewRange(-1);
            if (plotterUnit != null) {
                plotter.setUnit(plotterUnit);
            }
            plotter.createSequence(plotterKey, plotterName, PLOTTER_COLOR, true);
            Utilities.setAccessibleName(plotter, Resources.getText("OverviewPanel.plotter.accessibleName", title));
            this.setPlotter(plotter);
        }
    }

    public JLabel getInfoLabel() {
        if (this.infoLabel == null) {
            this.infoLabel = new JLabel("", 0){

                @Override
                public void setText(String text) {
                    if (text.startsWith("<html>")) {
                        StringBuilder buf = new StringBuilder();
                        char[] chars = text.toCharArray();
                        int n = chars.length;
                        for (int i = 0; i < n; ++i) {
                            if (chars[i] == ' ' && (i < n - 1 && chars[i + 1] == ' ' || (i == 0 || chars[i - 1] != ' ') && (i == n - 1 || chars[i + 1] != ' '))) {
                                buf.append("&nbsp;");
                                continue;
                            }
                            buf.append(chars[i]);
                        }
                        text = buf.toString();
                    }
                    super.setText(text);
                }
            };
            if (JConsole.IS_GTK) {
                JPanel southPanel = new JPanel(new BorderLayout());
                JSeparator separator = new JSeparator(0);
                southPanel.add((Component)separator, "North");
                southPanel.add((Component)this.infoLabel, "South");
                this.add((Component)southPanel, "South");
            } else {
                this.add((Component)this.infoLabel, "South");
            }
        }
        return this.infoLabel;
    }
}

