/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.HmacCore;
import com.sun.crypto.provider.PKCS12PBECipherCore;
import com.sun.crypto.provider.SunJCE;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class HmacPKCS12PBESHA1
extends MacSpi
implements Cloneable {
    private HmacCore hmac = new HmacCore(MessageDigest.getInstance("SHA1"), 64);
    private static final int SHA1_BLOCK_LENGTH = 64;

    @Override
    protected int engineGetMacLength() {
        return this.hmac.getDigestLength();
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        char[] passwdChars;
        byte[] salt = null;
        int iCount = 0;
        if (key instanceof PBEKey) {
            PBEKey pbeKey = (PBEKey)key;
            passwdChars = pbeKey.getPassword();
            salt = pbeKey.getSalt();
            iCount = pbeKey.getIterationCount();
        } else if (key instanceof SecretKey) {
            byte[] passwdBytes = key.getEncoded();
            if (passwdBytes == null || !key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
                throw new InvalidKeyException("Missing password");
            }
            passwdChars = new char[passwdBytes.length];
            for (int i = 0; i < passwdChars.length; ++i) {
                passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
            }
        } else {
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        if (params == null) {
            if (salt == null) {
                salt = new byte[20];
                SunJCE.RANDOM.nextBytes(salt);
            }
            if (iCount == 0) {
                iCount = 100;
            }
        } else {
            if (!(params instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
            }
            PBEParameterSpec pbeParams = (PBEParameterSpec)params;
            if (salt != null) {
                if (!Arrays.equals(salt, pbeParams.getSalt())) {
                    throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                }
            } else {
                salt = pbeParams.getSalt();
            }
            if (iCount != 0) {
                if (iCount != pbeParams.getIterationCount()) {
                    throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                }
            } else {
                iCount = pbeParams.getIterationCount();
            }
        }
        if (salt.length < 8) {
            throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
        }
        if (iCount <= 0) {
            throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
        }
        byte[] derivedKey = PKCS12PBECipherCore.derive(passwdChars, salt, iCount, this.hmac.getDigestLength(), 3);
        SecretKeySpec cipherKey = new SecretKeySpec(derivedKey, "HmacSHA1");
        this.hmac.init(cipherKey, null);
    }

    @Override
    protected void engineUpdate(byte input) {
        this.hmac.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.hmac.update(input, offset, len);
    }

    @Override
    protected void engineUpdate(ByteBuffer input) {
        this.hmac.update(input);
    }

    @Override
    protected byte[] engineDoFinal() {
        return this.hmac.doFinal();
    }

    @Override
    protected void engineReset() {
        this.hmac.reset();
    }

    @Override
    public Object clone() {
        HmacPKCS12PBESHA1 that = null;
        try {
            that = (HmacPKCS12PBESHA1)super.clone();
            that.hmac = (HmacCore)this.hmac.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return that;
    }
}

