/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioPermission;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.classpath.icedtea.pulseaudio.Debug;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.PulseAudioDataLine;
import org.classpath.icedtea.pulseaudio.PulseAudioMixer;
import org.classpath.icedtea.pulseaudio.Stream;
import org.classpath.icedtea.pulseaudio.StreamBufferAttributes;

public final class PulseAudioTargetDataLine
extends PulseAudioDataLine
implements TargetDataLine {
    private byte[] fragmentBuffer;
    private boolean flushed = false;
    private boolean drained = false;
    public static final String DEFAULT_TARGETDATALINE_NAME = "Audio Stream";

    PulseAudioTargetDataLine(AudioFormat[] formats, AudioFormat defaultFormat) {
        this.supportedFormats = formats;
        this.defaultFormat = defaultFormat;
        this.currentFormat = defaultFormat;
        this.streamName = DEFAULT_TARGETDATALINE_NAME;
    }

    @Override
    public synchronized void close() {
        if (!this.isOpen()) {
            Debug.println(Debug.DebugLevel.Verbose, "PulseAudioTargetDataLine.close(): Line closed that wasn't open.");
            return;
        }
        AudioPermission perm = new AudioPermission("record", null);
        perm.checkGuard(null);
        PulseAudioMixer parentMixer = PulseAudioMixer.getInstance();
        parentMixer.removeTargetLine(this);
        super.close();
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioTargetDataLine.close(): Line closed");
    }

    @Override
    public synchronized void open(AudioFormat format, int bufferSize) throws LineUnavailableException {
        AudioPermission perm = new AudioPermission("record", null);
        perm.checkGuard(null);
        if (this.isOpen()) {
            throw new IllegalStateException("already open");
        }
        super.open(format, bufferSize);
        this.framesSinceOpen = 0L;
        this.fragmentBuffer = null;
        this.flushed = false;
        this.drained = false;
        PulseAudioMixer parentMixer = PulseAudioMixer.getInstance();
        parentMixer.addTargetLine(this);
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioTargetDataLine.open(): Line opened");
    }

    @Override
    public synchronized void open(AudioFormat format) throws LineUnavailableException {
        this.open(format, 50000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectLine(int bufferSize, Stream masterStream) throws LineUnavailableException {
        StreamBufferAttributes bufferAttributes;
        int fs = this.currentFormat.getFrameSize();
        float fr = this.currentFormat.getFrameRate();
        int bps = (int)((float)fs * fr);
        long flags = Stream.FLAG_START_CORKED;
        if (bps * 2 < bufferSize) {
            bufferAttributes = new StreamBufferAttributes(bufferSize, -1, -1, -1, -1);
        } else {
            flags |= Stream.FLAG_ADJUST_LATENCY;
            int fragmentSize = bufferSize / 2;
            fragmentSize = Math.max(fragmentSize / fs * fs, fs);
            bufferAttributes = new StreamBufferAttributes(bufferSize, -1, -1, -1, fragmentSize);
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.stream.connectForRecording(Stream.DEFAULT_DEVICE, flags, bufferAttributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] data, int offset, int length) {
        int bytesRead;
        if (!this.isOpen()) {
            return 0;
        }
        int frameSize = this.currentFormat.getFrameSize();
        if (length % frameSize != 0) {
            throw new IllegalArgumentException("amount of data to read does not represent an integral number of frames");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is negative");
        }
        if (offset < 0 || offset > data.length - length) {
            throw new ArrayIndexOutOfBoundsException("array size: " + data.length + " offset:" + offset + " length:" + length);
        }
        int position = offset;
        int remainingLength = length;
        int sizeRead = 0;
        this.flushed = false;
        this.drained = false;
        PulseAudioTargetDataLine pulseAudioTargetDataLine = this;
        synchronized (pulseAudioTargetDataLine) {
            if (this.fragmentBuffer != null) {
                boolean fragmentBufferSmaller = this.fragmentBuffer.length < length;
                int smallerBufferLength = Math.min(this.fragmentBuffer.length, length);
                System.arraycopy(this.fragmentBuffer, 0, data, position, smallerBufferLength);
                this.framesSinceOpen += (long)(smallerBufferLength / this.currentFormat.getFrameSize());
                if (!fragmentBufferSmaller) {
                    int remainingBytesInFragment = this.fragmentBuffer.length - length;
                    byte[] newFragmentBuffer = new byte[remainingBytesInFragment];
                    System.arraycopy(this.fragmentBuffer, length, newFragmentBuffer, 0, newFragmentBuffer.length);
                    this.fragmentBuffer = newFragmentBuffer;
                    return length;
                }
                bytesRead = smallerBufferLength;
                sizeRead += bytesRead;
                position += bytesRead;
                remainingLength -= bytesRead;
                this.fragmentBuffer = null;
            }
        }
        while (remainingLength != 0) {
            pulseAudioTargetDataLine = this;
            synchronized (pulseAudioTargetDataLine) {
                if (!this.isOpen() || !this.isStarted) {
                    return sizeRead;
                }
                if (this.flushed) {
                    this.flushed = false;
                    return sizeRead;
                }
                if (this.drained) {
                    this.drained = false;
                    return sizeRead;
                }
                Object object = this.eventLoop.threadLock;
                synchronized (object) {
                    byte[] currentFragment = this.stream.peek();
                    this.stream.drop();
                    if (currentFragment == null) {
                        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioTargetDataLine.read():  error in stream.peek()");
                        continue;
                    }
                    bytesRead = Math.min(currentFragment.length, remainingLength);
                    if (bytesRead < currentFragment.length) {
                        this.fragmentBuffer = new byte[currentFragment.length - bytesRead];
                        System.arraycopy(currentFragment, bytesRead, this.fragmentBuffer, 0, currentFragment.length - bytesRead);
                    }
                    System.arraycopy(currentFragment, 0, data, position, bytesRead);
                    sizeRead += bytesRead;
                    position += bytesRead;
                    remainingLength -= bytesRead;
                    this.framesSinceOpen += (long)(bytesRead / this.currentFormat.getFrameSize());
                }
            }
        }
        assert (sizeRead == length);
        return sizeRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drain() {
        PulseAudioTargetDataLine pulseAudioTargetDataLine;
        while (true) {
            pulseAudioTargetDataLine = this;
            synchronized (pulseAudioTargetDataLine) {
                if (!this.isStarted || !this.isOpen()) {
                    break;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        pulseAudioTargetDataLine = this;
        synchronized (pulseAudioTargetDataLine) {
            this.drained = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() {
        if (this.isOpen()) {
            Operation operation;
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                operation = this.stream.flush();
            }
            operation.waitForCompletion();
            operation.releaseReference();
        }
        this.flushed = true;
        this.fragmentBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() {
        if (!this.isOpen()) {
            return 0;
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            return this.stream.getReableSize();
        }
    }

    @Override
    public int getFramePosition() {
        return (int)this.framesSinceOpen;
    }

    @Override
    public long getLongFramePosition() {
        return this.framesSinceOpen;
    }

    @Override
    public long getMicrosecondPosition() {
        return (long)((float)this.framesSinceOpen / this.currentFormat.getFrameRate());
    }

    @Override
    public synchronized void start() {
        super.start();
        this.fireLineEvent(new LineEvent(this, LineEvent.Type.START, this.framesSinceOpen));
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.fireLineEvent(new LineEvent(this, LineEvent.Type.STOP, this.framesSinceOpen));
    }

    @Override
    public Line.Info getLineInfo() {
        return new DataLine.Info(TargetDataLine.class, this.supportedFormats, 0, 1000000);
    }
}

