/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.FileInputStream;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.TreeSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import sun.security.ssl.AbstractKeyManagerWrapper;
import sun.security.ssl.AbstractTrustManagerWrapper;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.Debug;
import sun.security.ssl.DummyX509KeyManager;
import sun.security.ssl.DummyX509TrustManager;
import sun.security.ssl.EphemeralKeyManager;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLServerSocketFactoryImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSocketFactoryImpl;
import sun.security.ssl.SunJSSE;
import sun.security.ssl.SunX509KeyManagerImpl;
import sun.security.ssl.TrustManagerFactoryImpl;
import sun.security.ssl.X509KeyManagerImpl;
import sun.security.ssl.X509TrustManagerImpl;

public abstract class SSLContextImpl
extends SSLContextSpi {
    private static final Debug debug = Debug.getInstance("ssl");
    private final EphemeralKeyManager ephemeralKeyManager;
    private final SSLSessionContextImpl clientCache;
    private final SSLSessionContextImpl serverCache;
    private boolean isInitialized;
    private X509ExtendedKeyManager keyManager;
    private X509TrustManager trustManager;
    private SecureRandom secureRandom;
    private AlgorithmConstraints defaultAlgorithmConstraints = new SSLAlgorithmConstraints(null);
    private ProtocolList defaultServerProtocolList;
    private ProtocolList defaultClientProtocolList;
    private ProtocolList supportedProtocolList;
    private CipherSuiteList defaultServerCipherSuiteList;
    private CipherSuiteList defaultClientCipherSuiteList;
    private CipherSuiteList supportedCipherSuiteList;

    SSLContextImpl() {
        this.ephemeralKeyManager = new EphemeralKeyManager();
        this.clientCache = new SSLSessionContextImpl();
        this.serverCache = new SSLSessionContextImpl();
    }

    @Override
    protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
        this.isInitialized = false;
        this.keyManager = this.chooseKeyManager(km);
        if (tm == null) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
                tm = tmf.getTrustManagers();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.trustManager = this.chooseTrustManager(tm);
        if (sr == null) {
            this.secureRandom = JsseJce.getSecureRandom();
        } else {
            if (SunJSSE.isFIPS() && sr.getProvider() != SunJSSE.cryptoProvider) {
                throw new KeyManagementException("FIPS mode: SecureRandom must be from provider " + SunJSSE.cryptoProvider.getName());
            }
            this.secureRandom = sr;
        }
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("trigger seeding of SecureRandom");
        }
        this.secureRandom.nextInt();
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("done seeding SecureRandom");
        }
        this.isInitialized = true;
    }

    private X509TrustManager chooseTrustManager(TrustManager[] tm) throws KeyManagementException {
        for (int i = 0; tm != null && i < tm.length; ++i) {
            if (!(tm[i] instanceof X509TrustManager)) continue;
            if (SunJSSE.isFIPS() && !(tm[i] instanceof X509TrustManagerImpl)) {
                throw new KeyManagementException("FIPS mode: only SunJSSE TrustManagers may be used");
            }
            if (tm[i] instanceof X509ExtendedTrustManager) {
                return (X509TrustManager)tm[i];
            }
            return new AbstractTrustManagerWrapper((X509TrustManager)tm[i]);
        }
        return DummyX509TrustManager.INSTANCE;
    }

    private X509ExtendedKeyManager chooseKeyManager(KeyManager[] kms) throws KeyManagementException {
        for (int i = 0; kms != null && i < kms.length; ++i) {
            KeyManager km = kms[i];
            if (!(km instanceof X509KeyManager)) continue;
            if (SunJSSE.isFIPS()) {
                if (km instanceof X509KeyManagerImpl || km instanceof SunX509KeyManagerImpl) {
                    return (X509ExtendedKeyManager)km;
                }
                throw new KeyManagementException("FIPS mode: only SunJSSE KeyManagers may be used");
            }
            if (km instanceof X509ExtendedKeyManager) {
                return (X509ExtendedKeyManager)km;
            }
            if (debug != null && Debug.isOn("sslctx")) {
                System.out.println("X509KeyManager passed to SSLContext.init():  need an X509ExtendedKeyManager for SSLEngine use");
            }
            return new AbstractKeyManagerWrapper((X509KeyManager)km);
        }
        return DummyX509KeyManager.INSTANCE;
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLSocketFactoryImpl(this);
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContext is not initialized");
        }
        return new SSLServerSocketFactoryImpl(this);
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLEngineImpl(this);
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String host, int port) {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLEngineImpl(this, host, port);
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.clientCache;
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.serverCache;
    }

    SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    X509ExtendedKeyManager getX509KeyManager() {
        return this.keyManager;
    }

    X509TrustManager getX509TrustManager() {
        return this.trustManager;
    }

    EphemeralKeyManager getEphemeralKeyManager() {
        return this.ephemeralKeyManager;
    }

    abstract SSLParameters getDefaultServerSSLParams();

    abstract SSLParameters getDefaultClientSSLParams();

    abstract SSLParameters getSupportedSSLParams();

    ProtocolList getSuportedProtocolList() {
        if (this.supportedProtocolList == null) {
            this.supportedProtocolList = new ProtocolList(this.getSupportedSSLParams().getProtocols());
        }
        return this.supportedProtocolList;
    }

    ProtocolList getDefaultProtocolList(boolean roleIsServer) {
        if (roleIsServer) {
            if (this.defaultServerProtocolList == null) {
                this.defaultServerProtocolList = new ProtocolList(this.getDefaultServerSSLParams().getProtocols());
            }
            return this.defaultServerProtocolList;
        }
        if (this.defaultClientProtocolList == null) {
            this.defaultClientProtocolList = new ProtocolList(this.getDefaultClientSSLParams().getProtocols());
        }
        return this.defaultClientProtocolList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CipherSuiteList getSuportedCipherSuiteList() {
        SSLContextImpl sSLContextImpl = this;
        synchronized (sSLContextImpl) {
            this.clearAvailableCache();
            if (this.supportedCipherSuiteList == null) {
                this.supportedCipherSuiteList = this.getApplicableCipherSuiteList(this.getSuportedProtocolList(), false);
            }
            return this.supportedCipherSuiteList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CipherSuiteList getDefaultCipherSuiteList(boolean roleIsServer) {
        SSLContextImpl sSLContextImpl = this;
        synchronized (sSLContextImpl) {
            this.clearAvailableCache();
            if (roleIsServer) {
                if (this.defaultServerCipherSuiteList == null) {
                    this.defaultServerCipherSuiteList = this.getApplicableCipherSuiteList(this.getDefaultProtocolList(true), true);
                }
                return this.defaultServerCipherSuiteList;
            }
            if (this.defaultClientCipherSuiteList == null) {
                this.defaultClientCipherSuiteList = this.getApplicableCipherSuiteList(this.getDefaultProtocolList(false), true);
            }
            return this.defaultClientCipherSuiteList;
        }
    }

    boolean isDefaultProtocolList(ProtocolList protocols) {
        return protocols == this.defaultServerProtocolList || protocols == this.defaultClientProtocolList;
    }

    private CipherSuiteList getApplicableCipherSuiteList(ProtocolList protocols, boolean onlyEnabled) {
        int minPriority = 1;
        if (onlyEnabled) {
            minPriority = 300;
        }
        Collection<CipherSuite> allowedCipherSuites = CipherSuite.allowedCipherSuites();
        TreeSet<CipherSuite> suites = new TreeSet<CipherSuite>();
        if (!protocols.collection().isEmpty() && protocols.min.v != ProtocolVersion.NONE.v) {
            for (CipherSuite suite : allowedCipherSuites) {
                if (!suite.allowed || suite.priority < minPriority) continue;
                if (suite.isAvailable() && suite.obsoleted > protocols.min.v && suite.supported <= protocols.max.v) {
                    if (!this.defaultAlgorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), suite.name, null)) continue;
                    suites.add(suite);
                    continue;
                }
                if (debug == null || !Debug.isOn("sslctx") || !Debug.isOn("verbose")) continue;
                if (suite.obsoleted <= protocols.min.v) {
                    System.out.println("Ignoring obsoleted cipher suite: " + suite);
                    continue;
                }
                if (suite.supported > protocols.max.v) {
                    System.out.println("Ignoring unsupported cipher suite: " + suite);
                    continue;
                }
                System.out.println("Ignoring unavailable cipher suite: " + suite);
            }
        }
        return new CipherSuiteList(suites);
    }

    private void clearAvailableCache() {
        this.supportedCipherSuiteList = null;
        this.defaultServerCipherSuiteList = null;
        this.defaultClientCipherSuiteList = null;
        CipherSuite.BulkCipher.clearAvailableCache();
        JsseJce.clearEcAvailable();
    }

    public static final class TLS12Context
    extends SSLContextImpl {
        private static SSLParameters defaultServerSSLParams;
        private static SSLParameters defaultClientSSLParams;
        private static SSLParameters supportedSSLParams;

        @Override
        SSLParameters getDefaultServerSSLParams() {
            return defaultServerSSLParams;
        }

        @Override
        SSLParameters getDefaultClientSSLParams() {
            return defaultClientSSLParams;
        }

        @Override
        SSLParameters getSupportedSSLParams() {
            return supportedSSLParams;
        }

        static {
            if (SunJSSE.isFIPS()) {
                supportedSSLParams = new SSLParameters();
                supportedSSLParams.setProtocols(new String[]{ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                defaultServerSSLParams = supportedSSLParams;
                defaultClientSSLParams = new SSLParameters();
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
            } else {
                supportedSSLParams = new SSLParameters();
                supportedSSLParams.setProtocols(new String[]{ProtocolVersion.SSL20Hello.name, ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                defaultServerSSLParams = supportedSSLParams;
                defaultClientSSLParams = new SSLParameters();
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
            }
        }
    }

    public static final class TLS11Context
    extends SSLContextImpl {
        private static SSLParameters defaultServerSSLParams;
        private static SSLParameters defaultClientSSLParams;
        private static SSLParameters supportedSSLParams;

        @Override
        SSLParameters getDefaultServerSSLParams() {
            return defaultServerSSLParams;
        }

        @Override
        SSLParameters getDefaultClientSSLParams() {
            return defaultClientSSLParams;
        }

        @Override
        SSLParameters getSupportedSSLParams() {
            return supportedSSLParams;
        }

        static {
            if (SunJSSE.isFIPS()) {
                supportedSSLParams = new SSLParameters();
                supportedSSLParams.setProtocols(new String[]{ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                defaultServerSSLParams = supportedSSLParams;
                defaultClientSSLParams = new SSLParameters();
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name});
            } else {
                supportedSSLParams = new SSLParameters();
                supportedSSLParams.setProtocols(new String[]{ProtocolVersion.SSL20Hello.name, ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                defaultServerSSLParams = supportedSSLParams;
                defaultClientSSLParams = new SSLParameters();
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name});
            }
        }
    }

    public static final class TLS10Context
    extends ConservativeSSLContext {
    }

    public static final class DefaultSSLContext
    extends ConservativeSSLContext {
        private static final String NONE = "NONE";
        private static final String P11KEYSTORE = "PKCS11";
        private static volatile SSLContextImpl defaultImpl;
        private static TrustManager[] defaultTrustManagers;
        private static KeyManager[] defaultKeyManagers;

        public DefaultSSLContext() throws Exception {
            try {
                super.engineInit(DefaultSSLContext.getDefaultKeyManager(), DefaultSSLContext.getDefaultTrustManager(), null);
            }
            catch (Exception e) {
                if (debug != null && Debug.isOn("defaultctx")) {
                    System.out.println("default context init failed: " + e);
                }
                throw e;
            }
            if (defaultImpl == null) {
                defaultImpl = this;
            }
        }

        @Override
        protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
            throw new KeyManagementException("Default SSLContext is initialized automatically");
        }

        static synchronized SSLContextImpl getDefaultImpl() throws Exception {
            if (defaultImpl == null) {
                new DefaultSSLContext();
            }
            return defaultImpl;
        }

        private static synchronized TrustManager[] getDefaultTrustManager() throws Exception {
            if (defaultTrustManagers != null) {
                return defaultTrustManagers;
            }
            KeyStore ks = TrustManagerFactoryImpl.getCacertsKeyStore("defaultctx");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            defaultTrustManagers = tmf.getTrustManagers();
            return defaultTrustManagers;
        }

        private static synchronized KeyManager[] getDefaultKeyManager() throws Exception {
            if (defaultKeyManagers != null) {
                return defaultKeyManagers;
            }
            final HashMap props = new HashMap();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    props.put("keyStore", System.getProperty("javax.net.ssl.keyStore", ""));
                    props.put("keyStoreType", System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
                    props.put("keyStoreProvider", System.getProperty("javax.net.ssl.keyStoreProvider", ""));
                    props.put("keyStorePasswd", System.getProperty("javax.net.ssl.keyStorePassword", ""));
                    return null;
                }
            });
            final String defaultKeyStore = (String)props.get("keyStore");
            String defaultKeyStoreType = (String)props.get("keyStoreType");
            String defaultKeyStoreProvider = (String)props.get("keyStoreProvider");
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("keyStore is : " + defaultKeyStore);
                System.out.println("keyStore type is : " + defaultKeyStoreType);
                System.out.println("keyStore provider is : " + defaultKeyStoreProvider);
            }
            if (P11KEYSTORE.equals(defaultKeyStoreType) && !NONE.equals(defaultKeyStore)) {
                throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
            }
            FileInputStream fs = null;
            if (defaultKeyStore.length() != 0 && !NONE.equals(defaultKeyStore)) {
                fs = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws Exception {
                        return new FileInputStream(defaultKeyStore);
                    }
                });
            }
            String defaultKeyStorePassword = (String)props.get("keyStorePasswd");
            char[] passwd = null;
            if (defaultKeyStorePassword.length() != 0) {
                passwd = defaultKeyStorePassword.toCharArray();
            }
            KeyStore ks = null;
            if (defaultKeyStoreType.length() != 0) {
                if (debug != null && Debug.isOn("defaultctx")) {
                    System.out.println("init keystore");
                }
                ks = defaultKeyStoreProvider.length() == 0 ? KeyStore.getInstance(defaultKeyStoreType) : KeyStore.getInstance(defaultKeyStoreType, defaultKeyStoreProvider);
                ks.load(fs, passwd);
            }
            if (fs != null) {
                fs.close();
                fs = null;
            }
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (P11KEYSTORE.equals(defaultKeyStoreType)) {
                kmf.init(ks, null);
            } else {
                kmf.init(ks, passwd);
            }
            defaultKeyManagers = kmf.getKeyManagers();
            return defaultKeyManagers;
        }
    }

    private static class ConservativeSSLContext
    extends SSLContextImpl {
        private static SSLParameters defaultServerSSLParams;
        private static SSLParameters defaultClientSSLParams;
        private static SSLParameters supportedSSLParams;

        private ConservativeSSLContext() {
        }

        @Override
        SSLParameters getDefaultServerSSLParams() {
            return defaultServerSSLParams;
        }

        @Override
        SSLParameters getDefaultClientSSLParams() {
            return defaultClientSSLParams;
        }

        @Override
        SSLParameters getSupportedSSLParams() {
            return supportedSSLParams;
        }

        static {
            if (SunJSSE.isFIPS()) {
                supportedSSLParams = new SSLParameters();
                supportedSSLParams.setProtocols(new String[]{ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                defaultServerSSLParams = supportedSSLParams;
                defaultClientSSLParams = new SSLParameters();
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.TLS10.name});
            } else {
                supportedSSLParams = new SSLParameters();
                supportedSSLParams.setProtocols(new String[]{ProtocolVersion.SSL20Hello.name, ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                defaultServerSSLParams = supportedSSLParams;
                defaultClientSSLParams = new SSLParameters();
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name});
            }
        }
    }
}

