/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import sun.security.ssl.CipherSuite;
import sun.security.util.DisabledAlgorithmConstraints;

final class SSLAlgorithmConstraints
implements AlgorithmConstraints {
    private static final AlgorithmConstraints tlsDisabledAlgConstraints = new TLSDisabledAlgConstraints();
    private static final AlgorithmConstraints x509DisabledAlgConstraints = new X509DisabledAlgConstraints();
    private AlgorithmConstraints userAlgConstraints = null;
    private AlgorithmConstraints peerAlgConstraints = null;
    private boolean enabledX509DisabledAlgConstraints = true;

    SSLAlgorithmConstraints(AlgorithmConstraints algorithmConstraints) {
        this.userAlgConstraints = algorithmConstraints;
    }

    SSLAlgorithmConstraints(SSLSocket socket, boolean withDefaultCertPathConstraints) {
        if (socket != null) {
            this.userAlgConstraints = socket.getSSLParameters().getAlgorithmConstraints();
        }
        if (!withDefaultCertPathConstraints) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    SSLAlgorithmConstraints(SSLEngine engine, boolean withDefaultCertPathConstraints) {
        if (engine != null) {
            this.userAlgConstraints = engine.getSSLParameters().getAlgorithmConstraints();
        }
        if (!withDefaultCertPathConstraints) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    SSLAlgorithmConstraints(SSLSocket socket, String[] supportedAlgorithms, boolean withDefaultCertPathConstraints) {
        if (socket != null) {
            this.userAlgConstraints = socket.getSSLParameters().getAlgorithmConstraints();
            this.peerAlgConstraints = new SupportedSignatureAlgorithmConstraints(supportedAlgorithms);
        }
        if (!withDefaultCertPathConstraints) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    SSLAlgorithmConstraints(SSLEngine engine, String[] supportedAlgorithms, boolean withDefaultCertPathConstraints) {
        if (engine != null) {
            this.userAlgConstraints = engine.getSSLParameters().getAlgorithmConstraints();
            this.peerAlgConstraints = new SupportedSignatureAlgorithmConstraints(supportedAlgorithms);
        }
        if (!withDefaultCertPathConstraints) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        boolean permitted = true;
        if (this.peerAlgConstraints != null) {
            permitted = this.peerAlgConstraints.permits(primitives, algorithm, parameters);
        }
        if (permitted && this.userAlgConstraints != null) {
            permitted = this.userAlgConstraints.permits(primitives, algorithm, parameters);
        }
        if (permitted) {
            permitted = tlsDisabledAlgConstraints.permits(primitives, algorithm, parameters);
        }
        if (permitted && this.enabledX509DisabledAlgConstraints) {
            permitted = x509DisabledAlgConstraints.permits(primitives, algorithm, parameters);
        }
        return permitted;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> primitives, Key key) {
        boolean permitted = true;
        if (this.peerAlgConstraints != null) {
            permitted = this.peerAlgConstraints.permits(primitives, key);
        }
        if (permitted && this.userAlgConstraints != null) {
            permitted = this.userAlgConstraints.permits(primitives, key);
        }
        if (permitted) {
            permitted = tlsDisabledAlgConstraints.permits(primitives, key);
        }
        if (permitted && this.enabledX509DisabledAlgConstraints) {
            permitted = x509DisabledAlgConstraints.permits(primitives, key);
        }
        return permitted;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        boolean permitted = true;
        if (this.peerAlgConstraints != null) {
            permitted = this.peerAlgConstraints.permits(primitives, algorithm, key, parameters);
        }
        if (permitted && this.userAlgConstraints != null) {
            permitted = this.userAlgConstraints.permits(primitives, algorithm, key, parameters);
        }
        if (permitted) {
            permitted = tlsDisabledAlgConstraints.permits(primitives, algorithm, key, parameters);
        }
        if (permitted && this.enabledX509DisabledAlgConstraints) {
            permitted = x509DisabledAlgConstraints.permits(primitives, algorithm, key, parameters);
        }
        return permitted;
    }

    private static class X509DisabledAlgConstraints
    extends BasicDisabledAlgConstraints {
        X509DisabledAlgConstraints() {
            super("jdk.certpath.disabledAlgorithms");
        }

        protected Set<String> decomposes(String algorithm) {
            if (algorithm.startsWith("SSL_") || algorithm.startsWith("TLS_")) {
                CipherSuite cipherSuite = null;
                try {
                    cipherSuite = CipherSuite.valueOf(algorithm);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
                if (cipherSuite != null) {
                    HashSet<String> components = new HashSet<String>();
                    if (cipherSuite.keyExchange != null) {
                        components.addAll(this.decomposes(cipherSuite.keyExchange, true));
                    }
                    return components;
                }
            }
            return super.decomposes(algorithm);
        }
    }

    private static class TLSDisabledAlgConstraints
    extends BasicDisabledAlgConstraints {
        TLSDisabledAlgConstraints() {
            super("jdk.tls.disabledAlgorithms");
        }

        protected Set<String> decomposes(String algorithm) {
            if (algorithm.startsWith("SSL_") || algorithm.startsWith("TLS_")) {
                CipherSuite cipherSuite = null;
                try {
                    cipherSuite = CipherSuite.valueOf(algorithm);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
                if (cipherSuite != null) {
                    HashSet<String> components = new HashSet<String>();
                    if (cipherSuite.keyExchange != null) {
                        components.addAll(this.decomposes(cipherSuite.keyExchange, false));
                    }
                    if (cipherSuite.cipher != null) {
                        components.addAll(this.decomposes(cipherSuite.cipher));
                    }
                    if (cipherSuite.macAlg != null) {
                        components.addAll(this.decomposes(cipherSuite.macAlg));
                    }
                    return components;
                }
            }
            return super.decomposes(algorithm);
        }
    }

    private static class BasicDisabledAlgConstraints
    extends DisabledAlgorithmConstraints {
        BasicDisabledAlgConstraints(String propertyName) {
            super(propertyName);
        }

        protected Set<String> decomposes(CipherSuite.KeyExchange keyExchange, boolean forCertPathOnly) {
            HashSet<String> components = new HashSet<String>();
            switch (keyExchange) {
                case K_NULL: {
                    if (forCertPathOnly) break;
                    components.add("NULL");
                    break;
                }
                case K_RSA: {
                    components.add("RSA");
                    break;
                }
                case K_RSA_EXPORT: {
                    components.add("RSA");
                    components.add("RSA_EXPORT");
                    break;
                }
                case K_DH_RSA: {
                    components.add("RSA");
                    components.add("DH");
                    components.add("DiffieHellman");
                    components.add("DH_RSA");
                    break;
                }
                case K_DH_DSS: {
                    components.add("DSA");
                    components.add("DSS");
                    components.add("DH");
                    components.add("DiffieHellman");
                    components.add("DH_DSS");
                    break;
                }
                case K_DHE_DSS: {
                    components.add("DSA");
                    components.add("DSS");
                    components.add("DH");
                    components.add("DHE");
                    components.add("DiffieHellman");
                    components.add("DHE_DSS");
                    break;
                }
                case K_DHE_RSA: {
                    components.add("RSA");
                    components.add("DH");
                    components.add("DHE");
                    components.add("DiffieHellman");
                    components.add("DHE_RSA");
                    break;
                }
                case K_DH_ANON: {
                    if (forCertPathOnly) break;
                    components.add("ANON");
                    components.add("DH");
                    components.add("DiffieHellman");
                    components.add("DH_ANON");
                    break;
                }
                case K_ECDH_ECDSA: {
                    components.add("ECDH");
                    components.add("ECDSA");
                    components.add("ECDH_ECDSA");
                    break;
                }
                case K_ECDH_RSA: {
                    components.add("ECDH");
                    components.add("RSA");
                    components.add("ECDH_RSA");
                    break;
                }
                case K_ECDHE_ECDSA: {
                    components.add("ECDHE");
                    components.add("ECDSA");
                    components.add("ECDHE_ECDSA");
                    break;
                }
                case K_ECDHE_RSA: {
                    components.add("ECDHE");
                    components.add("RSA");
                    components.add("ECDHE_RSA");
                    break;
                }
                case K_ECDH_ANON: {
                    if (forCertPathOnly) break;
                    components.add("ECDH");
                    components.add("ANON");
                    components.add("ECDH_ANON");
                    break;
                }
                case K_KRB5: {
                    if (forCertPathOnly) break;
                    components.add("KRB5");
                    break;
                }
                case K_KRB5_EXPORT: {
                    if (forCertPathOnly) break;
                    components.add("KRB5_EXPORT");
                    break;
                }
            }
            return components;
        }

        protected Set<String> decomposes(CipherSuite.BulkCipher bulkCipher) {
            HashSet<String> components = new HashSet<String>();
            if (bulkCipher.transformation != null) {
                components.addAll(super.decomposes(bulkCipher.transformation));
            }
            return components;
        }

        protected Set<String> decomposes(CipherSuite.MacAlg macAlg) {
            HashSet<String> components = new HashSet<String>();
            if (macAlg == CipherSuite.M_MD5) {
                components.add("MD5");
                components.add("HmacMD5");
            } else if (macAlg == CipherSuite.M_SHA) {
                components.add("SHA1");
                components.add("SHA-1");
                components.add("HmacSHA1");
            } else if (macAlg == CipherSuite.M_SHA256) {
                components.add("SHA256");
                components.add("SHA-256");
                components.add("HmacSHA256");
            } else if (macAlg == CipherSuite.M_SHA384) {
                components.add("SHA384");
                components.add("SHA-384");
                components.add("HmacSHA384");
            }
            return components;
        }
    }

    private static class SupportedSignatureAlgorithmConstraints
    implements AlgorithmConstraints {
        private String[] supportedAlgorithms;

        SupportedSignatureAlgorithmConstraints(String[] supportedAlgorithms) {
            this.supportedAlgorithms = supportedAlgorithms != null ? (String[])supportedAlgorithms.clone() : null;
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
            if (algorithm == null || algorithm.length() == 0) {
                throw new IllegalArgumentException("No algorithm name specified");
            }
            if (primitives == null || primitives.isEmpty()) {
                throw new IllegalArgumentException("No cryptographic primitive specified");
            }
            if (this.supportedAlgorithms == null || this.supportedAlgorithms.length == 0) {
                return false;
            }
            int position = algorithm.indexOf("and");
            if (position > 0) {
                algorithm = algorithm.substring(0, position);
            }
            for (String supportedAlgorithm : this.supportedAlgorithms) {
                if (!algorithm.equalsIgnoreCase(supportedAlgorithm)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final boolean permits(Set<CryptoPrimitive> primitives, Key key) {
            return true;
        }

        @Override
        public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
            if (algorithm == null || algorithm.length() == 0) {
                throw new IllegalArgumentException("No algorithm name specified");
            }
            return this.permits(primitives, algorithm, parameters);
        }
    }
}

