/*
 * Decompiled with CFR 0.152.
 */
package sun.util.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.util.logging.LoggingSupport;

public class PlatformLogger {
    public static final int OFF = Integer.MAX_VALUE;
    public static final int SEVERE = 1000;
    public static final int WARNING = 900;
    public static final int INFO = 800;
    public static final int CONFIG = 700;
    public static final int FINE = 500;
    public static final int FINER = 400;
    public static final int FINEST = 300;
    public static final int ALL = Integer.MIN_VALUE;
    private static final int defaultLevel = 800;
    private static boolean loggingEnabled = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            String cname = System.getProperty("java.util.logging.config.class");
            String fname = System.getProperty("java.util.logging.config.file");
            return cname != null || fname != null;
        }
    });
    private static Map<String, WeakReference<PlatformLogger>> loggers = new HashMap<String, WeakReference<PlatformLogger>>();
    private volatile LoggerProxy logger;

    public static synchronized PlatformLogger getLogger(String name) {
        PlatformLogger log = null;
        WeakReference<PlatformLogger> ref = loggers.get(name);
        if (ref != null) {
            log = (PlatformLogger)ref.get();
        }
        if (log == null) {
            log = new PlatformLogger(name);
            loggers.put(name, new WeakReference<PlatformLogger>(log));
        }
        return log;
    }

    public static synchronized void redirectPlatformLoggers() {
        if (loggingEnabled || !LoggingSupport.isAvailable()) {
            return;
        }
        loggingEnabled = true;
        for (Map.Entry<String, WeakReference<PlatformLogger>> entry : loggers.entrySet()) {
            WeakReference<PlatformLogger> ref = entry.getValue();
            PlatformLogger plog = (PlatformLogger)ref.get();
            if (plog == null) continue;
            plog.newJavaLogger();
        }
    }

    private void newJavaLogger() {
        this.logger = new JavaLogger(this.logger.name, this.logger.effectiveLevel);
    }

    private PlatformLogger(String name) {
        this.logger = loggingEnabled ? new JavaLogger(name) : new LoggerProxy(name);
    }

    public boolean isEnabled() {
        return this.logger.isEnabled();
    }

    public String getName() {
        return this.logger.name;
    }

    public boolean isLoggable(int level) {
        return this.logger.isLoggable(level);
    }

    public int getLevel() {
        return this.logger.getLevel();
    }

    public void setLevel(int newLevel) {
        this.logger.setLevel(newLevel);
    }

    public void severe(String msg) {
        this.logger.doLog(1000, msg);
    }

    public void severe(String msg, Throwable t) {
        this.logger.doLog(1000, msg, t);
    }

    public void severe(String msg, Object ... params) {
        this.logger.doLog(1000, msg, params);
    }

    public void warning(String msg) {
        this.logger.doLog(900, msg);
    }

    public void warning(String msg, Throwable t) {
        this.logger.doLog(900, msg, t);
    }

    public void warning(String msg, Object ... params) {
        this.logger.doLog(900, msg, params);
    }

    public void info(String msg) {
        this.logger.doLog(800, msg);
    }

    public void info(String msg, Throwable t) {
        this.logger.doLog(800, msg, t);
    }

    public void info(String msg, Object ... params) {
        this.logger.doLog(800, msg, params);
    }

    public void config(String msg) {
        this.logger.doLog(700, msg);
    }

    public void config(String msg, Throwable t) {
        this.logger.doLog(700, msg, t);
    }

    public void config(String msg, Object ... params) {
        this.logger.doLog(700, msg, params);
    }

    public void fine(String msg) {
        this.logger.doLog(500, msg);
    }

    public void fine(String msg, Throwable t) {
        this.logger.doLog(500, msg, t);
    }

    public void fine(String msg, Object ... params) {
        this.logger.doLog(500, msg, params);
    }

    public void finer(String msg) {
        this.logger.doLog(400, msg);
    }

    public void finer(String msg, Throwable t) {
        this.logger.doLog(400, msg, t);
    }

    public void finer(String msg, Object ... params) {
        this.logger.doLog(400, msg, params);
    }

    public void finest(String msg) {
        this.logger.doLog(300, msg);
    }

    public void finest(String msg, Throwable t) {
        this.logger.doLog(300, msg, t);
    }

    public void finest(String msg, Object ... params) {
        this.logger.doLog(300, msg, params);
    }

    private static String getLevelName(int level) {
        switch (level) {
            case 0x7FFFFFFF: {
                return "OFF";
            }
            case 1000: {
                return "SEVERE";
            }
            case 900: {
                return "WARNING";
            }
            case 800: {
                return "INFO";
            }
            case 700: {
                return "CONFIG";
            }
            case 500: {
                return "FINE";
            }
            case 400: {
                return "FINER";
            }
            case 300: {
                return "FINEST";
            }
            case -2147483648: {
                return "ALL";
            }
        }
        return "UNKNOWN";
    }

    static class JavaLogger
    extends LoggerProxy {
        private static final Map<Integer, Object> levelObjects = new HashMap<Integer, Object>();
        private final Object javaLogger;

        private static void getLevelObjects() {
            int[] levelArray;
            for (int l : levelArray = new int[]{Integer.MAX_VALUE, 1000, 900, 800, 700, 500, 400, 300, Integer.MIN_VALUE}) {
                Object level = LoggingSupport.parseLevel(PlatformLogger.getLevelName(l));
                levelObjects.put(l, level);
            }
        }

        JavaLogger(String name) {
            this(name, 0);
        }

        JavaLogger(String name, int level) {
            super(name, level);
            this.javaLogger = LoggingSupport.getLogger(name);
            if (level != 0) {
                LoggingSupport.setLevel(this.javaLogger, levelObjects.get(level));
            }
        }

        @Override
        void doLog(int level, String msg) {
            LoggingSupport.log(this.javaLogger, levelObjects.get(level), msg);
        }

        @Override
        void doLog(int level, String msg, Throwable t) {
            LoggingSupport.log(this.javaLogger, levelObjects.get(level), msg, t);
        }

        @Override
        void doLog(int level, String msg, Object ... params) {
            int len = params != null ? params.length : 0;
            Object[] sparams = new String[len];
            for (int i = 0; i < len; ++i) {
                sparams[i] = String.valueOf(params[i]);
            }
            LoggingSupport.log(this.javaLogger, levelObjects.get(level), msg, sparams);
        }

        @Override
        boolean isEnabled() {
            Object level = LoggingSupport.getLevel(this.javaLogger);
            return level == null || !level.equals(levelObjects.get(Integer.MAX_VALUE));
        }

        @Override
        int getLevel() {
            Object level = LoggingSupport.getLevel(this.javaLogger);
            if (level != null) {
                for (Map.Entry<Integer, Object> l : levelObjects.entrySet()) {
                    if (level != l.getValue()) continue;
                    return l.getKey();
                }
            }
            return 0;
        }

        @Override
        void setLevel(int newLevel) {
            this.levelValue = newLevel;
            LoggingSupport.setLevel(this.javaLogger, levelObjects.get(newLevel));
        }

        @Override
        public boolean isLoggable(int level) {
            return LoggingSupport.isLoggable(this.javaLogger, levelObjects.get(level));
        }

        static {
            if (LoggingSupport.isAvailable()) {
                JavaLogger.getLevelObjects();
            }
        }
    }

    static class LoggerProxy {
        private static final PrintStream defaultStream = System.err;
        final String name;
        volatile int levelValue;
        volatile int effectiveLevel = 0;
        private static final String formatString = LoggingSupport.getSimpleFormat(false);
        private Date date = new Date();

        LoggerProxy(String name) {
            this(name, 800);
        }

        LoggerProxy(String name, int level) {
            this.name = name;
            this.levelValue = level == 0 ? 800 : level;
        }

        boolean isEnabled() {
            return this.levelValue != Integer.MAX_VALUE;
        }

        int getLevel() {
            return this.effectiveLevel;
        }

        void setLevel(int newLevel) {
            this.levelValue = newLevel;
            this.effectiveLevel = newLevel;
        }

        void doLog(int level, String msg) {
            if (level < this.levelValue || this.levelValue == Integer.MAX_VALUE) {
                return;
            }
            defaultStream.print(this.format(level, msg, null));
        }

        void doLog(int level, String msg, Throwable thrown) {
            if (level < this.levelValue || this.levelValue == Integer.MAX_VALUE) {
                return;
            }
            defaultStream.print(this.format(level, msg, thrown));
        }

        void doLog(int level, String msg, Object ... params) {
            if (level < this.levelValue || this.levelValue == Integer.MAX_VALUE) {
                return;
            }
            String newMsg = this.formatMessage(msg, params);
            defaultStream.print(this.format(level, newMsg, null));
        }

        public boolean isLoggable(int level) {
            return level >= this.levelValue && this.levelValue != Integer.MAX_VALUE;
        }

        private String formatMessage(String format, Object ... parameters) {
            try {
                if (parameters == null || parameters.length == 0) {
                    return format;
                }
                if (format.indexOf("{0") >= 0 || format.indexOf("{1") >= 0 || format.indexOf("{2") >= 0 || format.indexOf("{3") >= 0) {
                    return MessageFormat.format(format, parameters);
                }
                return format;
            }
            catch (Exception ex) {
                return format;
            }
        }

        private synchronized String format(int level, String msg, Throwable thrown) {
            this.date.setTime(System.currentTimeMillis());
            String throwable = "";
            if (thrown != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                thrown.printStackTrace(pw);
                pw.close();
                throwable = sw.toString();
            }
            return String.format(formatString, this.date, this.getCallerInfo(), this.name, PlatformLogger.getLevelName(level), msg, throwable);
        }

        private String getCallerInfo() {
            String sourceClassName = null;
            String sourceMethodName = null;
            JavaLangAccess access = SharedSecrets.getJavaLangAccess();
            Throwable throwable = new Throwable();
            int depth = access.getStackTraceDepth(throwable);
            String logClassName = "sun.util.logging.PlatformLogger";
            boolean lookingForLogger = true;
            for (int ix = 0; ix < depth; ++ix) {
                StackTraceElement frame = access.getStackTraceElement(throwable, ix);
                String cname = frame.getClassName();
                if (lookingForLogger) {
                    if (!cname.equals(logClassName)) continue;
                    lookingForLogger = false;
                    continue;
                }
                if (cname.equals(logClassName)) continue;
                sourceClassName = cname;
                sourceMethodName = frame.getMethodName();
                break;
            }
            if (sourceClassName != null) {
                return sourceClassName + " " + sourceMethodName;
            }
            return this.name;
        }
    }
}

