/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.util.KeyLength;

public class DisabledAlgorithmConstraints
implements AlgorithmConstraints {
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    private static Map<String, String[]> disabledAlgorithmsMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, KeySizeConstraints> keySizeConstraintsMap = Collections.synchronizedMap(new HashMap());
    private String[] disabledAlgorithms;
    private KeySizeConstraints keySizeConstraints;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisabledAlgorithmConstraints(String propertyName) {
        Map<String, String[]> map = disabledAlgorithmsMap;
        synchronized (map) {
            if (!disabledAlgorithmsMap.containsKey(propertyName)) {
                DisabledAlgorithmConstraints.loadDisabledAlgorithmsMap(propertyName);
            }
            this.disabledAlgorithms = disabledAlgorithmsMap.get(propertyName);
            this.keySizeConstraints = keySizeConstraintsMap.get(propertyName);
        }
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        if (algorithm == null || algorithm.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        if (primitives == null || primitives.isEmpty()) {
            throw new IllegalArgumentException("No cryptographic primitive specified");
        }
        Set<String> elements = null;
        for (String disabled : this.disabledAlgorithms) {
            if (disabled == null || disabled.isEmpty()) continue;
            if (disabled.equalsIgnoreCase(algorithm)) {
                return false;
            }
            if (elements == null) {
                elements = this.decomposes(algorithm);
            }
            for (String element : elements) {
                if (!disabled.equalsIgnoreCase(element)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, Key key) {
        return this.checkConstraints(primitives, "", key, null);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (algorithm == null || algorithm.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        return this.checkConstraints(primitives, algorithm, key, parameters);
    }

    protected Set<String> decomposes(String algorithm) {
        if (algorithm == null || algorithm.length() == 0) {
            return new HashSet<String>();
        }
        Pattern transPattern = Pattern.compile("/");
        String[] transTockens = transPattern.split(algorithm);
        HashSet<String> elements = new HashSet<String>();
        for (String transTocken : transTockens) {
            String[] tokens;
            if (transTocken == null || transTocken.length() == 0) continue;
            Pattern pattern = Pattern.compile("with|and", 2);
            for (String token : tokens = pattern.split(transTocken)) {
                if (token == null || token.length() == 0) continue;
                elements.add(token);
            }
        }
        if (elements.contains("SHA1") && !elements.contains("SHA-1")) {
            elements.add("SHA-1");
        }
        if (elements.contains("SHA-1") && !elements.contains("SHA1")) {
            elements.add("SHA1");
        }
        if (elements.contains("SHA224") && !elements.contains("SHA-224")) {
            elements.add("SHA-224");
        }
        if (elements.contains("SHA-224") && !elements.contains("SHA224")) {
            elements.add("SHA224");
        }
        if (elements.contains("SHA256") && !elements.contains("SHA-256")) {
            elements.add("SHA-256");
        }
        if (elements.contains("SHA-256") && !elements.contains("SHA256")) {
            elements.add("SHA256");
        }
        if (elements.contains("SHA384") && !elements.contains("SHA-384")) {
            elements.add("SHA-384");
        }
        if (elements.contains("SHA-384") && !elements.contains("SHA384")) {
            elements.add("SHA384");
        }
        if (elements.contains("SHA512") && !elements.contains("SHA-512")) {
            elements.add("SHA-512");
        }
        if (elements.contains("SHA-512") && !elements.contains("SHA512")) {
            elements.add("SHA512");
        }
        return elements;
    }

    private boolean checkConstraints(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (algorithm != null && algorithm.length() != 0 && !this.permits(primitives, algorithm, parameters)) {
            return false;
        }
        if (!this.permits(primitives, key.getAlgorithm(), null)) {
            return false;
        }
        return !this.keySizeConstraints.disables(key);
    }

    private static void loadDisabledAlgorithmsMap(final String propertyName) {
        String property = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(propertyName);
            }
        });
        String[] algorithmsInProperty = null;
        if (property != null && !property.isEmpty()) {
            if (property.charAt(0) == '\"' && property.charAt(property.length() - 1) == '\"') {
                property = property.substring(1, property.length() - 1);
            }
            algorithmsInProperty = property.split(",");
            for (int i = 0; i < algorithmsInProperty.length; ++i) {
                algorithmsInProperty[i] = algorithmsInProperty[i].trim();
            }
        }
        if (algorithmsInProperty == null) {
            algorithmsInProperty = new String[]{};
        }
        disabledAlgorithmsMap.put(propertyName, algorithmsInProperty);
        KeySizeConstraints keySizeConstraints = new KeySizeConstraints(algorithmsInProperty);
        keySizeConstraintsMap.put(propertyName, keySizeConstraints);
    }

    private static class KeySizeConstraint {
        private int minSize;
        private int maxSize;
        private int prohibitedSize = -1;

        public KeySizeConstraint(Operator operator, int length) {
            switch (operator) {
                case EQ: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = length;
                    break;
                }
                case NE: {
                    this.minSize = length;
                    this.maxSize = length;
                    break;
                }
                case LT: {
                    this.minSize = length;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case LE: {
                    this.minSize = length + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case GT: {
                    this.minSize = 0;
                    this.maxSize = length;
                    break;
                }
                case GE: {
                    this.minSize = 0;
                    this.maxSize = length > 1 ? length - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        public boolean disables(Key key) {
            int size = KeyLength.getKeySize(key);
            if (size == 0) {
                return true;
            }
            if (size > 0) {
                return size < this.minSize || size > this.maxSize || this.prohibitedSize == size;
            }
            return false;
        }

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String s) {
                switch (s) {
                    case "==": {
                        return EQ;
                    }
                    case "!=": {
                        return NE;
                    }
                    case "<": {
                        return LT;
                    }
                    case "<=": {
                        return LE;
                    }
                    case ">": {
                        return GT;
                    }
                    case ">=": {
                        return GE;
                    }
                }
                throw new IllegalArgumentException(s + " is not a legal Operator");
            }
        }
    }

    private static class KeySizeConstraints {
        private static final Pattern pattern = Pattern.compile("(\\S+)\\s+keySize\\s*(<=|<|==|!=|>|>=)\\s*(\\d+)");
        private Map<String, Set<KeySizeConstraint>> constraintsMap = Collections.synchronizedMap(new HashMap());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeySizeConstraints(String[] restrictions) {
            for (String restriction : restrictions) {
                Matcher matcher;
                if (restriction == null || restriction.isEmpty() || !(matcher = pattern.matcher(restriction)).matches()) continue;
                String algorithm = matcher.group(1);
                KeySizeConstraint.Operator operator = KeySizeConstraint.Operator.of(matcher.group(2));
                int length = Integer.parseInt(matcher.group(3));
                algorithm = algorithm.toLowerCase(Locale.ENGLISH);
                Map<String, Set<KeySizeConstraint>> map = this.constraintsMap;
                synchronized (map) {
                    if (!this.constraintsMap.containsKey(algorithm)) {
                        this.constraintsMap.put(algorithm, new HashSet());
                    }
                    Set<KeySizeConstraint> constraintSet = this.constraintsMap.get(algorithm);
                    KeySizeConstraint constraint = new KeySizeConstraint(operator, length);
                    constraintSet.add(constraint);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean disables(Key key) {
            String algorithm = key.getAlgorithm().toLowerCase(Locale.ENGLISH);
            Map<String, Set<KeySizeConstraint>> map = this.constraintsMap;
            synchronized (map) {
                if (this.constraintsMap.containsKey(algorithm)) {
                    Set<KeySizeConstraint> constraintSet = this.constraintsMap.get(algorithm);
                    for (KeySizeConstraint constraint : constraintSet) {
                        if (!constraint.disables(key)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

