/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXReason;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import sun.security.action.GetBooleanSecurityPropertyAction;
import sun.security.provider.certpath.AdaptableX509CertSelector;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.ConstraintsChecker;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.OCSPChecker;
import sun.security.provider.certpath.PKIXMasterCertPathValidator;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.UntrustedChecker;
import sun.security.util.Debug;
import sun.security.x509.X509CertImpl;

public class PKIXCertPathValidator
extends CertPathValidatorSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private Date testDate;
    private List<PKIXCertPathChecker> userCheckers;
    private String sigProvider;
    private BasicChecker basicChecker;
    private boolean ocspEnabled = false;
    private boolean onlyEECert = false;

    @Override
    public CertPathValidatorResult engineValidate(CertPath cp, CertPathParameters param) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.println("PKIXCertPathValidator.engineValidate()...");
        }
        if (!(param instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("inappropriate parameters, must be an instance of PKIXParameters");
        }
        if (!cp.getType().equals("X.509") && !cp.getType().equals("X509")) {
            throw new InvalidAlgorithmParameterException("inappropriate certification path type specified, must be X.509 or X509");
        }
        PKIXParameters pkixParam = (PKIXParameters)param;
        Set<TrustAnchor> anchors = pkixParam.getTrustAnchors();
        for (TrustAnchor anchor : anchors) {
            if (anchor.getNameConstraints() == null) continue;
            throw new InvalidAlgorithmParameterException("name constraints in trust anchor not supported");
        }
        ArrayList<? extends Certificate> certList = new ArrayList<Certificate>(cp.getCertificates());
        if (debug != null) {
            if (certList.isEmpty()) {
                debug.println("PKIXCertPathValidator.engineValidate() certList is empty");
            }
            debug.println("PKIXCertPathValidator.engineValidate() reversing certpath...");
        }
        Collections.reverse(certList);
        this.populateVariables(pkixParam);
        X509Certificate firstCert = null;
        if (!certList.isEmpty()) {
            firstCert = (X509Certificate)certList.get(0);
        }
        CertPathValidatorException lastException = null;
        for (TrustAnchor anchor : anchors) {
            X509Certificate trustedCert = anchor.getTrustedCert();
            if (trustedCert != null) {
                if (debug != null) {
                    debug.println("PKIXCertPathValidator.engineValidate() anchor.getTrustedCert() != null");
                }
                if (!this.isWorthTrying(trustedCert, firstCert)) continue;
                if (debug != null) {
                    debug.println("anchor.getTrustedCert().getSubjectX500Principal() = " + trustedCert.getSubjectX500Principal());
                }
            } else if (debug != null) {
                debug.println("PKIXCertPathValidator.engineValidate(): anchor.getTrustedCert() == null");
            }
            try {
                PolicyNodeImpl rootNode = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, Collections.singleton("2.5.29.32.0"), false);
                PolicyNode policyTree = this.doValidate(anchor, cp, certList, pkixParam, rootNode);
                return new PKIXCertPathValidatorResult(anchor, policyTree, this.basicChecker.getPublicKey());
            }
            catch (CertPathValidatorException cpe) {
                lastException = cpe;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new CertPathValidatorException("Path does not chain with any of the trust anchors", null, null, -1, PKIXReason.NO_TRUST_ANCHOR);
    }

    private boolean isWorthTrying(X509Certificate trustedCert, X509Certificate firstCert) {
        boolean worthy = false;
        if (debug != null) {
            debug.println("PKIXCertPathValidator.isWorthTrying() checking if this trusted cert is worth trying ...");
        }
        if (firstCert == null) {
            return true;
        }
        AdaptableX509CertSelector issuerSelector = new AdaptableX509CertSelector();
        issuerSelector.setSubject(firstCert.getIssuerX500Principal());
        issuerSelector.setValidityPeriod(firstCert.getNotBefore(), firstCert.getNotAfter());
        try {
            X509CertImpl firstCertImpl = X509CertImpl.toImpl(firstCert);
            issuerSelector.parseAuthorityKeyIdentifierExtension(firstCertImpl.getAuthorityKeyIdentifierExtension());
            worthy = issuerSelector.match(trustedCert);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (debug != null) {
            if (worthy) {
                debug.println("YES - try this trustedCert");
            } else {
                debug.println("NO - don't try this trustedCert");
            }
        }
        return worthy;
    }

    private void populateVariables(PKIXParameters pkixParam) {
        this.testDate = pkixParam.getDate();
        if (this.testDate == null) {
            this.testDate = new Date(System.currentTimeMillis());
        }
        this.userCheckers = pkixParam.getCertPathCheckers();
        this.sigProvider = pkixParam.getSigProvider();
        if (pkixParam.isRevocationEnabled()) {
            this.ocspEnabled = AccessController.doPrivileged(new GetBooleanSecurityPropertyAction("ocsp.enable"));
            this.onlyEECert = AccessController.doPrivileged(new GetBooleanSecurityPropertyAction("com.sun.security.onlyCheckRevocationOfEECert"));
        }
    }

    private PolicyNode doValidate(TrustAnchor anchor, CertPath cpOriginal, ArrayList<X509Certificate> certList, PKIXParameters pkixParam, PolicyNodeImpl rootNode) throws CertPathValidatorException {
        int certPathLen = certList.size();
        this.basicChecker = new BasicChecker(anchor, this.testDate, this.sigProvider, false);
        AlgorithmChecker algorithmChecker = new AlgorithmChecker(anchor);
        KeyChecker keyChecker = new KeyChecker(certPathLen, pkixParam.getTargetCertConstraints());
        ConstraintsChecker constraintsChecker = new ConstraintsChecker(certPathLen);
        PolicyChecker policyChecker = new PolicyChecker(pkixParam.getInitialPolicies(), certPathLen, pkixParam.isExplicitPolicyRequired(), pkixParam.isPolicyMappingInhibited(), pkixParam.isAnyPolicyInhibited(), pkixParam.getPolicyQualifiersRejected(), rootNode);
        UntrustedChecker untrustedChecker = new UntrustedChecker();
        ArrayList<PKIXCertPathChecker> certPathCheckers = new ArrayList<PKIXCertPathChecker>();
        certPathCheckers.add(untrustedChecker);
        certPathCheckers.add(algorithmChecker);
        certPathCheckers.add(keyChecker);
        certPathCheckers.add(constraintsChecker);
        certPathCheckers.add(policyChecker);
        certPathCheckers.add(this.basicChecker);
        if (pkixParam.isRevocationEnabled()) {
            if (this.ocspEnabled) {
                OCSPChecker ocspChecker = new OCSPChecker(cpOriginal, pkixParam, this.onlyEECert);
                certPathCheckers.add(ocspChecker);
            }
            CrlRevocationChecker revocationChecker = new CrlRevocationChecker(anchor, pkixParam, certList, this.onlyEECert);
            certPathCheckers.add(revocationChecker);
        }
        certPathCheckers.addAll(this.userCheckers);
        PKIXMasterCertPathValidator masterValidator = new PKIXMasterCertPathValidator(certPathCheckers);
        masterValidator.validate(cpOriginal, certList);
        return policyChecker.getPolicyTree();
    }
}

