/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.provider.DSA;
import sun.security.provider.DSAKeyFactory;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;
import sun.security.provider.DSAPublicKeyImpl;
import sun.security.provider.ParameterCache;

public class DSAKeyPairGenerator
extends KeyPairGenerator
implements java.security.interfaces.DSAKeyPairGenerator {
    private int modlen;
    private boolean forceNewParameters;
    private DSAParameterSpec params;
    private SecureRandom random;

    public DSAKeyPairGenerator() {
        super("DSA");
        this.initialize(1024, null);
    }

    private static void checkStrength(int strength) {
        if (strength < 512 || strength > 1024 || strength % 64 != 0) {
            throw new InvalidParameterException("Modulus size must range from 512 to 1024 and be a multiple of 64");
        }
    }

    @Override
    public void initialize(int modlen, SecureRandom random) {
        DSAKeyPairGenerator.checkStrength(modlen);
        this.random = random;
        this.modlen = modlen;
        this.params = null;
        this.forceNewParameters = false;
    }

    @Override
    public void initialize(int modlen, boolean genParams, SecureRandom random) {
        DSAKeyPairGenerator.checkStrength(modlen);
        if (genParams) {
            this.params = null;
        } else {
            this.params = ParameterCache.getCachedDSAParameterSpec(modlen);
            if (this.params == null) {
                throw new InvalidParameterException("No precomputed parameters for requested modulus size available");
            }
        }
        this.modlen = modlen;
        this.random = random;
        this.forceNewParameters = genParams;
    }

    @Override
    public void initialize(DSAParams params, SecureRandom random) {
        if (params == null) {
            throw new InvalidParameterException("Params must not be null");
        }
        DSAParameterSpec spec = new DSAParameterSpec(params.getP(), params.getQ(), params.getG());
        this.initialize0(spec, random);
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter");
        }
        this.initialize0((DSAParameterSpec)params, random);
    }

    private void initialize0(DSAParameterSpec params, SecureRandom random) {
        int modlen = params.getP().bitLength();
        DSAKeyPairGenerator.checkStrength(modlen);
        this.modlen = modlen;
        this.params = params;
        this.random = random;
        this.forceNewParameters = false;
    }

    @Override
    public KeyPair generateKeyPair() {
        DSAParameterSpec spec;
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        try {
            if (this.forceNewParameters) {
                spec = ParameterCache.getNewDSAParameterSpec(this.modlen, this.random);
            } else {
                if (this.params == null) {
                    this.params = ParameterCache.getDSAParameterSpec(this.modlen, this.random);
                }
                spec = this.params;
            }
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
        return this.generateKeyPair(spec.getP(), spec.getQ(), spec.getG(), this.random);
    }

    public KeyPair generateKeyPair(BigInteger p, BigInteger q, BigInteger g, SecureRandom random) {
        BigInteger x = this.generateX(random, q);
        BigInteger y = this.generateY(x, p, g);
        try {
            DSAPublicKey pub = DSAKeyFactory.SERIAL_INTEROP ? new DSAPublicKey(y, p, q, g) : new DSAPublicKeyImpl(y, p, q, g);
            DSAPrivateKey priv = new DSAPrivateKey(x, p, q, g);
            KeyPair pair = new KeyPair(pub, priv);
            return pair;
        }
        catch (InvalidKeyException e) {
            throw new ProviderException(e);
        }
    }

    private BigInteger generateX(SecureRandom random, BigInteger q) {
        int[] seed;
        BigInteger x = null;
        do {
            seed = new int[5];
            for (int i = 0; i < 5; ++i) {
                seed[i] = random.nextInt();
            }
        } while ((x = this.generateX(seed, q)).signum() <= 0 || x.compareTo(q) >= 0);
        return x;
    }

    BigInteger generateX(int[] seed, BigInteger q) {
        int[] t = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
        int[] tmp = DSA.SHA_7(seed, t);
        byte[] tmpBytes = new byte[tmp.length * 4];
        for (int i = 0; i < tmp.length; ++i) {
            int k = tmp[i];
            for (int j = 0; j < 4; ++j) {
                tmpBytes[i * 4 + j] = (byte)(k >>> 24 - j * 8);
            }
        }
        BigInteger x = new BigInteger(1, tmpBytes).mod(q);
        return x;
    }

    BigInteger generateY(BigInteger x, BigInteger p, BigInteger g) {
        BigInteger y = g.modPow(x, p);
        return y;
    }
}

