/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Vector;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class PKCS7 {
    private ObjectIdentifier contentType;
    private BigInteger version = null;
    private AlgorithmId[] digestAlgorithmIds = null;
    private ContentInfo contentInfo = null;
    private X509Certificate[] certificates = null;
    private X509CRL[] crls = null;
    private SignerInfo[] signerInfos = null;
    private boolean oldStyle = false;
    private Principal[] certIssuerNames;

    public PKCS7(InputStream in) throws ParsingException, IOException {
        DataInputStream dis = new DataInputStream(in);
        byte[] data = new byte[dis.available()];
        dis.readFully(data);
        this.parse(new DerInputStream(data));
    }

    public PKCS7(DerInputStream derin) throws ParsingException {
        this.parse(derin);
    }

    public PKCS7(byte[] bytes) throws ParsingException {
        try {
            DerInputStream derin = new DerInputStream(bytes);
            this.parse(derin);
        }
        catch (IOException ioe1) {
            ParsingException pe = new ParsingException("Unable to parse the encoded bytes");
            pe.initCause(ioe1);
            throw pe;
        }
    }

    private void parse(DerInputStream derin) throws ParsingException {
        try {
            derin.mark(derin.available());
            this.parse(derin, false);
        }
        catch (IOException ioe) {
            try {
                derin.reset();
                this.parse(derin, true);
                this.oldStyle = true;
            }
            catch (IOException ioe1) {
                ParsingException pe = new ParsingException(ioe1.getMessage());
                pe.initCause(ioe1);
                throw pe;
            }
        }
    }

    private void parse(DerInputStream derin, boolean oldStyle) throws IOException {
        this.contentInfo = new ContentInfo(derin, oldStyle);
        this.contentType = this.contentInfo.contentType;
        DerValue content = this.contentInfo.getContent();
        if (this.contentType.equals(ContentInfo.SIGNED_DATA_OID)) {
            this.parseSignedData(content);
        } else if (this.contentType.equals(ContentInfo.OLD_SIGNED_DATA_OID)) {
            this.parseOldSignedData(content);
        } else if (this.contentType.equals(ContentInfo.NETSCAPE_CERT_SEQUENCE_OID)) {
            this.parseNetscapeCertChain(content);
        } else {
            throw new ParsingException("content type " + this.contentType + " not supported.");
        }
    }

    public PKCS7(AlgorithmId[] digestAlgorithmIds, ContentInfo contentInfo, X509Certificate[] certificates, X509CRL[] crls, SignerInfo[] signerInfos) {
        this.version = BigInteger.ONE;
        this.digestAlgorithmIds = digestAlgorithmIds;
        this.contentInfo = contentInfo;
        this.certificates = certificates;
        this.crls = crls;
        this.signerInfos = signerInfos;
    }

    public PKCS7(AlgorithmId[] digestAlgorithmIds, ContentInfo contentInfo, X509Certificate[] certificates, SignerInfo[] signerInfos) {
        this(digestAlgorithmIds, contentInfo, certificates, null, signerInfos);
    }

    private void parseNetscapeCertChain(DerValue val) throws ParsingException, IOException {
        DerInputStream dis = new DerInputStream(val.toByteArray());
        DerValue[] contents = dis.getSequence(2);
        this.certificates = new X509Certificate[contents.length];
        CertificateFactory certfac = null;
        try {
            certfac = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ce) {
            // empty catch block
        }
        for (int i = 0; i < contents.length; ++i) {
            try (ByteArrayInputStream bais = null;){
                if (certfac == null) {
                    this.certificates[i] = new X509CertImpl(contents[i]);
                    continue;
                }
                byte[] encoded = contents[i].toByteArray();
                bais = new ByteArrayInputStream(encoded);
                this.certificates[i] = (X509Certificate)certfac.generateCertificate(bais);
                bais.close();
                bais = null;
                continue;
            }
        }
    }

    private void parseSignedData(DerValue val) throws ParsingException, IOException {
        byte[] encoded;
        ByteArrayInputStream bais;
        int i;
        DerInputStream dis = val.toDerInputStream();
        this.version = dis.getBigInteger();
        DerValue[] digestAlgorithmIdVals = dis.getSet(1);
        int len = digestAlgorithmIdVals.length;
        this.digestAlgorithmIds = new AlgorithmId[len];
        try {
            for (int i2 = 0; i2 < len; ++i2) {
                DerValue oid = digestAlgorithmIdVals[i2];
                this.digestAlgorithmIds[i2] = AlgorithmId.parse(oid);
            }
        }
        catch (IOException e) {
            ParsingException pe = new ParsingException("Error parsing digest AlgorithmId IDs: " + e.getMessage());
            pe.initCause(e);
            throw pe;
        }
        this.contentInfo = new ContentInfo(dis);
        CertificateFactory certfac = null;
        try {
            certfac = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ce) {
            // empty catch block
        }
        if ((byte)dis.peekByte() == -96) {
            DerValue[] certVals = dis.getSet(2, true);
            len = certVals.length;
            this.certificates = new X509Certificate[len];
            for (i = 0; i < len; ++i) {
                bais = null;
                try {
                    if (certfac == null) {
                        this.certificates[i] = new X509CertImpl(certVals[i]);
                        continue;
                    }
                    encoded = certVals[i].toByteArray();
                    bais = new ByteArrayInputStream(encoded);
                    this.certificates[i] = (X509Certificate)certfac.generateCertificate(bais);
                    bais.close();
                    bais = null;
                    continue;
                }
                catch (CertificateException ce) {
                    ParsingException pe = new ParsingException(ce.getMessage());
                    pe.initCause(ce);
                    throw pe;
                }
                catch (IOException ioe) {
                    ParsingException pe = new ParsingException(ioe.getMessage());
                    pe.initCause(ioe);
                    throw pe;
                }
                finally {
                    if (bais != null) {
                        bais.close();
                    }
                }
            }
        }
        if ((byte)dis.peekByte() == -95) {
            DerValue[] crlVals = dis.getSet(1, true);
            len = crlVals.length;
            this.crls = new X509CRL[len];
            for (i = 0; i < len; ++i) {
                bais = null;
                try {
                    if (certfac == null) {
                        this.crls[i] = new X509CRLImpl(crlVals[i]);
                        continue;
                    }
                    encoded = crlVals[i].toByteArray();
                    bais = new ByteArrayInputStream(encoded);
                    this.crls[i] = (X509CRL)certfac.generateCRL(bais);
                    bais.close();
                    bais = null;
                    continue;
                }
                catch (CRLException e) {
                    ParsingException pe = new ParsingException(e.getMessage());
                    pe.initCause(e);
                    throw pe;
                }
                finally {
                    if (bais != null) {
                        bais.close();
                    }
                }
            }
        }
        DerValue[] signerInfoVals = dis.getSet(1);
        len = signerInfoVals.length;
        this.signerInfos = new SignerInfo[len];
        for (i = 0; i < len; ++i) {
            DerInputStream in = signerInfoVals[i].toDerInputStream();
            this.signerInfos[i] = new SignerInfo(in);
        }
    }

    private void parseOldSignedData(DerValue val) throws ParsingException, IOException {
        DerInputStream dis = val.toDerInputStream();
        this.version = dis.getBigInteger();
        DerValue[] digestAlgorithmIdVals = dis.getSet(1);
        int len = digestAlgorithmIdVals.length;
        this.digestAlgorithmIds = new AlgorithmId[len];
        try {
            for (int i = 0; i < len; ++i) {
                DerValue oid = digestAlgorithmIdVals[i];
                this.digestAlgorithmIds[i] = AlgorithmId.parse(oid);
            }
        }
        catch (IOException e) {
            throw new ParsingException("Error parsing digest AlgorithmId IDs");
        }
        this.contentInfo = new ContentInfo(dis, true);
        CertificateFactory certfac = null;
        try {
            certfac = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ce) {
            // empty catch block
        }
        DerValue[] certVals = dis.getSet(2);
        len = certVals.length;
        this.certificates = new X509Certificate[len];
        for (int i = 0; i < len; ++i) {
            try (ByteArrayInputStream bais = null;){
                if (certfac == null) {
                    this.certificates[i] = new X509CertImpl(certVals[i]);
                    continue;
                }
                byte[] encoded = certVals[i].toByteArray();
                bais = new ByteArrayInputStream(encoded);
                this.certificates[i] = (X509Certificate)certfac.generateCertificate(bais);
                bais.close();
                bais = null;
                continue;
            }
        }
        dis.getSet(0);
        DerValue[] signerInfoVals = dis.getSet(1);
        len = signerInfoVals.length;
        this.signerInfos = new SignerInfo[len];
        for (int i = 0; i < len; ++i) {
            DerInputStream in = signerInfoVals[i].toDerInputStream();
            this.signerInfos[i] = new SignerInfo(in, true);
        }
    }

    public void encodeSignedData(OutputStream out) throws IOException {
        DerOutputStream derout = new DerOutputStream();
        this.encodeSignedData(derout);
        out.write(derout.toByteArray());
    }

    public void encodeSignedData(DerOutputStream out) throws IOException {
        DerOutputStream signedData = new DerOutputStream();
        signedData.putInteger(this.version);
        signedData.putOrderedSetOf((byte)49, this.digestAlgorithmIds);
        this.contentInfo.encode(signedData);
        if (this.certificates != null && this.certificates.length != 0) {
            DerEncoder[] implCerts = new X509CertImpl[this.certificates.length];
            for (int i = 0; i < this.certificates.length; ++i) {
                if (this.certificates[i] instanceof X509CertImpl) {
                    implCerts[i] = (X509CertImpl)this.certificates[i];
                    continue;
                }
                try {
                    byte[] encoded = this.certificates[i].getEncoded();
                    implCerts[i] = new X509CertImpl(encoded);
                    continue;
                }
                catch (CertificateException ce) {
                    IOException ie = new IOException(ce.getMessage());
                    ie.initCause(ce);
                    throw ie;
                }
            }
            signedData.putOrderedSetOf((byte)-96, implCerts);
        }
        if (this.crls != null && this.crls.length != 0) {
            HashSet<X509CRLImpl> implCRLs = new HashSet<X509CRLImpl>(this.crls.length);
            for (X509CRL crl : this.crls) {
                if (crl instanceof X509CRLImpl) {
                    implCRLs.add((X509CRLImpl)crl);
                    continue;
                }
                try {
                    byte[] encoded = crl.getEncoded();
                    implCRLs.add(new X509CRLImpl(encoded));
                }
                catch (CRLException ce) {
                    IOException ie = new IOException(ce.getMessage());
                    ie.initCause(ce);
                    throw ie;
                }
            }
            signedData.putOrderedSetOf((byte)-95, implCRLs.toArray(new X509CRLImpl[implCRLs.size()]));
        }
        signedData.putOrderedSetOf((byte)49, this.signerInfos);
        DerValue signedDataSeq = new DerValue(48, signedData.toByteArray());
        ContentInfo block = new ContentInfo(ContentInfo.SIGNED_DATA_OID, signedDataSeq);
        block.encode(out);
    }

    public SignerInfo verify(SignerInfo info, byte[] bytes) throws NoSuchAlgorithmException, SignatureException {
        return info.verify(this, bytes);
    }

    public SignerInfo[] verify(byte[] bytes) throws NoSuchAlgorithmException, SignatureException {
        Vector<SignerInfo> intResult = new Vector<SignerInfo>();
        for (int i = 0; i < this.signerInfos.length; ++i) {
            SignerInfo signerInfo = this.verify(this.signerInfos[i], bytes);
            if (signerInfo == null) continue;
            intResult.addElement(signerInfo);
        }
        if (intResult.size() != 0) {
            Object[] result = new SignerInfo[intResult.size()];
            intResult.copyInto(result);
            return result;
        }
        return null;
    }

    public SignerInfo[] verify() throws NoSuchAlgorithmException, SignatureException {
        return this.verify(null);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public AlgorithmId[] getDigestAlgorithmIds() {
        return this.digestAlgorithmIds;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public X509Certificate[] getCertificates() {
        if (this.certificates != null) {
            return (X509Certificate[])this.certificates.clone();
        }
        return null;
    }

    public X509CRL[] getCRLs() {
        if (this.crls != null) {
            return (X509CRL[])this.crls.clone();
        }
        return null;
    }

    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    public X509Certificate getCertificate(BigInteger serial, X500Name issuerName) {
        if (this.certificates != null) {
            if (this.certIssuerNames == null) {
                this.populateCertIssuerNames();
            }
            for (int i = 0; i < this.certificates.length; ++i) {
                X509Certificate cert = this.certificates[i];
                BigInteger thisSerial = cert.getSerialNumber();
                if (!serial.equals(thisSerial) || !issuerName.equals(this.certIssuerNames[i])) continue;
                return cert;
            }
        }
        return null;
    }

    private void populateCertIssuerNames() {
        if (this.certificates == null) {
            return;
        }
        this.certIssuerNames = new Principal[this.certificates.length];
        for (int i = 0; i < this.certificates.length; ++i) {
            X509Certificate cert = this.certificates[i];
            Principal certIssuerName = cert.getIssuerDN();
            if (!(certIssuerName instanceof X500Name)) {
                try {
                    X509CertInfo tbsCert = new X509CertInfo(cert.getTBSCertificate());
                    certIssuerName = (Principal)tbsCert.get("issuer.dname");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.certIssuerNames[i] = certIssuerName;
        }
    }

    public String toString() {
        int i;
        String out = "";
        out = out + this.contentInfo + "\n";
        if (this.version != null) {
            out = out + "PKCS7 :: version: " + Debug.toHexString(this.version) + "\n";
        }
        if (this.digestAlgorithmIds != null) {
            out = out + "PKCS7 :: digest AlgorithmIds: \n";
            for (i = 0; i < this.digestAlgorithmIds.length; ++i) {
                out = out + "\t" + this.digestAlgorithmIds[i] + "\n";
            }
        }
        if (this.certificates != null) {
            out = out + "PKCS7 :: certificates: \n";
            for (i = 0; i < this.certificates.length; ++i) {
                out = out + "\t" + i + ".   " + this.certificates[i] + "\n";
            }
        }
        if (this.crls != null) {
            out = out + "PKCS7 :: crls: \n";
            for (i = 0; i < this.crls.length; ++i) {
                out = out + "\t" + i + ".   " + this.crls[i] + "\n";
            }
        }
        if (this.signerInfos != null) {
            out = out + "PKCS7 :: signer infos: \n";
            for (i = 0; i < this.signerInfos.length; ++i) {
                out = out + "\t" + i + ".  " + this.signerInfos[i] + "\n";
            }
        }
        return out;
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }
}

