/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PrincipalName
implements Cloneable {
    public static final int KRB_NT_UNKNOWN = 0;
    public static final int KRB_NT_PRINCIPAL = 1;
    public static final int KRB_NT_SRV_INST = 2;
    public static final int KRB_NT_SRV_HST = 3;
    public static final int KRB_NT_SRV_XHST = 4;
    public static final int KRB_NT_UID = 5;
    public static final String TGS_DEFAULT_SRV_NAME = "krbtgt";
    public static final int TGS_DEFAULT_NT = 2;
    public static final char NAME_COMPONENT_SEPARATOR = '/';
    public static final char NAME_REALM_SEPARATOR = '@';
    public static final char REALM_COMPONENT_SEPARATOR = '.';
    public static final String NAME_COMPONENT_SEPARATOR_STR = "/";
    public static final String NAME_REALM_SEPARATOR_STR = "@";
    public static final String REALM_COMPONENT_SEPARATOR_STR = ".";
    private int nameType;
    private String[] nameStrings;
    private Realm nameRealm;
    private String salt = null;

    protected PrincipalName() {
    }

    public PrincipalName(String[] nameParts, int type) throws IllegalArgumentException, IOException {
        if (nameParts == null) {
            throw new IllegalArgumentException("Null input not allowed");
        }
        this.nameStrings = new String[nameParts.length];
        System.arraycopy(nameParts, 0, this.nameStrings, 0, nameParts.length);
        this.nameType = type;
        this.nameRealm = null;
    }

    public PrincipalName(String[] nameParts) throws IOException {
        this(nameParts, 0);
    }

    public Object clone() {
        try {
            PrincipalName pName = (PrincipalName)super.clone();
            if (this.nameStrings != null) {
                pName.nameStrings = (String[])this.nameStrings.clone();
            }
            if (this.nameRealm != null) {
                pName.nameRealm = (Realm)this.nameRealm.clone();
            }
            return pName;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)"Should never happen");
        }
    }

    public boolean equals(Object o) {
        if (o instanceof PrincipalName) {
            return this.equals((PrincipalName)o);
        }
        return false;
    }

    public boolean equals(PrincipalName other) {
        if (!this.equalsWithoutRealm(other)) {
            return false;
        }
        if (this.nameRealm != null && other.nameRealm == null || this.nameRealm == null && other.nameRealm != null) {
            return false;
        }
        return this.nameRealm == null || other.nameRealm == null || this.nameRealm.equals(other.nameRealm);
    }

    boolean equalsWithoutRealm(PrincipalName other) {
        if (this.nameStrings != null && other.nameStrings == null || this.nameStrings == null && other.nameStrings != null) {
            return false;
        }
        if (this.nameStrings != null && other.nameStrings != null) {
            if (this.nameStrings.length != other.nameStrings.length) {
                return false;
            }
            for (int i = 0; i < this.nameStrings.length; ++i) {
                if (this.nameStrings[i].equals(other.nameStrings[i])) continue;
                return false;
            }
        }
        return true;
    }

    public PrincipalName(DerValue encoding) throws Asn1Exception, IOException {
        this.nameRealm = null;
        if (encoding == null) {
            throw new IllegalArgumentException("Null input not allowed");
        }
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        BigInteger bint = der.getData().getBigInteger();
        this.nameType = bint.intValue();
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) == 1) {
            DerValue subDer = der.getData().getDerValue();
            if (subDer.getTag() != 48) {
                throw new Asn1Exception(906);
            }
            Vector<String> v = new Vector<String>();
            while (subDer.getData().available() > 0) {
                DerValue subSubDer = subDer.getData().getDerValue();
                v.addElement(new KerberosString(subSubDer).toString());
            }
            if (v.size() > 0) {
                this.nameStrings = new String[v.size()];
                v.copyInto(this.nameStrings);
            } else {
                this.nameStrings = new String[]{""};
            }
        } else {
            throw new Asn1Exception(906);
        }
    }

    public static PrincipalName parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new PrincipalName(subDer);
    }

    protected static String[] parseName(String name) {
        String component;
        Vector<String> tempStrings = new Vector<String>();
        String temp = name;
        int i = 0;
        int componentStart = 0;
        while (i < temp.length()) {
            if (temp.charAt(i) == '/') {
                if (i > 0 && temp.charAt(i - 1) == '\\') {
                    temp = temp.substring(0, i - 1) + temp.substring(i, temp.length());
                    continue;
                }
                if (componentStart < i) {
                    component = temp.substring(componentStart, i);
                    tempStrings.addElement(component);
                }
                componentStart = i + 1;
            } else if (temp.charAt(i) == '@') {
                if (i > 0 && temp.charAt(i - 1) == '\\') {
                    temp = temp.substring(0, i - 1) + temp.substring(i, temp.length());
                    continue;
                }
                if (componentStart < i) {
                    component = temp.substring(componentStart, i);
                    tempStrings.addElement(component);
                }
                componentStart = i + 1;
                break;
            }
            ++i;
        }
        if (i == temp.length() && componentStart < i) {
            component = temp.substring(componentStart, i);
            tempStrings.addElement(component);
        }
        Object[] result = new String[tempStrings.size()];
        tempStrings.copyInto(result);
        return result;
    }

    public PrincipalName(String name, int type) throws RealmException {
        if (name == null) {
            throw new IllegalArgumentException("Null name not allowed");
        }
        String[] nameParts = PrincipalName.parseName(name);
        Realm tempRealm = null;
        String realmString = Realm.parseRealmAtSeparator(name);
        if (realmString == null) {
            try {
                Config config = Config.getInstance();
                realmString = config.getDefaultRealm();
            }
            catch (KrbException e) {
                RealmException re = new RealmException(e.getMessage());
                re.initCause(e);
                throw re;
            }
        }
        if (realmString != null) {
            tempRealm = new Realm(realmString);
        }
        switch (type) {
            case 3: {
                if (nameParts.length >= 2) {
                    String hostName = nameParts[1];
                    try {
                        String canonicalized = InetAddress.getByName(hostName).getCanonicalHostName();
                        if (canonicalized.toLowerCase().startsWith(hostName.toLowerCase() + REALM_COMPONENT_SEPARATOR_STR)) {
                            hostName = canonicalized;
                        }
                    }
                    catch (UnknownHostException e) {
                        // empty catch block
                    }
                    nameParts[1] = hostName.toLowerCase();
                }
                this.nameStrings = nameParts;
                this.nameType = type;
                String mapRealm = PrincipalName.mapHostToRealm(nameParts[1]);
                if (mapRealm != null) {
                    this.nameRealm = new Realm(mapRealm);
                    break;
                }
                this.nameRealm = tempRealm;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                this.nameStrings = nameParts;
                this.nameType = type;
                this.nameRealm = tempRealm;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal name type");
            }
        }
    }

    public PrincipalName(String name) throws RealmException {
        this(name, 0);
    }

    public PrincipalName(String name, String realm) throws RealmException {
        this(name, 0);
        this.nameRealm = new Realm(realm);
    }

    public String getRealmAsString() {
        return this.getRealmString();
    }

    public String getPrincipalNameAsString() {
        StringBuffer temp = new StringBuffer(this.nameStrings[0]);
        for (int i = 1; i < this.nameStrings.length; ++i) {
            temp.append(this.nameStrings[i]);
        }
        return temp.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getName() {
        return this.toString();
    }

    public int getNameType() {
        return this.nameType;
    }

    public String[] getNameStrings() {
        return this.nameStrings;
    }

    public byte[][] toByteArray() {
        byte[][] result = new byte[this.nameStrings.length][];
        for (int i = 0; i < this.nameStrings.length; ++i) {
            result[i] = new byte[this.nameStrings[i].length()];
            result[i] = this.nameStrings[i].getBytes();
        }
        return result;
    }

    public String getRealmString() {
        if (this.nameRealm != null) {
            return this.nameRealm.toString();
        }
        return null;
    }

    public Realm getRealm() {
        return this.nameRealm;
    }

    public void setRealm(Realm new_nameRealm) throws RealmException {
        this.nameRealm = new_nameRealm;
    }

    public void setRealm(String realmsString) throws RealmException {
        this.nameRealm = new Realm(realmsString);
    }

    public String getSalt() {
        if (this.salt == null) {
            StringBuffer salt = new StringBuffer();
            if (this.nameRealm != null) {
                salt.append(this.nameRealm.toString());
            }
            for (int i = 0; i < this.nameStrings.length; ++i) {
                salt.append(this.nameStrings[i]);
            }
            return salt.toString();
        }
        return this.salt;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.nameStrings.length; ++i) {
            if (i > 0) {
                str.append(NAME_COMPONENT_SEPARATOR_STR);
            }
            str.append(this.nameStrings[i]);
        }
        if (this.nameRealm != null) {
            str.append(NAME_REALM_SEPARATOR_STR);
            str.append(this.nameRealm.toString());
        }
        return str.toString();
    }

    public String getNameString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.nameStrings.length; ++i) {
            if (i > 0) {
                str.append(NAME_COMPONENT_SEPARATOR_STR);
            }
            str.append(this.nameStrings[i]);
        }
        return str.toString();
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        BigInteger bint = BigInteger.valueOf(this.nameType);
        temp.putInteger(bint);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        DerValue[] der = new DerValue[this.nameStrings.length];
        for (int i = 0; i < this.nameStrings.length; ++i) {
            der[i] = new KerberosString(this.nameStrings[i]).toDerValue();
        }
        temp.putSequence(der);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public boolean match(PrincipalName pname) {
        boolean matched = true;
        if (this.nameRealm != null && pname.nameRealm != null && !this.nameRealm.toString().equalsIgnoreCase(pname.nameRealm.toString())) {
            matched = false;
        }
        if (this.nameStrings.length != pname.nameStrings.length) {
            matched = false;
        } else {
            for (int i = 0; i < this.nameStrings.length; ++i) {
                if (this.nameStrings[i].equalsIgnoreCase(pname.nameStrings[i])) continue;
                matched = false;
            }
        }
        return matched;
    }

    public void writePrincipal(CCacheOutputStream cos) throws IOException {
        cos.write32(this.nameType);
        cos.write32(this.nameStrings.length);
        if (this.nameRealm != null) {
            byte[] realmBytes = null;
            realmBytes = this.nameRealm.toString().getBytes();
            cos.write32(realmBytes.length);
            cos.write(realmBytes, 0, realmBytes.length);
        }
        byte[] bytes = null;
        for (int i = 0; i < this.nameStrings.length; ++i) {
            bytes = this.nameStrings[i].getBytes();
            cos.write32(bytes.length);
            cos.write(bytes, 0, bytes.length);
        }
    }

    protected PrincipalName(String primary, String instance, String realm, int type) throws KrbException {
        if (type != 2) {
            throw new KrbException(60, "Bad name type");
        }
        String[] nParts = new String[]{primary, instance};
        this.nameStrings = nParts;
        this.nameRealm = new Realm(realm);
        this.nameType = type;
    }

    public String getInstanceComponent() {
        if (this.nameStrings != null && this.nameStrings.length >= 2) {
            return new String(this.nameStrings[1]);
        }
        return null;
    }

    static String mapHostToRealm(String name) {
        String result = null;
        try {
            String subname = null;
            Config c = Config.getInstance();
            result = c.getDefault(name, "domain_realm");
            if (result != null) {
                return result;
            }
            for (int i = 1; i < name.length() && (name.charAt(i) != '.' || i == name.length() - 1 || (result = c.getDefault(subname = name.substring(i), "domain_realm")) == null && (result = c.getDefault(subname = name.substring(i + 1), "domain_realm")) == null); ++i) {
            }
        }
        catch (KrbException krbException) {
            // empty catch block
        }
        return result;
    }
}

