/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class TCPEndpoint
implements Endpoint {
    private String host;
    private int port;
    private final RMIClientSocketFactory csf;
    private final RMIServerSocketFactory ssf;
    private int listenPort = -1;
    private TCPTransport transport = null;
    private static String localHost;
    private static boolean localHostKnown;
    private static final Map<TCPEndpoint, LinkedList<TCPEndpoint>> localEndpoints;
    private static final int FORMAT_HOST_PORT = 0;
    private static final int FORMAT_HOST_PORT_FACTORY = 1;

    private static int getInt(String name, int def) {
        return AccessController.doPrivileged(new GetIntegerAction(name, def));
    }

    private static boolean getBoolean(String name) {
        return AccessController.doPrivileged(new GetBooleanAction(name));
    }

    private static String getHostnameProperty() {
        return AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.hostname"));
    }

    public TCPEndpoint(String host, int port) {
        this(host, port, null, null);
    }

    public TCPEndpoint(String host, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        if (host == null) {
            host = "";
        }
        this.host = host;
        this.port = port;
        this.csf = csf;
        this.ssf = ssf;
    }

    public static TCPEndpoint getLocalEndpoint(int port) {
        return TCPEndpoint.getLocalEndpoint(port, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TCPEndpoint getLocalEndpoint(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        TCPEndpoint ep = null;
        Map<TCPEndpoint, LinkedList<TCPEndpoint>> map = localEndpoints;
        synchronized (map) {
            TCPEndpoint endpointKey = new TCPEndpoint(null, port, csf, ssf);
            LinkedList<TCPEndpoint> epList = localEndpoints.get(endpointKey);
            String localHost = TCPEndpoint.resampleLocalHost();
            if (epList == null) {
                ep = new TCPEndpoint(localHost, port, csf, ssf);
                epList = new LinkedList();
                epList.add(ep);
                ep.listenPort = port;
                ep.transport = new TCPTransport(epList);
                localEndpoints.put(endpointKey, epList);
                if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                    TCPTransport.tcpLog.log(Log.BRIEF, "created local endpoint for socket factory " + ssf + " on port " + port);
                }
            } else {
                LinkedList<TCPEndpoint> linkedList = epList;
                synchronized (linkedList) {
                    ep = epList.getLast();
                    String lastHost = ep.host;
                    int lastPort = ep.port;
                    TCPTransport lastTransport = ep.transport;
                    if (localHost != null && !localHost.equals(lastHost)) {
                        if (lastPort != 0) {
                            epList.clear();
                        }
                        ep = new TCPEndpoint(localHost, lastPort, csf, ssf);
                        ep.listenPort = port;
                        ep.transport = lastTransport;
                        epList.add(ep);
                    }
                }
            }
        }
        return ep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String resampleLocalHost() {
        String hostnameProperty = TCPEndpoint.getHostnameProperty();
        Map<TCPEndpoint, LinkedList<TCPEndpoint>> map = localEndpoints;
        synchronized (map) {
            if (hostnameProperty != null) {
                if (!localHostKnown) {
                    TCPEndpoint.setLocalHost(hostnameProperty);
                } else if (!hostnameProperty.equals(localHost)) {
                    localHost = hostnameProperty;
                    if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                        TCPTransport.tcpLog.log(Log.BRIEF, "updated local hostname to: " + localHost);
                    }
                }
            }
            return localHost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setLocalHost(String host) {
        Map<TCPEndpoint, LinkedList<TCPEndpoint>> map = localEndpoints;
        synchronized (map) {
            if (!localHostKnown) {
                localHost = host;
                localHostKnown = true;
                if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                    TCPTransport.tcpLog.log(Log.BRIEF, "local host set to " + host);
                }
                Iterator<LinkedList<TCPEndpoint>> i$ = localEndpoints.values().iterator();
                while (i$.hasNext()) {
                    LinkedList<TCPEndpoint> epList;
                    LinkedList<TCPEndpoint> linkedList = epList = i$.next();
                    synchronized (linkedList) {
                        for (TCPEndpoint ep : epList) {
                            ep.host = host;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDefaultPort(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        TCPEndpoint endpointKey = new TCPEndpoint(null, 0, csf, ssf);
        Map<TCPEndpoint, LinkedList<TCPEndpoint>> map = localEndpoints;
        synchronized (map) {
            LinkedList<TCPEndpoint> epList;
            LinkedList<TCPEndpoint> linkedList = epList = localEndpoints.get(endpointKey);
            synchronized (linkedList) {
                int size = epList.size();
                TCPEndpoint lastEp = epList.getLast();
                for (TCPEndpoint ep : epList) {
                    ep.port = port;
                }
                if (size > 1) {
                    epList.clear();
                    epList.add(lastEp);
                }
            }
            TCPEndpoint newEndpointKey = new TCPEndpoint(null, port, csf, ssf);
            localEndpoints.put(newEndpointKey, epList);
            if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                TCPTransport.tcpLog.log(Log.BRIEF, "default port for server socket factory " + ssf + " and client socket factory " + csf + " set to " + port);
            }
        }
    }

    @Override
    public Transport getOutboundTransport() {
        TCPEndpoint localEndpoint = TCPEndpoint.getLocalEndpoint(0, null, null);
        return localEndpoint.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<TCPTransport> allKnownTransports() {
        HashSet<TCPTransport> s;
        Map<TCPEndpoint, LinkedList<TCPEndpoint>> map = localEndpoints;
        synchronized (map) {
            s = new HashSet<TCPTransport>(localEndpoints.size());
            for (LinkedList<TCPEndpoint> epList : localEndpoints.values()) {
                TCPEndpoint ep = epList.getFirst();
                s.add(ep.transport);
            }
        }
        return s;
    }

    public static void shedConnectionCaches() {
        for (TCPTransport transport : TCPEndpoint.allKnownTransports()) {
            transport.shedConnectionCaches();
        }
    }

    @Override
    public void exportObject(Target target) throws RemoteException {
        this.transport.exportObject(target);
    }

    @Override
    public Channel getChannel() {
        return this.getOutboundTransport().getChannel(this);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    @Override
    public Transport getInboundTransport() {
        return this.transport;
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return this.csf;
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public String toString() {
        return "[" + this.host + ":" + this.port + (this.ssf != null ? "," + this.ssf : "") + (this.csf != null ? "," + this.csf : "") + "]";
    }

    public int hashCode() {
        return this.port;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TCPEndpoint) {
            TCPEndpoint ep = (TCPEndpoint)obj;
            if (this.port != ep.port || !this.host.equals(ep.host)) {
                return false;
            }
            if (this.csf == null ^ ep.csf == null || this.ssf == null ^ ep.ssf == null) {
                return false;
            }
            if (!(this.csf == null || this.csf.getClass() == ep.csf.getClass() && this.csf.equals(ep.csf))) {
                return false;
            }
            return this.ssf == null || this.ssf.getClass() == ep.ssf.getClass() && this.ssf.equals(ep.ssf);
        }
        return false;
    }

    public void write(ObjectOutput out) throws IOException {
        if (this.csf == null) {
            out.writeByte(0);
            out.writeUTF(this.host);
            out.writeInt(this.port);
        } else {
            out.writeByte(1);
            out.writeUTF(this.host);
            out.writeInt(this.port);
            out.writeObject(this.csf);
        }
    }

    public static TCPEndpoint read(ObjectInput in) throws IOException, ClassNotFoundException {
        int port;
        String host;
        RMIClientSocketFactory csf = null;
        byte format = in.readByte();
        switch (format) {
            case 0: {
                host = in.readUTF();
                port = in.readInt();
                break;
            }
            case 1: {
                host = in.readUTF();
                port = in.readInt();
                csf = (RMIClientSocketFactory)in.readObject();
                break;
            }
            default: {
                throw new IOException("invalid endpoint format");
            }
        }
        return new TCPEndpoint(host, port, csf, null);
    }

    public void writeHostPortFormat(DataOutput out) throws IOException {
        if (this.csf != null) {
            throw new InternalError("TCPEndpoint.writeHostPortFormat: called for endpoint with non-null socket factory");
        }
        out.writeUTF(this.host);
        out.writeInt(this.port);
    }

    public static TCPEndpoint readHostPortFormat(DataInput in) throws IOException {
        String host = in.readUTF();
        int port = in.readInt();
        return new TCPEndpoint(host, port);
    }

    private static RMISocketFactory chooseFactory() {
        RMISocketFactory sf = RMISocketFactory.getSocketFactory();
        if (sf == null) {
            sf = TCPTransport.defaultSocketFactory;
        }
        return sf;
    }

    Socket newSocket() throws RemoteException {
        Socket socket;
        if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
            TCPTransport.tcpLog.log(Log.VERBOSE, "opening socket to " + this);
        }
        try {
            RMIClientSocketFactory clientFactory = this.csf;
            if (clientFactory == null) {
                clientFactory = TCPEndpoint.chooseFactory();
            }
            socket = clientFactory.createSocket(this.host, this.port);
        }
        catch (UnknownHostException e) {
            throw new java.rmi.UnknownHostException("Unknown host: " + this.host, e);
        }
        catch (ConnectException e) {
            throw new java.rmi.ConnectException("Connection refused to host: " + this.host, e);
        }
        catch (IOException e) {
            try {
                TCPEndpoint.shedConnectionCaches();
            }
            catch (OutOfMemoryError mem) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ConnectIOException("Exception creating connection to: " + this.host, e);
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            socket.setKeepAlive(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return socket;
    }

    ServerSocket newServerSocket() throws IOException {
        RMIServerSocketFactory serverFactory;
        if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
            TCPTransport.tcpLog.log(Log.VERBOSE, "creating server socket on " + this);
        }
        if ((serverFactory = this.ssf) == null) {
            serverFactory = TCPEndpoint.chooseFactory();
        }
        ServerSocket server = serverFactory.createServerSocket(this.listenPort);
        if (this.listenPort == 0) {
            TCPEndpoint.setDefaultPort(server.getLocalPort(), this.csf, this.ssf);
        }
        return server;
    }

    static {
        localHostKnown = true;
        localHost = TCPEndpoint.getHostnameProperty();
        if (localHost == null) {
            try {
                InetAddress localAddr = InetAddress.getLocalHost();
                byte[] raw = localAddr.getAddress();
                if (raw[0] == 127 && raw[1] == 0 && raw[2] == 0 && raw[3] == 1) {
                    localHostKnown = false;
                }
                localHost = TCPEndpoint.getBoolean("java.rmi.server.useLocalHostName") ? FQDN.attemptFQDN(localAddr) : localAddr.getHostAddress();
            }
            catch (Exception e) {
                localHostKnown = false;
                localHost = null;
            }
        }
        if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
            TCPTransport.tcpLog.log(Log.BRIEF, "localHostKnown = " + localHostKnown + ", localHost = " + localHost);
        }
        localEndpoints = new HashMap<TCPEndpoint, LinkedList<TCPEndpoint>>();
    }

    private static class FQDN
    implements Runnable {
        private String reverseLookup;
        private String hostAddress;

        private FQDN(String hostAddress) {
            this.hostAddress = hostAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static String attemptFQDN(InetAddress localAddr) throws UnknownHostException {
            String hostName = localAddr.getHostName();
            if (hostName.indexOf(46) < 0) {
                String hostAddress = localAddr.getHostAddress();
                FQDN f = new FQDN(hostAddress);
                int nameServiceTimeOut = TCPEndpoint.getInt("sun.rmi.transport.tcp.localHostNameTimeOut", 10000);
                try {
                    FQDN fQDN = f;
                    synchronized (fQDN) {
                        f.getFQDN();
                        f.wait(nameServiceTimeOut);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                hostName = f.getHost();
                if (hostName == null || hostName.equals("") || hostName.indexOf(46) < 0) {
                    hostName = hostAddress;
                }
            }
            return hostName;
        }

        private void getFQDN() {
            Thread t = AccessController.doPrivileged(new NewThreadAction(this, "FQDN Finder", true));
            t.start();
        }

        private synchronized String getHost() {
            return this.reverseLookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String name = null;
            try {
                name = InetAddress.getByName(this.hostAddress).getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                FQDN fQDN = this;
                synchronized (fQDN) {
                    this.reverseLookup = name;
                    this.notify();
                }
            }
            finally {
                FQDN fQDN = this;
                synchronized (fQDN) {
                    this.reverseLookup = name;
                    this.notify();
                }
            }
        }
    }
}

