/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.rmi.server.Unreferenced;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.server.Dispatcher;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.ObjectEndpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.SequenceEntry;
import sun.rmi.transport.Transport;
import sun.rmi.transport.WeakRef;

public final class Target {
    private final ObjID id;
    private final boolean permanent;
    private final WeakRef weakImpl;
    private volatile Dispatcher disp;
    private final Remote stub;
    private final Vector refSet = new Vector();
    private final Hashtable sequenceTable = new Hashtable(5);
    private final AccessControlContext acc;
    private final ClassLoader ccl;
    private int callCount = 0;
    private boolean removed = false;
    private volatile Transport exportedTransport = null;
    private static int nextThreadNum = 0;

    public Target(Remote impl, Dispatcher disp, Remote stub, ObjID id, boolean permanent) {
        this.weakImpl = new WeakRef(impl, ObjectTable.reapQueue);
        this.disp = disp;
        this.stub = stub;
        this.id = id;
        this.acc = AccessController.getContext();
        ClassLoader threadContextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader serverLoader = impl.getClass().getClassLoader();
        this.ccl = Target.checkLoaderAncestry(threadContextLoader, serverLoader) ? threadContextLoader : serverLoader;
        this.permanent = permanent;
        if (permanent) {
            this.pinImpl();
        }
    }

    private static boolean checkLoaderAncestry(ClassLoader child, ClassLoader ancestor) {
        if (ancestor == null) {
            return true;
        }
        if (child == null) {
            return false;
        }
        for (ClassLoader parent = child; parent != null; parent = parent.getParent()) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    public Remote getStub() {
        return this.stub;
    }

    ObjectEndpoint getObjectEndpoint() {
        return new ObjectEndpoint(this.id, this.exportedTransport);
    }

    WeakRef getWeakImpl() {
        return this.weakImpl;
    }

    Dispatcher getDispatcher() {
        return this.disp;
    }

    AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    ClassLoader getContextClassLoader() {
        return this.ccl;
    }

    Remote getImpl() {
        return (Remote)this.weakImpl.get();
    }

    boolean isPermanent() {
        return this.permanent;
    }

    synchronized void pinImpl() {
        this.weakImpl.pin();
    }

    synchronized void unpinImpl() {
        if (!this.permanent && this.refSet.isEmpty()) {
            this.weakImpl.unpin();
        }
    }

    void setExportedTransport(Transport exportedTransport) {
        if (this.exportedTransport == null) {
            this.exportedTransport = exportedTransport;
        }
    }

    synchronized void referenced(long sequenceNum, VMID vmid) {
        SequenceEntry entry = (SequenceEntry)this.sequenceTable.get(vmid);
        if (entry == null) {
            this.sequenceTable.put(vmid, new SequenceEntry(sequenceNum));
        } else if (entry.sequenceNum < sequenceNum) {
            entry.update(sequenceNum);
        } else {
            return;
        }
        if (!this.refSet.contains(vmid)) {
            this.pinImpl();
            if (this.getImpl() == null) {
                return;
            }
            if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
                DGCImpl.dgcLog.log(Log.VERBOSE, "add to dirty set: " + vmid);
            }
            this.refSet.addElement(vmid);
            DGCImpl.getDGCImpl().registerTarget(vmid, this);
        }
    }

    synchronized void unreferenced(long sequenceNum, VMID vmid, boolean strong) {
        SequenceEntry entry = (SequenceEntry)this.sequenceTable.get(vmid);
        if (entry == null || entry.sequenceNum > sequenceNum) {
            return;
        }
        if (strong) {
            entry.retain(sequenceNum);
        } else if (!entry.keep) {
            this.sequenceTable.remove(vmid);
        }
        if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
            DGCImpl.dgcLog.log(Log.VERBOSE, "remove from dirty set: " + vmid);
        }
        this.refSetRemove(vmid);
    }

    private synchronized void refSetRemove(VMID vmid) {
        DGCImpl.getDGCImpl().unregisterTarget(vmid, this);
        if (this.refSet.removeElement(vmid) && this.refSet.isEmpty()) {
            Remote obj;
            if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
                DGCImpl.dgcLog.log(Log.VERBOSE, "reference set is empty: target = " + this);
            }
            if ((obj = this.getImpl()) instanceof Unreferenced) {
                final Unreferenced unrefObj = (Unreferenced)((Object)obj);
                final Thread t = AccessController.doPrivileged(new NewThreadAction(new Runnable(){

                    @Override
                    public void run() {
                        unrefObj.unreferenced();
                    }
                }, "Unreferenced-" + nextThreadNum++, false, true));
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        t.setContextClassLoader(Target.this.ccl);
                        return null;
                    }
                });
                t.start();
            }
            this.unpinImpl();
        }
    }

    synchronized boolean unexport(boolean force) {
        if (force || this.callCount == 0 || this.disp == null) {
            this.disp = null;
            this.unpinImpl();
            DGCImpl dgc = DGCImpl.getDGCImpl();
            Enumeration enum_ = this.refSet.elements();
            while (enum_.hasMoreElements()) {
                VMID vmid = (VMID)enum_.nextElement();
                dgc.unregisterTarget(vmid, this);
            }
            return true;
        }
        return false;
    }

    synchronized void markRemoved() {
        if (this.removed) {
            throw new AssertionError();
        }
        this.removed = true;
        if (!this.permanent && this.callCount == 0) {
            ObjectTable.decrementKeepAliveCount();
        }
        if (this.exportedTransport != null) {
            this.exportedTransport.targetUnexported();
        }
    }

    synchronized void incrementCallCount() throws NoSuchObjectException {
        if (this.disp != null) {
            ++this.callCount;
        } else {
            throw new NoSuchObjectException("object not accepting new calls");
        }
    }

    synchronized void decrementCallCount() {
        if (--this.callCount < 0) {
            throw new Error("internal error: call count less than zero");
        }
        if (!this.permanent && this.removed && this.callCount == 0) {
            ObjectTable.decrementKeepAliveCount();
        }
    }

    boolean isEmpty() {
        return this.refSet.isEmpty();
    }

    public synchronized void vmidDead(VMID vmid) {
        if (DGCImpl.dgcLog.isLoggable(Log.BRIEF)) {
            DGCImpl.dgcLog.log(Log.BRIEF, "removing endpoint " + vmid + " from reference set");
        }
        this.sequenceTable.remove(vmid);
        this.refSetRemove(vmid);
    }
}

