/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.AbstractBasicFileAttributeView;
import sun.nio.fs.FileOwnerAttributeViewImpl;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileModeAttribute;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUserPrincipals;
import sun.nio.fs.Util;

class UnixFileAttributeViews {
    UnixFileAttributeViews() {
    }

    static Basic createBasicView(UnixPath file, boolean followLinks) {
        return new Basic(file, followLinks);
    }

    static Posix createPosixView(UnixPath file, boolean followLinks) {
        return new Posix(file, followLinks);
    }

    static Unix createUnixView(UnixPath file, boolean followLinks) {
        return new Unix(file, followLinks);
    }

    static FileOwnerAttributeViewImpl createOwnerView(UnixPath file, boolean followLinks) {
        return new FileOwnerAttributeViewImpl(UnixFileAttributeViews.createPosixView(file, followLinks));
    }

    private static class Unix
    extends Posix {
        private static final String MODE_NAME = "mode";
        private static final String INO_NAME = "ino";
        private static final String DEV_NAME = "dev";
        private static final String RDEV_NAME = "rdev";
        private static final String NLINK_NAME = "nlink";
        private static final String UID_NAME = "uid";
        private static final String GID_NAME = "gid";
        private static final String CTIME_NAME = "ctime";
        static final Set<String> unixAttributeNames = Util.newSet(posixAttributeNames, new String[]{"mode", "ino", "dev", "rdev", "nlink", "uid", "gid", "ctime"});

        Unix(UnixPath file, boolean followLinks) {
            super(file, followLinks);
        }

        @Override
        public String name() {
            return "unix";
        }

        @Override
        public void setAttribute(String attribute, Object value) throws IOException {
            if (attribute.equals(MODE_NAME)) {
                this.setMode((Integer)value);
                return;
            }
            if (attribute.equals(UID_NAME)) {
                this.setOwners((Integer)value, -1);
                return;
            }
            if (attribute.equals(GID_NAME)) {
                this.setOwners(-1, (Integer)value);
                return;
            }
            super.setAttribute(attribute, value);
        }

        @Override
        public Map<String, Object> readAttributes(String[] requested) throws IOException {
            AbstractBasicFileAttributeView.AttributesBuilder builder = AbstractBasicFileAttributeView.AttributesBuilder.create(unixAttributeNames, requested);
            UnixFileAttributes attrs = this.readAttributes();
            this.addRequestedPosixAttributes(attrs, builder);
            if (builder.match(MODE_NAME)) {
                builder.add(MODE_NAME, attrs.mode());
            }
            if (builder.match(INO_NAME)) {
                builder.add(INO_NAME, attrs.ino());
            }
            if (builder.match(DEV_NAME)) {
                builder.add(DEV_NAME, attrs.dev());
            }
            if (builder.match(RDEV_NAME)) {
                builder.add(RDEV_NAME, attrs.rdev());
            }
            if (builder.match(NLINK_NAME)) {
                builder.add(NLINK_NAME, attrs.nlink());
            }
            if (builder.match(UID_NAME)) {
                builder.add(UID_NAME, attrs.uid());
            }
            if (builder.match(GID_NAME)) {
                builder.add(GID_NAME, attrs.gid());
            }
            if (builder.match(CTIME_NAME)) {
                builder.add(CTIME_NAME, attrs.ctime());
            }
            return builder.unmodifiableMap();
        }
    }

    private static class Posix
    extends Basic
    implements PosixFileAttributeView {
        private static final String PERMISSIONS_NAME = "permissions";
        private static final String OWNER_NAME = "owner";
        private static final String GROUP_NAME = "group";
        static final Set<String> posixAttributeNames = Util.newSet(basicAttributeNames, new String[]{"permissions", "owner", "group"});

        Posix(UnixPath file, boolean followLinks) {
            super(file, followLinks);
        }

        final void checkReadExtended() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                this.file.checkRead();
                sm.checkPermission(new RuntimePermission("accessUserInformation"));
            }
        }

        final void checkWriteExtended() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                this.file.checkWrite();
                sm.checkPermission(new RuntimePermission("accessUserInformation"));
            }
        }

        @Override
        public String name() {
            return "posix";
        }

        @Override
        public void setAttribute(String attribute, Object value) throws IOException {
            if (attribute.equals(PERMISSIONS_NAME)) {
                this.setPermissions((Set)value);
                return;
            }
            if (attribute.equals(OWNER_NAME)) {
                this.setOwner((UserPrincipal)value);
                return;
            }
            if (attribute.equals(GROUP_NAME)) {
                this.setGroup((GroupPrincipal)value);
                return;
            }
            super.setAttribute(attribute, value);
        }

        final void addRequestedPosixAttributes(PosixFileAttributes attrs, AbstractBasicFileAttributeView.AttributesBuilder builder) {
            this.addRequestedBasicAttributes(attrs, builder);
            if (builder.match(PERMISSIONS_NAME)) {
                builder.add(PERMISSIONS_NAME, attrs.permissions());
            }
            if (builder.match(OWNER_NAME)) {
                builder.add(OWNER_NAME, attrs.owner());
            }
            if (builder.match(GROUP_NAME)) {
                builder.add(GROUP_NAME, attrs.group());
            }
        }

        @Override
        public Map<String, Object> readAttributes(String[] requested) throws IOException {
            AbstractBasicFileAttributeView.AttributesBuilder builder = AbstractBasicFileAttributeView.AttributesBuilder.create(posixAttributeNames, requested);
            UnixFileAttributes attrs = this.readAttributes();
            this.addRequestedPosixAttributes(attrs, builder);
            return builder.unmodifiableMap();
        }

        @Override
        public UnixFileAttributes readAttributes() throws IOException {
            this.checkReadExtended();
            try {
                return UnixFileAttributes.get(this.file, this.followLinks);
            }
            catch (UnixException x) {
                x.rethrowAsIOException(this.file);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setMode(int mode) throws IOException {
            block6: {
                this.checkWriteExtended();
                try {
                    if (this.followLinks) {
                        UnixNativeDispatcher.chmod(this.file, mode);
                        break block6;
                    }
                    int fd = this.file.openForAttributeAccess(false);
                    try {
                        UnixNativeDispatcher.fchmod(fd, mode);
                    }
                    finally {
                        UnixNativeDispatcher.close(fd);
                    }
                }
                catch (UnixException x) {
                    x.rethrowAsIOException(this.file);
                }
            }
        }

        final void setOwners(int uid, int gid) throws IOException {
            this.checkWriteExtended();
            try {
                if (this.followLinks) {
                    UnixNativeDispatcher.chown(this.file, uid, gid);
                } else {
                    UnixNativeDispatcher.lchown(this.file, uid, gid);
                }
            }
            catch (UnixException x) {
                x.rethrowAsIOException(this.file);
            }
        }

        @Override
        public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
            this.setMode(UnixFileModeAttribute.toUnixMode(perms));
        }

        @Override
        public void setOwner(UserPrincipal owner) throws IOException {
            if (owner == null) {
                throw new NullPointerException("'owner' is null");
            }
            if (!(owner instanceof UnixUserPrincipals.User)) {
                throw new ProviderMismatchException();
            }
            if (owner instanceof UnixUserPrincipals.Group) {
                throw new IOException("'owner' parameter can't be a group");
            }
            int uid = ((UnixUserPrincipals.User)owner).uid();
            this.setOwners(uid, -1);
        }

        @Override
        public UserPrincipal getOwner() throws IOException {
            return this.readAttributes().owner();
        }

        @Override
        public void setGroup(GroupPrincipal group) throws IOException {
            if (group == null) {
                throw new NullPointerException("'owner' is null");
            }
            if (!(group instanceof UnixUserPrincipals.Group)) {
                throw new ProviderMismatchException();
            }
            int gid = ((UnixUserPrincipals.Group)group).gid();
            this.setOwners(-1, gid);
        }
    }

    static class Basic
    extends AbstractBasicFileAttributeView {
        protected final UnixPath file;
        protected final boolean followLinks;

        Basic(UnixPath file, boolean followLinks) {
            this.file = file;
            this.followLinks = followLinks;
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            this.file.checkRead();
            try {
                UnixFileAttributes attrs = UnixFileAttributes.get(this.file, this.followLinks);
                return attrs.asBasicFileAttributes();
            }
            catch (UnixException x) {
                x.rethrowAsIOException(this.file);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            if (lastModifiedTime == null && lastAccessTime == null) {
                return;
            }
            this.file.checkWrite();
            int fd = this.file.openForAttributeAccess(this.followLinks);
            try {
                if (lastModifiedTime == null || lastAccessTime == null) {
                    try {
                        UnixFileAttributes attrs = UnixFileAttributes.get(fd);
                        if (lastModifiedTime == null) {
                            lastModifiedTime = attrs.lastModifiedTime();
                        }
                        if (lastAccessTime == null) {
                            lastAccessTime = attrs.lastAccessTime();
                        }
                    }
                    catch (UnixException x) {
                        x.rethrowAsIOException(this.file);
                    }
                }
                long modValue = lastModifiedTime.to(TimeUnit.MICROSECONDS);
                long accessValue = lastAccessTime.to(TimeUnit.MICROSECONDS);
                boolean retry = false;
                try {
                    UnixNativeDispatcher.futimes(fd, accessValue, modValue);
                }
                catch (UnixException x) {
                    if (x.errno() == 22 && (modValue < 0L || accessValue < 0L)) {
                        retry = true;
                    }
                    x.rethrowAsIOException(this.file);
                }
                if (retry) {
                    if (modValue < 0L) {
                        modValue = 0L;
                    }
                    if (accessValue < 0L) {
                        accessValue = 0L;
                    }
                    try {
                        UnixNativeDispatcher.futimes(fd, accessValue, modValue);
                    }
                    catch (UnixException x) {
                        x.rethrowAsIOException(this.file);
                    }
                }
            }
            finally {
                UnixNativeDispatcher.close(fd);
            }
        }
    }
}

