/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import sun.nio.fs.DynamicFileAttributeView;
import sun.nio.fs.LinuxDosFileAttributeView;
import sun.nio.fs.LinuxFileStore;
import sun.nio.fs.LinuxFileSystem;
import sun.nio.fs.LinuxUserDefinedFileAttributeView;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

public class LinuxFileSystemProvider
extends UnixFileSystemProvider {
    @Override
    LinuxFileSystem newFileSystem(String dir) {
        return new LinuxFileSystem(this, dir);
    }

    @Override
    LinuxFileStore getFileStore(UnixPath path) throws IOException {
        return new LinuxFileStore(path);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path obj, Class<V> type, LinkOption ... options) {
        if (type == DosFileAttributeView.class) {
            return (V)new LinuxDosFileAttributeView(UnixPath.toUnixPath(obj), Util.followLinks(options));
        }
        if (type == UserDefinedFileAttributeView.class) {
            return (V)new LinuxUserDefinedFileAttributeView(UnixPath.toUnixPath(obj), Util.followLinks(options));
        }
        return super.getFileAttributeView(obj, type, options);
    }

    @Override
    public DynamicFileAttributeView getFileAttributeView(Path obj, String name, LinkOption ... options) {
        if (name.equals("dos")) {
            return new LinuxDosFileAttributeView(UnixPath.toUnixPath(obj), Util.followLinks(options));
        }
        if (name.equals("user")) {
            return new LinuxUserDefinedFileAttributeView(UnixPath.toUnixPath(obj), Util.followLinks(options));
        }
        return super.getFileAttributeView(obj, name, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path file, Class<A> type, LinkOption ... options) throws IOException {
        if (type == DosFileAttributes.class) {
            DosFileAttributeView view = this.getFileAttributeView(file, DosFileAttributeView.class, options);
            return (A)view.readAttributes();
        }
        return super.readAttributes(file, type, options);
    }
}

