/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.fs.AbstractFileTypeDetector;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixPath;

public class GnomeFileTypeDetector
extends AbstractFileTypeDetector {
    private static final String GNOME_VFS_MIME_TYPE_UNKNOWN = "application/octet-stream";
    private final boolean gioAvailable = GnomeFileTypeDetector.initializeGio();
    private final boolean gnomeVfsAvailable = this.gioAvailable ? false : GnomeFileTypeDetector.initializeGnomeVfs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String implProbeContentType(Path obj) throws IOException {
        if (!this.gioAvailable && !this.gnomeVfsAvailable) {
            return null;
        }
        if (!(obj instanceof UnixPath)) {
            return null;
        }
        UnixPath path = (UnixPath)obj;
        NativeBuffer buffer = NativeBuffers.asNativeBuffer(path.getByteArrayForSysCalls());
        try {
            if (this.gioAvailable) {
                byte[] type = GnomeFileTypeDetector.probeUsingGio(buffer.address());
                String string = type == null ? null : new String(type);
                return string;
            }
            byte[] type = GnomeFileTypeDetector.probeUsingGnomeVfs(buffer.address());
            if (type == null) {
                String string = null;
                return string;
            }
            String s = new String(type);
            String string = s.equals(GNOME_VFS_MIME_TYPE_UNKNOWN) ? null : s;
            return string;
        }
        finally {
            buffer.release();
        }
    }

    private static native boolean initializeGio();

    private static native byte[] probeUsingGio(long var0);

    private static native boolean initializeGnomeVfs();

    private static native byte[] probeUsingGnomeVfs(long var0);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
    }
}

