/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcherImpl;

class DevPollArrayWrapper {
    static final short POLLIN = 1;
    static final short POLLPRI = 2;
    static final short POLLOUT = 4;
    static final short POLLRDNORM = 64;
    static final short POLLWRNORM = 4;
    static final short POLLRDBAND = 128;
    static final short POLLWRBAND = 256;
    static final short POLLNORM = 64;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    static final short POLLNVAL = 32;
    static final short POLLREMOVE = 2048;
    static final short POLLCONN = 4;
    static final short SIZE_POLLFD = 8;
    static final short FD_OFFSET = 0;
    static final short EVENT_OFFSET = 4;
    static final short REVENT_OFFSET = 6;
    static final byte CANCELLED = -1;
    static final int OPEN_MAX = DevPollArrayWrapper.fdLimit();
    static final int NUM_POLLFDS = Math.min(OPEN_MAX - 1, 8192);
    private final int INITIAL_PENDING_UPDATE_SIZE = 64;
    private final int MAX_UPDATE_ARRAY_SIZE = Math.min(OPEN_MAX, 65536);
    private final AllocatedNativeObject pollArray;
    private final long pollArrayAddress;
    private int wfd;
    private int outgoingInterruptFD;
    private int incomingInterruptFD;
    private int interruptedIndex;
    int updated;
    private final Object updateLock = new Object();
    private int updateCount;
    private int[] updateDescriptors = new int[64];
    private final byte[] eventsLow = new byte[this.MAX_UPDATE_ARRAY_SIZE];
    private Map<Integer, Byte> eventsHigh;
    private final BitSet registered = new BitSet();
    boolean interrupted = false;

    DevPollArrayWrapper() {
        int allocationSize = NUM_POLLFDS * 8;
        this.pollArray = new AllocatedNativeObject(allocationSize, true);
        this.pollArrayAddress = this.pollArray.address();
        this.wfd = this.init();
        if (OPEN_MAX > this.MAX_UPDATE_ARRAY_SIZE) {
            this.eventsHigh = new HashMap<Integer, Byte>();
        }
    }

    void initInterrupt(int fd0, int fd1) {
        this.outgoingInterruptFD = fd1;
        this.incomingInterruptFD = fd0;
        this.register(this.wfd, fd0, 1);
    }

    void putReventOps(int i, int revent) {
        int offset = 8 * i + 6;
        this.pollArray.putShort(offset, (short)revent);
    }

    int getEventOps(int i) {
        int offset = 8 * i + 4;
        return this.pollArray.getShort(offset);
    }

    int getReventOps(int i) {
        int offset = 8 * i + 6;
        return this.pollArray.getShort(offset);
    }

    int getDescriptor(int i) {
        int offset = 8 * i + 0;
        return this.pollArray.getInt(offset);
    }

    private void setUpdateEvents(int fd, byte events) {
        if (fd < this.MAX_UPDATE_ARRAY_SIZE) {
            this.eventsLow[fd] = events;
        } else {
            this.eventsHigh.put(fd, events);
        }
    }

    private byte getUpdateEvents(int fd) {
        if (fd < this.MAX_UPDATE_ARRAY_SIZE) {
            return this.eventsLow[fd];
        }
        Byte result = this.eventsHigh.get(fd);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int fd, int mask) {
        Object object = this.updateLock;
        synchronized (object) {
            int oldCapacity = this.updateDescriptors.length;
            if (this.updateCount == oldCapacity) {
                int newCapacity = oldCapacity + 64;
                int[] newDescriptors = new int[newCapacity];
                System.arraycopy(this.updateDescriptors, 0, newDescriptors, 0, oldCapacity);
                this.updateDescriptors = newDescriptors;
            }
            this.updateDescriptors[this.updateCount++] = fd;
            byte b = (byte)mask;
            assert (b == mask && b != -1);
            this.setUpdateEvents(fd, b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int fd) {
        Object object = this.updateLock;
        synchronized (object) {
            this.setUpdateEvents(fd, (byte)-1);
            if (this.registered.get(fd)) {
                this.register(this.wfd, fd, 2048);
                this.registered.clear(fd);
            }
        }
    }

    void closeDevPollFD() throws IOException {
        FileDispatcherImpl.closeIntFD(this.wfd);
        this.pollArray.free();
    }

    int poll(long timeout) throws IOException {
        this.updateRegistrations();
        this.updated = this.poll0(this.pollArrayAddress, NUM_POLLFDS, timeout, this.wfd);
        for (int i = 0; i < this.updated; ++i) {
            if (this.getDescriptor(i) != this.incomingInterruptFD) continue;
            this.interruptedIndex = i;
            this.interrupted = true;
            break;
        }
        return this.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegistrations() throws IOException {
        Object object = this.updateLock;
        synchronized (object) {
            int index = 0;
            for (int j = 0; j < this.updateCount; ++j) {
                int fd = this.updateDescriptors[j];
                short events = this.getUpdateEvents(fd);
                boolean isRegistered = this.registered.get(fd);
                if (events != -1) {
                    if (events == 0) {
                        if (isRegistered) {
                            events = 2048;
                            this.registered.clear(fd);
                        } else {
                            events = -1;
                        }
                    } else if (!isRegistered) {
                        this.registered.set(fd);
                    }
                }
                if (events == -1) continue;
                this.putPollFD(this.pollArray, index, fd, events);
                if (++index < NUM_POLLFDS) continue;
                this.registerMultiple(this.wfd, this.pollArray.address(), index);
                index = 0;
            }
            if (index > 0) {
                this.registerMultiple(this.wfd, this.pollArray.address(), index);
            }
            this.updateCount = 0;
        }
    }

    private void putPollFD(AllocatedNativeObject array, int index, int fd, short event) {
        int structIndex = 8 * index;
        array.putInt(structIndex + 0, fd);
        array.putShort(structIndex + 4, event);
        array.putShort(structIndex + 6, (short)0);
    }

    public void interrupt() {
        DevPollArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    public int interruptedIndex() {
        return this.interruptedIndex;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private native int init();

    private native void register(int var1, int var2, int var3);

    private native void registerMultiple(int var1, long var2, int var4) throws IOException;

    private native int poll0(long var1, int var3, long var4, int var6);

    private static native void interrupt(int var0);

    private static native int fdLimit();
}

