/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.file;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.security.Permission;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import sun.net.ProgressMonitor;
import sun.net.ProgressSource;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.ParseUtil;
import sun.net.www.URLConnection;

public class FileURLConnection
extends URLConnection {
    static String CONTENT_LENGTH = "content-length";
    static String CONTENT_TYPE = "content-type";
    static String TEXT_PLAIN = "text/plain";
    static String LAST_MODIFIED = "last-modified";
    String contentType;
    InputStream is;
    File file;
    String filename;
    boolean isDirectory = false;
    boolean exists = false;
    List<String> files;
    long length = -1L;
    long lastModified = 0L;
    private boolean initializedHeaders = false;
    Permission permission;

    protected FileURLConnection(URL u, File file) {
        super(u);
        this.file = file;
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.filename = this.file.toString();
            this.isDirectory = this.file.isDirectory();
            if (this.isDirectory) {
                String[] fileList = this.file.list();
                if (fileList == null) {
                    throw new FileNotFoundException(this.filename + " exists, but is not accessible");
                }
                this.files = Arrays.asList(fileList);
            } else {
                this.is = new BufferedInputStream(new FileInputStream(this.filename));
                boolean meteredInput = ProgressMonitor.getDefault().shouldMeterInput(this.url, "GET");
                if (meteredInput) {
                    ProgressSource pi = new ProgressSource(this.url, "GET", this.file.length());
                    this.is = new MeteredStream(this.is, pi, this.file.length());
                }
            }
            this.connected = true;
        }
    }

    private void initializeHeaders() {
        try {
            this.connect();
            this.exists = this.file.exists();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!this.initializedHeaders || !this.exists) {
            this.length = this.file.length();
            this.lastModified = this.file.lastModified();
            if (!this.isDirectory) {
                FileNameMap map = java.net.URLConnection.getFileNameMap();
                this.contentType = map.getContentTypeFor(this.filename);
                if (this.contentType != null) {
                    this.properties.add(CONTENT_TYPE, this.contentType);
                }
                this.properties.add(CONTENT_LENGTH, String.valueOf(this.length));
                if (this.lastModified != 0L) {
                    Date date = new Date(this.lastModified);
                    SimpleDateFormat fo = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                    fo.setTimeZone(TimeZone.getTimeZone("GMT"));
                    this.properties.add(LAST_MODIFIED, fo.format(date));
                }
            } else {
                this.properties.add(CONTENT_TYPE, TEXT_PLAIN);
            }
            this.initializedHeaders = true;
        }
    }

    @Override
    public String getHeaderField(String name) {
        this.initializeHeaders();
        return super.getHeaderField(name);
    }

    @Override
    public String getHeaderField(int n) {
        this.initializeHeaders();
        return super.getHeaderField(n);
    }

    @Override
    public int getContentLength() {
        this.initializeHeaders();
        if (this.length > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)this.length;
    }

    @Override
    public long getContentLengthLong() {
        this.initializeHeaders();
        return this.length;
    }

    @Override
    public String getHeaderFieldKey(int n) {
        this.initializeHeaders();
        return super.getHeaderFieldKey(n);
    }

    @Override
    public MessageHeader getProperties() {
        this.initializeHeaders();
        return super.getProperties();
    }

    @Override
    public long getLastModified() {
        this.initializeHeaders();
        return this.lastModified;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        this.connect();
        if (this.is == null) {
            if (this.isDirectory) {
                FileNameMap map = java.net.URLConnection.getFileNameMap();
                StringBuffer buf = new StringBuffer();
                if (this.files == null) {
                    throw new FileNotFoundException(this.filename);
                }
                Collections.sort(this.files, Collator.getInstance());
                for (int i = 0; i < this.files.size(); ++i) {
                    String fileName = this.files.get(i);
                    buf.append(fileName);
                    buf.append("\n");
                }
                this.is = new ByteArrayInputStream(buf.toString().getBytes());
            } else {
                throw new FileNotFoundException(this.filename);
            }
        }
        return this.is;
    }

    @Override
    public Permission getPermission() throws IOException {
        if (this.permission == null) {
            String decodedPath = ParseUtil.decode(this.url.getPath());
            this.permission = File.separatorChar == '/' ? new FilePermission(decodedPath, "read") : new FilePermission(decodedPath.replace('/', File.separatorChar), "read");
        }
        return this.permission;
    }
}

