/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import sun.management.LazyCompositeData;
import sun.management.LockDataConverter;
import sun.management.MappedMXBeanType;
import sun.management.MonitorInfoCompositeData;
import sun.management.StackTraceElementCompositeData;

public class ThreadInfoCompositeData
extends LazyCompositeData {
    private final ThreadInfo threadInfo;
    private final CompositeData cdata;
    private final boolean currentVersion;
    private static final String THREAD_ID = "threadId";
    private static final String THREAD_NAME = "threadName";
    private static final String THREAD_STATE = "threadState";
    private static final String BLOCKED_TIME = "blockedTime";
    private static final String BLOCKED_COUNT = "blockedCount";
    private static final String WAITED_TIME = "waitedTime";
    private static final String WAITED_COUNT = "waitedCount";
    private static final String LOCK_INFO = "lockInfo";
    private static final String LOCK_NAME = "lockName";
    private static final String LOCK_OWNER_ID = "lockOwnerId";
    private static final String LOCK_OWNER_NAME = "lockOwnerName";
    private static final String STACK_TRACE = "stackTrace";
    private static final String SUSPENDED = "suspended";
    private static final String IN_NATIVE = "inNative";
    private static final String LOCKED_MONITORS = "lockedMonitors";
    private static final String LOCKED_SYNCS = "lockedSynchronizers";
    private static final String[] threadInfoItemNames = new String[]{"threadId", "threadName", "threadState", "blockedTime", "blockedCount", "waitedTime", "waitedCount", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "suspended", "inNative", "lockedMonitors", "lockedSynchronizers"};
    private static final String[] threadInfoV6Attributes = new String[]{"lockInfo", "lockedMonitors", "lockedSynchronizers"};
    private static final CompositeType threadInfoCompositeType;
    private static final CompositeType threadInfoV5CompositeType;
    private static final CompositeType lockInfoCompositeType;
    private static final long serialVersionUID = 2464378539119753175L;

    private ThreadInfoCompositeData(ThreadInfo ti) {
        this.threadInfo = ti;
        this.currentVersion = true;
        this.cdata = null;
    }

    private ThreadInfoCompositeData(CompositeData cd) {
        this.threadInfo = null;
        this.currentVersion = ThreadInfoCompositeData.isCurrentVersion(cd);
        this.cdata = cd;
    }

    public ThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    public boolean isCurrentVersion() {
        return this.currentVersion;
    }

    public static ThreadInfoCompositeData getInstance(CompositeData cd) {
        ThreadInfoCompositeData.validateCompositeData(cd);
        return new ThreadInfoCompositeData(cd);
    }

    public static CompositeData toCompositeData(ThreadInfo ti) {
        ThreadInfoCompositeData ticd = new ThreadInfoCompositeData(ti);
        return ticd.getCompositeData();
    }

    @Override
    protected CompositeData getCompositeData() {
        StackTraceElement[] stackTrace = this.threadInfo.getStackTrace();
        CompositeData[] stackTraceData = new CompositeData[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            stackTraceData[i] = StackTraceElementCompositeData.toCompositeData(ste);
        }
        LockDataConverter converter = new LockDataConverter(this.threadInfo);
        CompositeData lockInfoData = converter.toLockInfoCompositeData();
        CompositeData[] lockedSyncsData = converter.toLockedSynchronizersCompositeData();
        MonitorInfo[] lockedMonitors = this.threadInfo.getLockedMonitors();
        CompositeData[] lockedMonitorsData = new CompositeData[lockedMonitors.length];
        for (int i = 0; i < lockedMonitors.length; ++i) {
            MonitorInfo mi = lockedMonitors[i];
            lockedMonitorsData[i] = MonitorInfoCompositeData.toCompositeData(mi);
        }
        Object[] threadInfoItemValues = new Object[]{new Long(this.threadInfo.getThreadId()), this.threadInfo.getThreadName(), this.threadInfo.getThreadState().name(), new Long(this.threadInfo.getBlockedTime()), new Long(this.threadInfo.getBlockedCount()), new Long(this.threadInfo.getWaitedTime()), new Long(this.threadInfo.getWaitedCount()), lockInfoData, this.threadInfo.getLockName(), new Long(this.threadInfo.getLockOwnerId()), this.threadInfo.getLockOwnerName(), stackTraceData, new Boolean(this.threadInfo.isSuspended()), new Boolean(this.threadInfo.isInNative()), lockedMonitorsData, lockedSyncsData};
        try {
            return new CompositeDataSupport(threadInfoCompositeType, threadInfoItemNames, threadInfoItemValues);
        }
        catch (OpenDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean isV5Attribute(String itemName) {
        for (String n : threadInfoV6Attributes) {
            if (!itemName.equals(n)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCurrentVersion(CompositeData cd) {
        if (cd == null) {
            throw new NullPointerException("Null CompositeData");
        }
        return ThreadInfoCompositeData.isTypeMatched(threadInfoCompositeType, cd.getCompositeType());
    }

    public long threadId() {
        return ThreadInfoCompositeData.getLong(this.cdata, THREAD_ID);
    }

    public String threadName() {
        String name = ThreadInfoCompositeData.getString(this.cdata, THREAD_NAME);
        if (name == null) {
            throw new IllegalArgumentException("Invalid composite data: Attribute threadName has null value");
        }
        return name;
    }

    public Thread.State threadState() {
        return Thread.State.valueOf(ThreadInfoCompositeData.getString(this.cdata, THREAD_STATE));
    }

    public long blockedTime() {
        return ThreadInfoCompositeData.getLong(this.cdata, BLOCKED_TIME);
    }

    public long blockedCount() {
        return ThreadInfoCompositeData.getLong(this.cdata, BLOCKED_COUNT);
    }

    public long waitedTime() {
        return ThreadInfoCompositeData.getLong(this.cdata, WAITED_TIME);
    }

    public long waitedCount() {
        return ThreadInfoCompositeData.getLong(this.cdata, WAITED_COUNT);
    }

    public String lockName() {
        return ThreadInfoCompositeData.getString(this.cdata, LOCK_NAME);
    }

    public long lockOwnerId() {
        return ThreadInfoCompositeData.getLong(this.cdata, LOCK_OWNER_ID);
    }

    public String lockOwnerName() {
        return ThreadInfoCompositeData.getString(this.cdata, LOCK_OWNER_NAME);
    }

    public boolean suspended() {
        return ThreadInfoCompositeData.getBoolean(this.cdata, SUSPENDED);
    }

    public boolean inNative() {
        return ThreadInfoCompositeData.getBoolean(this.cdata, IN_NATIVE);
    }

    public StackTraceElement[] stackTrace() {
        CompositeData[] stackTraceData = (CompositeData[])this.cdata.get(STACK_TRACE);
        StackTraceElement[] stackTrace = new StackTraceElement[stackTraceData.length];
        for (int i = 0; i < stackTraceData.length; ++i) {
            CompositeData cdi = stackTraceData[i];
            stackTrace[i] = StackTraceElementCompositeData.from(cdi);
        }
        return stackTrace;
    }

    public LockInfo lockInfo() {
        LockDataConverter converter = new LockDataConverter();
        CompositeData lockInfoData = (CompositeData)this.cdata.get(LOCK_INFO);
        return converter.toLockInfo(lockInfoData);
    }

    public MonitorInfo[] lockedMonitors() {
        CompositeData[] lockedMonitorsData = (CompositeData[])this.cdata.get(LOCKED_MONITORS);
        MonitorInfo[] monitors = new MonitorInfo[lockedMonitorsData.length];
        for (int i = 0; i < lockedMonitorsData.length; ++i) {
            CompositeData cdi = lockedMonitorsData[i];
            monitors[i] = MonitorInfo.from(cdi);
        }
        return monitors;
    }

    public LockInfo[] lockedSynchronizers() {
        LockDataConverter converter = new LockDataConverter();
        CompositeData[] lockedSyncsData = (CompositeData[])this.cdata.get(LOCKED_SYNCS);
        return converter.toLockedSynchronizers(lockedSyncsData);
    }

    public static void validateCompositeData(CompositeData cd) {
        CompositeData[] stackTraceData;
        if (cd == null) {
            throw new NullPointerException("Null CompositeData");
        }
        CompositeType type = cd.getCompositeType();
        boolean currentVersion = true;
        if (!ThreadInfoCompositeData.isTypeMatched(threadInfoCompositeType, type)) {
            currentVersion = false;
            if (!ThreadInfoCompositeData.isTypeMatched(threadInfoV5CompositeType, type)) {
                throw new IllegalArgumentException("Unexpected composite type for ThreadInfo");
            }
        }
        if ((stackTraceData = (CompositeData[])cd.get(STACK_TRACE)) == null) {
            throw new IllegalArgumentException("StackTraceElement[] is missing");
        }
        if (stackTraceData.length > 0) {
            StackTraceElementCompositeData.validateCompositeData(stackTraceData[0]);
        }
        if (currentVersion) {
            CompositeData[] lsyncs;
            CompositeData li = (CompositeData)cd.get(LOCK_INFO);
            if (li != null && !ThreadInfoCompositeData.isTypeMatched(lockInfoCompositeType, li.getCompositeType())) {
                throw new IllegalArgumentException("Unexpected composite type for \"lockInfo\" attribute.");
            }
            CompositeData[] lms = (CompositeData[])cd.get(LOCKED_MONITORS);
            if (lms == null) {
                throw new IllegalArgumentException("MonitorInfo[] is null");
            }
            if (lms.length > 0) {
                MonitorInfoCompositeData.validateCompositeData(lms[0]);
            }
            if ((lsyncs = (CompositeData[])cd.get(LOCKED_SYNCS)) == null) {
                throw new IllegalArgumentException("LockInfo[] is null");
            }
            if (lsyncs.length > 0 && !ThreadInfoCompositeData.isTypeMatched(lockInfoCompositeType, lsyncs[0].getCompositeType())) {
                throw new IllegalArgumentException("Unexpected composite type for \"lockedSynchronizers\" attribute.");
            }
        }
    }

    static {
        try {
            threadInfoCompositeType = (CompositeType)MappedMXBeanType.toOpenType(ThreadInfo.class);
            String[] itemNames = threadInfoCompositeType.keySet().toArray(new String[0]);
            int numV5Attributes = threadInfoItemNames.length - threadInfoV6Attributes.length;
            String[] v5ItemNames = new String[numV5Attributes];
            String[] v5ItemDescs = new String[numV5Attributes];
            OpenType[] v5ItemTypes = new OpenType[numV5Attributes];
            int i = 0;
            for (String n : itemNames) {
                if (!ThreadInfoCompositeData.isV5Attribute(n)) continue;
                v5ItemNames[i] = n;
                v5ItemDescs[i] = threadInfoCompositeType.getDescription(n);
                v5ItemTypes[i] = threadInfoCompositeType.getType(n);
                ++i;
            }
            threadInfoV5CompositeType = new CompositeType("java.lang.management.ThreadInfo", "J2SE 5.0 java.lang.management.ThreadInfo", v5ItemNames, v5ItemDescs, v5ItemTypes);
        }
        catch (OpenDataException e) {
            throw new AssertionError((Object)e);
        }
        Object o = new Object();
        LockInfo li = new LockInfo(o.getClass().getName(), System.identityHashCode(o));
        CompositeData cd = LockDataConverter.toLockInfoCompositeData(li);
        lockInfoCompositeType = cd.getCompositeType();
    }
}

