/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import sun.java2d.DefaultDisposerRecord;
import sun.java2d.DisposerRecord;
import sun.java2d.DisposerTarget;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class Disposer
implements Runnable {
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static final Hashtable records = new Hashtable();
    private static Disposer disposerInstance;
    public static final int WEAK = 0;
    public static final int PHANTOM = 1;
    public static int refType;
    private static ArrayList<DisposerRecord> deferredRecords;
    public static volatile boolean pollingQueue;

    public static void addRecord(Object target, long disposeMethod, long pData) {
        disposerInstance.add(target, new DefaultDisposerRecord(disposeMethod, pData));
    }

    public static void addRecord(Object target, DisposerRecord rec) {
        disposerInstance.add(target, rec);
    }

    synchronized void add(Object target, DisposerRecord rec) {
        if (target instanceof DisposerTarget) {
            target = ((DisposerTarget)target).getDisposerReferent();
        }
        Reference ref = refType == 1 ? new PhantomReference<Object>(target, queue) : new WeakReference<Object>(target, queue);
        records.put(ref, rec);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Reference obj = queue.remove();
                    obj.clear();
                    DisposerRecord rec = (DisposerRecord)records.remove(obj);
                    rec.dispose();
                    obj = null;
                    rec = null;
                    Disposer.clearDeferredRecords();
                }
            }
            catch (Exception e) {
                System.out.println("Exception while removing reference: " + e);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static void clearDeferredRecords() {
        if (deferredRecords == null || deferredRecords.isEmpty()) {
            return;
        }
        for (int i = 0; i < deferredRecords.size(); ++i) {
            try {
                DisposerRecord rec = deferredRecords.get(i);
                rec.dispose();
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception while disposing deferred rec.");
                e.printStackTrace();
            }
        }
        deferredRecords.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollRemove() {
        if (pollingQueue) {
            return;
        }
        pollingQueue = true;
        int freed = 0;
        int deferred = 0;
        try {
            Reference obj;
            while ((obj = queue.poll()) != null && freed < 10000 && deferred < 100) {
                ++freed;
                obj.clear();
                DisposerRecord rec = (DisposerRecord)records.remove(obj);
                if (rec instanceof PollDisposable) {
                    rec.dispose();
                    obj = null;
                    rec = null;
                    continue;
                }
                if (rec == null) continue;
                ++deferred;
                if (deferredRecords == null) {
                    deferredRecords = new ArrayList(5);
                }
                deferredRecords.add(rec);
            }
        }
        catch (Exception e) {
            System.out.println("Exception while removing reference: " + e);
            e.printStackTrace();
        }
        finally {
            pollingQueue = false;
        }
    }

    private static native void initIDs();

    public static void addReference(Reference ref, DisposerRecord rec) {
        records.put(ref, rec);
    }

    public static void addObjectRecord(Object obj, DisposerRecord rec) {
        records.put(new WeakReference<Object>(obj, queue), rec);
    }

    public static ReferenceQueue getQueue() {
        return queue;
    }

    static {
        refType = 1;
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        Disposer.initIDs();
        String type = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.reftype"));
        if (type != null) {
            if (type.equals("weak")) {
                refType = 0;
                System.err.println("Using WEAK refs");
            } else {
                refType = 1;
                System.err.println("Using PHANTOM refs");
            }
        }
        disposerInstance = new Disposer();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup tg;
                ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
                while (tgn != null) {
                    tg = tgn;
                    tgn = tg.getParent();
                }
                Thread t = new Thread(tg, disposerInstance, "Java2D Disposer");
                t.setContextClassLoader(null);
                t.setDaemon(true);
                t.setPriority(10);
                t.start();
                return null;
            }
        });
        deferredRecords = null;
        pollingQueue = false;
    }

    public static interface PollDisposable {
    }
}

