/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.peer.LabelPeer;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;

class XLabelPeer
extends XComponentPeer
implements LabelPeer {
    static final int TEXT_XPAD = 8;
    static final int TEXT_YPAD = 6;
    String label;
    int alignment;
    FontMetrics cachedFontMetrics;
    Font oldfont;

    FontMetrics getFontMetrics() {
        if (this.cachedFontMetrics != null) {
            return this.cachedFontMetrics;
        }
        return this.getFontMetrics(this.getPeerFont());
    }

    @Override
    void preInit(XCreateWindowParams params) {
        super.preInit(params);
        Label target = (Label)this.target;
        this.label = target.getText();
        if (this.label == null) {
            this.label = "";
        }
        this.alignment = target.getAlignment();
    }

    XLabelPeer(Label target) {
        super(target);
    }

    @Override
    public Dimension getMinimumSize() {
        int w;
        FontMetrics fm = this.getFontMetrics();
        try {
            w = fm.stringWidth(this.label);
        }
        catch (NullPointerException e) {
            w = 0;
        }
        return new Dimension(w + 8, fm.getAscent() + fm.getMaxDescent() + 6);
    }

    @Override
    public void paint(Graphics g) {
        int textX = 0;
        int textY = 0;
        g.setColor(this.getPeerBackground());
        g.fillRect(0, 0, this.width, this.height);
        Font f = this.getPeerFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        if (this.cachedFontMetrics == null) {
            this.cachedFontMetrics = fm;
        } else if (this.oldfont != f) {
            this.cachedFontMetrics = fm;
        }
        switch (this.alignment) {
            case 0: {
                textX = 2;
                textY = (this.height + fm.getMaxAscent() - fm.getMaxDescent()) / 2;
                break;
            }
            case 2: {
                textX = this.width - (fm.stringWidth(this.label) + 2);
                textY = (this.height + fm.getMaxAscent() - fm.getMaxDescent()) / 2;
                break;
            }
            case 1: {
                textX = (this.width - fm.stringWidth(this.label)) / 2;
                textY = (this.height + fm.getMaxAscent() - fm.getMaxDescent()) / 2;
            }
        }
        if (this.isEnabled()) {
            g.setColor(this.getPeerForeground());
            g.drawString(this.label, textX, textY);
        } else {
            g.setColor(this.getPeerBackground().brighter());
            g.drawString(this.label, textX, textY);
            g.setColor(this.getPeerBackground().darker());
            g.drawString(this.label, textX - 1, textY - 1);
        }
    }

    @Override
    public void setText(String text) {
        this.label = text;
        if (this.label == null) {
            this.label = "";
        }
        this.repaint();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.target.repaint();
    }

    @Override
    public void setAlignment(int align) {
        this.alignment = align;
        this.repaint();
    }
}

