/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import sun.awt.CausedFocusEvent;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XEmbedChildProxy;
import sun.awt.X11.XEmbeddingContainer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.java2d.pipe.Region;

public class XEmbedChildProxyPeer
implements ComponentPeer,
XEventDispatcher {
    XEmbeddingContainer container;
    XEmbedChildProxy proxy;
    long handle;

    XEmbedChildProxyPeer(XEmbedChildProxy proxy) {
        this.container = proxy.getEmbeddingContainer();
        this.handle = proxy.getHandle();
        this.proxy = proxy;
        this.initDispatching();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initDispatching() {
        XToolkit.awtLock();
        try {
            XToolkit.addEventDispatcher(this.handle, this);
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.handle, 0x420000L);
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.container.notifyChildEmbedded(this.handle);
    }

    @Override
    public boolean isObscured() {
        return false;
    }

    @Override
    public boolean canDetermineObscurity() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean b) {
        if (!b) {
            XToolkit.awtLock();
            try {
                XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.handle);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XMapWindow(XToolkit.getDisplay(), this.handle);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public void paint(Graphics g) {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void print(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
        XToolkit.awtLock();
        try {
            XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), this.handle, x, y, width, height);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public void handleEvent(AWTEvent e) {
        switch (e.getID()) {
            case 1004: {
                XKeyboardFocusManagerPeer.setCurrentNativeFocusOwner(this.proxy);
                this.container.focusGained(this.handle);
                break;
            }
            case 1005: {
                XKeyboardFocusManagerPeer.setCurrentNativeFocusOwner(null);
                this.container.focusLost(this.handle);
                break;
            }
            case 401: 
            case 402: {
                if (((InputEvent)e).isConsumed()) break;
                this.container.forwardKeyEvent(this.handle, (KeyEvent)e);
            }
        }
    }

    @Override
    public void coalescePaintEvent(PaintEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLocationOnScreen() {
        XWindowAttributes attr = new XWindowAttributes();
        XToolkit.awtLock();
        try {
            XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), this.handle, attr.pData);
            Point point = new Point(attr.get_x(), attr.get_y());
            return point;
        }
        finally {
            XToolkit.awtUnlock();
            attr.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        XToolkit.awtLock();
        long p_hints = XlibWrapper.XAllocSizeHints();
        try {
            Dimension res;
            XSizeHints hints = new XSizeHints(p_hints);
            XlibWrapper.XGetWMNormalHints(XToolkit.getDisplay(), this.handle, p_hints, XlibWrapper.larg1);
            Dimension dimension = res = new Dimension(hints.get_width(), hints.get_height());
            return dimension;
        }
        finally {
            XlibWrapper.XFree(p_hints);
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize() {
        XToolkit.awtLock();
        long p_hints = XlibWrapper.XAllocSizeHints();
        try {
            Dimension res;
            XSizeHints hints = new XSizeHints(p_hints);
            XlibWrapper.XGetWMNormalHints(XToolkit.getDisplay(), this.handle, p_hints, XlibWrapper.larg1);
            Dimension dimension = res = new Dimension(hints.get_min_width(), hints.get_min_height());
            return dimension;
        }
        finally {
            XlibWrapper.XFree(p_hints);
            XToolkit.awtUnlock();
        }
    }

    @Override
    public ColorModel getColorModel() {
        return null;
    }

    @Override
    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    @Override
    public Graphics getGraphics() {
        return null;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return null;
    }

    @Override
    public void dispose() {
        this.container.detachChild(this.handle);
    }

    @Override
    public void setForeground(Color c) {
    }

    @Override
    public void setBackground(Color c) {
    }

    @Override
    public void setFont(Font f) {
    }

    @Override
    public void updateCursorImmediately() {
    }

    void postEvent(AWTEvent event) {
        XToolkit.postEvent(XToolkit.targetToAppContext(this.proxy), event);
    }

    boolean simulateMotifRequestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time) {
        Component currentOwner;
        if (lightweightChild == null) {
            lightweightChild = this.proxy;
        }
        if ((currentOwner = XKeyboardFocusManagerPeer.getCurrentNativeFocusOwner()) != null && currentOwner.getPeer() == null) {
            currentOwner = null;
        }
        FocusEvent fg = new FocusEvent(lightweightChild, 1004, false, currentOwner);
        FocusEvent fl = null;
        if (currentOwner != null) {
            fl = new FocusEvent(currentOwner, 1005, false, lightweightChild);
        }
        if (fl != null) {
            this.postEvent(XComponentPeer.wrapInSequenced(fl));
        }
        this.postEvent(XComponentPeer.wrapInSequenced(fg));
        return true;
    }

    @Override
    public boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause) {
        int result = XKeyboardFocusManagerPeer.shouldNativelyFocusHeavyweight(this.proxy, lightweightChild, temporary, false, time, cause);
        switch (result) {
            case 0: {
                return false;
            }
            case 2: {
                Window parentWindow;
                Container parent;
                for (parent = this.proxy.getParent(); parent != null && !(parent instanceof Window); parent = parent.getParent()) {
                }
                if (parent != null && !(parentWindow = (Window)parent).isFocused() && XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow() == parentWindow) {
                    return true;
                }
                return this.simulateMotifRequestFocus(lightweightChild, temporary, focusedWindowChangeAllowed, time);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public Image createImage(ImageProducer producer) {
        return null;
    }

    @Override
    public Image createImage(int width, int height) {
        return null;
    }

    @Override
    public VolatileImage createVolatileImage(int width, int height) {
        return null;
    }

    @Override
    public boolean prepareImage(Image img, int w, int h, ImageObserver o) {
        return false;
    }

    @Override
    public int checkImage(Image img, int w, int h, ImageObserver o) {
        return 0;
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        return null;
    }

    @Override
    public boolean handlesWheelScrolling() {
        return true;
    }

    @Override
    public void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
    }

    @Override
    public Image getBackBuffer() {
        return null;
    }

    @Override
    public void flip(int x1, int y1, int x2, int y2, BufferCapabilities.FlipContents flipAction) {
    }

    @Override
    public void destroyBuffers() {
    }

    @Override
    public void layout() {
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void enable() {
    }

    public void disable() {
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height, 3);
    }

    Window getTopLevel(Component comp) {
        while (comp != null && !(comp instanceof Window)) {
            comp = comp.getParent();
        }
        return (Window)comp;
    }

    void childResized() {
        XToolkit.postEvent(XToolkit.targetToAppContext(this.proxy), new ComponentEvent(this.proxy, 101));
        this.container.childResized(this.proxy);
    }

    void handlePropertyNotify(XEvent xev) {
        XPropertyEvent ev = xev.get_xproperty();
        if (ev.get_atom() == 40L) {
            this.childResized();
        }
    }

    void handleConfigureNotify(XEvent xev) {
        this.childResized();
    }

    @Override
    public void dispatchEvent(XEvent xev) {
        int type = xev.get_type();
        switch (type) {
            case 28: {
                this.handlePropertyNotify(xev);
                break;
            }
            case 22: {
                this.handleConfigureNotify(xev);
            }
        }
    }

    void requestXEmbedFocus() {
        this.postEvent(new InvocationEvent((Object)this.proxy, new Runnable(){

            @Override
            public void run() {
                XEmbedChildProxyPeer.this.proxy.requestFocusInWindow();
            }
        }));
    }

    @Override
    public void reparent(ContainerPeer newNativeParent) {
    }

    @Override
    public boolean isReparentSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        XWindowAttributes attrs = new XWindowAttributes();
        XToolkit.awtLock();
        try {
            XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), this.handle, attrs.pData);
            Rectangle rectangle = new Rectangle(attrs.get_x(), attrs.get_y(), attrs.get_width(), attrs.get_height());
            return rectangle;
        }
        finally {
            XToolkit.awtUnlock();
            attrs.dispose();
        }
    }

    public void setBoundsOperation(int operation) {
    }

    @Override
    public void applyShape(Region shape) {
    }

    @Override
    public void setZOrder(ComponentPeer above) {
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration gc) {
        return false;
    }
}

