/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TooManyListenersException;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.CausedFocusEvent;
import sun.awt.ModalityEvent;
import sun.awt.ModalityListener;
import sun.awt.SunToolkit;
import sun.awt.WindowIDProvider;
import sun.awt.X11.Native;
import sun.awt.X11.XCanvasPeer;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XCreateWindowEvent;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDestroyWindowEvent;
import sun.awt.X11.XDnDConstants;
import sun.awt.X11.XDropTargetContextPeer;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XEmbedHelper;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.security.action.GetBooleanAction;
import sun.util.logging.PlatformLogger;

public class XEmbedCanvasPeer
extends XCanvasPeer
implements WindowFocusListener,
KeyEventPostProcessor,
ModalityListener,
WindowIDProvider {
    private static final PlatformLogger xembedLog = PlatformLogger.getLogger("sun.awt.X11.xembed.XEmbedCanvasPeer");
    boolean applicationActive;
    XEmbedServer xembed = new XEmbedServer();
    Map<Long, AWTKeyStroke> accelerators = new HashMap<Long, AWTKeyStroke>();
    Map<AWTKeyStroke, Long> accel_lookup = new HashMap<AWTKeyStroke, Long>();
    Set<GrabbedKey> grabbed_keys = new HashSet<GrabbedKey>();
    Object ACCEL_LOCK = this.accelerators;
    Object GRAB_LOCK = this.grabbed_keys;

    XEmbedCanvasPeer() {
    }

    XEmbedCanvasPeer(XCreateWindowParams params) {
        super(params);
    }

    XEmbedCanvasPeer(Component target) {
        super(target);
    }

    @Override
    protected void postInit(XCreateWindowParams params) {
        super.postInit(params);
        this.installActivateListener();
        this.installAcceleratorListener();
        this.installModalityListener();
        this.target.setFocusTraversalKeysEnabled(false);
    }

    @Override
    protected void preInit(XCreateWindowParams params) {
        super.preInit(params);
        params.put("event mask", 2793599L);
    }

    void installModalityListener() {
        ((SunToolkit)Toolkit.getDefaultToolkit()).addModalityListener(this);
    }

    void deinstallModalityListener() {
        ((SunToolkit)Toolkit.getDefaultToolkit()).removeModalityListener(this);
    }

    void installAcceleratorListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this);
    }

    void deinstallAcceleratorListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this);
    }

    void installActivateListener() {
        Window toplevel = this.getTopLevel(this.target);
        if (toplevel != null) {
            toplevel.addWindowFocusListener(this);
            this.applicationActive = toplevel.isFocused();
        }
    }

    void deinstallActivateListener() {
        Window toplevel = this.getTopLevel(this.target);
        if (toplevel != null) {
            toplevel.removeWindowFocusListener(this);
        }
    }

    boolean isXEmbedActive() {
        return this.xembed.handle != 0L;
    }

    boolean isApplicationActive() {
        return this.applicationActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initDispatching() {
        if (xembedLog.isLoggable(500)) {
            xembedLog.fine("Init embedding for " + Long.toHexString(this.xembed.handle));
        }
        XToolkit.awtLock();
        try {
            XToolkit.addEventDispatcher(this.xembed.handle, this.xembed);
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.xembed.handle, 0x420000L);
            XDropTargetRegistry.getRegistry().registerXEmbedClient(this.getWindow(), this.xembed.handle);
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.xembed.processXEmbedInfo();
        this.notifyChildEmbedded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endDispatching() {
        xembedLog.fine("End dispatching for " + Long.toHexString(this.xembed.handle));
        XToolkit.awtLock();
        try {
            XDropTargetRegistry.getRegistry().unregisterXEmbedClient(this.getWindow(), this.xembed.handle);
            XToolkit.removeEventDispatcher(this.xembed.handle, this.xembed);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void embedChild(long child) {
        if (this.xembed.handle != 0L) {
            this.detachChild();
        }
        this.xembed.handle = child;
        this.initDispatching();
    }

    void childDestroyed() {
        xembedLog.fine("Child " + Long.toHexString(this.xembed.handle) + " has self-destroyed.");
        this.endDispatching();
        this.xembed.handle = 0L;
    }

    @Override
    public void handleEvent(AWTEvent e) {
        super.handleEvent(e);
        if (this.isXEmbedActive()) {
            switch (e.getID()) {
                case 1004: {
                    this.canvasFocusGained((FocusEvent)e);
                    break;
                }
                case 1005: {
                    this.canvasFocusLost((FocusEvent)e);
                    break;
                }
                case 401: 
                case 402: {
                    if (((InputEvent)e).isConsumed()) break;
                    this.forwardKeyEvent((KeyEvent)e);
                }
            }
        }
    }

    @Override
    public void dispatchEvent(XEvent ev) {
        super.dispatchEvent(ev);
        switch (ev.get_type()) {
            case 16: {
                XCreateWindowEvent cr = ev.get_xcreatewindow();
                if (xembedLog.isLoggable(300)) {
                    xembedLog.finest("Message on embedder: " + cr);
                }
                if (xembedLog.isLoggable(400)) {
                    xembedLog.finer("Create notify for parent " + Long.toHexString(cr.get_parent()) + ", window " + Long.toHexString(cr.get_window()));
                }
                this.embedChild(cr.get_window());
                break;
            }
            case 17: {
                XDestroyWindowEvent dn = ev.get_xdestroywindow();
                if (xembedLog.isLoggable(300)) {
                    xembedLog.finest("Message on embedder: " + dn);
                }
                if (xembedLog.isLoggable(400)) {
                    xembedLog.finer("Destroy notify for parent: " + dn);
                }
                this.childDestroyed();
                break;
            }
            case 21: {
                XReparentEvent rep = ev.get_xreparent();
                if (xembedLog.isLoggable(300)) {
                    xembedLog.finest("Message on embedder: " + rep);
                }
                if (xembedLog.isLoggable(400)) {
                    xembedLog.finer("Reparent notify for parent " + Long.toHexString(rep.get_parent()) + ", window " + Long.toHexString(rep.get_window()) + ", event " + Long.toHexString(rep.get_event()));
                }
                if (rep.get_parent() == this.getWindow()) {
                    this.embedChild(rep.get_window());
                    break;
                }
                this.childDestroyed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        if (this.isXEmbedActive()) {
            XToolkit.awtLock();
            try {
                long p_hints = XlibWrapper.XAllocSizeHints();
                XSizeHints hints = new XSizeHints(p_hints);
                XlibWrapper.XGetWMNormalHints(XToolkit.getDisplay(), this.xembed.handle, p_hints, XlibWrapper.larg1);
                Dimension res = new Dimension(hints.get_width(), hints.get_height());
                XlibWrapper.XFree(p_hints);
                Dimension dimension = res;
                return dimension;
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return super.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize() {
        if (this.isXEmbedActive()) {
            XToolkit.awtLock();
            try {
                long p_hints = XlibWrapper.XAllocSizeHints();
                XSizeHints hints = new XSizeHints(p_hints);
                XlibWrapper.XGetWMNormalHints(XToolkit.getDisplay(), this.xembed.handle, p_hints, XlibWrapper.larg1);
                Dimension res = new Dimension(hints.get_min_width(), hints.get_min_height());
                XlibWrapper.XFree(p_hints);
                Dimension dimension = res;
                return dimension;
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return super.getMinimumSize();
    }

    @Override
    public void dispose() {
        if (this.isXEmbedActive()) {
            this.detachChild();
        }
        this.deinstallActivateListener();
        this.deinstallModalityListener();
        this.deinstallAcceleratorListener();
        super.dispose();
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    Window getTopLevel(Component comp) {
        while (comp != null && !(comp instanceof Window)) {
            comp = comp.getParent();
        }
        return (Window)comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Rectangle getClientBounds() {
        XToolkit.awtLock();
        try {
            XWindowAttributes wattr;
            block8: {
                wattr = new XWindowAttributes();
                try {
                    XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                    int status = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), this.xembed.handle, wattr.pData);
                    XToolkit.RESTORE_XERROR_HANDLER();
                    if (status != 0 && (XToolkit.saved_error == null || XToolkit.saved_error.get_error_code() == 0)) break block8;
                    Rectangle rectangle = null;
                    wattr.dispose();
                    return rectangle;
                }
                catch (Throwable throwable) {
                    wattr.dispose();
                    throw throwable;
                }
            }
            Rectangle rectangle = new Rectangle(wattr.get_x(), wattr.get_y(), wattr.get_width(), wattr.get_height());
            wattr.dispose();
            return rectangle;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void childResized() {
        if (xembedLog.isLoggable(400)) {
            Rectangle bounds = this.getClientBounds();
            xembedLog.finer("Child resized: " + bounds);
        }
        XToolkit.postEvent(XToolkit.targetToAppContext(this.target), new ComponentEvent(this.target, 101));
    }

    void focusNext() {
        if (this.isXEmbedActive()) {
            xembedLog.fine("Requesting focus for the next component after embedder");
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                @Override
                public void run() {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(XEmbedCanvasPeer.this.target);
                }
            }));
        } else {
            xembedLog.fine("XEmbed is not active - denying focus next");
        }
    }

    void focusPrev() {
        if (this.isXEmbedActive()) {
            xembedLog.fine("Requesting focus for the next component after embedder");
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                @Override
                public void run() {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(XEmbedCanvasPeer.this.target);
                }
            }));
        } else {
            xembedLog.fine("XEmbed is not active - denying focus prev");
        }
    }

    void requestXEmbedFocus() {
        if (this.isXEmbedActive()) {
            xembedLog.fine("Requesting focus for client");
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                @Override
                public void run() {
                    XEmbedCanvasPeer.this.target.requestFocus();
                }
            }));
        } else {
            xembedLog.fine("XEmbed is not active - denying request focus");
        }
    }

    void notifyChildEmbedded() {
        this.xembed.sendMessage(this.xembed.handle, 0, this.getWindow(), Math.min(this.xembed.version, 0L), 0L);
        if (this.isApplicationActive()) {
            xembedLog.fine("Sending WINDOW_ACTIVATE during initialization");
            this.xembed.sendMessage(this.xembed.handle, 1);
            if (this.hasFocus()) {
                xembedLog.fine("Sending FOCUS_GAINED during initialization");
                this.xembed.sendMessage(this.xembed.handle, 4, 0L, 0L, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachChild() {
        if (xembedLog.isLoggable(500)) {
            xembedLog.fine("Detaching child " + Long.toHexString(this.xembed.handle));
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.xembed.handle);
            XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.xembed.handle, XToolkit.getDefaultRootWindow(), 0, 0);
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.endDispatching();
        this.xembed.handle = 0L;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.applicationActive = true;
        if (this.isXEmbedActive()) {
            xembedLog.fine("Sending WINDOW_ACTIVATE");
            this.xembed.sendMessage(this.xembed.handle, 1);
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.applicationActive = false;
        if (this.isXEmbedActive()) {
            xembedLog.fine("Sending WINDOW_DEACTIVATE");
            this.xembed.sendMessage(this.xembed.handle, 2);
        }
    }

    void canvasFocusGained(FocusEvent e) {
        if (this.isXEmbedActive()) {
            xembedLog.fine("Forwarding FOCUS_GAINED");
            int flavor = 0;
            if (e instanceof CausedFocusEvent) {
                CausedFocusEvent ce = (CausedFocusEvent)e;
                if (ce.getCause() == CausedFocusEvent.Cause.TRAVERSAL_FORWARD) {
                    flavor = 1;
                } else if (ce.getCause() == CausedFocusEvent.Cause.TRAVERSAL_BACKWARD) {
                    flavor = 2;
                }
            }
            this.xembed.sendMessage(this.xembed.handle, 4, flavor, 0L, 0L);
        }
    }

    void canvasFocusLost(FocusEvent e) {
        if (this.isXEmbedActive() && !e.isTemporary()) {
            xembedLog.fine("Forwarding FOCUS_LOST");
            int num = 0;
            if (AccessController.doPrivileged(new GetBooleanAction("sun.awt.xembed.testing")).booleanValue()) {
                Component opp = e.getOppositeComponent();
                try {
                    num = Integer.parseInt(opp.getName());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            this.xembed.sendMessage(this.xembed.handle, 5, num, 0L, 0L);
        }
    }

    static byte[] getBData(KeyEvent e) {
        return AWTAccessor.getAWTEventAccessor().getBData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forwardKeyEvent(KeyEvent e) {
        xembedLog.fine("Try to forward key event");
        byte[] bdata = XEmbedCanvasPeer.getBData(e);
        long data = Native.toData(bdata);
        if (data == 0L) {
            return;
        }
        try {
            XKeyEvent ke = new XKeyEvent(data);
            ke.set_window(this.xembed.handle);
            if (xembedLog.isLoggable(500)) {
                xembedLog.fine("Forwarding native key event: " + ke);
            }
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.xembed.handle, false, 0L, data);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            XlibWrapper.unsafe.freeMemory(data);
        }
    }

    void grabKey(final long keysym, final long modifiers) {
        this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GrabbedKey grab = new GrabbedKey(keysym, modifiers);
                if (xembedLog.isLoggable(500)) {
                    xembedLog.fine("Grabbing key: " + grab);
                }
                Object object = XEmbedCanvasPeer.this.GRAB_LOCK;
                synchronized (object) {
                    XEmbedCanvasPeer.this.grabbed_keys.add(grab);
                }
            }
        }));
    }

    void ungrabKey(final long keysym, final long modifiers) {
        this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GrabbedKey grab = new GrabbedKey(keysym, modifiers);
                if (xembedLog.isLoggable(500)) {
                    xembedLog.fine("UnGrabbing key: " + grab);
                }
                Object object = XEmbedCanvasPeer.this.GRAB_LOCK;
                synchronized (object) {
                    XEmbedCanvasPeer.this.grabbed_keys.remove(grab);
                }
            }
        }));
    }

    void registerAccelerator(final long accel_id, final long keysym, final long modifiers) {
        this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AWTKeyStroke stroke = XEmbedCanvasPeer.this.xembed.getKeyStrokeForKeySym(keysym, modifiers);
                if (stroke != null) {
                    if (xembedLog.isLoggable(500)) {
                        xembedLog.fine("Registering accelerator " + accel_id + " for " + stroke);
                    }
                    Object object = XEmbedCanvasPeer.this.ACCEL_LOCK;
                    synchronized (object) {
                        XEmbedCanvasPeer.this.accelerators.put(accel_id, stroke);
                        XEmbedCanvasPeer.this.accel_lookup.put(stroke, accel_id);
                    }
                }
                XEmbedCanvasPeer.this.propogateRegisterAccelerator(stroke);
            }
        }));
    }

    void unregisterAccelerator(final long accel_id) {
        this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AWTKeyStroke stroke = null;
                Object object = XEmbedCanvasPeer.this.ACCEL_LOCK;
                synchronized (object) {
                    stroke = XEmbedCanvasPeer.this.accelerators.get(accel_id);
                    if (stroke != null) {
                        if (xembedLog.isLoggable(500)) {
                            xembedLog.fine("Unregistering accelerator: " + accel_id);
                        }
                        XEmbedCanvasPeer.this.accelerators.remove(accel_id);
                        XEmbedCanvasPeer.this.accel_lookup.remove(stroke);
                    }
                }
                XEmbedCanvasPeer.this.propogateUnRegisterAccelerator(stroke);
            }
        }));
    }

    void propogateRegisterAccelerator(AWTKeyStroke stroke) {
        XWindowPeer parent = this.getToplevelXWindow();
        if (parent != null && parent instanceof XEmbeddedFramePeer) {
            XEmbeddedFramePeer embedded = (XEmbeddedFramePeer)parent;
            embedded.registerAccelerator(stroke);
        }
    }

    void propogateUnRegisterAccelerator(AWTKeyStroke stroke) {
        XWindowPeer parent = this.getToplevelXWindow();
        if (parent != null && parent instanceof XEmbeddedFramePeer) {
            XEmbeddedFramePeer embedded = (XEmbeddedFramePeer)parent;
            embedded.unregisterAccelerator(stroke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postProcessKeyEvent(KeyEvent e) {
        XWindowPeer parent = this.getToplevelXWindow();
        if (parent == null || !((Window)parent.getTarget()).isFocused() || this.target.isFocusOwner()) {
            return false;
        }
        boolean result = false;
        if (xembedLog.isLoggable(400)) {
            xembedLog.finer("Post-processing event " + e);
        }
        AWTKeyStroke stroke = AWTKeyStroke.getAWTKeyStrokeForEvent(e);
        long accel_id = 0L;
        boolean exists = false;
        Object object = this.ACCEL_LOCK;
        synchronized (object) {
            exists = this.accel_lookup.containsKey(stroke);
            if (exists) {
                accel_id = this.accel_lookup.get(stroke);
            }
        }
        if (exists) {
            if (xembedLog.isLoggable(500)) {
                xembedLog.fine("Activating accelerator " + accel_id);
            }
            this.xembed.sendMessage(this.xembed.handle, 14, accel_id, 0L, 0L);
            result = true;
        }
        exists = false;
        GrabbedKey key = new GrabbedKey(e);
        Object object2 = this.GRAB_LOCK;
        synchronized (object2) {
            exists = this.grabbed_keys.contains(key);
        }
        if (exists) {
            if (xembedLog.isLoggable(500)) {
                xembedLog.fine("Forwarding grabbed key " + e);
            }
            this.forwardKeyEvent(e);
            result = true;
        }
        return result;
    }

    @Override
    public void modalityPushed(ModalityEvent ev) {
        this.xembed.sendMessage(this.xembed.handle, 10);
    }

    @Override
    public void modalityPopped(ModalityEvent ev) {
        this.xembed.sendMessage(this.xembed.handle, 11);
    }

    @Override
    public void handleClientMessage(XEvent xev) {
        super.handleClientMessage(xev);
        XClientMessageEvent msg = xev.get_xclient();
        if (xembedLog.isLoggable(400)) {
            xembedLog.finer("Client message to embedder: " + msg);
        }
        if (msg.get_message_type() == XEmbedServer.XEmbed.getAtom() && xembedLog.isLoggable(500)) {
            xembedLog.fine(XEmbedServer.XEmbedMessageToString(msg));
        }
        if (this.isXEmbedActive()) {
            switch ((int)msg.get_data(1)) {
                case 3: {
                    this.requestXEmbedFocus();
                    break;
                }
                case 6: {
                    this.focusNext();
                    break;
                }
                case 7: {
                    this.focusPrev();
                    break;
                }
                case 12: {
                    this.registerAccelerator(msg.get_data(2), msg.get_data(3), msg.get_data(4));
                    break;
                }
                case 13: {
                    this.unregisterAccelerator(msg.get_data(2));
                    break;
                }
                case 108: {
                    this.grabKey(msg.get_data(3), msg.get_data(4));
                    break;
                }
                case 109: {
                    this.ungrabKey(msg.get_data(3), msg.get_data(4));
                }
            }
        } else {
            xembedLog.finer("But XEmbed is not Active!");
        }
    }

    public void setXEmbedDropTarget() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                XEmbedCanvasPeer.this.target.setDropTarget(new XEmbedDropTarget());
            }
        };
        SunToolkit.executeOnEventHandlerThread(this.target, r);
    }

    public void removeXEmbedDropTarget() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (XEmbedCanvasPeer.this.target.getDropTarget() instanceof XEmbedDropTarget) {
                    XEmbedCanvasPeer.this.target.setDropTarget(null);
                }
            }
        };
        SunToolkit.executeOnEventHandlerThread(this.target, r);
    }

    public boolean processXEmbedDnDEvent(long ctxt, int eventID) {
        if (xembedLog.isLoggable(300)) {
            xembedLog.finest("     Drop target=" + this.target.getDropTarget());
        }
        if (this.target.getDropTarget() instanceof XEmbedDropTarget) {
            AppContext appContext = XToolkit.targetToAppContext(this.getTarget());
            XDropTargetContextPeer peer = XDropTargetContextPeer.getPeer(appContext);
            peer.forwardEventToEmbedded(this.xembed.handle, ctxt, eventID);
            return true;
        }
        return false;
    }

    static class GrabbedKey {
        long keysym;
        long modifiers;

        GrabbedKey(long keysym, long modifiers) {
            this.keysym = keysym;
            this.modifiers = modifiers;
        }

        GrabbedKey(KeyEvent ev) {
            this.init(ev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init(KeyEvent e) {
            byte[] bdata = XEmbedCanvasPeer.getBData(e);
            long data = Native.toData(bdata);
            if (data == 0L) {
                return;
            }
            try {
                XToolkit.awtLock();
                try {
                    this.keysym = XWindow.getKeySymForAWTKeyCode(e.getKeyCode());
                }
                finally {
                    XToolkit.awtUnlock();
                }
                XKeyEvent ke = new XKeyEvent(data);
                this.modifiers = ke.get_state() & 7;
                if (xembedLog.isLoggable(300)) {
                    xembedLog.finest("Mapped " + e + " to " + this);
                }
            }
            finally {
                XlibWrapper.unsafe.freeMemory(data);
            }
        }

        public int hashCode() {
            return (int)this.keysym & 0xFFFFFFFF;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GrabbedKey)) {
                return false;
            }
            GrabbedKey key = (GrabbedKey)o;
            return this.keysym == key.keysym && this.modifiers == key.modifiers;
        }

        public String toString() {
            return "Key combination[keysym=" + this.keysym + ", mods=" + this.modifiers + "]";
        }
    }

    class XEmbedServer
    extends XEmbedHelper
    implements XEventDispatcher {
        long handle;
        long version;
        long flags;

        XEmbedServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean processXEmbedInfo() {
            long xembed_info_data = Native.allocateLongArray(2);
            try {
                boolean currently_mapped;
                if (!XEmbedInfo.getAtomData(this.handle, xembed_info_data, 2)) {
                    xembedLog.finer("Unable to get XEMBED_INFO atom data");
                    boolean bl = false;
                    return bl;
                }
                this.version = Native.getCard32(xembed_info_data, 0);
                this.flags = Native.getCard32(xembed_info_data, 1);
                boolean new_mapped = (this.flags & 1L) != 0L;
                boolean bl = currently_mapped = XlibUtil.getWindowMapState(this.handle) != 0;
                if (new_mapped != currently_mapped) {
                    if (xembedLog.isLoggable(400)) {
                        xembedLog.fine("Mapping state of the client has changed, old state: " + currently_mapped + ", new state: " + new_mapped);
                    }
                    if (new_mapped) {
                        XToolkit.awtLock();
                        try {
                            XlibWrapper.XMapWindow(XToolkit.getDisplay(), this.handle);
                        }
                        finally {
                            XToolkit.awtUnlock();
                        }
                    } else {
                        XToolkit.awtLock();
                        try {
                            XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.handle);
                        }
                        finally {
                            XToolkit.awtUnlock();
                        }
                    }
                } else {
                    xembedLog.finer("Mapping state didn't change, mapped: " + currently_mapped);
                }
                boolean bl2 = true;
                return bl2;
            }
            finally {
                XlibWrapper.unsafe.freeMemory(xembed_info_data);
            }
        }

        public void handlePropertyNotify(XEvent xev) {
            if (XEmbedCanvasPeer.this.isXEmbedActive()) {
                XPropertyEvent ev = xev.get_xproperty();
                if (xembedLog.isLoggable(400)) {
                    xembedLog.finer("Property change on client: " + ev);
                }
                if (ev.get_atom() == 40L) {
                    XEmbedCanvasPeer.this.childResized();
                } else if (ev.get_atom() == XEmbedInfo.getAtom()) {
                    this.processXEmbedInfo();
                } else if (ev.get_atom() == XDnDConstants.XA_XdndAware.getAtom()) {
                    XDropTargetRegistry.getRegistry().unregisterXEmbedClient(XEmbedCanvasPeer.this.getWindow(), XEmbedCanvasPeer.this.xembed.handle);
                    if (ev.get_state() == 0) {
                        XDropTargetRegistry.getRegistry().registerXEmbedClient(XEmbedCanvasPeer.this.getWindow(), XEmbedCanvasPeer.this.xembed.handle);
                    }
                }
            } else {
                xembedLog.finer("XEmbed is not active");
            }
        }

        void handleConfigureNotify(XEvent xev) {
            if (XEmbedCanvasPeer.this.isXEmbedActive()) {
                XConfigureEvent ev = xev.get_xconfigure();
                if (xembedLog.isLoggable(400)) {
                    xembedLog.finer("Bounds change on client: " + ev);
                }
                if (xev.get_xany().get_window() == this.handle) {
                    XEmbedCanvasPeer.this.childResized();
                }
            }
        }

        @Override
        public void dispatchEvent(XEvent xev) {
            int type = xev.get_type();
            switch (type) {
                case 28: {
                    this.handlePropertyNotify(xev);
                    break;
                }
                case 22: {
                    this.handleConfigureNotify(xev);
                    break;
                }
                case 33: {
                    XEmbedCanvasPeer.this.handleClientMessage(xev);
                }
            }
        }
    }

    private static class XEmbedDropTarget
    extends DropTarget {
        private XEmbedDropTarget() {
        }

        @Override
        public void addDropTargetListener(DropTargetListener dtl) throws TooManyListenersException {
            throw new TooManyListenersException();
        }
    }
}

