/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.applet.AppletClassLoader;
import sun.applet.AppletEvent;
import sun.applet.AppletEventMulticaster;
import sun.applet.AppletListener;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletObjectInputStream;
import sun.awt.AppContext;
import sun.awt.EmbeddedFrame;
import sun.awt.SunToolkit;
import sun.misc.MessageUtils;
import sun.misc.PerformanceLogger;
import sun.misc.Queue;
import sun.security.util.SecurityConstants;

public abstract class AppletPanel
extends Panel
implements AppletStub,
Runnable {
    protected Applet applet;
    protected boolean doInit = true;
    protected AppletClassLoader loader;
    public static final int APPLET_DISPOSE = 0;
    public static final int APPLET_LOAD = 1;
    public static final int APPLET_INIT = 2;
    public static final int APPLET_START = 3;
    public static final int APPLET_STOP = 4;
    public static final int APPLET_DESTROY = 5;
    public static final int APPLET_QUIT = 6;
    public static final int APPLET_ERROR = 7;
    public static final int APPLET_RESIZE = 51234;
    public static final int APPLET_LOADING = 51235;
    public static final int APPLET_LOADING_COMPLETED = 51236;
    protected int status;
    protected Thread handler;
    Dimension defaultAppletSize = new Dimension(10, 10);
    Dimension currentAppletSize = new Dimension(10, 10);
    MessageUtils mu = new MessageUtils();
    Thread loaderThread = null;
    boolean loadAbortRequest = false;
    private static int threadGroupNumber = 0;
    private AppletListener listeners;
    private Queue queue = null;
    private EventQueue appEvtQ = null;
    private static HashMap classloaders = new HashMap();
    private boolean jdk11Applet = false;
    private boolean jdk12Applet = false;
    private static AppletMessageHandler amh = new AppletMessageHandler("appletpanel");

    protected abstract String getCode();

    protected abstract String getJarFiles();

    protected abstract String getSerializedObject();

    @Override
    public abstract int getWidth();

    @Override
    public abstract int getHeight();

    public abstract boolean hasInitialFocus();

    protected void setupAppletAppContext() {
    }

    protected synchronized void createAppletThread() {
        String nm = "applet-" + this.getCode();
        this.loader = this.getClassLoader(this.getCodeBase(), this.getClassLoaderCacheKey());
        this.loader.grab();
        String param = this.getParameter("codebase_lookup");
        if (param != null && param.equals("false")) {
            this.loader.setCodebaseLookup(false);
        } else {
            this.loader.setCodebaseLookup(true);
        }
        ThreadGroup appletGroup = this.loader.getThreadGroup();
        this.handler = new Thread(appletGroup, this, "thread " + nm);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AppletPanel.this.handler.setContextClassLoader(AppletPanel.this.loader);
                return null;
            }
        });
        this.handler.start();
    }

    void joinAppletThread() throws InterruptedException {
        if (this.handler != null) {
            this.handler.join();
            this.handler = null;
        }
    }

    void release() {
        if (this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
    }

    public void init() {
        try {
            this.currentAppletSize.width = this.defaultAppletSize.width = this.getWidth();
            this.currentAppletSize.height = this.defaultAppletSize.height = this.getHeight();
        }
        catch (NumberFormatException e) {
            this.status = 7;
            this.showAppletStatus("badattribute.exception");
            this.showAppletLog("badattribute.exception");
            this.showAppletException(e);
        }
        this.setLayout(new BorderLayout());
        this.createAppletThread();
    }

    @Override
    public Dimension minimumSize() {
        return new Dimension(this.defaultAppletSize.width, this.defaultAppletSize.height);
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(this.currentAppletSize.width, this.currentAppletSize.height);
    }

    public synchronized void addAppletListener(AppletListener l) {
        this.listeners = AppletEventMulticaster.add(this.listeners, l);
    }

    public synchronized void removeAppletListener(AppletListener l) {
        this.listeners = AppletEventMulticaster.remove(this.listeners, l);
    }

    public void dispatchAppletEvent(int id, Object argument) {
        if (this.listeners != null) {
            AppletEvent evt = new AppletEvent(this, id, argument);
            this.listeners.appletStateChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(int id) {
        AppletPanel appletPanel = this;
        synchronized (appletPanel) {
            if (this.queue == null) {
                this.queue = new Queue();
            }
            Integer eventId = id;
            this.queue.enqueue(eventId);
            this.notifyAll();
        }
        if (id == 6) {
            try {
                this.joinAppletThread();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.loader == null) {
                this.loader = this.getClassLoader(this.getCodeBase(), this.getClassLoaderCacheKey());
            }
            this.release();
        }
    }

    protected synchronized AppletEvent getNextEvent() throws InterruptedException {
        while (this.queue == null || this.queue.isEmpty()) {
            this.wait();
        }
        Integer eventId = (Integer)this.queue.dequeue();
        return new AppletEvent(this, eventId, null);
    }

    boolean emptyEventQueue() {
        return this.queue == null || this.queue.isEmpty();
    }

    private void setExceptionStatus(AccessControlException e) {
        Permission p = e.getPermission();
        if (p instanceof RuntimePermission && p.getName().startsWith("modifyThread")) {
            if (this.loader == null) {
                this.loader = this.getClassLoader(this.getCodeBase(), this.getClassLoaderCacheKey());
            }
            this.loader.setExceptionStatus();
        }
    }

    @Override
    public void run() {
        Thread curThread = Thread.currentThread();
        if (curThread == this.loaderThread) {
            this.runLoader();
            return;
        }
        boolean disposed = false;
        while (!disposed && !curThread.isInterrupted()) {
            AppletEvent evt;
            try {
                evt = this.getNextEvent();
            }
            catch (InterruptedException e) {
                this.showAppletStatus("bail");
                return;
            }
            try {
                switch (evt.getID()) {
                    case 1: {
                        if (!this.okToLoad() || this.loaderThread != null) break;
                        this.setLoaderThread(new Thread(this));
                        this.loaderThread.start();
                        this.loaderThread.join();
                        this.setLoaderThread(null);
                        break;
                    }
                    case 2: {
                        AppletPanel p;
                        Font f;
                        if (this.status != 1 && this.status != 5) {
                            this.showAppletStatus("notloaded");
                            break;
                        }
                        this.applet.resize(this.defaultAppletSize);
                        if (this.doInit) {
                            if (PerformanceLogger.loggingEnabled()) {
                                PerformanceLogger.setTime("Applet Init");
                                PerformanceLogger.outputLog();
                            }
                            this.applet.init();
                        }
                        if ((f = this.getFont()) == null || "dialog".equals(f.getFamily().toLowerCase(Locale.ENGLISH)) && f.getSize() == 12 && f.getStyle() == 0) {
                            this.setFont(new Font("Dialog", 0, 12));
                        }
                        this.doInit = true;
                        try {
                            p = this;
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    p.validate();
                                }
                            });
                        }
                        catch (InterruptedException ie) {
                        }
                        catch (InvocationTargetException ite) {
                            // empty catch block
                        }
                        this.status = 2;
                        this.showAppletStatus("inited");
                        break;
                    }
                    case 3: {
                        AppletPanel p;
                        if (this.status != 2 && this.status != 4) {
                            this.showAppletStatus("notinited");
                            break;
                        }
                        this.applet.resize(this.currentAppletSize);
                        this.applet.start();
                        try {
                            p = this;
                            final Applet a = this.applet;
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    p.validate();
                                    a.setVisible(true);
                                    if (AppletPanel.this.hasInitialFocus()) {
                                        AppletPanel.this.setDefaultFocus();
                                    }
                                }
                            });
                        }
                        catch (InterruptedException ie) {
                        }
                        catch (InvocationTargetException ite) {
                            // empty catch block
                        }
                        this.status = 3;
                        this.showAppletStatus("started");
                        break;
                    }
                    case 4: {
                        Applet a;
                        if (this.status != 3) {
                            this.showAppletStatus("notstarted");
                            break;
                        }
                        this.status = 4;
                        try {
                            a = this.applet;
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    a.setVisible(false);
                                }
                            });
                        }
                        catch (InterruptedException ie) {
                        }
                        catch (InvocationTargetException ite) {
                            // empty catch block
                        }
                        try {
                            this.applet.stop();
                        }
                        catch (AccessControlException e) {
                            this.setExceptionStatus(e);
                            throw e;
                        }
                        this.showAppletStatus("stopped");
                        break;
                    }
                    case 5: {
                        if (this.status != 4 && this.status != 2) {
                            this.showAppletStatus("notstopped");
                            break;
                        }
                        this.status = 5;
                        try {
                            this.applet.destroy();
                        }
                        catch (AccessControlException e) {
                            this.setExceptionStatus(e);
                            throw e;
                        }
                        this.showAppletStatus("destroyed");
                        break;
                    }
                    case 0: {
                        Applet a;
                        if (this.status != 5 && this.status != 1) {
                            this.showAppletStatus("notdestroyed");
                            break;
                        }
                        this.status = 0;
                        try {
                            a = this.applet;
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    AppletPanel.this.remove(a);
                                }
                            });
                        }
                        catch (InterruptedException ie) {
                        }
                        catch (InvocationTargetException ite) {
                            // empty catch block
                        }
                        this.applet = null;
                        this.showAppletStatus("disposed");
                        disposed = true;
                        break;
                    }
                    case 6: {
                        return;
                    }
                }
            }
            catch (Exception e) {
                this.status = 7;
                if (e.getMessage() != null) {
                    this.showAppletStatus("exception2", e.getClass().getName(), e.getMessage());
                } else {
                    this.showAppletStatus("exception", e.getClass().getName());
                }
                this.showAppletException(e);
            }
            catch (ThreadDeath e) {
                this.showAppletStatus("death");
                return;
            }
            catch (Error e) {
                this.status = 7;
                if (e.getMessage() != null) {
                    this.showAppletStatus("error2", e.getClass().getName(), e.getMessage());
                } else {
                    this.showAppletStatus("error", e.getClass().getName());
                }
                this.showAppletException(e);
            }
            this.clearLoadAbortRequest();
        }
    }

    private Component getMostRecentFocusOwnerForWindow(Window w) {
        Method meth = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method meth = null;
                try {
                    meth = KeyboardFocusManager.class.getDeclaredMethod("getMostRecentFocusOwner", Window.class);
                    meth.setAccessible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return meth;
            }
        });
        if (meth != null) {
            try {
                return (Component)meth.invoke(null, w);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return w.getMostRecentFocusOwner();
    }

    private void setDefaultFocus() {
        Component toFocus = null;
        Container parent = this.getParent();
        if (parent != null) {
            if (parent instanceof Window) {
                toFocus = this.getMostRecentFocusOwnerForWindow((Window)parent);
                if (toFocus == parent || toFocus == null) {
                    toFocus = parent.getFocusTraversalPolicy().getInitialComponent((Window)parent);
                }
            } else if (parent.isFocusCycleRoot()) {
                toFocus = parent.getFocusTraversalPolicy().getDefaultComponent(parent);
            }
        }
        if (toFocus != null) {
            if (parent instanceof EmbeddedFrame) {
                ((EmbeddedFrame)parent).synthesizeWindowActivation(true);
            }
            toFocus.requestFocusInWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runLoader() {
        if (this.status != 0) {
            this.showAppletStatus("notdisposed");
            return;
        }
        this.dispatchAppletEvent(51235, null);
        this.status = 1;
        this.loader = this.getClassLoader(this.getCodeBase(), this.getClassLoaderCacheKey());
        String code = this.getCode();
        this.setupAppletAppContext();
        try {
            this.loadJarFiles(this.loader);
            this.applet = this.createApplet(this.loader);
        }
        catch (ClassNotFoundException e) {
            this.status = 7;
            this.showAppletStatus("notfound", code);
            this.showAppletLog("notfound", code);
            this.showAppletException(e);
            return;
        }
        catch (InstantiationException e) {
            this.status = 7;
            this.showAppletStatus("nocreate", code);
            this.showAppletLog("nocreate", code);
            this.showAppletException(e);
            return;
        }
        catch (IllegalAccessException e) {
            this.status = 7;
            this.showAppletStatus("noconstruct", code);
            this.showAppletLog("noconstruct", code);
            this.showAppletException(e);
            return;
        }
        catch (Exception e) {
            this.status = 7;
            this.showAppletStatus("exception", e.getMessage());
            this.showAppletException(e);
            return;
        }
        catch (ThreadDeath e) {
            this.status = 7;
            this.showAppletStatus("death");
            return;
        }
        catch (Error e) {
            this.status = 7;
            this.showAppletStatus("error", e.getMessage());
            this.showAppletException(e);
            return;
        }
        finally {
            this.dispatchAppletEvent(51236, null);
        }
        if (this.applet != null) {
            this.applet.setStub(this);
            this.applet.hide();
            this.add("Center", this.applet);
            this.showAppletStatus("loaded");
            this.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Applet createApplet(final AppletClassLoader loader) throws ClassNotFoundException, IllegalAccessException, IOException, InstantiationException, InterruptedException {
        final String serName = this.getSerializedObject();
        String code = this.getCode();
        if (code != null && serName != null) {
            System.err.println(amh.getMessage("runloader.err"));
            throw new InstantiationException("Either \"code\" or \"object\" should be specified, but not both.");
        }
        if (code == null && serName == null) {
            String msg = "nocode";
            this.status = 7;
            this.showAppletStatus(msg);
            this.showAppletLog(msg);
            this.repaint();
        }
        if (code != null) {
            this.applet = (Applet)loader.loadCode(code).newInstance();
            this.doInit = true;
        } else {
            InputStream is = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return loader.getResourceAsStream(serName);
                }
            });
            AppletObjectInputStream ois = new AppletObjectInputStream(is, loader);
            Object serObject = ois.readObject();
            this.applet = (Applet)serObject;
            this.doInit = false;
        }
        this.findAppletJDKLevel(this.applet);
        if (Thread.interrupted()) {
            try {
                this.status = 0;
                this.applet = null;
                this.showAppletStatus("death");
            }
            finally {
                Thread.currentThread().interrupt();
            }
            return null;
        }
        return this.applet;
    }

    protected void loadJarFiles(AppletClassLoader loader) throws IOException, InterruptedException {
        String jarFiles = this.getJarFiles();
        if (jarFiles != null) {
            StringTokenizer st = new StringTokenizer(jarFiles, ",", false);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken().trim();
                try {
                    loader.addJar(tok);
                }
                catch (IllegalArgumentException e) {}
            }
        }
    }

    protected synchronized void stopLoading() {
        if (this.loaderThread != null) {
            this.loaderThread.interrupt();
        } else {
            this.setLoadAbortRequest();
        }
    }

    protected synchronized boolean okToLoad() {
        return !this.loadAbortRequest;
    }

    protected synchronized void clearLoadAbortRequest() {
        this.loadAbortRequest = false;
    }

    protected synchronized void setLoadAbortRequest() {
        this.loadAbortRequest = true;
    }

    private synchronized void setLoaderThread(Thread loaderThread) {
        this.loaderThread = loaderThread;
    }

    @Override
    public boolean isActive() {
        return this.status == 3;
    }

    @Override
    public void appletResize(int width, int height) {
        AppContext appCtxt;
        this.currentAppletSize.width = width;
        this.currentAppletSize.height = height;
        final Dimension currentSize = new Dimension(this.currentAppletSize.width, this.currentAppletSize.height);
        if (this.loader != null && (appCtxt = this.loader.getAppContext()) != null) {
            this.appEvtQ = (EventQueue)appCtxt.get(AppContext.EVENT_QUEUE_KEY);
        }
        final AppletPanel ap = this;
        if (this.appEvtQ != null) {
            this.appEvtQ.postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), new Runnable(){

                @Override
                public void run() {
                    if (ap != null) {
                        ap.dispatchAppletEvent(51234, currentSize);
                    }
                }
            }));
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.currentAppletSize.width = width;
        this.currentAppletSize.height = height;
    }

    public Applet getApplet() {
        return this.applet;
    }

    protected void showAppletStatus(String status) {
        this.getAppletContext().showStatus(amh.getMessage(status));
    }

    protected void showAppletStatus(String status, Object arg) {
        this.getAppletContext().showStatus(amh.getMessage(status, arg));
    }

    protected void showAppletStatus(String status, Object arg1, Object arg2) {
        this.getAppletContext().showStatus(amh.getMessage(status, arg1, arg2));
    }

    protected void showAppletLog(String msg) {
        System.out.println(amh.getMessage(msg));
    }

    protected void showAppletLog(String msg, Object arg) {
        System.out.println(amh.getMessage(msg, arg));
    }

    protected void showAppletException(Throwable t) {
        t.printStackTrace();
        this.repaint();
    }

    public String getClassLoaderCacheKey() {
        return this.getCodeBase().toString();
    }

    public static synchronized void flushClassLoader(String key) {
        classloaders.remove(key);
    }

    public static synchronized void flushClassLoaders() {
        classloaders = new HashMap();
    }

    protected AppletClassLoader createClassLoader(URL codebase) {
        return new AppletClassLoader(codebase);
    }

    synchronized AppletClassLoader getClassLoader(final URL codebase, final String key) {
        AppletClassLoader c = (AppletClassLoader)classloaders.get(key);
        if (c == null) {
            AccessControlContext acc = this.getAccessControlContext(codebase);
            c = (AppletClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    AppletClassLoader ac = AppletPanel.this.createClassLoader(codebase);
                    Class<?> clazz = this.getClass();
                    synchronized (clazz) {
                        AppletClassLoader res = (AppletClassLoader)classloaders.get(key);
                        if (res == null) {
                            classloaders.put(key, ac);
                            return ac;
                        }
                        return res;
                    }
                }
            }, acc);
        }
        return c;
    }

    private AccessControlContext getAccessControlContext(URL codebase) {
        Permission p;
        PermissionCollection perms = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Policy p = Policy.getPolicy();
                if (p != null) {
                    return p.getPermissions(new CodeSource(null, (Certificate[])null));
                }
                return null;
            }
        });
        if (perms == null) {
            perms = new Permissions();
        }
        perms.add(SecurityConstants.CREATE_CLASSLOADER_PERMISSION);
        URLConnection urlConnection = null;
        try {
            urlConnection = codebase.openConnection();
            p = urlConnection.getPermission();
        }
        catch (IOException ioe) {
            p = null;
        }
        if (p != null) {
            perms.add(p);
        }
        if (p instanceof FilePermission) {
            String path = p.getName();
            int endIndex = path.lastIndexOf(File.separatorChar);
            if (endIndex != -1) {
                if ((path = path.substring(0, endIndex + 1)).endsWith(File.separator)) {
                    path = path + "-";
                }
                perms.add(new FilePermission(path, "read"));
            }
        } else {
            String host;
            URL locUrl = codebase;
            if (urlConnection instanceof JarURLConnection) {
                locUrl = ((JarURLConnection)urlConnection).getJarFileURL();
            }
            if ((host = locUrl.getHost()) != null && host.length() > 0) {
                perms.add(new SocketPermission(host, "connect,accept"));
            }
        }
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(codebase, (Certificate[])null), perms);
        AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{domain});
        return acc;
    }

    public Thread getAppletHandlerThread() {
        return this.handler;
    }

    public int getAppletWidth() {
        return this.currentAppletSize.width;
    }

    public int getAppletHeight() {
        return this.currentAppletSize.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeFrameAppContext(Frame frame, AppContext newAppContext) {
        AppContext oldAppContext = SunToolkit.targetToAppContext(frame);
        if (oldAppContext == newAppContext) {
            return;
        }
        Class<Window> clazz = Window.class;
        synchronized (Window.class) {
            WeakReference weakRef = null;
            Vector<WeakReference> windowList = (Vector<WeakReference>)oldAppContext.get(Window.class);
            if (windowList != null) {
                for (WeakReference ref : windowList) {
                    if (ref.get() != frame) continue;
                    weakRef = ref;
                    break;
                }
                if (weakRef != null) {
                    windowList.remove(weakRef);
                }
            }
            SunToolkit.insertTargetMapping(frame, newAppContext);
            windowList = (Vector)newAppContext.get(Window.class);
            if (windowList == null) {
                windowList = new Vector<WeakReference>();
                newAppContext.put(Window.class, windowList);
            }
            windowList.add(weakRef);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAppletJDKLevel(Applet applet) {
        Class<?> appletClass;
        Class<?> clazz = appletClass = applet.getClass();
        synchronized (clazz) {
            Boolean jdk11Target = this.loader.isJDK11Target(appletClass);
            Boolean jdk12Target = this.loader.isJDK12Target(appletClass);
            if (jdk11Target != null || jdk12Target != null) {
                this.jdk11Applet = jdk11Target == null ? false : jdk11Target;
                this.jdk12Applet = jdk12Target == null ? false : jdk12Target;
                return;
            }
            String name = appletClass.getName();
            name = name.replace('.', '/');
            final String resourceName = name + ".class";
            InputStream is = null;
            byte[] classHeader = new byte[8];
            try {
                is = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return AppletPanel.this.loader.getResourceAsStream(resourceName);
                    }
                });
                int byteRead = is.read(classHeader, 0, 8);
                is.close();
                if (byteRead != 8) {
                    return;
                }
            }
            catch (IOException e) {
                return;
            }
            int major_version = this.readShort(classHeader, 6);
            if (major_version < 46) {
                this.jdk11Applet = true;
            } else if (major_version == 46) {
                this.jdk12Applet = true;
            }
            this.loader.setJDK11Target(appletClass, this.jdk11Applet);
            this.loader.setJDK12Target(appletClass, this.jdk12Applet);
        }
    }

    protected boolean isJDK11Applet() {
        return this.jdk11Applet;
    }

    protected boolean isJDK12Applet() {
        return this.jdk12Applet;
    }

    private int readShort(byte[] b, int off) {
        int hi = this.readByte(b[off]);
        int lo = this.readByte(b[off + 1]);
        return hi << 8 | lo;
    }

    private int readByte(byte b) {
        return b & 0xFF;
    }
}

