/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.lang.reflect.Constructor;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.InternationalFormatter;

public class NumberFormatter
extends InternationalFormatter {
    private String specialChars;

    public NumberFormatter() {
        this(NumberFormat.getNumberInstance());
    }

    public NumberFormatter(NumberFormat format) {
        super(format);
        this.setFormat(format);
        this.setAllowsInvalid(true);
        this.setCommitsOnValidEdit(false);
        this.setOverwriteMode(false);
    }

    @Override
    public void setFormat(Format format) {
        super.setFormat(format);
        DecimalFormatSymbols dfs = this.getDecimalFormatSymbols();
        if (dfs != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(dfs.getCurrencySymbol());
            sb.append(dfs.getDecimalSeparator());
            sb.append(dfs.getGroupingSeparator());
            sb.append(dfs.getInfinity());
            sb.append(dfs.getInternationalCurrencySymbol());
            sb.append(dfs.getMinusSign());
            sb.append(dfs.getMonetaryDecimalSeparator());
            sb.append(dfs.getNaN());
            sb.append(dfs.getPercent());
            sb.append('+');
            this.specialChars = sb.toString();
        } else {
            this.specialChars = "";
        }
    }

    @Override
    Object stringToValue(String text, Format f) throws ParseException {
        if (f == null) {
            return text;
        }
        Object value = f.parseObject(text);
        return this.convertValueToValueClass(value, this.getValueClass());
    }

    private Object convertValueToValueClass(Object value, Class valueClass) {
        if (valueClass != null && value instanceof Number) {
            Number numberValue = (Number)value;
            if (valueClass == Integer.class) {
                return numberValue.intValue();
            }
            if (valueClass == Long.class) {
                return numberValue.longValue();
            }
            if (valueClass == Float.class) {
                return Float.valueOf(numberValue.floatValue());
            }
            if (valueClass == Double.class) {
                return numberValue.doubleValue();
            }
            if (valueClass == Byte.class) {
                return numberValue.byteValue();
            }
            if (valueClass == Short.class) {
                return numberValue.shortValue();
            }
        }
        return value;
    }

    private char getPositiveSign() {
        return '+';
    }

    private char getMinusSign() {
        DecimalFormatSymbols dfs = this.getDecimalFormatSymbols();
        if (dfs != null) {
            return dfs.getMinusSign();
        }
        return '-';
    }

    private char getDecimalSeparator() {
        DecimalFormatSymbols dfs = this.getDecimalFormatSymbols();
        if (dfs != null) {
            return dfs.getDecimalSeparator();
        }
        return '.';
    }

    private DecimalFormatSymbols getDecimalFormatSymbols() {
        Format f = this.getFormat();
        if (f instanceof DecimalFormat) {
            return ((DecimalFormat)f).getDecimalFormatSymbols();
        }
        return null;
    }

    @Override
    boolean isLegalInsertText(String text) {
        if (this.getAllowsInvalid()) {
            return true;
        }
        for (int counter = text.length() - 1; counter >= 0; --counter) {
            char aChar = text.charAt(counter);
            if (Character.isDigit(aChar) || this.specialChars.indexOf(aChar) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isLiteral(Map attrs) {
        if (!super.isLiteral(attrs)) {
            if (attrs == null) {
                return false;
            }
            int size = attrs.size();
            if (attrs.get(NumberFormat.Field.GROUPING_SEPARATOR) != null) {
                --size;
                if (attrs.get(NumberFormat.Field.INTEGER) != null) {
                    --size;
                }
            }
            if (attrs.get(NumberFormat.Field.EXPONENT_SYMBOL) != null) {
                --size;
            }
            if (attrs.get(NumberFormat.Field.PERCENT) != null) {
                --size;
            }
            if (attrs.get(NumberFormat.Field.PERMILLE) != null) {
                --size;
            }
            if (attrs.get(NumberFormat.Field.CURRENCY) != null) {
                --size;
            }
            if (attrs.get(NumberFormat.Field.SIGN) != null) {
                --size;
            }
            return size == 0;
        }
        return true;
    }

    @Override
    boolean isNavigatable(int index) {
        if (!super.isNavigatable(index)) {
            return this.getBufferedChar(index) == this.getDecimalSeparator();
        }
        return true;
    }

    private NumberFormat.Field getFieldFrom(int index, int direction) {
        if (this.isValidMask()) {
            int max = this.getFormattedTextField().getDocument().getLength();
            AttributedCharacterIterator iterator = this.getIterator();
            if (index >= max) {
                index += direction;
            }
            while (index >= 0 && index < max) {
                iterator.setIndex(index);
                Map<AttributedCharacterIterator.Attribute, Object> attrs = iterator.getAttributes();
                if (attrs != null && attrs.size() > 0) {
                    for (AttributedCharacterIterator.Attribute key : attrs.keySet()) {
                        if (!(key instanceof NumberFormat.Field)) continue;
                        return (NumberFormat.Field)key;
                    }
                }
                index += direction;
            }
        }
        return null;
    }

    @Override
    void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
        if (!this.getAllowsInvalid() && length == 0 && string != null && string.length() == 1 && this.toggleSignIfNecessary(fb, offset, string.charAt(0))) {
            return;
        }
        super.replace(fb, offset, length, string, attr);
    }

    private boolean toggleSignIfNecessary(DocumentFilter.FilterBypass fb, int offset, char aChar) throws BadLocationException {
        if (aChar == this.getMinusSign() || aChar == this.getPositiveSign()) {
            NumberFormat.Field field = this.getFieldFrom(offset, -1);
            try {
                Object newValue = field == null || field != NumberFormat.Field.EXPONENT && field != NumberFormat.Field.EXPONENT_SYMBOL && field != NumberFormat.Field.EXPONENT_SIGN ? this.toggleSign(aChar == this.getPositiveSign()) : this.toggleExponentSign(offset, aChar);
                if (newValue != null && this.isValidValue(newValue, false)) {
                    int lc = this.getLiteralCountTo(offset);
                    String string = this.valueToString(newValue);
                    fb.remove(0, fb.getDocument().getLength());
                    fb.insertString(0, string, null);
                    this.updateValue(newValue);
                    this.repositionCursor(this.getLiteralCountTo(offset) - lc + offset, 1);
                    return true;
                }
            }
            catch (ParseException pe) {
                this.invalidEdit();
            }
        }
        return false;
    }

    private Object toggleSign(boolean positive) throws ParseException {
        String string;
        Object value = this.stringToValue(this.getFormattedTextField().getText());
        if (value != null && (string = value.toString()) != null && string.length() > 0) {
            if (positive) {
                if (string.charAt(0) == '-') {
                    string = string.substring(1);
                }
            } else {
                if (string.charAt(0) == '+') {
                    string = string.substring(1);
                }
                if (string.length() > 0 && string.charAt(0) != '-') {
                    string = "-" + string;
                }
            }
            if (string != null) {
                Class<?> valueClass = this.getValueClass();
                if (valueClass == null) {
                    valueClass = value.getClass();
                }
                try {
                    Constructor<?> cons = valueClass.getConstructor(String.class);
                    if (cons != null) {
                        return cons.newInstance(string);
                    }
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private Object toggleExponentSign(int offset, char aChar) throws BadLocationException, ParseException {
        String string = this.getFormattedTextField().getText();
        int replaceLength = 0;
        int loc = this.getAttributeStart(NumberFormat.Field.EXPONENT_SIGN);
        if (loc >= 0) {
            replaceLength = 1;
            offset = loc;
        }
        string = aChar == this.getPositiveSign() ? this.getReplaceString(offset, replaceLength, null) : this.getReplaceString(offset, replaceLength, new String(new char[]{aChar}));
        return this.stringToValue(string);
    }
}

