/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.nimbus.EffectUtils;
import javax.swing.plaf.nimbus.ImageCache;
import javax.swing.plaf.nimbus.LoweredBorder;
import javax.swing.plaf.nimbus.NimbusDefaults;
import javax.swing.plaf.nimbus.NimbusStyle;
import javax.swing.plaf.nimbus.TableScrollPaneCorner;
import javax.swing.plaf.nimbus.ToolBarSeparatorPainter;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import sun.security.action.GetPropertyAction;
import sun.swing.ImageIconUIResource;
import sun.swing.plaf.GTKKeybindings;
import sun.swing.plaf.WindowsKeybindings;
import sun.swing.plaf.synth.SynthIcon;

public class NimbusLookAndFeel
extends SynthLookAndFeel {
    private static final String[] COMPONENT_KEYS = new String[]{"ArrowButton", "Button", "CheckBox", "CheckBoxMenuItem", "ColorChooser", "ComboBox", "DesktopPane", "DesktopIcon", "EditorPane", "FileChooser", "FormattedTextField", "InternalFrame", "InternalFrameTitlePane", "Label", "List", "Menu", "MenuBar", "MenuItem", "OptionPane", "Panel", "PasswordField", "PopupMenu", "PopupMenuSeparator", "ProgressBar", "RadioButton", "RadioButtonMenuItem", "RootPane", "ScrollBar", "ScrollBarTrack", "ScrollBarThumb", "ScrollPane", "Separator", "Slider", "SliderTrack", "SliderThumb", "Spinner", "SplitPane", "TabbedPane", "Table", "TableHeader", "TextArea", "TextField", "TextPane", "ToggleButton", "ToolBar", "ToolTip", "Tree", "Viewport"};
    private NimbusDefaults defaults;
    private UIDefaults uiDefaults;
    private DefaultsListener defaultsListener = new DefaultsListener();
    private Map<String, Map<String, Object>> compiledDefaults = null;
    private boolean defaultListenerAdded = false;

    public NimbusLookAndFeel() {
        this.defaults = new NimbusDefaults();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.defaults.initialize();
        NimbusLookAndFeel.setStyleFactory(new SynthStyleFactory(){

            @Override
            public SynthStyle getStyle(JComponent c, Region r) {
                return NimbusLookAndFeel.this.defaults.getStyle(c, r);
            }
        });
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        this.defaults.uninitialize();
        ImageCache.getInstance().flush();
        UIManager.getDefaults().removePropertyChangeListener(this.defaultsListener);
    }

    @Override
    public UIDefaults getDefaults() {
        if (this.uiDefaults == null) {
            String osName = this.getSystemProperty("os.name");
            boolean isWindows = osName != null && osName.contains("Windows");
            this.uiDefaults = super.getDefaults();
            this.defaults.initializeDefaults(this.uiDefaults);
            if (isWindows) {
                WindowsKeybindings.installKeybindings(this.uiDefaults);
            } else {
                GTKKeybindings.installKeybindings(this.uiDefaults);
            }
            this.uiDefaults.put("TitledBorder.titlePosition", (Object)1);
            this.uiDefaults.put("TitledBorder.border", new BorderUIResource(new LoweredBorder()));
            this.uiDefaults.put("TitledBorder.titleColor", this.getDerivedColor("text", 0.0f, 0.0f, 0.23f, 0, true));
            this.uiDefaults.put("TitledBorder.font", new NimbusDefaults.DerivedFont("defaultFont", 1.0f, true, null));
            this.uiDefaults.put("OptionPane.isYesLast", (Object)(!isWindows ? 1 : 0));
            this.uiDefaults.put("Table.scrollPaneCornerComponent", TableScrollPaneCorner.class);
            this.uiDefaults.put("ToolBarSeparator[Enabled].backgroundPainter", new ToolBarSeparatorPainter());
            for (String componentKey : COMPONENT_KEYS) {
                String key = componentKey + ".foreground";
                if (!this.uiDefaults.containsKey(key)) {
                    this.uiDefaults.put(key, new NimbusProperty(componentKey, "textForeground"));
                }
                if (!this.uiDefaults.containsKey(key = componentKey + ".background")) {
                    this.uiDefaults.put(key, new NimbusProperty(componentKey, "background"));
                }
                if (!this.uiDefaults.containsKey(key = componentKey + ".font")) {
                    this.uiDefaults.put(key, new NimbusProperty(componentKey, "font"));
                }
                if (!this.uiDefaults.containsKey(key = componentKey + ".disabledText")) {
                    this.uiDefaults.put(key, new NimbusProperty(componentKey, "Disabled", "textForeground"));
                }
                if (this.uiDefaults.containsKey(key = componentKey + ".disabled")) continue;
                this.uiDefaults.put(key, new NimbusProperty(componentKey, "Disabled", "background"));
            }
            this.uiDefaults.put("FileView.computerIcon", new LinkProperty("FileChooser.homeFolderIcon"));
            this.uiDefaults.put("FileView.directoryIcon", new LinkProperty("FileChooser.directoryIcon"));
            this.uiDefaults.put("FileView.fileIcon", new LinkProperty("FileChooser.fileIcon"));
            this.uiDefaults.put("FileView.floppyDriveIcon", new LinkProperty("FileChooser.floppyDriveIcon"));
            this.uiDefaults.put("FileView.hardDriveIcon", new LinkProperty("FileChooser.hardDriveIcon"));
        }
        return this.uiDefaults;
    }

    public static NimbusStyle getStyle(JComponent c, Region r) {
        return (NimbusStyle)SynthLookAndFeel.getStyle(c, r);
    }

    @Override
    public String getName() {
        return "Nimbus";
    }

    @Override
    public String getID() {
        return "Nimbus";
    }

    @Override
    public String getDescription() {
        return "Nimbus Look and Feel";
    }

    @Override
    public boolean shouldUpdateStyleOnAncestorChanged() {
        return true;
    }

    @Override
    protected boolean shouldUpdateStyleOnEvent(PropertyChangeEvent ev) {
        String eName = ev.getPropertyName();
        if ("name" == eName || "ancestor" == eName || "Nimbus.Overrides" == eName || "Nimbus.Overrides.InheritDefaults" == eName || "JComponent.sizeVariant" == eName) {
            JComponent c = (JComponent)ev.getSource();
            this.defaults.clearOverridesCache(c);
            return true;
        }
        return super.shouldUpdateStyleOnEvent(ev);
    }

    public void register(Region region, String prefix) {
        this.defaults.register(region, prefix);
    }

    private String getSystemProperty(String key) {
        return AccessController.doPrivileged(new GetPropertyAction(key));
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        if (icon instanceof SynthIcon) {
            SynthIcon si = (SynthIcon)icon;
            BufferedImage img = EffectUtils.createCompatibleTranslucentImage(si.getIconWidth(), si.getIconHeight());
            Graphics2D gfx = img.createGraphics();
            si.paintIcon(component, gfx, 0, 0);
            gfx.dispose();
            return new ImageIconUIResource(GrayFilter.createDisabledImage(img));
        }
        return super.getDisabledIcon(component, icon);
    }

    public Color getDerivedColor(String uiDefaultParentName, float hOffset, float sOffset, float bOffset, int aOffset, boolean uiResource) {
        return this.defaults.getDerivedColor(uiDefaultParentName, hOffset, sOffset, bOffset, aOffset, uiResource);
    }

    protected final Color getDerivedColor(Color color1, Color color2, float midPoint, boolean uiResource) {
        int argb = NimbusLookAndFeel.deriveARGB(color1, color2, midPoint);
        if (uiResource) {
            return new ColorUIResource(argb);
        }
        return new Color(argb);
    }

    protected final Color getDerivedColor(Color color1, Color color2, float midPoint) {
        return this.getDerivedColor(color1, color2, midPoint, true);
    }

    static Object resolveToolbarConstraint(JToolBar toolbar) {
        LayoutManager m;
        Container parent;
        if (toolbar != null && (parent = toolbar.getParent()) != null && (m = parent.getLayout()) instanceof BorderLayout) {
            BorderLayout b = (BorderLayout)m;
            Object con = b.getConstraints(toolbar);
            if (con == "South" || con == "East" || con == "West") {
                return con;
            }
            return "North";
        }
        return "North";
    }

    static int deriveARGB(Color color1, Color color2, float midPoint) {
        int r = color1.getRed() + Math.round((float)(color2.getRed() - color1.getRed()) * midPoint);
        int g = color1.getGreen() + Math.round((float)(color2.getGreen() - color1.getGreen()) * midPoint);
        int b = color1.getBlue() + Math.round((float)(color2.getBlue() - color1.getBlue()) * midPoint);
        int a = color1.getAlpha() + Math.round((float)(color2.getAlpha() - color1.getAlpha()) * midPoint);
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    static String parsePrefix(String key) {
        if (key == null) {
            return null;
        }
        boolean inquotes = false;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '\"') {
                inquotes = !inquotes;
                continue;
            }
            if (c != '[' && c != '.' || inquotes) continue;
            return key.substring(0, i);
        }
        return null;
    }

    Map<String, Object> getDefaultsForPrefix(String prefix) {
        if (this.compiledDefaults == null) {
            this.compiledDefaults = new HashMap<String, Map<String, Object>>();
            for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                this.addDefault((String)entry.getKey(), entry.getValue());
            }
            if (!this.defaultListenerAdded) {
                UIManager.getDefaults().addPropertyChangeListener(this.defaultsListener);
                this.defaultListenerAdded = true;
            }
        }
        return this.compiledDefaults.get(prefix);
    }

    private void addDefault(String key, Object value) {
        if (this.compiledDefaults == null) {
            return;
        }
        String prefix = NimbusLookAndFeel.parsePrefix(key);
        if (prefix != null) {
            Map<String, Object> keys = this.compiledDefaults.get(prefix);
            if (keys == null) {
                keys = new HashMap<String, Object>();
                this.compiledDefaults.put(prefix, keys);
            }
            keys.put(key, value);
        }
    }

    private class DefaultsListener
    implements PropertyChangeListener {
        private DefaultsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String key = ev.getPropertyName();
            if ("UIDefaults".equals(key)) {
                NimbusLookAndFeel.this.compiledDefaults = null;
            } else {
                NimbusLookAndFeel.this.addDefault(key, ev.getNewValue());
            }
        }
    }

    private class NimbusProperty
    implements UIDefaults.ActiveValue,
    UIResource {
        private String prefix;
        private String state = null;
        private String suffix;
        private boolean isFont;

        private NimbusProperty(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.isFont = "font".equals(suffix);
        }

        private NimbusProperty(String prefix, String state, String suffix) {
            this(prefix, suffix);
            this.state = state;
        }

        @Override
        public Object createValue(UIDefaults table) {
            Object obj = null;
            if (this.state != null) {
                obj = NimbusLookAndFeel.this.uiDefaults.get(this.prefix + "[" + this.state + "]." + this.suffix);
            }
            if (obj == null) {
                obj = NimbusLookAndFeel.this.uiDefaults.get(this.prefix + "[Enabled]." + this.suffix);
            }
            if (obj == null) {
                obj = this.isFont ? NimbusLookAndFeel.this.uiDefaults.get("defaultFont") : NimbusLookAndFeel.this.uiDefaults.get(this.suffix);
            }
            return obj;
        }
    }

    private class LinkProperty
    implements UIDefaults.ActiveValue,
    UIResource {
        private String dstPropName;

        private LinkProperty(String dstPropName) {
            this.dstPropName = dstPropName;
        }

        @Override
        public Object createValue(UIDefaults table) {
            return UIManager.get(this.dstPropName);
        }
    }
}

