/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorModel;
import javax.swing.colorchooser.ColorPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DiagramComponent;
import javax.swing.colorchooser.ValueFormatter;

final class ColorChooserPanel
extends AbstractColorChooserPanel
implements PropertyChangeListener {
    private static final int MASK = -16777216;
    private final ColorModel model;
    private final ColorPanel panel;
    private final DiagramComponent slider;
    private final DiagramComponent diagram;
    private final JFormattedTextField text;
    private final JLabel label;

    ColorChooserPanel(ColorModel model) {
        this.model = model;
        this.panel = new ColorPanel(this.model);
        this.slider = new DiagramComponent(this.panel, false);
        this.diagram = new DiagramComponent(this.panel, true);
        this.text = new JFormattedTextField();
        this.label = new JLabel(null, null, 4);
        ValueFormatter.init(6, true, this.text);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ColorChooserPanel.setEnabled(this, enabled);
    }

    private static void setEnabled(Container container, boolean enabled) {
        for (Component component : container.getComponents()) {
            component.setEnabled(enabled);
            if (!(component instanceof Container)) continue;
            ColorChooserPanel.setEnabled((Container)component, enabled);
        }
    }

    @Override
    public void updateChooser() {
        Color color = this.getColorFromModel();
        if (color != null) {
            this.panel.setColor(color);
            this.text.setValue(color.getRGB());
            this.slider.repaint();
            this.diagram.repaint();
        }
    }

    @Override
    protected void buildChooser() {
        String label;
        if (0 == this.getComponentCount()) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridwidth = 2;
            gbc.weighty = 1.0;
            gbc.anchor = 11;
            gbc.fill = 2;
            gbc.insets.top = 10;
            gbc.insets.right = 10;
            this.add((Component)this.panel, gbc);
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 10;
            gbc.insets.right = 5;
            gbc.insets.bottom = 10;
            this.add((Component)this.label, gbc);
            gbc.gridx = 4;
            gbc.weightx = 0.0;
            gbc.insets.right = 10;
            this.add((Component)this.text, gbc);
            gbc.gridx = 2;
            gbc.gridheight = 2;
            gbc.anchor = 11;
            gbc.ipadx = this.text.getPreferredSize().height;
            gbc.ipady = this.getPreferredSize().height;
            this.add((Component)this.slider, gbc);
            gbc.gridx = 1;
            gbc.insets.left = 10;
            gbc.ipadx = gbc.ipady;
            this.add((Component)this.diagram, gbc);
            this.label.setLabelFor(this.text);
            this.text.addPropertyChangeListener("value", this);
            this.slider.setBorder(this.text.getBorder());
            this.diagram.setBorder(this.text.getBorder());
            ColorChooserPanel.setInheritsPopupMenu(this, true);
        }
        boolean visible = (label = this.model.getText(this, "HexCode")) != null;
        this.text.setVisible(visible);
        this.label.setVisible(visible);
        if (visible) {
            this.label.setText(label);
            int mnemonic = this.model.getInteger(this, "HexCodeMnemonic");
            if (mnemonic > 0) {
                this.label.setDisplayedMnemonic(mnemonic);
                mnemonic = this.model.getInteger(this, "HexCodeMnemonicIndex");
                if (mnemonic >= 0) {
                    this.label.setDisplayedMnemonicIndex(mnemonic);
                }
            }
        }
        this.panel.buildPanel();
    }

    @Override
    public String getDisplayName() {
        return this.model.getText(this, "Name");
    }

    @Override
    public int getMnemonic() {
        return this.model.getInteger(this, "Mnemonic");
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return this.model.getInteger(this, "DisplayedMnemonicIndex");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object object;
        ColorSelectionModel model = this.getColorSelectionModel();
        if (model != null && (object = event.getNewValue()) instanceof Integer) {
            int value = 0xFF000000 & model.getSelectedColor().getRGB() | (Integer)object;
            model.setSelectedColor(new Color(value, true));
        }
        this.text.selectAll();
    }

    private static void setInheritsPopupMenu(JComponent component, boolean value) {
        component.setInheritsPopupMenu(value);
        for (Component object : component.getComponents()) {
            if (!(object instanceof JComponent)) continue;
            ColorChooserPanel.setInheritsPopupMenu((JComponent)object, value);
        }
    }
}

