/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.InternalFrameFocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.SwingContainerOrderFocusTraversalPolicy;
import sun.util.logging.PlatformLogger;

public class SortingFocusTraversalPolicy
extends InternalFrameFocusTraversalPolicy {
    private Comparator<? super Component> comparator;
    private boolean implicitDownCycleTraversal = true;
    private PlatformLogger log = PlatformLogger.getLogger("javax.swing.SortingFocusTraversalPolicy");
    private transient Container cachedRoot;
    private transient List<Component> cachedCycle;
    private static final SwingContainerOrderFocusTraversalPolicy fitnessTestPolicy = new SwingContainerOrderFocusTraversalPolicy();
    private final int FORWARD_TRAVERSAL = 0;
    private final int BACKWARD_TRAVERSAL = 1;

    protected SortingFocusTraversalPolicy() {
    }

    public SortingFocusTraversalPolicy(Comparator<? super Component> comparator) {
        this.comparator = comparator;
    }

    private List<Component> getFocusTraversalCycle(Container aContainer) {
        ArrayList<Component> cycle = new ArrayList<Component>();
        this.enumerateAndSortCycle(aContainer, cycle);
        return cycle;
    }

    private int getComponentIndex(List<Component> cycle, Component aComponent) {
        int index;
        try {
            index = Collections.binarySearch(cycle, aComponent, this.comparator);
        }
        catch (ClassCastException e) {
            if (this.log.isLoggable(500)) {
                this.log.fine("### During the binary search for " + aComponent + " the exception occured: ", e);
            }
            return -1;
        }
        if (index < 0) {
            index = cycle.indexOf(aComponent);
        }
        return index;
    }

    private void enumerateAndSortCycle(Container focusCycleRoot, List<Component> cycle) {
        if (focusCycleRoot.isShowing()) {
            this.enumerateCycle(focusCycleRoot, cycle);
            Collections.sort(cycle, this.comparator);
        }
    }

    private void enumerateCycle(Container container, List<Component> cycle) {
        Component[] components;
        if (!container.isVisible() || !container.isDisplayable()) {
            return;
        }
        cycle.add(container);
        for (Component comp : components = container.getComponents()) {
            Container cont;
            if (!(!(comp instanceof Container) || (cont = (Container)comp).isFocusCycleRoot() || cont.isFocusTraversalPolicyProvider() || cont instanceof JComponent && ((JComponent)cont).isManagingFocus())) {
                this.enumerateCycle(cont, cycle);
                continue;
            }
            cycle.add(comp);
        }
    }

    Container getTopmostProvider(Container focusCycleRoot, Component aComponent) {
        Container aCont;
        Container ftp = null;
        for (aCont = aComponent.getParent(); aCont != focusCycleRoot && aCont != null; aCont = aCont.getParent()) {
            if (!aCont.isFocusTraversalPolicyProvider()) continue;
            ftp = aCont;
        }
        if (aCont == null) {
            return null;
        }
        return ftp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Component getComponentDownCycle(Component comp, int traversalDirection) {
        Component retComp = null;
        if (!(comp instanceof Container)) return retComp;
        Container cont = (Container)comp;
        if (cont.isFocusCycleRoot()) {
            if (!this.getImplicitDownCycleTraversal()) return null;
            retComp = cont.getFocusTraversalPolicy().getDefaultComponent(cont);
            if (retComp == null || !this.log.isLoggable(500)) return retComp;
            this.log.fine("### Transfered focus down-cycle to " + retComp + " in the focus cycle root " + cont);
            return retComp;
        } else {
            if (!cont.isFocusTraversalPolicyProvider()) return retComp;
            Component component = retComp = traversalDirection == 0 ? cont.getFocusTraversalPolicy().getDefaultComponent(cont) : cont.getFocusTraversalPolicy().getLastComponent(cont);
            if (retComp == null || !this.log.isLoggable(500)) return retComp;
            this.log.fine("### Transfered focus to " + retComp + " in the FTP provider " + cont);
        }
        return retComp;
    }

    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        int index;
        if (this.log.isLoggable(500)) {
            this.log.fine("### Searching in " + aContainer + " for component after " + aComponent);
        }
        if (aContainer == null || aComponent == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!aContainer.isFocusTraversalPolicyProvider() && !aContainer.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (aContainer.isFocusCycleRoot() && !aComponent.isFocusCycleRoot(aContainer)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Component comp = this.getComponentDownCycle(aComponent, 0);
        if (comp != null) {
            return comp;
        }
        Container provider = this.getTopmostProvider(aContainer, aComponent);
        if (provider != null) {
            FocusTraversalPolicy policy;
            Component afterComp;
            if (this.log.isLoggable(500)) {
                this.log.fine("### Asking FTP " + provider + " for component after " + aComponent);
            }
            if ((afterComp = (policy = provider.getFocusTraversalPolicy()).getComponentAfter(provider, aComponent)) != null) {
                if (this.log.isLoggable(500)) {
                    this.log.fine("### FTP returned " + afterComp);
                }
                return afterComp;
            }
            aComponent = provider;
        }
        List<Component> cycle = this.getFocusTraversalCycle(aContainer);
        if (this.log.isLoggable(500)) {
            this.log.fine("### Cycle is " + cycle + ", component is " + aComponent);
        }
        if ((index = this.getComponentIndex(cycle, aComponent)) < 0) {
            if (this.log.isLoggable(500)) {
                this.log.fine("### Didn't find component " + aComponent + " in a cycle " + aContainer);
            }
            return this.getFirstComponent(aContainer);
        }
        ++index;
        while (index < cycle.size()) {
            comp = cycle.get(index);
            if (this.accept(comp)) {
                return comp;
            }
            if ((comp = this.getComponentDownCycle(comp, 0)) != null) {
                return comp;
            }
            ++index;
        }
        if (aContainer.isFocusCycleRoot()) {
            this.cachedRoot = aContainer;
            this.cachedCycle = cycle;
            comp = this.getFirstComponent(aContainer);
            this.cachedRoot = null;
            this.cachedCycle = null;
            return comp;
        }
        return null;
    }

    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        Component comp;
        int index;
        if (aContainer == null || aComponent == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!aContainer.isFocusTraversalPolicyProvider() && !aContainer.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (aContainer.isFocusCycleRoot() && !aComponent.isFocusCycleRoot(aContainer)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Container provider = this.getTopmostProvider(aContainer, aComponent);
        if (provider != null) {
            FocusTraversalPolicy policy;
            Component beforeComp;
            if (this.log.isLoggable(500)) {
                this.log.fine("### Asking FTP " + provider + " for component after " + aComponent);
            }
            if ((beforeComp = (policy = provider.getFocusTraversalPolicy()).getComponentBefore(provider, aComponent)) != null) {
                if (this.log.isLoggable(500)) {
                    this.log.fine("### FTP returned " + beforeComp);
                }
                return beforeComp;
            }
            aComponent = provider;
            if (this.accept(aComponent)) {
                return aComponent;
            }
        }
        List<Component> cycle = this.getFocusTraversalCycle(aContainer);
        if (this.log.isLoggable(500)) {
            this.log.fine("### Cycle is " + cycle + ", component is " + aComponent);
        }
        if ((index = this.getComponentIndex(cycle, aComponent)) < 0) {
            if (this.log.isLoggable(500)) {
                this.log.fine("### Didn't find component " + aComponent + " in a cycle " + aContainer);
            }
            return this.getLastComponent(aContainer);
        }
        --index;
        while (index >= 0) {
            Component tryComp;
            comp = cycle.get(index);
            if (comp != aContainer && (tryComp = this.getComponentDownCycle(comp, 1)) != null) {
                return tryComp;
            }
            if (this.accept(comp)) {
                return comp;
            }
            --index;
        }
        if (aContainer.isFocusCycleRoot()) {
            this.cachedRoot = aContainer;
            this.cachedCycle = cycle;
            comp = this.getLastComponent(aContainer);
            this.cachedRoot = null;
            this.cachedCycle = null;
            return comp;
        }
        return null;
    }

    @Override
    public Component getFirstComponent(Container aContainer) {
        if (this.log.isLoggable(500)) {
            this.log.fine("### Getting first component in " + aContainer);
        }
        if (aContainer == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        List<Component> cycle = this.cachedRoot == aContainer ? this.cachedCycle : this.getFocusTraversalCycle(aContainer);
        if (cycle.size() == 0) {
            if (this.log.isLoggable(500)) {
                this.log.fine("### Cycle is empty");
            }
            return null;
        }
        if (this.log.isLoggable(500)) {
            this.log.fine("### Cycle is " + cycle);
        }
        for (Component comp : cycle) {
            if (this.accept(comp)) {
                return comp;
            }
            if (comp == aContainer || (comp = this.getComponentDownCycle(comp, 0)) == null) continue;
            return comp;
        }
        return null;
    }

    @Override
    public Component getLastComponent(Container aContainer) {
        if (this.log.isLoggable(500)) {
            this.log.fine("### Getting last component in " + aContainer);
        }
        if (aContainer == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        List<Component> cycle = this.cachedRoot == aContainer ? this.cachedCycle : this.getFocusTraversalCycle(aContainer);
        if (cycle.size() == 0) {
            if (this.log.isLoggable(500)) {
                this.log.fine("### Cycle is empty");
            }
            return null;
        }
        if (this.log.isLoggable(500)) {
            this.log.fine("### Cycle is " + cycle);
        }
        for (int i = cycle.size() - 1; i >= 0; --i) {
            Container cont;
            Component comp = cycle.get(i);
            if (this.accept(comp)) {
                return comp;
            }
            if (!(comp instanceof Container) || comp == aContainer || !(cont = (Container)comp).isFocusTraversalPolicyProvider()) continue;
            return cont.getFocusTraversalPolicy().getLastComponent(cont);
        }
        return null;
    }

    @Override
    public Component getDefaultComponent(Container aContainer) {
        return this.getFirstComponent(aContainer);
    }

    public void setImplicitDownCycleTraversal(boolean implicitDownCycleTraversal) {
        this.implicitDownCycleTraversal = implicitDownCycleTraversal;
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    protected void setComparator(Comparator<? super Component> comparator) {
        this.comparator = comparator;
    }

    protected Comparator<? super Component> getComparator() {
        return this.comparator;
    }

    protected boolean accept(Component aComponent) {
        return fitnessTestPolicy.accept(aComponent);
    }
}

