/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.StringTokenizer;

public class JMXServiceURL
implements Serializable {
    private static final long serialVersionUID = 8173364409860779292L;
    private static final Exception randomException;
    private static final BitSet alphaBitSet;
    private static final BitSet numericBitSet;
    private static final BitSet alphaNumericBitSet;
    private static final BitSet protocolBitSet;
    private static final BitSet hostNameBitSet;
    private final String protocol;
    private final String host;
    private final int port;
    private final String urlPath;
    private transient String toString;
    private static final ClassLogger logger;

    public JMXServiceURL(String serviceURL) throws MalformedURLException {
        int urlPathStart;
        int portEnd;
        int hostEnd;
        int serviceURLLength = serviceURL.length();
        for (int i = 0; i < serviceURLLength; ++i) {
            char c = serviceURL.charAt(i);
            if (c >= ' ' && c < '\u007f') continue;
            throw new MalformedURLException("Service URL contains non-ASCII character 0x" + Integer.toHexString(c));
        }
        String requiredPrefix = "service:jmx:";
        int requiredPrefixLength = "service:jmx:".length();
        if (!serviceURL.regionMatches(true, 0, "service:jmx:", 0, requiredPrefixLength)) {
            throw new MalformedURLException("Service URL must start with service:jmx:");
        }
        int protoStart = requiredPrefixLength;
        int protoEnd = JMXServiceURL.indexOf(serviceURL, ':', protoStart);
        this.protocol = serviceURL.substring(protoStart, protoEnd).toLowerCase();
        if (!serviceURL.regionMatches(protoEnd, "://", 0, 3)) {
            throw new MalformedURLException("Missing \"://\" after protocol name");
        }
        int hostStart = protoEnd + 3;
        if (hostStart < serviceURLLength && serviceURL.charAt(hostStart) == '[') {
            hostEnd = serviceURL.indexOf(93, hostStart) + 1;
            if (hostEnd == 0) {
                throw new MalformedURLException("Bad host name: [ without ]");
            }
            this.host = serviceURL.substring(hostStart + 1, hostEnd - 1);
            if (!JMXServiceURL.isNumericIPv6Address(this.host)) {
                throw new MalformedURLException("Address inside [...] must be numeric IPv6 address");
            }
        } else {
            hostEnd = JMXServiceURL.indexOfFirstNotInSet(serviceURL, hostNameBitSet, hostStart);
            this.host = serviceURL.substring(hostStart, hostEnd);
        }
        if (hostEnd < serviceURLLength && serviceURL.charAt(hostEnd) == ':') {
            if (this.host.length() == 0) {
                throw new MalformedURLException("Cannot give port number without host name");
            }
            int portStart = hostEnd + 1;
            portEnd = JMXServiceURL.indexOfFirstNotInSet(serviceURL, numericBitSet, portStart);
            String portString = serviceURL.substring(portStart, portEnd);
            try {
                this.port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new MalformedURLException("Bad port number: \"" + portString + "\": " + e);
            }
        } else {
            portEnd = hostEnd;
            this.port = 0;
        }
        this.urlPath = (urlPathStart = portEnd) < serviceURLLength ? serviceURL.substring(urlPathStart) : "";
        this.validate();
    }

    public JMXServiceURL(String protocol, String host, int port) throws MalformedURLException {
        this(protocol, host, port, null);
    }

    public JMXServiceURL(String protocol, String host, int port, String urlPath) throws MalformedURLException {
        if (protocol == null) {
            protocol = "jmxmp";
        }
        if (host == null) {
            InetAddress local;
            try {
                local = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new MalformedURLException("Local host name unknown: " + e);
            }
            host = local.getHostName();
            try {
                JMXServiceURL.validateHost(host);
            }
            catch (MalformedURLException e) {
                if (logger.fineOn()) {
                    logger.fine("JMXServiceURL", "Replacing illegal local host name " + host + " with numeric IP address " + "(see RFC 1034)", e);
                }
                host = local.getHostAddress();
            }
        }
        if (host.startsWith("[")) {
            if (!host.endsWith("]")) {
                throw new MalformedURLException("Host starts with [ but does not end with ]");
            }
            if (!JMXServiceURL.isNumericIPv6Address(host = host.substring(1, host.length() - 1))) {
                throw new MalformedURLException("Address inside [...] must be numeric IPv6 address");
            }
            if (host.startsWith("[")) {
                throw new MalformedURLException("More than one [[...]]");
            }
        }
        this.protocol = protocol.toLowerCase();
        this.host = host;
        this.port = port;
        if (urlPath == null) {
            urlPath = "";
        }
        this.urlPath = urlPath;
        this.validate();
    }

    private void validate() throws MalformedURLException {
        int protoEnd = JMXServiceURL.indexOfFirstNotInSet(this.protocol, protocolBitSet, 0);
        if (protoEnd == 0 || protoEnd < this.protocol.length() || !alphaBitSet.get(this.protocol.charAt(0))) {
            throw new MalformedURLException("Missing or invalid protocol name: \"" + this.protocol + "\"");
        }
        this.validateHost();
        if (this.port < 0) {
            throw new MalformedURLException("Bad port: " + this.port);
        }
        if (this.urlPath.length() > 0 && !this.urlPath.startsWith("/") && !this.urlPath.startsWith(";")) {
            throw new MalformedURLException("Bad URL path: " + this.urlPath);
        }
    }

    private void validateHost() throws MalformedURLException {
        if (this.host.length() == 0) {
            if (this.port != 0) {
                throw new MalformedURLException("Cannot give port number without host name");
            }
            return;
        }
        JMXServiceURL.validateHost(this.host);
    }

    private static void validateHost(String h) throws MalformedURLException {
        if (JMXServiceURL.isNumericIPv6Address(h)) {
            try {
                InetAddress.getByName(h);
            }
            catch (Exception e) {
                MalformedURLException bad = new MalformedURLException("Bad IPv6 address: " + h);
                EnvHelp.initCause(bad, e);
                throw bad;
            }
        }
        int hostLen = h.length();
        int lastc = 46;
        boolean sawDot = false;
        int componentStart = 0;
        for (int i = 0; i < hostLen; ++i) {
            char c = h.charAt(i);
            boolean isAlphaNumeric = alphaNumericBitSet.get(c);
            if (lastc == 46) {
                componentStart = c;
            }
            if (isAlphaNumeric) {
                lastc = 97;
                continue;
            }
            if (c == '-') {
                if (lastc == 46) break;
                lastc = 45;
                continue;
            }
            if (c == '.') {
                sawDot = true;
                if (lastc != 97) break;
                lastc = 46;
                continue;
            }
            lastc = 46;
            break;
        }
        try {
            if (lastc != 97) {
                throw randomException;
            }
            if (sawDot && !alphaBitSet.get(componentStart)) {
                StringTokenizer tok = new StringTokenizer(h, ".", true);
                for (int i = 0; i < 4; ++i) {
                    String ns = tok.nextToken();
                    int n = Integer.parseInt(ns);
                    if (n < 0 || n > 255) {
                        throw randomException;
                    }
                    if (i >= 3 || tok.nextToken().equals(".")) continue;
                    throw randomException;
                }
                if (tok.hasMoreTokens()) {
                    throw randomException;
                }
            }
        }
        catch (Exception e) {
            throw new MalformedURLException("Bad host: \"" + h + "\"");
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getURLPath() {
        return this.urlPath;
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        StringBuilder buf = new StringBuilder("service:jmx:");
        buf.append(this.getProtocol()).append("://");
        String getHost = this.getHost();
        if (JMXServiceURL.isNumericIPv6Address(getHost)) {
            buf.append('[').append(getHost).append(']');
        } else {
            buf.append(getHost);
        }
        int getPort = this.getPort();
        if (getPort != 0) {
            buf.append(':').append(getPort);
        }
        buf.append(this.getURLPath());
        this.toString = buf.toString();
        return this.toString;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JMXServiceURL)) {
            return false;
        }
        JMXServiceURL u = (JMXServiceURL)obj;
        return u.getProtocol().equalsIgnoreCase(this.getProtocol()) && u.getHost().equalsIgnoreCase(this.getHost()) && u.getPort() == this.getPort() && u.getURLPath().equals(this.getURLPath());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static boolean isNumericIPv6Address(String s) {
        return s.indexOf(58) >= 0;
    }

    private static int indexOf(String s, char c, int fromIndex) {
        int index = s.indexOf(c, fromIndex);
        if (index < 0) {
            return s.length();
        }
        return index;
    }

    private static int indexOfFirstNotInSet(String s, BitSet set, int fromIndex) {
        char c;
        int i;
        int slen = s.length();
        for (i = fromIndex; i < slen && (c = s.charAt(i)) < '\u0080' && set.get(c); ++i) {
        }
        return i;
    }

    static {
        int c;
        randomException = new Exception();
        alphaBitSet = new BitSet(128);
        numericBitSet = new BitSet(128);
        alphaNumericBitSet = new BitSet(128);
        protocolBitSet = new BitSet(128);
        hostNameBitSet = new BitSet(128);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            numericBitSet.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            alphaBitSet.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            alphaBitSet.set(c);
        }
        alphaNumericBitSet.or(alphaBitSet);
        alphaNumericBitSet.or(numericBitSet);
        protocolBitSet.or(alphaNumericBitSet);
        protocolBitSet.set(43);
        protocolBitSet.set(45);
        hostNameBitSet.or(alphaNumericBitSet);
        hostNameBitSet.set(45);
        hostNameBitSet.set(46);
        logger = new ClassLogger("javax.management.remote.misc", "JMXServiceURL");
    }
}

