/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.relation.RelationService;

public class RelationNotification
extends Notification {
    private static final long oldSerialVersionUID = -2126464566505527147L;
    private static final long newSerialVersionUID = -6871117877523310399L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myNewRoleValue", ArrayList.class), new ObjectStreamField("myOldRoleValue", ArrayList.class), new ObjectStreamField("myRelId", String.class), new ObjectStreamField("myRelObjName", ObjectName.class), new ObjectStreamField("myRelTypeName", String.class), new ObjectStreamField("myRoleName", String.class), new ObjectStreamField("myUnregMBeanList", ArrayList.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("newRoleValue", List.class), new ObjectStreamField("oldRoleValue", List.class), new ObjectStreamField("relationId", String.class), new ObjectStreamField("relationObjName", ObjectName.class), new ObjectStreamField("relationTypeName", String.class), new ObjectStreamField("roleName", String.class), new ObjectStreamField("unregisterMBeanList", List.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    public static final String RELATION_BASIC_CREATION = "jmx.relation.creation.basic";
    public static final String RELATION_MBEAN_CREATION = "jmx.relation.creation.mbean";
    public static final String RELATION_BASIC_UPDATE = "jmx.relation.update.basic";
    public static final String RELATION_MBEAN_UPDATE = "jmx.relation.update.mbean";
    public static final String RELATION_BASIC_REMOVAL = "jmx.relation.removal.basic";
    public static final String RELATION_MBEAN_REMOVAL = "jmx.relation.removal.mbean";
    private String relationId = null;
    private String relationTypeName = null;
    private ObjectName relationObjName = null;
    private List<ObjectName> unregisterMBeanList = null;
    private String roleName = null;
    private List<ObjectName> oldRoleValue = null;
    private List<ObjectName> newRoleValue = null;

    public RelationNotification(String notifType, Object sourceObj, long sequence, long timeStamp, String message, String id, String typeName, ObjectName objectName, List<ObjectName> unregMBeanList) throws IllegalArgumentException {
        super(notifType, sourceObj, sequence, timeStamp, message);
        this.initMembers(1, notifType, sourceObj, sequence, timeStamp, message, id, typeName, objectName, unregMBeanList, null, null, null);
    }

    public RelationNotification(String notifType, Object sourceObj, long sequence, long timeStamp, String message, String id, String typeName, ObjectName objectName, String name, List<ObjectName> newValue, List<ObjectName> oldValue) throws IllegalArgumentException {
        super(notifType, sourceObj, sequence, timeStamp, message);
        this.initMembers(2, notifType, sourceObj, sequence, timeStamp, message, id, typeName, objectName, null, name, newValue, oldValue);
    }

    public String getRelationId() {
        return this.relationId;
    }

    public String getRelationTypeName() {
        return this.relationTypeName;
    }

    public ObjectName getObjectName() {
        return this.relationObjName;
    }

    public List<ObjectName> getMBeansToUnregister() {
        List<ObjectName> result = this.unregisterMBeanList != null ? new ArrayList<ObjectName>(this.unregisterMBeanList) : Collections.emptyList();
        return result;
    }

    public String getRoleName() {
        String result = null;
        if (this.roleName != null) {
            result = this.roleName;
        }
        return result;
    }

    public List<ObjectName> getOldRoleValue() {
        List<ObjectName> result = this.oldRoleValue != null ? new ArrayList<ObjectName>(this.oldRoleValue) : Collections.emptyList();
        return result;
    }

    public List<ObjectName> getNewRoleValue() {
        List<ObjectName> result = this.newRoleValue != null ? new ArrayList<ObjectName>(this.newRoleValue) : Collections.emptyList();
        return result;
    }

    private void initMembers(int notifKind, String notifType, Object sourceObj, long sequence, long timeStamp, String message, String id, String typeName, ObjectName objectName, List<ObjectName> unregMBeanList, String name, List<ObjectName> newValue, List<ObjectName> oldValue) throws IllegalArgumentException {
        boolean badInitFlg = false;
        if (notifType == null || sourceObj == null || !(sourceObj instanceof RelationService) && !(sourceObj instanceof ObjectName) || id == null || typeName == null) {
            badInitFlg = true;
        }
        if (notifKind == 1) {
            if (!(notifType.equals(RELATION_BASIC_CREATION) || notifType.equals(RELATION_MBEAN_CREATION) || notifType.equals(RELATION_BASIC_REMOVAL) || notifType.equals(RELATION_MBEAN_REMOVAL))) {
                badInitFlg = true;
            }
        } else if (notifKind == 2 && (!notifType.equals(RELATION_BASIC_UPDATE) && !notifType.equals(RELATION_MBEAN_UPDATE) || name == null || oldValue == null || newValue == null)) {
            badInitFlg = true;
        }
        if (badInitFlg) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        this.relationId = id;
        this.relationTypeName = typeName;
        this.relationObjName = objectName;
        if (unregMBeanList != null) {
            this.unregisterMBeanList = new ArrayList<ObjectName>(unregMBeanList);
        }
        if (name != null) {
            this.roleName = name;
        }
        if (oldValue != null) {
            this.oldRoleValue = new ArrayList<ObjectName>(oldValue);
        }
        if (newValue != null) {
            this.newRoleValue = new ArrayList<ObjectName>(newValue);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField fields = in.readFields();
            this.newRoleValue = (List)Util.cast(fields.get("myNewRoleValue", null));
            if (fields.defaulted("myNewRoleValue")) {
                throw new NullPointerException("newRoleValue");
            }
            this.oldRoleValue = (List)Util.cast(fields.get("myOldRoleValue", null));
            if (fields.defaulted("myOldRoleValue")) {
                throw new NullPointerException("oldRoleValue");
            }
            this.relationId = (String)fields.get("myRelId", null);
            if (fields.defaulted("myRelId")) {
                throw new NullPointerException("relationId");
            }
            this.relationObjName = (ObjectName)fields.get("myRelObjName", null);
            if (fields.defaulted("myRelObjName")) {
                throw new NullPointerException("relationObjName");
            }
            this.relationTypeName = (String)fields.get("myRelTypeName", null);
            if (fields.defaulted("myRelTypeName")) {
                throw new NullPointerException("relationTypeName");
            }
            this.roleName = (String)fields.get("myRoleName", null);
            if (fields.defaulted("myRoleName")) {
                throw new NullPointerException("roleName");
            }
            this.unregisterMBeanList = (List)Util.cast(fields.get("myUnregMBeanList", null));
            if (fields.defaulted("myUnregMBeanList")) {
                throw new NullPointerException("unregisterMBeanList");
            }
        } else {
            in.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("myNewRoleValue", this.newRoleValue);
            fields.put("myOldRoleValue", this.oldRoleValue);
            fields.put("myRelId", this.relationId);
            fields.put("myRelObjName", this.relationObjName);
            fields.put("myRelTypeName", this.relationTypeName);
            fields.put("myRoleName", this.roleName);
            fields.put("myUnregMBeanList", this.unregisterMBeanList);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -2126464566505527147L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -6871117877523310399L;
        }
    }
}

