/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import com.sun.jmx.remote.util.EnvHelp;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.DescriptorRead;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

public class OpenMBeanAttributeInfoSupport
extends MBeanAttributeInfo
implements OpenMBeanAttributeInfo {
    static final long serialVersionUID = -4867215622149721849L;
    private OpenType<?> openType;
    private final Object defaultValue;
    private final Set<?> legalValues;
    private final Comparable<?> minValue;
    private final Comparable<?> maxValue;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType<?> openType, boolean isReadable, boolean isWritable, boolean isIs) {
        this(name, description, (OpenType)openType, isReadable, isWritable, isIs, (Object)null);
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType<?> openType, boolean isReadable, boolean isWritable, boolean isIs, Descriptor descriptor) {
        super(name, openType == null ? null : openType.getClassName(), description, isReadable, isWritable, isIs, ImmutableDescriptor.union(descriptor, openType == null ? null : openType.getDescriptor()));
        this.openType = openType;
        descriptor = this.getDescriptor();
        this.defaultValue = OpenMBeanAttributeInfoSupport.valueFrom(descriptor, "defaultValue", openType);
        this.legalValues = OpenMBeanAttributeInfoSupport.valuesFrom(descriptor, "legalValues", openType);
        this.minValue = OpenMBeanAttributeInfoSupport.comparableValueFrom(descriptor, "minValue", openType);
        this.maxValue = OpenMBeanAttributeInfoSupport.comparableValueFrom(descriptor, "maxValue", openType);
        try {
            OpenMBeanAttributeInfoSupport.check(this);
        }
        catch (OpenDataException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public <T> OpenMBeanAttributeInfoSupport(String name, String description, OpenType<T> openType, boolean isReadable, boolean isWritable, boolean isIs, T defaultValue) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs, defaultValue, null);
    }

    public <T> OpenMBeanAttributeInfoSupport(String name, String description, OpenType<T> openType, boolean isReadable, boolean isWritable, boolean isIs, T defaultValue, T[] legalValues) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs, defaultValue, legalValues, null, null);
    }

    public <T> OpenMBeanAttributeInfoSupport(String name, String description, OpenType<T> openType, boolean isReadable, boolean isWritable, boolean isIs, T defaultValue, Comparable<T> minValue, Comparable<T> maxValue) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs, defaultValue, null, minValue, maxValue);
    }

    private <T> OpenMBeanAttributeInfoSupport(String name, String description, OpenType<T> openType, boolean isReadable, boolean isWritable, boolean isIs, T defaultValue, T[] legalValues, Comparable<T> minValue, Comparable<T> maxValue) throws OpenDataException {
        super(name, openType == null ? null : openType.getClassName(), description, isReadable, isWritable, isIs, OpenMBeanAttributeInfoSupport.makeDescriptor(openType, defaultValue, legalValues, minValue, maxValue));
        this.openType = openType;
        Descriptor d = this.getDescriptor();
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.legalValues = (Set)d.getFieldValue("legalValues");
        OpenMBeanAttributeInfoSupport.check(this);
    }

    private Object readResolve() {
        if (this.getDescriptor().getFieldNames().length == 0) {
            OpenType xopenType = (OpenType)OpenMBeanAttributeInfoSupport.cast(this.openType);
            Set xlegalValues = (Set)OpenMBeanAttributeInfoSupport.cast(this.legalValues);
            Comparable xminValue = (Comparable)OpenMBeanAttributeInfoSupport.cast(this.minValue);
            Comparable xmaxValue = (Comparable)OpenMBeanAttributeInfoSupport.cast(this.maxValue);
            return new OpenMBeanAttributeInfoSupport(this.name, this.description, this.openType, this.isReadable(), this.isWritable(), this.isIs(), OpenMBeanAttributeInfoSupport.makeDescriptor(xopenType, this.defaultValue, xlegalValues, xminValue, xmaxValue));
        }
        return this;
    }

    static void check(OpenMBeanParameterInfo info) throws OpenDataException {
        OpenType<?> openType = info.getOpenType();
        if (openType == null) {
            throw new IllegalArgumentException("OpenType cannot be null");
        }
        if (info.getName() == null || info.getName().trim().equals("")) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (info.getDescription() == null || info.getDescription().trim().equals("")) {
            throw new IllegalArgumentException("Description cannot be null or empty");
        }
        if (info.hasDefaultValue()) {
            if (openType.isArray() || openType instanceof TabularType) {
                throw new OpenDataException("Default value not supported for ArrayType and TabularType");
            }
            if (!openType.isValue(info.getDefaultValue())) {
                String msg = "Argument defaultValue's class [\"" + info.getDefaultValue().getClass().getName() + "\"] does not match the one defined in openType[\"" + openType.getClassName() + "\"]";
                throw new OpenDataException(msg);
            }
        }
        if (info.hasLegalValues() && (info.hasMinValue() || info.hasMaxValue())) {
            throw new OpenDataException("cannot have both legalValue and minValue or maxValue");
        }
        if (info.hasMinValue() && !openType.isValue(info.getMinValue())) {
            String msg = "Type of minValue [" + info.getMinValue().getClass().getName() + "] does not match OpenType [" + openType.getClassName() + "]";
            throw new OpenDataException(msg);
        }
        if (info.hasMaxValue() && !openType.isValue(info.getMaxValue())) {
            String msg = "Type of maxValue [" + info.getMaxValue().getClass().getName() + "] does not match OpenType [" + openType.getClassName() + "]";
            throw new OpenDataException(msg);
        }
        if (info.hasDefaultValue()) {
            Object defaultValue = info.getDefaultValue();
            if (info.hasLegalValues() && !info.getLegalValues().contains(defaultValue)) {
                throw new OpenDataException("defaultValue is not contained in legalValues");
            }
            if (info.hasMinValue() && OpenMBeanAttributeInfoSupport.compare(info.getMinValue(), defaultValue) > 0) {
                throw new OpenDataException("minValue cannot be greater than defaultValue");
            }
            if (info.hasMaxValue() && OpenMBeanAttributeInfoSupport.compare(info.getMaxValue(), defaultValue) < 0) {
                throw new OpenDataException("maxValue cannot be less than defaultValue");
            }
        }
        if (info.hasLegalValues()) {
            if (openType instanceof TabularType || openType.isArray()) {
                throw new OpenDataException("Legal values not supported for TabularType and arrays");
            }
            for (Object v : info.getLegalValues()) {
                if (openType.isValue(v)) continue;
                String msg = "Element of legalValues [" + v + "] is not a valid value for the specified openType [" + openType.toString() + "]";
                throw new OpenDataException(msg);
            }
        }
        if (info.hasMinValue() && info.hasMaxValue() && OpenMBeanAttributeInfoSupport.compare(info.getMinValue(), info.getMaxValue()) > 0) {
            throw new OpenDataException("minValue cannot be greater than maxValue");
        }
    }

    static int compare(Object x, Object y) {
        return ((Comparable)x).compareTo(y);
    }

    static <T> Descriptor makeDescriptor(OpenType<T> openType, T defaultValue, T[] legalValues, Comparable<T> minValue, Comparable<T> maxValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (defaultValue != null) {
            map.put("defaultValue", defaultValue);
        }
        if (legalValues != null) {
            Set<T> set = new HashSet();
            for (T v : legalValues) {
                set.add(v);
            }
            set = Collections.unmodifiableSet(set);
            map.put("legalValues", set);
        }
        if (minValue != null) {
            map.put("minValue", minValue);
        }
        if (maxValue != null) {
            map.put("maxValue", maxValue);
        }
        if (map.isEmpty()) {
            return openType.getDescriptor();
        }
        map.put("openType", openType);
        return new ImmutableDescriptor(map);
    }

    static <T> Descriptor makeDescriptor(OpenType<T> openType, T defaultValue, Set<T> legalValues, Comparable<T> minValue, Comparable<T> maxValue) {
        Object[] legals;
        if (legalValues == null) {
            legals = null;
        } else {
            legals = (Object[])OpenMBeanAttributeInfoSupport.cast(new Object[legalValues.size()]);
            legalValues.toArray(legals);
        }
        return OpenMBeanAttributeInfoSupport.makeDescriptor(openType, defaultValue, legals, minValue, maxValue);
    }

    static <T> T valueFrom(Descriptor d, String name, OpenType<T> openType) {
        Object x = d.getFieldValue(name);
        if (x == null) {
            return null;
        }
        try {
            return OpenMBeanAttributeInfoSupport.convertFrom(x, openType);
        }
        catch (Exception e) {
            String msg = "Cannot convert descriptor field " + name + "  to " + openType.getTypeName();
            throw EnvHelp.initCause(new IllegalArgumentException(msg), e);
        }
    }

    static <T> Set<T> valuesFrom(Descriptor d, String name, OpenType<T> openType) {
        Collection<Object> coll;
        Object x = d.getFieldValue(name);
        if (x == null) {
            return null;
        }
        if (x instanceof Set) {
            Set set = (Set)x;
            boolean asis = true;
            for (Object element : set) {
                if (openType.isValue(element)) continue;
                asis = false;
                break;
            }
            if (asis) {
                return (Set)OpenMBeanAttributeInfoSupport.cast(set);
            }
            coll = set;
        } else if (x instanceof Object[]) {
            coll = Arrays.asList((Object[])x);
        } else {
            String msg = "Descriptor value for " + name + " must be a Set or " + "an array: " + x.getClass().getName();
            throw new IllegalArgumentException(msg);
        }
        HashSet<T> result = new HashSet<T>();
        for (Object e : coll) {
            result.add(OpenMBeanAttributeInfoSupport.convertFrom(e, openType));
        }
        return result;
    }

    static <T> Comparable<?> comparableValueFrom(Descriptor d, String name, OpenType<T> openType) {
        T t = OpenMBeanAttributeInfoSupport.valueFrom(d, name, openType);
        if (t == null || t instanceof Comparable) {
            return (Comparable)t;
        }
        String msg = "Descriptor field " + name + " with value " + t + " is not Comparable";
        throw new IllegalArgumentException(msg);
    }

    private static <T> T convertFrom(Object x, OpenType<T> openType) {
        if (openType.isValue(x)) {
            T t = OpenMBeanAttributeInfoSupport.cast(x);
            return t;
        }
        return OpenMBeanAttributeInfoSupport.convertFromStrings(x, openType);
    }

    private static <T> T convertFromStrings(Object x, OpenType<T> openType) {
        if (openType instanceof ArrayType) {
            return OpenMBeanAttributeInfoSupport.convertFromStringArray(x, openType);
        }
        if (x instanceof String) {
            return OpenMBeanAttributeInfoSupport.convertFromString((String)x, openType);
        }
        String msg = "Cannot convert value " + x + " of type " + x.getClass().getName() + " to type " + openType.getTypeName();
        throw new IllegalArgumentException(msg);
    }

    private static <T> T convertFromString(String s, OpenType<T> openType) {
        Constructor con;
        Method valueOf;
        Class c;
        try {
            c = (Class)OpenMBeanAttributeInfoSupport.cast(Class.forName(openType.safeGetClassName()));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.toString());
        }
        try {
            valueOf = c.getMethod("valueOf", String.class);
            if (!Modifier.isStatic(valueOf.getModifiers()) || valueOf.getReturnType() != c) {
                valueOf = null;
            }
        }
        catch (NoSuchMethodException e) {
            valueOf = null;
        }
        if (valueOf != null) {
            try {
                return c.cast(valueOf.invoke(null, s));
            }
            catch (Exception e) {
                String msg = "Could not convert \"" + s + "\" using method: " + valueOf;
                throw new IllegalArgumentException(msg, e);
            }
        }
        try {
            con = c.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            con = null;
        }
        if (con != null) {
            try {
                return con.newInstance(s);
            }
            catch (Exception e) {
                String msg = "Could not convert \"" + s + "\" using constructor: " + con;
                throw new IllegalArgumentException(msg, e);
            }
        }
        throw new IllegalArgumentException("Don't know how to convert string to " + openType.getTypeName());
    }

    private static <T> T convertFromStringArray(Object x, OpenType<T> openType) {
        OpenType<?> componentOpenType;
        Class<?> targetArrayClass;
        Class<?> stringArrayClass;
        ArrayType arrayType = (ArrayType)openType;
        OpenType<?> baseType = arrayType.getElementOpenType();
        int dim = arrayType.getDimension();
        String squareBrackets = "[";
        for (int i = 1; i < dim; ++i) {
            squareBrackets = squareBrackets + "[";
        }
        try {
            stringArrayClass = Class.forName(squareBrackets + "Ljava.lang.String;");
            targetArrayClass = Class.forName(squareBrackets + "L" + baseType.safeGetClassName() + ";");
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.toString());
        }
        if (!stringArrayClass.isInstance(x)) {
            String msg = "Value for " + dim + "-dimensional array of " + baseType.getTypeName() + " must be same type or a String " + "array with same dimensions";
            throw new IllegalArgumentException(msg);
        }
        if (dim == 1) {
            componentOpenType = baseType;
        } else {
            try {
                componentOpenType = new ArrayType(dim - 1, baseType);
            }
            catch (OpenDataException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        int n = Array.getLength(x);
        Object[] targetArray = (Object[])Array.newInstance(targetArrayClass.getComponentType(), n);
        for (int i = 0; i < n; ++i) {
            Object stringish = Array.get(x, i);
            Object converted = OpenMBeanAttributeInfoSupport.convertFromStrings(stringish, componentOpenType);
            Array.set(targetArray, i, converted);
        }
        return OpenMBeanAttributeInfoSupport.cast(targetArray);
    }

    static <T> T cast(Object x) {
        return (T)x;
    }

    @Override
    public OpenType<?> getOpenType() {
        return this.openType;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Set<?> getLegalValues() {
        return this.legalValues;
    }

    @Override
    public Comparable<?> getMinValue() {
        return this.minValue;
    }

    @Override
    public Comparable<?> getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    @Override
    public boolean hasLegalValues() {
        return this.legalValues != null;
    }

    @Override
    public boolean hasMinValue() {
        return this.minValue != null;
    }

    @Override
    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    @Override
    public boolean isValue(Object obj) {
        return OpenMBeanAttributeInfoSupport.isValue(this, obj);
    }

    static boolean isValue(OpenMBeanParameterInfo info, Object obj) {
        if (info.hasDefaultValue() && obj == null) {
            return true;
        }
        return !(!info.getOpenType().isValue(obj) || info.hasLegalValues() && !info.getLegalValues().contains(obj) || info.hasMinValue() && info.getMinValue().compareTo(obj) > 0 || info.hasMaxValue() && info.getMaxValue().compareTo(obj) < 0);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OpenMBeanAttributeInfo)) {
            return false;
        }
        OpenMBeanAttributeInfo other = (OpenMBeanAttributeInfo)obj;
        return this.isReadable() == other.isReadable() && this.isWritable() == other.isWritable() && this.isIs() == other.isIs() && OpenMBeanAttributeInfoSupport.equal(this, other);
    }

    static boolean equal(OpenMBeanParameterInfo x1, OpenMBeanParameterInfo x2) {
        if (x1 instanceof DescriptorRead) {
            Descriptor d2;
            if (!(x2 instanceof DescriptorRead)) {
                return false;
            }
            Descriptor d1 = ((DescriptorRead)((Object)x1)).getDescriptor();
            if (!d1.equals(d2 = ((DescriptorRead)((Object)x2)).getDescriptor())) {
                return false;
            }
        } else if (x2 instanceof DescriptorRead) {
            return false;
        }
        return x1.getName().equals(x2.getName()) && x1.getOpenType().equals(x2.getOpenType()) && (x1.hasDefaultValue() ? x1.getDefaultValue().equals(x2.getDefaultValue()) : !x2.hasDefaultValue()) && (x1.hasMinValue() ? x1.getMinValue().equals(x2.getMinValue()) : !x2.hasMinValue()) && (x1.hasMaxValue() ? x1.getMaxValue().equals(x2.getMaxValue()) : !x2.hasMaxValue()) && (x1.hasLegalValues() ? x1.getLegalValues().equals(x2.getLegalValues()) : !x2.hasLegalValues());
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            this.myHashCode = OpenMBeanAttributeInfoSupport.hashCode(this);
        }
        return this.myHashCode;
    }

    static int hashCode(OpenMBeanParameterInfo info) {
        int value = 0;
        value += info.getName().hashCode();
        value += info.getOpenType().hashCode();
        if (info.hasDefaultValue()) {
            value += info.getDefaultValue().hashCode();
        }
        if (info.hasMinValue()) {
            value += info.getMinValue().hashCode();
        }
        if (info.hasMaxValue()) {
            value += info.getMaxValue().hashCode();
        }
        if (info.hasLegalValues()) {
            value += info.getLegalValues().hashCode();
        }
        if (info instanceof DescriptorRead) {
            value += ((DescriptorRead)((Object)info)).getDescriptor().hashCode();
        }
        return value;
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            this.myToString = OpenMBeanAttributeInfoSupport.toString(this);
        }
        return this.myToString;
    }

    static String toString(OpenMBeanParameterInfo info) {
        Descriptor d = info instanceof DescriptorRead ? ((DescriptorRead)((Object)info)).getDescriptor() : null;
        return info.getClass().getName() + "(name=" + info.getName() + ",openType=" + info.getOpenType() + ",default=" + info.getDefaultValue() + ",minValue=" + info.getMinValue() + ",maxValue=" + info.getMaxValue() + ",legalValues=" + info.getLegalValues() + (d == null ? "" : ",descriptor=" + d) + ")";
    }
}

