/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sun.reflect.Reflection;

public class Logger {
    private static final Handler[] emptyHandlers = new Handler[0];
    private static final int offValue = Level.OFF.intValue();
    private LogManager manager;
    private String name;
    private final CopyOnWriteArrayList<Handler> handlers = new CopyOnWriteArrayList();
    private String resourceBundleName;
    private volatile boolean useParentHandlers = true;
    private volatile Filter filter;
    private boolean anonymous;
    private ResourceBundle catalog;
    private String catalogName;
    private Locale catalogLocale;
    private static Object treeLock = new Object();
    private volatile Logger parent;
    private ArrayList<LogManager.LoggerWeakRef> kids;
    private volatile Level levelObject;
    private volatile int levelValue;
    public static final String GLOBAL_LOGGER_NAME = "global";
    @Deprecated
    public static final Logger global = new Logger("global");

    public static final Logger getGlobal() {
        return global;
    }

    protected Logger(String name, String resourceBundleName) {
        this.manager = LogManager.getLogManager();
        if (resourceBundleName != null) {
            this.setupResourceInfo(resourceBundleName);
        }
        this.name = name;
        this.levelValue = Level.INFO.intValue();
    }

    private Logger(String name) {
        this.name = name;
        this.levelValue = Level.INFO.intValue();
    }

    void setLogManager(LogManager manager) {
        this.manager = manager;
    }

    private void checkPermission() throws SecurityException {
        if (!this.anonymous) {
            if (this.manager == null) {
                this.manager = LogManager.getLogManager();
            }
            this.manager.checkPermission();
        }
    }

    public static Logger getLogger(String name) {
        LogManager manager = LogManager.getLogManager();
        return manager.demandLogger(name);
    }

    public static Logger getLogger(String name, String resourceBundleName) {
        LogManager manager = LogManager.getLogManager();
        Logger result = manager.demandLogger(name);
        if (result.resourceBundleName == null) {
            result.setupResourceInfo(resourceBundleName);
        } else if (!result.resourceBundleName.equals(resourceBundleName)) {
            throw new IllegalArgumentException(result.resourceBundleName + " != " + resourceBundleName);
        }
        return result;
    }

    public static Logger getAnonymousLogger() {
        return Logger.getAnonymousLogger(null);
    }

    public static Logger getAnonymousLogger(String resourceBundleName) {
        LogManager manager = LogManager.getLogManager();
        manager.drainLoggerRefQueueBounded();
        Logger result = new Logger(null, resourceBundleName);
        result.anonymous = true;
        Logger root = manager.getLogger("");
        result.doSetParent(root);
        return result;
    }

    public ResourceBundle getResourceBundle() {
        return this.findResourceBundle(this.getResourceBundleName());
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setFilter(Filter newFilter) throws SecurityException {
        this.checkPermission();
        this.filter = newFilter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void log(LogRecord record) {
        if (record.getLevel().intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        Filter theFilter = this.filter;
        if (theFilter != null && !theFilter.isLoggable(record)) {
            return;
        }
        for (Logger logger = this; logger != null; logger = logger.getParent()) {
            for (Handler handler : logger.getHandlers()) {
                handler.publish(record);
            }
            if (!logger.getUseParentHandlers()) break;
        }
    }

    private void doLog(LogRecord lr) {
        lr.setLoggerName(this.name);
        String ebname = this.getEffectiveResourceBundleName();
        if (ebname != null) {
            lr.setResourceBundleName(ebname);
            lr.setResourceBundle(this.findResourceBundle(ebname));
        }
        this.log(lr);
    }

    public void log(Level level, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        this.doLog(lr);
    }

    public void log(Level level, String msg, Object param1) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void log(Level level, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    private void doLog(LogRecord lr, String rbname) {
        lr.setLoggerName(this.name);
        if (rbname != null) {
            lr.setResourceBundleName(rbname);
            lr.setResourceBundle(this.findResourceBundle(rbname));
        }
        this.log(lr);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        this.doLog(lr, bundleName);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr, bundleName);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setParameters(params);
        this.doLog(lr, bundleName);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog(lr, bundleName);
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY");
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY {0}", params);
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        String msg = "ENTRY";
        if (params == null) {
            this.logp(Level.FINER, sourceClass, sourceMethod, msg);
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            msg = msg + " {" + i + "}";
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, msg, params);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN");
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] params = new Object[]{result};
        this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN {0}", result);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (Level.FINER.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(Level.FINER, "THROW");
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    public void severe(String msg) {
        if (Level.SEVERE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        if (Level.WARNING.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.WARNING, msg);
    }

    public void info(String msg) {
        if (Level.INFO.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.INFO, msg);
    }

    public void config(String msg) {
        if (Level.CONFIG.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        if (Level.FINE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, msg);
    }

    public void finest(String msg) {
        if (Level.FINEST.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINEST, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(Level newLevel) throws SecurityException {
        this.checkPermission();
        Object object = treeLock;
        synchronized (object) {
            this.levelObject = newLevel;
            this.updateEffectiveLevel();
        }
    }

    public Level getLevel() {
        return this.levelObject;
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.levelValue && this.levelValue != offValue;
    }

    public String getName() {
        return this.name;
    }

    public void addHandler(Handler handler) throws SecurityException {
        handler.getClass();
        this.checkPermission();
        this.handlers.add(handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        this.checkPermission();
        if (handler == null) {
            return;
        }
        this.handlers.remove(handler);
    }

    public Handler[] getHandlers() {
        return this.handlers.toArray(emptyHandlers);
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this.checkPermission();
        this.useParentHandlers = useParentHandlers;
    }

    public boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    private synchronized ResourceBundle findResourceBundle(String name) {
        if (name == null) {
            return null;
        }
        Locale currentLocale = Locale.getDefault();
        if (this.catalog != null && currentLocale == this.catalogLocale && name == this.catalogName) {
            return this.catalog;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            this.catalog = ResourceBundle.getBundle(name, currentLocale, cl);
            this.catalogName = name;
            this.catalogLocale = currentLocale;
            return this.catalog;
        }
        catch (MissingResourceException ex) {
            Class clz;
            int ix = 0;
            while ((clz = Reflection.getCallerClass(ix)) != null) {
                ClassLoader cl2 = clz.getClassLoader();
                if (cl2 == null) {
                    cl2 = ClassLoader.getSystemClassLoader();
                }
                if (cl != cl2) {
                    cl = cl2;
                    try {
                        this.catalog = ResourceBundle.getBundle(name, currentLocale, cl);
                        this.catalogName = name;
                        this.catalogLocale = currentLocale;
                        return this.catalog;
                    }
                    catch (MissingResourceException ex2) {
                        // empty catch block
                    }
                }
                ++ix;
            }
            if (name.equals(this.catalogName)) {
                return this.catalog;
            }
            return null;
        }
    }

    private synchronized void setupResourceInfo(String name) {
        if (name == null) {
            return;
        }
        ResourceBundle rb = this.findResourceBundle(name);
        if (rb == null) {
            throw new MissingResourceException("Can't find " + name + " bundle", name, "");
        }
        this.resourceBundleName = name;
    }

    public Logger getParent() {
        return this.parent;
    }

    public void setParent(Logger parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.manager.checkPermission();
        this.doSetParent(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetParent(Logger newParent) {
        Object object = treeLock;
        synchronized (object) {
            LogManager.LoggerWeakRef ref = null;
            if (this.parent != null) {
                Iterator<LogManager.LoggerWeakRef> iter = this.parent.kids.iterator();
                while (iter.hasNext()) {
                    ref = iter.next();
                    Logger kid = (Logger)ref.get();
                    if (kid == this) {
                        iter.remove();
                        break;
                    }
                    ref = null;
                }
            }
            this.parent = newParent;
            if (this.parent.kids == null) {
                this.parent.kids = new ArrayList(2);
            }
            if (ref == null) {
                LogManager logManager = this.manager;
                logManager.getClass();
                ref = logManager.new LogManager.LoggerWeakRef(this);
            }
            ref.setParentRef(new WeakReference<Logger>(this.parent));
            this.parent.kids.add(ref);
            this.updateEffectiveLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeChildLogger(LogManager.LoggerWeakRef child) {
        Object object = treeLock;
        synchronized (object) {
            Iterator<LogManager.LoggerWeakRef> iter = this.kids.iterator();
            while (iter.hasNext()) {
                LogManager.LoggerWeakRef ref = iter.next();
                if (ref != child) continue;
                iter.remove();
                return;
            }
        }
    }

    private void updateEffectiveLevel() {
        int newLevelValue = this.levelObject != null ? this.levelObject.intValue() : (this.parent != null ? this.parent.levelValue : Level.INFO.intValue());
        if (this.levelValue == newLevelValue) {
            return;
        }
        this.levelValue = newLevelValue;
        if (this.kids != null) {
            for (int i = 0; i < this.kids.size(); ++i) {
                LogManager.LoggerWeakRef ref = this.kids.get(i);
                Logger kid = (Logger)ref.get();
                if (kid == null) continue;
                kid.updateEffectiveLevel();
            }
        }
    }

    private String getEffectiveResourceBundleName() {
        for (Logger target = this; target != null; target = target.getParent()) {
            String rbn = target.getResourceBundleName();
            if (rbn == null) continue;
            return rbn;
        }
        return null;
    }
}

