/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverInfo;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;

public class DriverManager {
    private static final CopyOnWriteArrayList<DriverInfo> registeredDrivers = new CopyOnWriteArrayList();
    private static volatile int loginTimeout = 0;
    private static volatile PrintWriter logWriter = null;
    private static volatile PrintStream logStream = null;
    private static final Object logSync = new Object();
    static final SQLPermission SET_LOG_PERMISSION;

    private DriverManager() {
    }

    public static PrintWriter getLogWriter() {
        return logWriter;
    }

    public static void setLogWriter(PrintWriter out) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(SET_LOG_PERMISSION);
        }
        logStream = null;
        logWriter = out;
    }

    public static Connection getConnection(String url, Properties info) throws SQLException {
        ClassLoader callerCL = DriverManager.getCallerClassLoader();
        return DriverManager.getConnection(url, info, callerCL);
    }

    public static Connection getConnection(String url, String user, String password) throws SQLException {
        Properties info = new Properties();
        ClassLoader callerCL = DriverManager.getCallerClassLoader();
        if (user != null) {
            info.put("user", user);
        }
        if (password != null) {
            info.put("password", password);
        }
        return DriverManager.getConnection(url, info, callerCL);
    }

    public static Connection getConnection(String url) throws SQLException {
        Properties info = new Properties();
        ClassLoader callerCL = DriverManager.getCallerClassLoader();
        return DriverManager.getConnection(url, info, callerCL);
    }

    public static Driver getDriver(String url) throws SQLException {
        DriverManager.println("DriverManager.getDriver(\"" + url + "\")");
        ClassLoader callerCL = DriverManager.getCallerClassLoader();
        for (DriverInfo aDriver : registeredDrivers) {
            if (DriverManager.isDriverAllowed(aDriver.driver, callerCL)) {
                try {
                    if (!aDriver.driver.acceptsURL(url)) continue;
                    DriverManager.println("getDriver returning " + aDriver.driver.getClass().getName());
                    return aDriver.driver;
                }
                catch (SQLException sqe) {
                    continue;
                }
            }
            DriverManager.println("    skipping: " + aDriver.driver.getClass().getName());
        }
        DriverManager.println("getDriver: no suitable driver");
        throw new SQLException("No suitable driver", "08001");
    }

    public static synchronized void registerDriver(Driver driver) throws SQLException {
        if (driver == null) {
            throw new NullPointerException();
        }
        registeredDrivers.addIfAbsent(new DriverInfo(driver));
        DriverManager.println("registerDriver: " + driver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void deregisterDriver(Driver driver) throws SQLException {
        if (driver == null) {
            return;
        }
        ClassLoader callerCL = DriverManager.getCallerClassLoader();
        DriverManager.println("DriverManager.deregisterDriver: " + driver);
        DriverInfo aDriver = new DriverInfo(driver);
        if (registeredDrivers.contains(aDriver)) {
            if (!DriverManager.isDriverAllowed(driver, callerCL)) throw new SecurityException();
            registeredDrivers.remove(aDriver);
            return;
        } else {
            DriverManager.println("    couldn't find driver to unload");
        }
    }

    public static Enumeration<Driver> getDrivers() {
        Vector<Driver> result = new Vector<Driver>();
        ClassLoader callerCL = DriverManager.getCallerClassLoader();
        for (DriverInfo aDriver : registeredDrivers) {
            if (DriverManager.isDriverAllowed(aDriver.driver, callerCL)) {
                result.addElement(aDriver.driver);
                continue;
            }
            DriverManager.println("    skipping: " + aDriver.getClass().getName());
        }
        return result.elements();
    }

    public static void setLoginTimeout(int seconds) {
        loginTimeout = seconds;
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    public static void setLogStream(PrintStream out) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(SET_LOG_PERMISSION);
        }
        logStream = out;
        logWriter = out != null ? new PrintWriter(out) : null;
    }

    public static PrintStream getLogStream() {
        return logStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String message) {
        Object object = logSync;
        synchronized (object) {
            if (logWriter != null) {
                logWriter.println(message);
                logWriter.flush();
            }
        }
    }

    private static boolean isDriverAllowed(Driver driver, ClassLoader classLoader) {
        boolean result = false;
        if (driver != null) {
            Class<?> aClass = null;
            try {
                aClass = Class.forName(driver.getClass().getName(), true, classLoader);
            }
            catch (Exception ex) {
                result = false;
            }
            result = aClass == driver.getClass();
        }
        return result;
    }

    private static void loadInitialDrivers() {
        String drivers;
        try {
            drivers = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("jdbc.drivers");
                }
            });
        }
        catch (Exception ex) {
            drivers = null;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ServiceLoader<Driver> loadedDrivers = ServiceLoader.load(Driver.class);
                Iterator<Driver> driversIterator = loadedDrivers.iterator();
                try {
                    while (driversIterator.hasNext()) {
                        DriverManager.println(" Loading done by the java.util.ServiceLoader :  " + driversIterator.next());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        DriverManager.println("DriverManager.initialize: jdbc.drivers = " + drivers);
        if (drivers == null || drivers.equals("")) {
            return;
        }
        String[] driversList = drivers.split(":");
        DriverManager.println("number of Drivers:" + driversList.length);
        for (String aDriver : driversList) {
            try {
                DriverManager.println("DriverManager.Initialize: loading " + aDriver);
                Class.forName(aDriver, true, ClassLoader.getSystemClassLoader());
            }
            catch (Exception ex) {
                DriverManager.println("DriverManager.Initialize: load failed: " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection getConnection(String url, Properties info, ClassLoader callerCL) throws SQLException {
        Class<DriverManager> clazz = DriverManager.class;
        synchronized (DriverManager.class) {
            if (callerCL == null) {
                callerCL = Thread.currentThread().getContextClassLoader();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (url == null) {
                throw new SQLException("The url cannot be null", "08001");
            }
            DriverManager.println("DriverManager.getConnection(\"" + url + "\")");
            SQLException reason = null;
            for (DriverInfo aDriver : registeredDrivers) {
                if (DriverManager.isDriverAllowed(aDriver.driver, callerCL)) {
                    try {
                        DriverManager.println("    trying " + aDriver.driver.getClass().getName());
                        Connection con = aDriver.driver.connect(url, info);
                        if (con == null) continue;
                        DriverManager.println("getConnection returning " + aDriver.driver.getClass().getName());
                        return con;
                    }
                    catch (SQLException ex) {
                        if (reason != null) continue;
                        reason = ex;
                        continue;
                    }
                }
                DriverManager.println("    skipping: " + aDriver.getClass().getName());
            }
            if (reason != null) {
                DriverManager.println("getConnection failed: " + reason);
                throw reason;
            }
            DriverManager.println("getConnection: no suitable driver found for " + url);
            throw new SQLException("No suitable driver found for " + url, "08001");
        }
    }

    private static native ClassLoader getCallerClassLoader();

    static {
        DriverManager.loadInitialDrivers();
        DriverManager.println("JDBC DriverManager initialized");
        SET_LOG_PERMISSION = new SQLPermission("setLog");
    }
}

