/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import sun.reflect.Reflection;
import sun.security.util.Debug;

public final class AccessController {
    private AccessController() {
    }

    public static native <T> T doPrivileged(PrivilegedAction<T> var0);

    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> action) {
        AccessControlContext acc = AccessController.getStackAccessControlContext();
        if (acc == null) {
            return AccessController.doPrivileged(action);
        }
        DomainCombiner dc = acc.getAssignedCombiner();
        return AccessController.doPrivileged(action, AccessController.preserveCombiner(dc));
    }

    public static native <T> T doPrivileged(PrivilegedAction<T> var0, AccessControlContext var1);

    public static native <T> T doPrivileged(PrivilegedExceptionAction<T> var0) throws PrivilegedActionException;

    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        AccessControlContext acc = AccessController.getStackAccessControlContext();
        if (acc == null) {
            return AccessController.doPrivileged(action);
        }
        DomainCombiner dc = acc.getAssignedCombiner();
        return AccessController.doPrivileged(action, AccessController.preserveCombiner(dc));
    }

    private static AccessControlContext preserveCombiner(DomainCombiner combiner) {
        final Class callerClass = Reflection.getCallerClass(3);
        ProtectionDomain callerPd = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return callerClass.getProtectionDomain();
            }
        });
        ProtectionDomain[] pds = new ProtectionDomain[]{callerPd};
        if (combiner == null) {
            return new AccessControlContext(pds);
        }
        return new AccessControlContext(combiner.combine(pds, null), combiner);
    }

    public static native <T> T doPrivileged(PrivilegedExceptionAction<T> var0, AccessControlContext var1) throws PrivilegedActionException;

    private static native AccessControlContext getStackAccessControlContext();

    static native AccessControlContext getInheritedAccessControlContext();

    public static AccessControlContext getContext() {
        AccessControlContext acc = AccessController.getStackAccessControlContext();
        if (acc == null) {
            return new AccessControlContext(null, true);
        }
        return acc.optimize();
    }

    public static void checkPermission(Permission perm) throws AccessControlException {
        if (perm == null) {
            throw new NullPointerException("permission can't be null");
        }
        AccessControlContext stack = AccessController.getStackAccessControlContext();
        if (stack == null) {
            Debug debug = AccessControlContext.getDebug();
            boolean dumpDebug = false;
            if (debug != null) {
                dumpDebug = !Debug.isOn("codebase=");
                dumpDebug &= !Debug.isOn("permission=") || Debug.isOn("permission=" + perm.getClass().getCanonicalName());
            }
            if (dumpDebug && Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (dumpDebug && Debug.isOn("domain")) {
                debug.println("domain (context is null)");
            }
            if (dumpDebug) {
                debug.println("access allowed " + perm);
            }
            return;
        }
        AccessControlContext acc = stack.optimize();
        acc.checkPermission(perm);
    }
}

