/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.dgc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;

public final class VMID
implements Serializable {
    private static byte[] localAddr = VMID.computeAddressHash();
    private byte[] addr = localAddr;
    private UID uid = new UID();
    private static final long serialVersionUID = -538642295484486218L;

    @Deprecated
    public static boolean isUnique() {
        return true;
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VMID) {
            VMID vmid = (VMID)obj;
            if (!this.uid.equals(vmid.uid)) {
                return false;
            }
            if (this.addr == null ^ vmid.addr == null) {
                return false;
            }
            if (this.addr != null) {
                if (this.addr.length != vmid.addr.length) {
                    return false;
                }
                for (int i = 0; i < this.addr.length; ++i) {
                    if (this.addr[i] == vmid.addr[i]) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.addr != null) {
            for (int i = 0; i < this.addr.length; ++i) {
                int x = this.addr[i] & 0xFF;
                result.append((x < 16 ? "0" : "") + Integer.toString(x, 16));
            }
        }
        result.append(':');
        result.append(this.uid.toString());
        return result.toString();
    }

    private static byte[] computeAddressHash() {
        byte[] addrHash;
        byte[] addr = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                try {
                    return InetAddress.getLocalHost().getAddress();
                }
                catch (Exception exception) {
                    return new byte[]{0, 0, 0, 0};
                }
            }
        });
        int ADDR_HASH_LENGTH = 8;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            ByteArrayOutputStream sink = new ByteArrayOutputStream(64);
            DataOutputStream out = new DataOutputStream(new DigestOutputStream(sink, md));
            out.write(addr, 0, addr.length);
            out.flush();
            byte[] digest = md.digest();
            int hashlength = Math.min(8, digest.length);
            addrHash = new byte[hashlength];
            System.arraycopy(digest, 0, addrHash, 0, hashlength);
        }
        catch (IOException ignore) {
            addrHash = new byte[]{};
        }
        catch (NoSuchAlgorithmException complain) {
            throw new InternalError(complain.toString());
        }
        return addrHash;
    }
}

